/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure;

import io.temporal.spring.boot.autoconfigure.properties.NonRootNamespaceProperties;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class NamespacesPresentCondition
extends SpringBootCondition {
    private static final Bindable<List<NonRootNamespaceProperties>> NAMESPACES_LIST = Bindable.listOf(NonRootNamespaceProperties.class);
    private static final String NAMESPACES_KEY = "spring.temporal.namespaces";

    NamespacesPresentCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        BindResult namespacesProperty = Binder.get((Environment)context.getEnvironment()).bind(NAMESPACES_KEY, NAMESPACES_LIST);
        ConditionMessage.Builder messageBuilder = ConditionMessage.forCondition((String)"Present namespaces", (Object[])new Object[0]);
        if (namespacesProperty.isBound()) {
            return ConditionOutcome.match((ConditionMessage)messageBuilder.found("property").items(new Object[]{NAMESPACES_KEY}));
        }
        return ConditionOutcome.noMatch((ConditionMessage)messageBuilder.didNotFind("property").items(new Object[]{NAMESPACES_KEY}));
    }
}

