/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.OpenTracingWorkerInterceptor;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.NamespaceProperties;
import io.temporal.worker.WorkerFactoryOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkerFactoryOptionsTemplate {
    @Nonnull
    private final NamespaceProperties namespaceProperties;
    @Nullable
    private final List<WorkerInterceptor> workerInterceptors;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final List<TemporalOptionsCustomizer<WorkerFactoryOptions.Builder>> customizer;

    public WorkerFactoryOptionsTemplate(@Nonnull NamespaceProperties namespaceProperties, @Nullable List<WorkerInterceptor> workerInterceptors, @Nullable Tracer tracer, @Nullable List<TemporalOptionsCustomizer<WorkerFactoryOptions.Builder>> customizer) {
        this.namespaceProperties = namespaceProperties;
        this.workerInterceptors = workerInterceptors;
        this.tracer = tracer;
        this.customizer = customizer;
    }

    public WorkerFactoryOptions createWorkerFactoryOptions() {
        WorkerFactoryOptions.Builder options = WorkerFactoryOptions.newBuilder();
        NamespaceProperties.WorkflowCacheProperties workflowCache = this.namespaceProperties.getWorkflowCache();
        if (workflowCache != null) {
            Optional.ofNullable(workflowCache.getMaxInstances()).ifPresent(arg_0 -> ((WorkerFactoryOptions.Builder)options).setWorkflowCacheSize(arg_0));
            Optional.ofNullable(workflowCache.getMaxThreads()).ifPresent(arg_0 -> ((WorkerFactoryOptions.Builder)options).setMaxWorkflowThreadCount(arg_0));
            Optional.ofNullable(workflowCache.isUsingVirtualWorkflowThreads()).ifPresent(arg_0 -> ((WorkerFactoryOptions.Builder)options).setUsingVirtualWorkflowThreads(arg_0));
        }
        ArrayList<Object> interceptors = new ArrayList<Object>();
        if (this.tracer != null) {
            OpenTracingWorkerInterceptor openTracingClientInterceptor = new OpenTracingWorkerInterceptor(OpenTracingOptions.newBuilder().setTracer(this.tracer).build());
            interceptors.add(openTracingClientInterceptor);
        }
        if (this.workerInterceptors != null) {
            interceptors.addAll(this.workerInterceptors);
        }
        options.setWorkerInterceptors(interceptors.toArray(new WorkerInterceptor[0]));
        if (this.customizer != null) {
            for (TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> customizer : this.customizer) {
                options = customizer.customize(options);
            }
        }
        return options.build();
    }
}

