/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.temporal.common.WorkerDeploymentVersion;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.WorkerOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.WorkerProperties;
import io.temporal.worker.WorkerDeploymentOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.tuning.PollerBehavior;
import io.temporal.worker.tuning.PollerBehaviorAutoscaling;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class WorkerOptionsTemplate {
    @Nonnull
    private final String taskQueue;
    @Nonnull
    private final String workerName;
    @Nullable
    private final WorkerProperties workerProperties;
    @Nullable
    private final List<TemporalOptionsCustomizer<WorkerOptions.Builder>> customizers;

    WorkerOptionsTemplate(@Nonnull String workerName, @Nonnull String taskQueue, @Nullable WorkerProperties workerProperties, @Nullable List<TemporalOptionsCustomizer<WorkerOptions.Builder>> customizers) {
        this.workerName = workerName;
        this.taskQueue = taskQueue;
        this.workerProperties = workerProperties;
        this.customizers = customizers;
    }

    WorkerOptions createWorkerOptions() {
        WorkerOptions.Builder options = WorkerOptions.newBuilder();
        if (this.workerProperties != null) {
            WorkerProperties.WorkerDeploymentConfigurationProperties workerDeploymentConfiguration;
            WorkerProperties.VirtualThreadConfigurationProperties virtualThreadConfiguration;
            WorkerProperties.BuildIdConfigurationProperties buildIdConfigurations;
            WorkerProperties.RateLimitsConfigurationProperties rateLimitConfiguration;
            WorkerProperties.CapacityConfigurationProperties threadsConfiguration = this.workerProperties.getCapacity();
            if (threadsConfiguration != null) {
                WorkerProperties.PollerConfigurationProperties.PollerBehaviorAutoscalingConfiguration pollerBehaviorAutoscaling;
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentWorkflowTaskExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentWorkflowTaskExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentActivityExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentActivityExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentLocalActivityExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentLocalActivityExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentNexusTasksExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentNexusExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentWorkflowTaskPollers()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentWorkflowTaskPollers(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentActivityTaskPollers()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentActivityTaskPollers(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentNexusTaskPollers()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentNexusTaskPollers(arg_0));
                if (threadsConfiguration.getWorkflowTaskPollersConfiguration() != null && (pollerBehaviorAutoscaling = threadsConfiguration.getWorkflowTaskPollersConfiguration().getPollerBehaviorAutoscaling()) != null && pollerBehaviorAutoscaling.isEnabled().booleanValue()) {
                    options.setWorkflowTaskPollersBehavior((PollerBehavior)new PollerBehaviorAutoscaling(pollerBehaviorAutoscaling.getMinConcurrentTaskPollers(), pollerBehaviorAutoscaling.getMaxConcurrentTaskPollers(), pollerBehaviorAutoscaling.getInitialConcurrentTaskPollers()));
                }
                if (threadsConfiguration.getActivityTaskPollersConfiguration() != null && (pollerBehaviorAutoscaling = threadsConfiguration.getActivityTaskPollersConfiguration().getPollerBehaviorAutoscaling()) != null && pollerBehaviorAutoscaling.isEnabled().booleanValue()) {
                    options.setActivityTaskPollersBehavior((PollerBehavior)new PollerBehaviorAutoscaling(pollerBehaviorAutoscaling.getMinConcurrentTaskPollers(), pollerBehaviorAutoscaling.getMaxConcurrentTaskPollers(), pollerBehaviorAutoscaling.getInitialConcurrentTaskPollers()));
                }
                if (threadsConfiguration.getNexusTaskPollersConfiguration() != null && (pollerBehaviorAutoscaling = threadsConfiguration.getNexusTaskPollersConfiguration().getPollerBehaviorAutoscaling()) != null && pollerBehaviorAutoscaling.isEnabled().booleanValue()) {
                    options.setNexusTaskPollersBehavior((PollerBehavior)new PollerBehaviorAutoscaling(pollerBehaviorAutoscaling.getMinConcurrentTaskPollers(), pollerBehaviorAutoscaling.getMaxConcurrentTaskPollers(), pollerBehaviorAutoscaling.getInitialConcurrentTaskPollers()));
                }
            }
            if ((rateLimitConfiguration = this.workerProperties.getRateLimits()) != null) {
                Optional.ofNullable(rateLimitConfiguration.getMaxWorkerActivitiesPerSecond()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxWorkerActivitiesPerSecond(arg_0));
                Optional.ofNullable(rateLimitConfiguration.getMaxTaskQueueActivitiesPerSecond()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxTaskQueueActivitiesPerSecond(arg_0));
            }
            if ((buildIdConfigurations = this.workerProperties.getBuildId()) != null) {
                Optional.ofNullable(buildIdConfigurations.getWorkerBuildId()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setBuildId(arg_0));
                options.setUseBuildIdForVersioning(buildIdConfigurations.getEnabledWorkerVersioning());
            }
            if ((virtualThreadConfiguration = this.workerProperties.getVirtualThreads()) != null) {
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreads()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreads(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnWorkflowWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnWorkflowWorker(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnActivityWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnActivityWorker(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnLocalActivityWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnLocalActivityWorker(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnNexusWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnNexusWorker(arg_0));
            }
            if ((workerDeploymentConfiguration = this.workerProperties.getDeploymentProperties()) != null) {
                WorkerDeploymentOptions.Builder opts = WorkerDeploymentOptions.newBuilder();
                Optional.ofNullable(workerDeploymentConfiguration.getUseVersioning()).ifPresent(arg_0 -> ((WorkerDeploymentOptions.Builder)opts).setUseVersioning(arg_0));
                Optional.ofNullable(workerDeploymentConfiguration.getDefaultVersioningBehavior()).ifPresent(arg_0 -> ((WorkerDeploymentOptions.Builder)opts).setDefaultVersioningBehavior(arg_0));
                if (workerDeploymentConfiguration.getDeploymentName() != null || workerDeploymentConfiguration.getBuildId() != null) {
                    if (workerDeploymentConfiguration.getBuildId() == null || workerDeploymentConfiguration.getDeploymentName() == null) {
                        throw new IllegalArgumentException("deploymentName and buildId must both be set when either is specified");
                    }
                    if (workerDeploymentConfiguration.getDeploymentVersion() != null) {
                        throw new IllegalArgumentException("deploymentVersion is exclusive with deploymentName and buildId");
                    }
                    opts.setVersion(new WorkerDeploymentVersion(workerDeploymentConfiguration.getDeploymentName(), workerDeploymentConfiguration.getBuildId()));
                } else {
                    Optional.ofNullable(workerDeploymentConfiguration.getDeploymentVersion()).ifPresent(v -> opts.setVersion(WorkerDeploymentVersion.fromCanonicalString((String)v)));
                }
                options.setDeploymentOptions(opts.build());
            }
        }
        if (this.customizers != null) {
            for (TemporalOptionsCustomizer<WorkerOptions.Builder> customizer : this.customizers) {
                options = customizer.customize(options);
                if (!(customizer instanceof WorkerOptionsCustomizer)) continue;
                options = ((WorkerOptionsCustomizer)customizer).customize(options, this.workerName, this.taskQueue);
            }
        }
        return options.build();
    }
}

