/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.opentracing.Tracer;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.ScheduleClientInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.opentracing.OpenTracingClientInterceptor;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowClientOptionsTemplate {
    @Nonnull
    private final String namespace;
    @Nullable
    private final DataConverter dataConverter;
    @Nullable
    private final List<WorkflowClientInterceptor> workflowClientInterceptors;
    @Nullable
    private final List<ScheduleClientInterceptor> scheduleClientInterceptors;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final List<TemporalOptionsCustomizer<WorkflowClientOptions.Builder>> clientCustomizers;
    @Nullable
    private final List<TemporalOptionsCustomizer<ScheduleClientOptions.Builder>> scheduleCustomizers;

    public WorkflowClientOptionsTemplate(@Nonnull String namespace, @Nullable DataConverter dataConverter, @Nullable List<WorkflowClientInterceptor> workflowClientInterceptors, @Nullable List<ScheduleClientInterceptor> scheduleClientInterceptors, @Nullable Tracer tracer, @Nullable List<TemporalOptionsCustomizer<WorkflowClientOptions.Builder>> clientCustomizers, @Nullable List<TemporalOptionsCustomizer<ScheduleClientOptions.Builder>> scheduleCustomizers) {
        this.namespace = namespace;
        this.dataConverter = dataConverter;
        this.workflowClientInterceptors = workflowClientInterceptors;
        this.scheduleClientInterceptors = scheduleClientInterceptors;
        this.tracer = tracer;
        this.clientCustomizers = clientCustomizers;
        this.scheduleCustomizers = scheduleCustomizers;
    }

    public WorkflowClientOptions createWorkflowClientOptions() {
        WorkflowClientOptions.Builder options = WorkflowClientOptions.newBuilder();
        options.setNamespace(this.namespace);
        Optional.ofNullable(this.dataConverter).ifPresent(arg_0 -> ((WorkflowClientOptions.Builder)options).setDataConverter(arg_0));
        ArrayList<Object> interceptors = new ArrayList<Object>();
        if (this.tracer != null) {
            OpenTracingClientInterceptor openTracingClientInterceptor = new OpenTracingClientInterceptor(OpenTracingOptions.newBuilder().setTracer(this.tracer).build());
            interceptors.add(openTracingClientInterceptor);
        }
        if (this.workflowClientInterceptors != null) {
            interceptors.addAll(this.workflowClientInterceptors);
        }
        options.setInterceptors(interceptors.toArray(new WorkflowClientInterceptor[0]));
        if (this.clientCustomizers != null) {
            for (TemporalOptionsCustomizer<WorkflowClientOptions.Builder> customizer : this.clientCustomizers) {
                options = customizer.customize(options);
            }
        }
        return options.build();
    }

    public ScheduleClientOptions createScheduleClientOptions() {
        ScheduleClientOptions.Builder options = ScheduleClientOptions.newBuilder();
        options.setNamespace(this.namespace);
        Optional.ofNullable(this.dataConverter).ifPresent(arg_0 -> ((ScheduleClientOptions.Builder)options).setDataConverter(arg_0));
        if (this.scheduleClientInterceptors != null && !this.scheduleClientInterceptors.isEmpty()) {
            options.setInterceptors(this.scheduleClientInterceptors);
        }
        if (this.scheduleCustomizers != null) {
            for (TemporalOptionsCustomizer<ScheduleClientOptions.Builder> customizer : this.scheduleCustomizers) {
                options = customizer.customize(options);
            }
        }
        return options.build();
    }
}

