/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure;

import com.uber.m3.tally.Scope;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.AutoConfigurationUtils;
import io.temporal.spring.boot.autoconfigure.MetricsScopeAutoConfiguration;
import io.temporal.spring.boot.autoconfigure.TestServerAutoConfiguration;
import io.temporal.spring.boot.autoconfigure.properties.TemporalProperties;
import io.temporal.spring.boot.autoconfigure.template.ServiceStubsTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TemporalProperties.class})
@AutoConfigureAfter(value={MetricsScopeAutoConfiguration.class, TestServerAutoConfiguration.class})
@ConditionalOnExpression(value="${spring.temporal.test-server.enabled:false} || '${spring.temporal.connection.target:}'.length() > 0")
public class ServiceStubsAutoConfiguration {
    ConfigurableListableBeanFactory beanFactory;

    public ServiceStubsAutoConfiguration(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Bean(name={"temporalServiceStubsTemplate"})
    public ServiceStubsTemplate serviceStubsTemplate(TemporalProperties properties, @Qualifier(value="temporalMetricsScope") @Autowired(required=false) @Nullable Scope metricsScope, @Qualifier(value="temporalTestWorkflowEnvironmentAdapter") @Autowired(required=false) @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Autowired(required=false) @Nullable Map<String, TemporalOptionsCustomizer<WorkflowServiceStubsOptions.Builder>> workflowServiceStubsCustomizerMap) {
        List<TemporalOptionsCustomizer<WorkflowServiceStubsOptions.Builder>> workflowServiceStubsCustomizer = AutoConfigurationUtils.chooseTemporalCustomizerBeans((ListableBeanFactory)this.beanFactory, workflowServiceStubsCustomizerMap, WorkflowServiceStubsOptions.Builder.class, properties);
        return new ServiceStubsTemplate(properties.getConnection(), metricsScope, testWorkflowEnvironment, workflowServiceStubsCustomizer);
    }

    @Bean(name={"temporalWorkflowServiceStubs"})
    public WorkflowServiceStubs workflowServiceStubsTemplate(@Qualifier(value="temporalServiceStubsTemplate") ServiceStubsTemplate serviceStubsTemplate) {
        return serviceStubsTemplate.getWorkflowServiceStubs();
    }
}

