/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.opentracing.Tracer;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.ScheduleClientInterceptor;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.NamespaceProperties;
import io.temporal.spring.boot.autoconfigure.template.ClientTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkersTemplate;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NamespaceTemplate {
    @Nonnull
    private final NamespaceProperties namespaceProperties;
    @Nonnull
    private final WorkflowServiceStubs workflowServiceStubs;
    @Nullable
    private final DataConverter dataConverter;
    @Nullable
    private final List<WorkflowClientInterceptor> workflowClientInterceptors;
    @Nullable
    private final List<ScheduleClientInterceptor> scheduleClientInterceptors;
    @Nullable
    private final List<WorkerInterceptor> workerInterceptors;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    @Nullable
    private final List<TemporalOptionsCustomizer<WorkerFactoryOptions.Builder>> workerFactoryCustomizers;
    @Nullable
    private final List<TemporalOptionsCustomizer<WorkerOptions.Builder>> workerCustomizers;
    @Nullable
    private final List<TemporalOptionsCustomizer<WorkflowClientOptions.Builder>> clientCustomizers;
    @Nullable
    private final List<TemporalOptionsCustomizer<ScheduleClientOptions.Builder>> scheduleCustomizers;
    @Nullable
    private final List<TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder>> workflowImplementationCustomizers;
    private ClientTemplate clientTemplate;
    private WorkersTemplate workersTemplate;

    public NamespaceTemplate(@Nonnull NamespaceProperties namespaceProperties, @Nonnull WorkflowServiceStubs workflowServiceStubs, @Nullable DataConverter dataConverter, @Nullable List<WorkflowClientInterceptor> workflowClientInterceptors, @Nullable List<ScheduleClientInterceptor> scheduleClientInterceptors, @Nullable List<WorkerInterceptor> workerInterceptors, @Nullable Tracer tracer, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable List<TemporalOptionsCustomizer<WorkerFactoryOptions.Builder>> workerFactoryCustomizers, @Nullable List<TemporalOptionsCustomizer<WorkerOptions.Builder>> workerCustomizers, @Nullable List<TemporalOptionsCustomizer<WorkflowClientOptions.Builder>> clientCustomizers, @Nullable List<TemporalOptionsCustomizer<ScheduleClientOptions.Builder>> scheduleCustomizers, @Nullable List<TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder>> workflowImplementationCustomizers) {
        this.namespaceProperties = namespaceProperties;
        this.workflowServiceStubs = workflowServiceStubs;
        this.dataConverter = dataConverter;
        this.workflowClientInterceptors = workflowClientInterceptors;
        this.scheduleClientInterceptors = scheduleClientInterceptors;
        this.workerInterceptors = workerInterceptors;
        this.tracer = tracer;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
        this.workerFactoryCustomizers = workerFactoryCustomizers;
        this.workerCustomizers = workerCustomizers;
        this.clientCustomizers = clientCustomizers;
        this.scheduleCustomizers = scheduleCustomizers;
        this.workflowImplementationCustomizers = workflowImplementationCustomizers;
    }

    public ClientTemplate getClientTemplate() {
        if (this.clientTemplate == null) {
            this.clientTemplate = new ClientTemplate(this.namespaceProperties.getNamespace(), this.dataConverter, this.workflowClientInterceptors, this.scheduleClientInterceptors, this.tracer, this.workflowServiceStubs, this.testWorkflowEnvironment, this.clientCustomizers, this.scheduleCustomizers);
        }
        return this.clientTemplate;
    }

    public WorkersTemplate getWorkersTemplate() {
        if (this.workersTemplate == null) {
            this.workersTemplate = new WorkersTemplate(this.namespaceProperties, this.getClientTemplate(), this.workerInterceptors, this.tracer, this.testWorkflowEnvironment, this.workerFactoryCustomizers, this.workerCustomizers, this.workflowImplementationCustomizers);
        }
        return this.workersTemplate;
    }
}

