/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.NamespaceState;
import io.temporal.api.enums.v1.SignalExternalWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.enums.v1.WorkflowIdReusePolicy;
import io.temporal.api.errordetails.v1.WorkflowExecutionAlreadyStartedFailure;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes;
import io.temporal.api.namespace.v1.NamespaceInfo;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.DescribeNamespaceRequest;
import io.temporal.api.workflowservice.v1.DescribeNamespaceResponse;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.ListClosedWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListClosedWorkflowExecutionsResponse;
import io.temporal.api.workflowservice.v1.ListOpenWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListOpenWorkflowExecutionsResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedResponse;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedResponse;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.testservice.ActivityId;
import io.temporal.internal.testservice.CronUtils;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.GRPCServerHelper;
import io.temporal.internal.testservice.InProcessGRPCServer;
import io.temporal.internal.testservice.QueryId;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.internal.testservice.SelfAdvancingTimerImpl;
import io.temporal.internal.testservice.TestServiceRetryState;
import io.temporal.internal.testservice.TestVisibilityStore;
import io.temporal.internal.testservice.TestVisibilityStoreImpl;
import io.temporal.internal.testservice.TestWorkflowMutableState;
import io.temporal.internal.testservice.TestWorkflowMutableStateImpl;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.internal.testservice.TestWorkflowStoreImpl;
import io.temporal.internal.testservice.WorkflowId;
import io.temporal.internal.testservice.WorkflowTaskToken;
import io.temporal.serviceclient.StatusUtils;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestWorkflowService
extends WorkflowServiceGrpc.WorkflowServiceImplBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowService.class);
    private final Map<ExecutionId, TestWorkflowMutableState> executions = new HashMap<ExecutionId, TestWorkflowMutableState>();
    private final Map<WorkflowId, TestWorkflowMutableState> executionsByWorkflowId = new HashMap<WorkflowId, TestWorkflowMutableState>();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Lock lock = new ReentrantLock();
    private final TestWorkflowStore store;
    private final TestVisibilityStore visibilityStore;
    private final SelfAdvancingTimer selfAdvancingTimer;
    private final ScheduledExecutorService backgroundScheduler = Executors.newSingleThreadScheduledExecutor();
    private final Server outOfProcessServer;
    private final InProcessGRPCServer inProcessServer;
    private final WorkflowServiceStubs workflowServiceStubs;

    TestWorkflowService(TestWorkflowStore store, TestVisibilityStore visibilityStore, SelfAdvancingTimer selfAdvancingTimer) {
        this.store = store;
        this.visibilityStore = visibilityStore;
        this.selfAdvancingTimer = selfAdvancingTimer;
        this.outOfProcessServer = null;
        this.inProcessServer = null;
        this.workflowServiceStubs = null;
    }

    @Override
    public void close() {
        log.debug("Shutting down TestWorkflowService");
        log.debug("Shutting down background scheduler");
        this.backgroundScheduler.shutdown();
        if (this.outOfProcessServer != null) {
            log.info("Shutting down out-of-process GRPC server");
            this.outOfProcessServer.shutdown();
        }
        if (this.workflowServiceStubs != null) {
            this.workflowServiceStubs.shutdown();
        }
        if (this.inProcessServer != null) {
            log.info("Shutting down in-process GRPC server");
            this.inProcessServer.shutdown();
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            if (this.outOfProcessServer != null) {
                this.outOfProcessServer.awaitTermination(1L, TimeUnit.SECONDS);
            }
            if (this.workflowServiceStubs != null) {
                this.workflowServiceStubs.awaitTermination(1L, TimeUnit.SECONDS);
            }
            if (this.inProcessServer != null) {
                this.inProcessServer.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("shutdown interrupted", (Throwable)e);
        }
        this.store.close();
    }

    private TestWorkflowMutableState getMutableState(ExecutionId executionId) {
        return this.getMutableState(executionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestWorkflowMutableState getMutableState(ExecutionId executionId, boolean failNotExists) {
        this.lock.lock();
        try {
            if (executionId.getExecution().getRunId().isEmpty()) {
                TestWorkflowMutableState testWorkflowMutableState = this.getMutableState(executionId.getWorkflowId(), failNotExists);
                return testWorkflowMutableState;
            }
            TestWorkflowMutableState mutableState = this.executions.get(executionId);
            if (mutableState == null && failNotExists) {
                throw Status.NOT_FOUND.withDescription("Execution \"" + executionId + "\" not found in mutable state. Known executions: " + this.executions.values() + ", service=" + this).asRuntimeException();
            }
            TestWorkflowMutableState testWorkflowMutableState = mutableState;
            return testWorkflowMutableState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestWorkflowMutableState getMutableState(WorkflowId workflowId, boolean failNotExists) {
        this.lock.lock();
        try {
            TestWorkflowMutableState mutableState = this.executionsByWorkflowId.get(workflowId);
            if (mutableState == null && failNotExists) {
                throw Status.NOT_FOUND.withDescription("Execution not found in mutable state: " + workflowId).asRuntimeException();
            }
            TestWorkflowMutableState testWorkflowMutableState = mutableState;
            return testWorkflowMutableState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void startWorkflowExecution(StartWorkflowExecutionRequest request, StreamObserver<StartWorkflowExecutionResponse> responseObserver) {
        try {
            java.time.Duration backoffInterval = CronUtils.getBackoffInterval(request.getCronSchedule(), this.store.currentTime());
            StartWorkflowExecutionResponse response = this.startWorkflowExecutionImpl(request, backoffInterval, Optional.empty(), OptionalLong.empty(), Optional.empty());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StartWorkflowExecutionResponse startWorkflowExecutionImpl(StartWorkflowExecutionRequest startRequest, java.time.Duration backoffStartInterval, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, Optional<SignalWorkflowExecutionRequest> signalWithStartSignal) {
        String requestWorkflowId = this.requireNotNull("WorkflowId", startRequest.getWorkflowId());
        String namespace = this.requireNotNull("Namespace", startRequest.getNamespace());
        WorkflowId workflowId = new WorkflowId(namespace, requestWorkflowId);
        this.lock.lock();
        try {
            Optional<Object> retryState;
            TestWorkflowMutableState existing = this.executionsByWorkflowId.get(workflowId);
            if (existing != null) {
                WorkflowExecutionStatus status = existing.getWorkflowExecutionStatus();
                WorkflowIdReusePolicy policy = startRequest.getWorkflowIdReusePolicy();
                if (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING || policy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_REJECT_DUPLICATE) {
                    StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.throwDuplicatedWorkflow(startRequest, existing);
                    return startWorkflowExecutionResponse;
                }
                if (policy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE_FAILED_ONLY && (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_COMPLETED || status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_CONTINUED_AS_NEW)) {
                    StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.throwDuplicatedWorkflow(startRequest, existing);
                    return startWorkflowExecutionResponse;
                }
            }
            Optional<Failure> lastFailure = Optional.empty();
            if (startRequest.hasRetryPolicy()) {
                java.time.Duration expirationInterval = ProtobufTimeUtils.toJavaDuration((Duration)startRequest.getWorkflowExecutionTimeout());
                retryState = this.newRetryStateLocked(startRequest.getRetryPolicy(), expirationInterval);
                if (retryState.isPresent()) {
                    lastFailure = ((TestServiceRetryState)retryState.get()).getPreviousRunFailure();
                }
            } else {
                retryState = Optional.empty();
            }
            String runId = UUID.randomUUID().toString();
            StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.startWorkflowExecutionNoRunningCheckLocked(startRequest, runId, runId, Optional.empty(), retryState, backoffStartInterval, null, lastFailure, parent, parentChildInitiatedEventId, signalWithStartSignal, workflowId);
            return startWorkflowExecutionResponse;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Optional<TestServiceRetryState> newRetryStateLocked(RetryPolicy retryPolicy, java.time.Duration expirationInterval) {
        Timestamp expirationTime = expirationInterval.isZero() ? Timestamps.fromNanos((long)0L) : Timestamps.add((Timestamp)this.store.currentTime(), (Duration)ProtobufTimeUtils.toProtoDuration((java.time.Duration)expirationInterval));
        return Optional.of(new TestServiceRetryState(retryPolicy, expirationTime));
    }

    private StartWorkflowExecutionResponse throwDuplicatedWorkflow(StartWorkflowExecutionRequest startRequest, TestWorkflowMutableState existing) {
        WorkflowExecution execution = existing.getExecutionId().getExecution();
        WorkflowExecutionAlreadyStartedFailure error = WorkflowExecutionAlreadyStartedFailure.newBuilder().setRunId(execution.getRunId()).setStartRequestId(startRequest.getRequestId()).build();
        throw StatusUtils.newException((Status)Status.ALREADY_EXISTS.withDescription(String.format("WorkflowId: %s, RunId: %s", execution.getWorkflowId(), execution.getRunId())), (GeneratedMessageV3)error, (Descriptors.Descriptor)WorkflowExecutionAlreadyStartedFailure.getDescriptor());
    }

    private StartWorkflowExecutionResponse startWorkflowExecutionNoRunningCheckLocked(StartWorkflowExecutionRequest startRequest, @Nonnull String runId, @Nonnull String firstExecutionRunId, Optional<String> continuedExecutionRunId, Optional<TestServiceRetryState> retryState, java.time.Duration backoffStartInterval, Payloads lastCompletionResult, Optional<Failure> lastFailure, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, Optional<SignalWorkflowExecutionRequest> signalWithStartSignal, WorkflowId workflowId) {
        String namespace = startRequest.getNamespace();
        TestWorkflowMutableStateImpl mutableState = new TestWorkflowMutableStateImpl(startRequest, firstExecutionRunId, runId, retryState, backoffStartInterval, lastCompletionResult, lastFailure, parent, parentChildInitiatedEventId, continuedExecutionRunId, this, this.store, this.visibilityStore, this.selfAdvancingTimer);
        WorkflowExecution execution = mutableState.getExecutionId().getExecution();
        ExecutionId executionId = new ExecutionId(namespace, execution);
        this.executionsByWorkflowId.put(workflowId, mutableState);
        this.executions.put(executionId, mutableState);
        mutableState.startWorkflow(continuedExecutionRunId.isPresent(), signalWithStartSignal);
        return StartWorkflowExecutionResponse.newBuilder().setRunId(execution.getRunId()).build();
    }

    public void getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, StreamObserver<GetWorkflowExecutionHistoryResponse> responseObserver) {
        ExecutionId executionId = new ExecutionId(getRequest.getNamespace(), getRequest.getExecution());
        this.executor.execute(Context.current().wrap(() -> {
            try {
                TestWorkflowMutableState mutableState = this.getMutableState(executionId);
                responseObserver.onNext((Object)this.store.getWorkflowExecutionHistory(mutableState.getExecutionId(), getRequest, Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS)));
                responseObserver.onCompleted();
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                    log.error("unexpected", (Throwable)e);
                }
                responseObserver.onError((Throwable)e);
            }
            catch (Exception e) {
                log.error("unexpected", (Throwable)e);
                responseObserver.onError((Throwable)e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T pollTaskQueue(Context ctx, Future<T> futureValue) throws ExecutionException, InterruptedException {
        Context.CancellationListener canceler = context -> futureValue.cancel(true);
        ctx.addListener(canceler, (Executor)this.backgroundScheduler);
        try {
            T t = futureValue.get();
            return t;
        }
        finally {
            ctx.removeListener(canceler);
        }
    }

    /*
     * Exception decompiling
     */
    public void pollWorkflowTaskQueue(PollWorkflowTaskQueueRequest pollRequest, StreamObserver<PollWorkflowTaskQueueResponse> responseObserver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void respondWorkflowTaskCompleted(RespondWorkflowTaskCompletedRequest request, StreamObserver<RespondWorkflowTaskCompletedResponse> responseObserver) {
        try {
            WorkflowTaskToken taskToken = WorkflowTaskToken.fromBytes(request.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(taskToken.getExecutionId());
            mutableState.completeWorkflowTask(taskToken.getHistorySize(), request);
            responseObserver.onNext((Object)RespondWorkflowTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
        catch (Throwable e) {
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(Throwables.getStackTraceAsString((Throwable)e)).withCause(e).asRuntimeException());
        }
    }

    public void respondWorkflowTaskFailed(RespondWorkflowTaskFailedRequest failedRequest, StreamObserver<RespondWorkflowTaskFailedResponse> responseObserver) {
        try {
            WorkflowTaskToken taskToken = WorkflowTaskToken.fromBytes(failedRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(taskToken.getExecutionId());
            mutableState.failWorkflowTask(failedRequest);
            responseObserver.onNext((Object)RespondWorkflowTaskFailedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private Context.CancellableContext deadlineCtx(Deadline deadline) {
        return Context.current().withDeadline(deadline, this.backgroundScheduler);
    }

    /*
     * Exception decompiling
     */
    public void pollActivityTaskQueue(PollActivityTaskQueueRequest pollRequest, StreamObserver<PollActivityTaskQueueResponse> responseObserver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest, StreamObserver<RecordActivityTaskHeartbeatResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(heartbeatRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            boolean cancelRequested = mutableState.heartbeatActivityTask(activityId.getScheduledEventId(), heartbeatRequest.getDetails());
            responseObserver.onNext((Object)RecordActivityTaskHeartbeatResponse.newBuilder().setCancelRequested(cancelRequested).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void recordActivityTaskHeartbeatById(RecordActivityTaskHeartbeatByIdRequest heartbeatRequest, StreamObserver<RecordActivityTaskHeartbeatByIdResponse> responseObserver) {
        try {
            ExecutionId execution = new ExecutionId(heartbeatRequest.getNamespace(), heartbeatRequest.getWorkflowId(), heartbeatRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(execution);
            boolean cancelRequested = mutableState.heartbeatActivityTaskById(heartbeatRequest.getActivityId(), heartbeatRequest.getDetails(), heartbeatRequest.getIdentity());
            responseObserver.onNext((Object)RecordActivityTaskHeartbeatByIdResponse.newBuilder().setCancelRequested(cancelRequested).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest, StreamObserver<RespondActivityTaskCompletedResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(completeRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            mutableState.completeActivityTask(activityId.getScheduledEventId(), completeRequest);
            responseObserver.onNext((Object)RespondActivityTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCompletedById(RespondActivityTaskCompletedByIdRequest completeRequest, StreamObserver<RespondActivityTaskCompletedByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(completeRequest.getNamespace(), completeRequest.getWorkflowId(), completeRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.completeActivityTaskById(completeRequest.getActivityId(), completeRequest);
            responseObserver.onNext((Object)RespondActivityTaskCompletedByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest, StreamObserver<RespondActivityTaskFailedResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(failRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            mutableState.failActivityTask(activityId.getScheduledEventId(), failRequest);
            responseObserver.onNext((Object)RespondActivityTaskFailedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskFailedById(RespondActivityTaskFailedByIdRequest failRequest, StreamObserver<RespondActivityTaskFailedByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(failRequest.getNamespace(), failRequest.getWorkflowId(), failRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.failActivityTaskById(failRequest.getActivityId(), failRequest);
            responseObserver.onNext((Object)RespondActivityTaskFailedByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest, StreamObserver<RespondActivityTaskCanceledResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(canceledRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            mutableState.cancelActivityTask(activityId.getScheduledEventId(), canceledRequest);
            responseObserver.onNext((Object)RespondActivityTaskCanceledResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCanceledById(RespondActivityTaskCanceledByIdRequest canceledRequest, StreamObserver<RespondActivityTaskCanceledByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(canceledRequest.getNamespace(), canceledRequest.getWorkflowId(), canceledRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.cancelActivityTaskById(canceledRequest.getActivityId(), canceledRequest);
            responseObserver.onNext((Object)RespondActivityTaskCanceledByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, StreamObserver<RequestCancelWorkflowExecutionResponse> responseObserver) {
        try {
            this.requestCancelWorkflowExecution(cancelRequest, Optional.empty());
            responseObserver.onNext((Object)RequestCancelWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, Optional<TestWorkflowMutableStateImpl.CancelExternalWorkflowExecutionCallerInfo> callerInfo) {
        ExecutionId executionId = new ExecutionId(cancelRequest.getNamespace(), cancelRequest.getWorkflowExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        mutableState.requestCancelWorkflowExecution(cancelRequest, callerInfo);
    }

    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request, StreamObserver<TerminateWorkflowExecutionResponse> responseObserver) {
        try {
            this.terminateWorkflowExecution(request);
            responseObserver.onNext((Object)TerminateWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request) {
        ExecutionId executionId = new ExecutionId(request.getNamespace(), request.getWorkflowExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        mutableState.terminateWorkflowExecution(request);
    }

    public void signalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest, StreamObserver<SignalWorkflowExecutionResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(signalRequest.getNamespace(), signalRequest.getWorkflowExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.signal(signalRequest);
            responseObserver.onNext((Object)SignalWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void signalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest r, StreamObserver<SignalWithStartWorkflowExecutionResponse> responseObserver) {
        try {
            if (!r.hasTaskQueue()) {
                throw Status.INVALID_ARGUMENT.withDescription("request missing required taskQueue field").asRuntimeException();
            }
            if (!r.hasWorkflowType()) {
                throw Status.INVALID_ARGUMENT.withDescription("request missing required workflowType field").asRuntimeException();
            }
            ExecutionId executionId = new ExecutionId(r.getNamespace(), r.getWorkflowId(), null);
            TestWorkflowMutableState mutableState = this.getMutableState(executionId, false);
            SignalWorkflowExecutionRequest signalRequest = SignalWorkflowExecutionRequest.newBuilder().setInput(r.getSignalInput()).setSignalName(r.getSignalName()).setWorkflowExecution(executionId.getExecution()).setRequestId(r.getRequestId()).setControl(r.getControl()).setNamespace(r.getNamespace()).setIdentity(r.getIdentity()).build();
            if (mutableState != null && !mutableState.isTerminalState()) {
                mutableState.signal(signalRequest);
                responseObserver.onNext((Object)SignalWithStartWorkflowExecutionResponse.newBuilder().setRunId(mutableState.getExecutionId().getExecution().getRunId()).build());
                responseObserver.onCompleted();
                return;
            }
            StartWorkflowExecutionRequest.Builder startRequest = StartWorkflowExecutionRequest.newBuilder().setRequestId(r.getRequestId()).setInput(r.getInput()).setWorkflowExecutionTimeout(r.getWorkflowExecutionTimeout()).setWorkflowRunTimeout(r.getWorkflowRunTimeout()).setWorkflowTaskTimeout(r.getWorkflowTaskTimeout()).setNamespace(r.getNamespace()).setTaskQueue(r.getTaskQueue()).setWorkflowId(r.getWorkflowId()).setWorkflowIdReusePolicy(r.getWorkflowIdReusePolicy()).setIdentity(r.getIdentity()).setWorkflowType(r.getWorkflowType()).setCronSchedule(r.getCronSchedule()).setRequestId(r.getRequestId());
            if (r.hasRetryPolicy()) {
                startRequest.setRetryPolicy(r.getRetryPolicy());
            }
            if (r.hasHeader()) {
                startRequest.setHeader(r.getHeader());
            }
            if (r.hasMemo()) {
                startRequest.setMemo(r.getMemo());
            }
            if (r.hasSearchAttributes()) {
                startRequest.setSearchAttributes(r.getSearchAttributes());
            }
            StartWorkflowExecutionResponse startResult = this.startWorkflowExecutionImpl(startRequest.build(), java.time.Duration.ZERO, Optional.empty(), OptionalLong.empty(), Optional.of(signalRequest));
            responseObserver.onNext((Object)SignalWithStartWorkflowExecutionResponse.newBuilder().setRunId(startResult.getRunId()).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void signalExternalWorkflowExecution(String signalId, SignalExternalWorkflowExecutionCommandAttributes commandAttributes, TestWorkflowMutableState source) {
        String namespace = commandAttributes.getNamespace().isEmpty() ? source.getExecutionId().getNamespace() : commandAttributes.getNamespace();
        ExecutionId executionId = new ExecutionId(namespace, commandAttributes.getExecution());
        try {
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.signalFromWorkflow(commandAttributes);
            source.completeSignalExternalWorkflowExecution(signalId, mutableState.getExecutionId().getExecution().getRunId());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                source.failSignalExternalWorkflowExecution(signalId, SignalExternalWorkflowExecutionFailedCause.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_CAUSE_EXTERNAL_WORKFLOW_EXECUTION_NOT_FOUND);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String continueAsNew(StartWorkflowExecutionRequest previousRunStartRequest, WorkflowExecutionContinuedAsNewEventAttributes a, Optional<TestServiceRetryState> retryState, String identity, ExecutionId continuedExecutionId, String firstExecutionRunId, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId) {
        StartWorkflowExecutionRequest.Builder startRequestBuilder = StartWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setWorkflowType(a.getWorkflowType()).setWorkflowRunTimeout(a.getWorkflowRunTimeout()).setWorkflowTaskTimeout(a.getWorkflowTaskTimeout()).setNamespace(continuedExecutionId.getNamespace()).setTaskQueue(a.getTaskQueue()).setWorkflowId(continuedExecutionId.getWorkflowId().getWorkflowId()).setWorkflowIdReusePolicy(previousRunStartRequest.getWorkflowIdReusePolicy()).setIdentity(identity).setCronSchedule(previousRunStartRequest.getCronSchedule());
        if (previousRunStartRequest.hasRetryPolicy()) {
            startRequestBuilder.setRetryPolicy(previousRunStartRequest.getRetryPolicy());
        }
        if (a.hasInput()) {
            startRequestBuilder.setInput(a.getInput());
        }
        if (a.hasHeader()) {
            startRequestBuilder.setHeader(a.getHeader());
        }
        StartWorkflowExecutionRequest startRequest = startRequestBuilder.build();
        this.lock.lock();
        Optional<Object> lastFail = a.hasFailure() ? Optional.of(a.getFailure()) : retryState.flatMap(TestServiceRetryState::getPreviousRunFailure);
        try {
            StartWorkflowExecutionResponse response = this.startWorkflowExecutionNoRunningCheckLocked(startRequest, a.getNewExecutionRunId(), firstExecutionRunId, Optional.of(continuedExecutionId.getExecution().getRunId()), retryState, ProtobufTimeUtils.toJavaDuration((Duration)a.getBackoffStartInterval()), a.getLastCompletionResult(), lastFail, parent, parentChildInitiatedEventId, Optional.empty(), continuedExecutionId.getWorkflowId());
            String string = response.getRunId();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest, StreamObserver<ListOpenWorkflowExecutionsResponse> responseObserver) {
        try {
            Optional<String> workflowIdFilter = listRequest.hasExecutionFilter() && !listRequest.getExecutionFilter().getWorkflowId().isEmpty() ? Optional.of(listRequest.getExecutionFilter().getWorkflowId()) : Optional.empty();
            List<WorkflowExecutionInfo> result = this.store.listWorkflows(TestWorkflowStore.WorkflowState.OPEN, workflowIdFilter);
            responseObserver.onNext((Object)ListOpenWorkflowExecutionsResponse.newBuilder().addAllExecutions(result).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest, StreamObserver<ListClosedWorkflowExecutionsResponse> responseObserver) {
        try {
            Optional<String> workflowIdFilter = listRequest.hasExecutionFilter() && !listRequest.getExecutionFilter().getWorkflowId().isEmpty() ? Optional.of(listRequest.getExecutionFilter().getWorkflowId()) : Optional.empty();
            List<WorkflowExecutionInfo> result = this.store.listWorkflows(TestWorkflowStore.WorkflowState.CLOSED, workflowIdFilter);
            responseObserver.onNext((Object)ListClosedWorkflowExecutionsResponse.newBuilder().addAllExecutions(result).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest, StreamObserver<RespondQueryTaskCompletedResponse> responseObserver) {
        try {
            QueryId queryId = QueryId.fromBytes(completeRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(queryId.getExecutionId());
            mutableState.completeQuery(queryId, completeRequest);
            responseObserver.onNext((Object)RespondQueryTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void queryWorkflow(QueryWorkflowRequest queryRequest, StreamObserver<QueryWorkflowResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(queryRequest.getNamespace(), queryRequest.getExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            Deadline deadline = Context.current().getDeadline();
            QueryWorkflowResponse result = mutableState.query(queryRequest, deadline != null ? deadline.timeRemaining(TimeUnit.MILLISECONDS) : Long.MAX_VALUE);
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void describeWorkflowExecution(DescribeWorkflowExecutionRequest request, StreamObserver<DescribeWorkflowExecutionResponse> responseObserver) {
        try {
            if (request.getNamespace().isEmpty()) {
                throw TestWorkflowService.createInvalidArgument("Namespace not set on request.");
            }
            if (!request.hasExecution()) {
                throw TestWorkflowService.createInvalidArgument("Execution not set on request.");
            }
            ExecutionId executionId = new ExecutionId(request.getNamespace(), request.getExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            DescribeWorkflowExecutionResponse result = mutableState.describeWorkflowExecution();
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void describeNamespace(DescribeNamespaceRequest request, StreamObserver<DescribeNamespaceResponse> responseObserver) {
        try {
            if (request.getNamespace().isEmpty()) {
                throw TestWorkflowService.createInvalidArgument("Namespace not set on request.");
            }
            String namespaceId = UUID.nameUUIDFromBytes(request.getNamespace().getBytes()).toString();
            DescribeNamespaceResponse result = DescribeNamespaceResponse.newBuilder().setNamespaceInfo(NamespaceInfo.newBuilder().setName(request.getNamespace()).setState(NamespaceState.NAMESPACE_STATE_REGISTERED).setId(namespaceId).build()).build();
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private <R> R requireNotNull(String fieldName, R value) {
        if (value == null) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing required field \"" + fieldName + "\".").asRuntimeException();
        }
        return value;
    }

    public void getDiagnostics(StringBuilder result) {
        this.store.getDiagnostics(result);
    }

    @Deprecated
    public long currentTimeMillis() {
        return this.selfAdvancingTimer.getClock().getAsLong();
    }

    public void registerDelayedCallback(java.time.Duration delay, Runnable r) {
        this.store.registerDelayedCallback(delay, r);
    }

    @Deprecated
    public void lockTimeSkipping(String caller) {
        this.selfAdvancingTimer.lockTimeSkipping(caller);
    }

    @Deprecated
    public void unlockTimeSkipping(String caller) {
        this.selfAdvancingTimer.unlockTimeSkipping(caller);
    }

    @Deprecated
    public void sleep(java.time.Duration duration) {
        CompletableFuture result = new CompletableFuture();
        this.selfAdvancingTimer.schedule(duration, () -> {
            this.selfAdvancingTimer.lockTimeSkipping("TestWorkflowService sleep");
            result.complete(null);
        }, "workflow sleep");
        this.selfAdvancingTimer.unlockTimeSkipping("TestWorkflowService sleep");
        try {
            result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Deadline getLongPollDeadline() {
        Deadline deadline = Context.current().getDeadline();
        Deadline maximumDeadline = Deadline.after((long)WorkflowServiceStubsOptions.DEFAULT_SERVER_LONG_POLL_RPC_TIMEOUT.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        return deadline != null ? deadline.minimum(maximumDeadline) : maximumDeadline;
    }

    private void handleStatusRuntimeException(StatusRuntimeException e, StreamObserver<?> responseObserver) {
        if (e.getStatus().getCode() == Status.Code.INTERNAL) {
            log.error("unexpected", (Throwable)e);
        }
        responseObserver.onError((Throwable)e);
    }

    @Deprecated
    public TestWorkflowService() {
        this(0L, true);
    }

    @Deprecated
    public TestWorkflowService(long initialTimeMillis) {
        this(initialTimeMillis, true);
    }

    @Deprecated
    public TestWorkflowService(boolean lockTimeSkipping) {
        this(0L, true);
        if (lockTimeSkipping) {
            this.lockTimeSkipping("constructor");
        }
    }

    @Deprecated
    public static TestWorkflowService createWithNoGrpcServer() {
        return new TestWorkflowService(0L, false);
    }

    private TestWorkflowService(long initialTimeMillis, boolean startInProcessServer) {
        this.selfAdvancingTimer = new SelfAdvancingTimerImpl(initialTimeMillis, Clock.systemDefaultZone());
        this.store = new TestWorkflowStoreImpl(this.selfAdvancingTimer);
        this.visibilityStore = new TestVisibilityStoreImpl();
        this.outOfProcessServer = null;
        if (startInProcessServer) {
            this.inProcessServer = new InProcessGRPCServer(Collections.singletonList(this));
            this.workflowServiceStubs = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)((WorkflowServiceStubsOptions.Builder)WorkflowServiceStubsOptions.newBuilder().setChannel(this.inProcessServer.getChannel())).build());
        } else {
            this.inProcessServer = null;
            this.workflowServiceStubs = null;
        }
    }

    @Deprecated
    public static TestWorkflowService createServerOnly(int port) {
        TestWorkflowService result = new TestWorkflowService(true, port);
        log.info("Server started, listening on " + port);
        return result;
    }

    private TestWorkflowService(boolean isOutOfProc, int port) {
        Preconditions.checkState((boolean)isOutOfProc, (Object)"Impossible.");
        this.inProcessServer = null;
        this.workflowServiceStubs = null;
        this.selfAdvancingTimer = new SelfAdvancingTimerImpl(0L, Clock.systemDefaultZone());
        this.store = new TestWorkflowStoreImpl(this.selfAdvancingTimer);
        this.visibilityStore = new TestVisibilityStoreImpl();
        try {
            ServerBuilder serverBuilder = Grpc.newServerBuilderForPort((int)port, (ServerCredentials)InsecureServerCredentials.create());
            GRPCServerHelper.registerServicesAndHealthChecks(Collections.singletonList(this), (ServerBuilder)serverBuilder);
            this.outOfProcessServer = serverBuilder.build().start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public WorkflowServiceStubs newClientStub() {
        if (this.workflowServiceStubs == null) {
            throw new RuntimeException("Cannot get a client when you created your TestWorkflowService with createServerOnly.");
        }
        return this.workflowServiceStubs;
    }

    private static StatusRuntimeException createInvalidArgument(String description) {
        throw Status.INVALID_ARGUMENT.withDescription(description).asRuntimeException();
    }
}

