/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.StatusRuntimeException;
import io.temporal.api.command.v1.Command;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import io.temporal.failure.ServerFailure;
import io.temporal.internal.common.ProtoEnumNameUtils;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.TestVisibilityStore;

class CommandVerifier {
    private final TestVisibilityStore visibilityStore;

    public CommandVerifier(TestVisibilityStore visibilityStore) {
        this.visibilityStore = visibilityStore;
    }

    InvalidCommandResult verifyCommand(RequestContext ctx, Command d) {
        switch (d.getCommandType()) {
            case COMMAND_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES: {
                try {
                    this.visibilityStore.validateSearchAttributes(d.getUpsertWorkflowSearchAttributesCommandAttributes().getSearchAttributes());
                    break;
                }
                catch (StatusRuntimeException e) {
                    ServerFailure eventAttributesFailure = new ServerFailure(ProtoEnumNameUtils.uniqueToSimplifiedName((Enum)WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_BAD_SEARCH_ATTRIBUTES) + ": " + e.getStatus().getDescription(), true);
                    return new InvalidCommandResult(WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_BAD_SEARCH_ATTRIBUTES, eventAttributesFailure, (RuntimeException)((Object)e));
                }
            }
        }
        return null;
    }

    static class InvalidCommandResult {
        private final WorkflowTaskFailedCause workflowTaskFailedCause;
        private final ServerFailure eventAttributesFailure;
        private final RuntimeException clientException;

        public InvalidCommandResult(WorkflowTaskFailedCause workflowTaskFailedCause, ServerFailure eventAttributesFailure, RuntimeException clientException) {
            this.workflowTaskFailedCause = workflowTaskFailedCause;
            this.eventAttributesFailure = eventAttributesFailure;
            this.clientException = clientException;
        }

        public WorkflowTaskFailedCause getWorkflowTaskFailedCause() {
            return this.workflowTaskFailedCause;
        }

        public ServerFailure getEventAttributesFailure() {
            return this.eventAttributesFailure;
        }

        public RuntimeException getClientException() {
            return this.clientException;
        }
    }
}

