/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.base.MoreObjects;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.TestWorkflowMutableState;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.workflow.Functions;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RequestContext {
    private final LongSupplier clock;
    private final ExecutionId executionId;
    private final TestWorkflowMutableState workflowMutableState;
    private final long initialEventId;
    private final List<HistoryEvent> events = new ArrayList<HistoryEvent>();
    private final List<CommitCallback> commitCallbacks = new ArrayList<CommitCallback>();
    private TestWorkflowStore.WorkflowTask workflowTaskForMatching;
    private final List<TestWorkflowStore.ActivityTask> activityTasks = new ArrayList<TestWorkflowStore.ActivityTask>();
    private final List<Timer> timers = new ArrayList<Timer>();
    private long workflowCompletedAtEventId = -1L;
    private boolean needWorkflowTask;
    private final List<TimerLockChange> timerLocks = new ArrayList<TimerLockChange>();
    private RuntimeException exception;

    RequestContext(LongSupplier clock, TestWorkflowMutableState workflowMutableState, long initialEventId) {
        this.clock = Objects.requireNonNull(clock);
        this.workflowMutableState = Objects.requireNonNull(workflowMutableState);
        this.executionId = Objects.requireNonNull(workflowMutableState.getExecutionId());
        if (initialEventId <= 0L) {
            throw new IllegalArgumentException("Invalid initialEventId: " + initialEventId);
        }
        this.initialEventId = initialEventId;
    }

    void add(RequestContext ctx) {
        this.activityTasks.addAll(ctx.getActivityTasks());
        this.timers.addAll(ctx.getTimers());
        this.events.addAll(ctx.getEvents());
    }

    void lockTimer(String caller) {
        this.timerLocks.add(new TimerLockChange(caller, 1));
    }

    void unlockTimer(String caller) {
        this.timerLocks.add(new TimerLockChange(caller, -1));
    }

    List<TimerLockChange> getTimerLocks() {
        return this.timerLocks;
    }

    void clearTimersAndLocks() {
        this.timerLocks.clear();
        this.timers.clear();
    }

    Timestamp currentTime() {
        return Timestamps.fromMillis((long)this.clock.getAsLong());
    }

    long addEvent(HistoryEvent event) {
        if (this.workflowMutableState.isTerminalState()) {
            throw Status.NOT_FOUND.withDescription("workflow execution already completed").asRuntimeException();
        }
        long eventId = this.initialEventId + (long)this.events.size();
        if (WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)event)) {
            this.workflowCompletedAtEventId = eventId;
        } else if (this.workflowCompletedAtEventId > 0L && this.workflowCompletedAtEventId < eventId) {
            throw new IllegalStateException("Event added after the workflow completion event");
        }
        this.events.add(event);
        return eventId;
    }

    WorkflowExecution getExecution() {
        return this.executionId.getExecution();
    }

    public TestWorkflowMutableState getWorkflowMutableState() {
        return this.workflowMutableState;
    }

    String getNamespace() {
        return this.executionId.getNamespace();
    }

    public long getInitialEventId() {
        return this.initialEventId;
    }

    public long getNextEventId() {
        return this.initialEventId + (long)this.events.size();
    }

    void setNeedWorkflowTask(boolean needWorkflowTask) {
        this.needWorkflowTask = needWorkflowTask;
    }

    boolean isNeedWorkflowTask() {
        return this.needWorkflowTask;
    }

    void setWorkflowTaskForMatching(@Nonnull TestWorkflowStore.WorkflowTask workflowTaskForMatching) {
        this.workflowTaskForMatching = Objects.requireNonNull(workflowTaskForMatching);
    }

    @Nullable
    TestWorkflowStore.WorkflowTask resetWorkflowTaskForMatching() {
        TestWorkflowStore.WorkflowTask existingTask = this.workflowTaskForMatching;
        this.workflowTaskForMatching = null;
        return existingTask;
    }

    TestWorkflowStore.WorkflowTask getWorkflowTaskForMatching() {
        return this.workflowTaskForMatching;
    }

    void addActivityTask(TestWorkflowStore.ActivityTask activityTask) {
        this.activityTasks.add(activityTask);
    }

    Functions.Proc addTimer(Duration delay, Runnable callback, String name) {
        Timer timer = new Timer(delay, callback, name);
        this.timers.add(timer);
        return timer.getCancellationHandle();
    }

    public List<Timer> getTimers() {
        return this.timers;
    }

    List<TestWorkflowStore.ActivityTask> getActivityTasks() {
        return this.activityTasks;
    }

    List<HistoryEvent> getEvents() {
        return this.events;
    }

    void onCommit(CommitCallback callback) {
        this.commitCallbacks.add(callback);
    }

    long commitChanges(TestWorkflowStore store) {
        return store.save(this);
    }

    void fireCallbacks(int historySize) {
        for (CommitCallback callback : this.commitCallbacks) {
            callback.apply(historySize);
        }
    }

    ExecutionId getExecutionId() {
        return this.executionId;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public void setExceptionIfEmpty(RuntimeException exception) {
        this.exception = (RuntimeException)MoreObjects.firstNonNull((Object)this.exception, (Object)exception);
    }

    static final class TimerLockChange {
        private final String caller;
        private final int change;

        TimerLockChange(String caller, int change) {
            this.caller = Objects.requireNonNull(caller);
            if (change != -1 && change != 1) {
                throw new IllegalArgumentException("Invalid change: " + change);
            }
            this.change = change;
        }

        public String getCaller() {
            return this.caller;
        }

        public int getChange() {
            return this.change;
        }
    }

    static final class Timer {
        private final Duration delay;
        private final Runnable callback;
        private final String taskInfo;
        private Functions.Proc cancellationHandle;
        private final Functions.Proc cancellationHandleWrapper;

        Timer(Duration delay, Runnable callback, String taskInfo) {
            this.delay = delay;
            this.callback = callback;
            this.taskInfo = taskInfo;
            this.cancellationHandleWrapper = (Functions.Proc & Serializable)() -> {
                if (this.cancellationHandle != null) {
                    this.cancellationHandle.apply();
                }
            };
        }

        Duration getDelay() {
            return this.delay;
        }

        Runnable getCallback() {
            return this.callback;
        }

        String getTaskInfo() {
            return this.taskInfo;
        }

        public void setCancellationHandle(Functions.Proc cancellationHandle) {
            this.cancellationHandle = cancellationHandle;
        }

        public Functions.Proc getCancellationHandle() {
            return this.cancellationHandleWrapper;
        }
    }

    @FunctionalInterface
    static interface CommitCallback {
        public void apply(int var1);
    }
}

