/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.internal.testservice.ExecutionId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

class NexusTaskToken {
    @Nonnull
    private final ExecutionId executionId;
    private final long scheduledEventId;
    private final int attempt;

    NexusTaskToken(@Nonnull String namespace, @Nonnull WorkflowExecution execution, long scheduledEventId, int attempt) {
        this(new ExecutionId(Objects.requireNonNull(namespace), Objects.requireNonNull(execution)), scheduledEventId, attempt);
    }

    NexusTaskToken(@Nonnull String namespace, @Nonnull String workflowId, @Nonnull String runId, long scheduledEventId, int attempt) {
        this(namespace, WorkflowExecution.newBuilder().setWorkflowId(Objects.requireNonNull(workflowId)).setRunId(Objects.requireNonNull(runId)).build(), scheduledEventId, attempt);
    }

    NexusTaskToken(@Nonnull ExecutionId executionId, long scheduledEventId, int attempt) {
        this.executionId = Objects.requireNonNull(executionId);
        this.scheduledEventId = scheduledEventId;
        this.attempt = attempt;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public long getScheduledEventId() {
        return this.scheduledEventId;
    }

    public long getAttempt() {
        return this.attempt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteString toBytes() {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ByteString byteString;
            try (DataOutputStream out = new DataOutputStream(bout);){
                out.writeUTF(this.executionId.getNamespace());
                WorkflowExecution execution = this.executionId.getExecution();
                out.writeUTF(execution.getWorkflowId());
                out.writeUTF(execution.getRunId());
                out.writeLong(this.scheduledEventId);
                out.writeInt(this.attempt);
                byteString = ByteString.copyFrom((byte[])bout.toByteArray());
            }
            return byteString;
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }

    static NexusTaskToken fromBytes(ByteString serialized) {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized.toByteArray());
        DataInputStream in = new DataInputStream(bin);
        try {
            String namespace = in.readUTF();
            String workflowId = in.readUTF();
            String runId = in.readUTF();
            long scheduledEventId = in.readLong();
            int attempt = in.readInt();
            return new NexusTaskToken(namespace, workflowId, runId, scheduledEventId, attempt);
        }
        catch (IOException e) {
            throw Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }
}

