/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.internal.common.ProtoEnumNameUtils;
import io.temporal.internal.common.SearchAttributesUtil;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.TestVisibilityStore;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

class TestVisibilityStoreImpl
implements TestVisibilityStore {
    private static final String DEFAULT_KEY_STRING = "CustomStringField";
    private static final String DEFAULT_KEY_TEXT = "CustomTextField";
    private static final String DEFAULT_KEY_KEYWORD = "CustomKeywordField";
    private static final String DEFAULT_KEY_INTEGER = "CustomIntField";
    private static final String DEFAULT_KEY_DATE_TIME = "CustomDatetimeField";
    private static final String DEFAULT_KEY_DOUBLE = "CustomDoubleField";
    private static final String DEFAULT_KEY_BOOL = "CustomBoolField";
    private static final String TEMPORAL_CHANGE_VERSION = "TemporalChangeVersion";
    private final Map<String, IndexedValueType> searchAttributes = new ConcurrentHashMap<String, IndexedValueType>((Map<String, IndexedValueType>)ImmutableMap.builder().put((Object)"CustomStringField", (Object)IndexedValueType.INDEXED_VALUE_TYPE_TEXT).put((Object)"CustomTextField", (Object)IndexedValueType.INDEXED_VALUE_TYPE_TEXT).put((Object)"CustomKeywordField", (Object)IndexedValueType.INDEXED_VALUE_TYPE_KEYWORD).put((Object)"CustomIntField", (Object)IndexedValueType.INDEXED_VALUE_TYPE_INT).put((Object)"CustomDoubleField", (Object)IndexedValueType.INDEXED_VALUE_TYPE_DOUBLE).put((Object)"CustomBoolField", (Object)IndexedValueType.INDEXED_VALUE_TYPE_BOOL).put((Object)"CustomDatetimeField", (Object)IndexedValueType.INDEXED_VALUE_TYPE_DATETIME).put((Object)"TemporalChangeVersion", (Object)IndexedValueType.INDEXED_VALUE_TYPE_KEYWORD_LIST).build());
    private final Map<ExecutionId, SearchAttributes> executionSearchAttributes = new ConcurrentHashMap<ExecutionId, SearchAttributes>();

    TestVisibilityStoreImpl() {
    }

    @Override
    public void addSearchAttribute(String name, IndexedValueType type) {
        if (type == IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED) {
            throw Status.INVALID_ARGUMENT.withDescription("Unable to read search attribute type: " + type).asRuntimeException();
        }
        if (this.searchAttributes.putIfAbsent(name, type) != null) {
            throw Status.ALREADY_EXISTS.withDescription("Search attribute " + name + " already exists.").asRuntimeException();
        }
    }

    @Override
    public void removeSearchAttribute(String name) {
        if (this.searchAttributes.remove(name) == null) {
            throw Status.NOT_FOUND.withDescription("Search attribute " + name + " doesn't exist.").asRuntimeException();
        }
    }

    @Override
    public Map<String, IndexedValueType> getRegisteredSearchAttributes() {
        return Collections.unmodifiableMap(this.searchAttributes);
    }

    @Override
    public SearchAttributes getSearchAttributesForExecution(ExecutionId executionId) {
        return this.executionSearchAttributes.get(executionId);
    }

    @Override
    public SearchAttributes upsertSearchAttributesForExecution(ExecutionId executionId, @Nonnull SearchAttributes searchAttributes) {
        this.validateSearchAttributes(searchAttributes);
        return this.executionSearchAttributes.compute(executionId, (key, value) -> value == null ? searchAttributes : value.toBuilder().putAllIndexedFields(searchAttributes.getIndexedFieldsMap()).build());
    }

    @Override
    public void validateSearchAttributes(SearchAttributes searchAttributes) {
        Map<String, IndexedValueType> registeredAttributes = this.getRegisteredSearchAttributes();
        for (Map.Entry searchAttribute : searchAttributes.getIndexedFieldsMap().entrySet()) {
            String saName = (String)searchAttribute.getKey();
            IndexedValueType indexedValueType = registeredAttributes.get(saName);
            if (indexedValueType == null) {
                throw Status.INVALID_ARGUMENT.withDescription("search attribute " + saName + " is not defined").asRuntimeException();
            }
            try {
                SearchAttributesUtil.decodeAsType((SearchAttributes)searchAttributes, (String)saName, (IndexedValueType)indexedValueType);
            }
            catch (Exception e) {
                throw Status.INVALID_ARGUMENT.withDescription("invalid value for search attribute " + saName + " of type " + ProtoEnumNameUtils.uniqueToSimplifiedName((Enum)indexedValueType) + ": " + ((Payload)searchAttributes.getIndexedFieldsMap().get(saName)).getData().toStringUtf8()).asRuntimeException();
            }
        }
    }

    @Override
    public void close() {
    }
}

