/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.command.v1.CancelTimerCommandAttributes;
import io.temporal.api.command.v1.CancelWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.CompleteWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.FailWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ModifyWorkflowPropertiesCommandAttributes;
import io.temporal.api.command.v1.ProtocolMessageCommandAttributes;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.command.v1.RequestCancelActivityTaskCommandAttributes;
import io.temporal.api.command.v1.RequestCancelExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.RequestCancelNexusOperationCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.ScheduleNexusOperationCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartTimerCommandAttributes;
import io.temporal.api.command.v1.UpsertWorkflowSearchAttributesCommandAttributes;
import io.temporal.api.common.v1.Callback;
import io.temporal.api.common.v1.Link;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.NexusOperationCancellationState;
import io.temporal.api.enums.v1.PendingActivityState;
import io.temporal.api.enums.v1.PendingNexusOperationState;
import io.temporal.api.enums.v1.QueryRejectCondition;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.enums.v1.SignalExternalWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.TimeoutType;
import io.temporal.api.enums.v1.UpdateWorkflowExecutionLifecycleStage;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import io.temporal.api.errordetails.v1.QueryFailedFailure;
import io.temporal.api.failure.v1.ApplicationFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.ActivityTaskScheduledEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionCanceledEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionCompletedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionStartedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionTimedOutEventAttributes;
import io.temporal.api.history.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.api.history.v1.NexusOperationCancelRequestedEventAttributes;
import io.temporal.api.history.v1.StartChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.UpsertWorkflowSearchAttributesEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionSignaledEventAttributes;
import io.temporal.api.history.v1.WorkflowPropertiesModifiedEventAttributes;
import io.temporal.api.nexus.v1.Endpoint;
import io.temporal.api.nexus.v1.Link;
import io.temporal.api.nexus.v1.StartOperationResponse;
import io.temporal.api.protocol.v1.Message;
import io.temporal.api.query.v1.QueryRejected;
import io.temporal.api.query.v1.WorkflowQueryResult;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.update.v1.Acceptance;
import io.temporal.api.update.v1.Outcome;
import io.temporal.api.update.v1.Rejection;
import io.temporal.api.update.v1.Response;
import io.temporal.api.update.v1.UpdateRef;
import io.temporal.api.workflow.v1.CallbackInfo;
import io.temporal.api.workflow.v1.NexusOperationCancellationInfo;
import io.temporal.api.workflow.v1.PendingActivityInfo;
import io.temporal.api.workflow.v1.PendingChildExecutionInfo;
import io.temporal.api.workflow.v1.PendingNexusOperationInfo;
import io.temporal.api.workflow.v1.WorkflowExecutionConfig;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.UpdateWorkflowExecutionRequest;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.failure.ServerFailure;
import io.temporal.internal.common.LinkConverter;
import io.temporal.internal.common.ProtoEnumNameUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.testservice.ActivityTaskToken;
import io.temporal.internal.testservice.CommandVerifier;
import io.temporal.internal.testservice.CronUtils;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.LockHandle;
import io.temporal.internal.testservice.NexusOperationRef;
import io.temporal.internal.testservice.NexusTaskToken;
import io.temporal.internal.testservice.QueryId;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.internal.testservice.StateMachine;
import io.temporal.internal.testservice.StateMachines;
import io.temporal.internal.testservice.StateUtils;
import io.temporal.internal.testservice.TestNexusEndpointStore;
import io.temporal.internal.testservice.TestServiceRetryState;
import io.temporal.internal.testservice.TestVisibilityStore;
import io.temporal.internal.testservice.TestWorkflowMutableState;
import io.temporal.internal.testservice.TestWorkflowService;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.serviceclient.StatusUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestWorkflowMutableStateImpl
implements TestWorkflowMutableState {
    static final Failure FAILED_UPDATE_ON_WF_COMPLETION = Failure.newBuilder().setMessage("Workflow Update failed because the Workflow completed before the Update completed.").setSource("Server").setApplicationFailureInfo(ApplicationFailureInfo.newBuilder().setType("AcceptedUpdateCompletedWorkflow").setNonRetryable(true).build()).build();
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowMutableStateImpl.class);
    private final Lock lock = new ReentrantLock();
    private final SelfAdvancingTimer timerService;
    private final LongSupplier clock;
    private final ExecutionId executionId;
    private final Optional<TestWorkflowMutableState> parent;
    private final OptionalLong parentChildInitiatedEventId;
    private final TestWorkflowStore store;
    private final TestVisibilityStore visibilityStore;
    private final TestNexusEndpointStore nexusEndpointStore;
    private final TestWorkflowService service;
    private final CommandVerifier commandVerifier;
    private final StartWorkflowExecutionRequest startRequest;
    private long nextEventId = 1L;
    private final Map<Long, StateMachine<StateMachines.ActivityTaskData>> activities = new HashMap<Long, StateMachine<StateMachines.ActivityTaskData>>();
    private final Map<String, Long> activityById = new HashMap<String, Long>();
    private final Map<Long, StateMachine<StateMachines.ChildWorkflowData>> childWorkflows = new HashMap<Long, StateMachine<StateMachines.ChildWorkflowData>>();
    private final Map<Long, StateMachine<StateMachines.NexusOperationData>> nexusOperations = new HashMap<Long, StateMachine<StateMachines.NexusOperationData>>();
    private final Map<String, StateMachine<StateMachines.TimerData>> timers = new HashMap<String, StateMachine<StateMachines.TimerData>>();
    private final Map<String, StateMachine<StateMachines.SignalExternalData>> externalSignals = new HashMap<String, StateMachine<StateMachines.SignalExternalData>>();
    private final Map<String, StateMachine<StateMachines.CancelExternalData>> externalCancellations = new HashMap<String, StateMachine<StateMachines.CancelExternalData>>();
    private final Map<String, StateMachine<StateMachines.UpdateWorkflowExecutionData>> updates = new HashMap<String, StateMachine<StateMachines.UpdateWorkflowExecutionData>>();
    private final StateMachine<StateMachines.WorkflowData> workflow;
    private final StateMachine<StateMachines.WorkflowTaskData> workflowTaskStateMachine;
    private final Map<String, CompletableFuture<QueryWorkflowResponse>> queries = new ConcurrentHashMap<String, CompletableFuture<QueryWorkflowResponse>>();
    public StickyExecutionAttributes stickyExecutionAttributes;
    private Map<String, Payload> currentMemo;

    TestWorkflowMutableStateImpl(StartWorkflowExecutionRequest startRequest, String firstExecutionRunId, String runId, Optional<TestServiceRetryState> retryState, java.time.Duration backoffStartInterval, Payloads lastCompletionResult, Optional<Failure> lastFailure, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, Optional<String> continuedExecutionRunId, TestWorkflowService service, TestWorkflowStore store, TestVisibilityStore visibilityStore, TestNexusEndpointStore nexusEndpointStore, SelfAdvancingTimer selfAdvancingTimer) {
        this.store = store;
        this.visibilityStore = visibilityStore;
        this.nexusEndpointStore = nexusEndpointStore;
        this.service = service;
        this.commandVerifier = new CommandVerifier(visibilityStore, nexusEndpointStore);
        this.startRequest = startRequest = this.overrideStartWorkflowExecutionRequest(startRequest);
        this.executionId = new ExecutionId(startRequest.getNamespace(), startRequest.getWorkflowId(), runId);
        this.parent = parent;
        this.parentChildInitiatedEventId = parentChildInitiatedEventId;
        this.timerService = selfAdvancingTimer;
        this.clock = selfAdvancingTimer.getClock();
        StateMachines.WorkflowData data = new StateMachines.WorkflowData(retryState, ProtobufTimeUtils.toProtoDuration((java.time.Duration)backoffStartInterval), startRequest.getCronSchedule(), lastCompletionResult, lastFailure, firstExecutionRunId, runId, continuedExecutionRunId);
        this.workflow = StateMachines.newWorkflowStateMachine(data);
        this.workflowTaskStateMachine = StateMachines.newWorkflowTaskStateMachine(store, startRequest);
        this.currentMemo = new HashMap<String, Payload>(startRequest.getMemo().getFieldsMap());
    }

    private StartWorkflowExecutionRequest overrideStartWorkflowExecutionRequest(StartWorkflowExecutionRequest r) {
        long taskTimeoutMillis;
        long runTimeoutMillis;
        StartWorkflowExecutionRequest.Builder request = this.validateStartWorkflowExecutionRequest(r.toBuilder());
        long executionTimeoutMillis = Durations.toMillis((Duration)request.getWorkflowExecutionTimeout());
        if (executionTimeoutMillis == 0L) {
            executionTimeoutMillis = 315360000000L;
        }
        if ((executionTimeoutMillis = Math.min(executionTimeoutMillis, 315360000000L)) != Durations.toMillis((Duration)request.getWorkflowExecutionTimeout())) {
            request.setWorkflowExecutionTimeout(Durations.fromMillis((long)executionTimeoutMillis));
        }
        if ((runTimeoutMillis = Durations.toMillis((Duration)request.getWorkflowRunTimeout())) == 0L) {
            runTimeoutMillis = 315360000000L;
        }
        runTimeoutMillis = Math.min(runTimeoutMillis, 315360000000L);
        if ((runTimeoutMillis = Math.min(runTimeoutMillis, executionTimeoutMillis)) != Durations.toMillis((Duration)request.getWorkflowRunTimeout())) {
            request.setWorkflowRunTimeout(Durations.fromMillis((long)runTimeoutMillis));
        }
        if ((taskTimeoutMillis = Durations.toMillis((Duration)request.getWorkflowTaskTimeout())) == 0L) {
            taskTimeoutMillis = 10000L;
        }
        taskTimeoutMillis = Math.min(taskTimeoutMillis, 120000L);
        if ((taskTimeoutMillis = Math.min(taskTimeoutMillis, runTimeoutMillis)) != Durations.toMillis((Duration)request.getWorkflowTaskTimeout())) {
            request.setWorkflowTaskTimeout(Durations.fromMillis((long)taskTimeoutMillis));
        }
        return request.build();
    }

    private StartWorkflowExecutionRequest.Builder validateStartWorkflowExecutionRequest(StartWorkflowExecutionRequest.Builder request) {
        if (request.getRequestId().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing request ID.").asRuntimeException();
        }
        if (Durations.toMillis((Duration)request.getWorkflowExecutionTimeout()) < 0L) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid WorkflowExecutionTimeoutSeconds.").asRuntimeException();
        }
        if (Durations.toMillis((Duration)request.getWorkflowRunTimeout()) < 0L) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid WorkflowRunTimeoutSeconds.").asRuntimeException();
        }
        if (Durations.toMillis((Duration)request.getWorkflowTaskTimeout()) < 0L) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid WorkflowTaskTimeoutSeconds.").asRuntimeException();
        }
        if (!request.hasTaskQueue() || request.getTaskQueue().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing TaskQueue.").asRuntimeException();
        }
        if (!request.hasWorkflowType() || request.getWorkflowType().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing WorkflowType.").asRuntimeException();
        }
        if (request.hasRetryPolicy()) {
            request.setRetryPolicy(TestServiceRetryState.validateAndOverrideRetryPolicy(request.getRetryPolicy()));
        }
        this.validateLinks(request.getLinksList());
        return request;
    }

    private void validateLinks(List<io.temporal.api.common.v1.Link> links) {
        if (links == null || links.isEmpty()) {
            return;
        }
        if (links.size() > 10) {
            throw Status.INVALID_ARGUMENT.withDescription(String.format("cannot attach more than %d links per request, got %d", 10, links.size())).asRuntimeException();
        }
        for (io.temporal.api.common.v1.Link l : links) {
            if (l.getSerializedSize() > 4000) {
                throw Status.INVALID_ARGUMENT.withDescription(String.format("link exceeds allowed size of %d, got %d", 4000, l.getSerializedSize())).asRuntimeException();
            }
            if (l.getVariantCase() == Link.VariantCase.WORKFLOW_EVENT) {
                if (l.getWorkflowEvent().getNamespace().isEmpty()) {
                    throw Status.INVALID_ARGUMENT.withDescription("workflow event link must not have an empty namespace field").asRuntimeException();
                }
                if (l.getWorkflowEvent().getWorkflowId().isEmpty()) {
                    throw Status.INVALID_ARGUMENT.withDescription("workflow event link must not have an empty workflow ID field").asRuntimeException();
                }
                if (l.getWorkflowEvent().getRunId().isEmpty()) {
                    throw Status.INVALID_ARGUMENT.withDescription("workflow event link must not have an empty run ID field").asRuntimeException();
                }
                if (l.getWorkflowEvent().getEventRef().getEventType() != EventType.EVENT_TYPE_UNSPECIFIED || l.getWorkflowEvent().getEventRef().getEventId() == 0L) continue;
                throw Status.INVALID_ARGUMENT.withDescription("workflow event link ref cannot have an unspecified event type and a non-zero event ID").asRuntimeException();
            }
            throw Status.INVALID_ARGUMENT.withDescription("unsupported link variant").asRuntimeException();
        }
    }

    private void update(UpdateProcedure updater) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.update(false, updater, stackTraceElements[2].getMethodName());
    }

    private void completeWorkflowTaskUpdate(UpdateProcedure updater, StickyExecutionAttributes attributes) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.lock.lock();
        try {
            this.stickyExecutionAttributes = attributes;
            this.update(true, updater, stackTraceElements[2].getMethodName());
        }
        catch (RuntimeException e) {
            this.stickyExecutionAttributes = null;
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void update(boolean completeWorkflowTaskUpdate, UpdateProcedure updater, String caller) {
        String callerInfo = "Command Update from " + caller;
        this.lock.lock();
        LockHandle lockHandle = this.timerService.lockTimeSkipping(callerInfo);
        try {
            if (this.isTerminalState()) {
                throw Status.NOT_FOUND.withDescription("Completed workflow").asRuntimeException();
            }
            boolean concurrentWorkflowTask = !completeWorkflowTaskUpdate && this.workflowTaskStateMachine.getState() == StateMachines.State.STARTED;
            RequestContext ctx = new RequestContext(this.clock, this, this.nextEventId);
            updater.apply(ctx);
            if (StateUtils.isWorkflowExecutionForcefullyCompleted(this.workflow.getState())) {
                this.nextEventId = ctx.commitChanges(this.store);
            } else if (concurrentWorkflowTask) {
                this.workflowTaskStateMachine.getData().bufferedEvents.add(ctx);
                ctx.fireCallbacks(0);
                this.store.applyTimersAndLocks(ctx);
            } else {
                this.nextEventId = ctx.commitChanges(this.store);
            }
            if (ctx.getException() != null) {
                throw ctx.getException();
            }
        }
        catch (StatusRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
        finally {
            lockHandle.unlock();
            this.lock.unlock();
        }
    }

    @Override
    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    @Override
    public WorkflowExecutionStatus getWorkflowExecutionStatus() {
        switch (this.workflow.getState()) {
            case NONE: 
            case INITIATED: 
            case STARTED: 
            case CANCELLATION_REQUESTED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING;
            }
            case FAILED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_FAILED;
            }
            case TIMED_OUT: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_TIMED_OUT;
            }
            case CANCELED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_CANCELED;
            }
            case COMPLETED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_COMPLETED;
            }
            case CONTINUED_AS_NEW: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_CONTINUED_AS_NEW;
            }
            case TERMINATED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_TERMINATED;
            }
        }
        throw new IllegalStateException("unreachable");
    }

    @Override
    public StartWorkflowExecutionRequest getStartRequest() {
        return this.startRequest;
    }

    @Override
    public StickyExecutionAttributes getStickyExecutionAttributes() {
        return this.stickyExecutionAttributes;
    }

    @Override
    public Optional<TestWorkflowMutableState> getParent() {
        return this.parent;
    }

    @Override
    public void startWorkflowTask(PollWorkflowTaskQueueResponse.Builder task, PollWorkflowTaskQueueRequest pollRequest) {
        if (!task.hasQuery()) {
            this.update(ctx -> {
                StateMachines.WorkflowTaskData data = this.workflowTaskStateMachine.getData();
                long scheduledEventId = data.scheduledEventId;
                this.workflowTaskStateMachine.action(StateMachines.Action.START, ctx, pollRequest, 0L);
                task.setStartedTime(ctx.currentTime());
                ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)this.startRequest.getWorkflowTaskTimeout()), () -> this.timeoutWorkflowTask(scheduledEventId), "WorkflowTask StartToCloseTimeout");
            });
        }
    }

    @Override
    public void completeWorkflowTask(int historySizeFromToken, RespondWorkflowTaskCompletedRequest request) {
        List commands = request.getCommandsList();
        ArrayList messages = new ArrayList(request.getMessagesList());
        this.completeWorkflowTaskUpdate(ctx -> {
            if (ctx.getInitialEventId() != (long)(historySizeFromToken + 1)) {
                throw Status.NOT_FOUND.withDescription("Expired workflow task: expectedHistorySize=" + historySizeFromToken + ", actualHistorySize=" + ctx.getInitialEventId()).asRuntimeException();
            }
            int indexOfCompletionEvent = IntStream.range(0, commands.size()).filter(index -> WorkflowExecutionUtils.isWorkflowExecutionCompleteCommand((Command)((Command)commands.get(index)))).findFirst().orElse(-1);
            if (indexOfCompletionEvent >= 0 && indexOfCompletionEvent < commands.size() - 1) {
                throw Status.INVALID_ARGUMENT.withDescription("invalid command sequence: " + commands.stream().map(Command::getCommandType).map(ProtoEnumNameUtils::uniqueToSimplifiedName).collect(Collectors.toList()) + ", command " + ProtoEnumNameUtils.uniqueToSimplifiedName((Enum)((Command)commands.get(indexOfCompletionEvent)).getCommandType()) + " must be the last command.").asRuntimeException();
            }
            if (this.unhandledCommand(request) || this.unhandledMessages(request)) {
                this.failWorkflowTaskWithAReason(WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_UNHANDLED_COMMAND, null, ctx, request, false);
                return;
            }
            for (Command command : commands) {
                CommandVerifier.InvalidCommandResult invalidCommandResult = this.commandVerifier.verifyCommand(ctx, command);
                if (invalidCommandResult == null) continue;
                this.failWorkflowTaskWithAReason(invalidCommandResult.getWorkflowTaskFailedCause(), invalidCommandResult.getEventAttributesFailure(), ctx, request, true);
                ctx.setExceptionIfEmpty(invalidCommandResult.getClientException());
                return;
            }
            long workflowTaskCompletedId = ctx.getNextEventId() - 1L;
            try {
                boolean completed;
                this.workflowTaskStateMachine.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
                for (Command command : commands) {
                    this.processCommand(ctx, command, messages, request.getIdentity(), workflowTaskCompletedId);
                }
                for (Message message : messages) {
                    this.processMessage(ctx, message, request.getIdentity(), workflowTaskCompletedId);
                }
                this.workflowTaskStateMachine.getData().updateRequest.clear();
                for (RequestContext deferredCtx : this.workflowTaskStateMachine.getData().bufferedEvents) {
                    ctx.add(deferredCtx);
                }
                StateMachines.WorkflowTaskData data = this.workflowTaskStateMachine.getData();
                boolean bl = completed = this.workflow.getState() == StateMachines.State.COMPLETED || this.workflow.getState() == StateMachines.State.FAILED || this.workflow.getState() == StateMachines.State.CANCELED;
                if (!(completed || !ctx.isNeedWorkflowTask() && this.workflowTaskStateMachine.getData().bufferedEvents.isEmpty() && this.workflowTaskStateMachine.getData().updateRequestBuffer.isEmpty() && !request.getForceCreateNewWorkflowTask())) {
                    this.scheduleWorkflowTask(ctx);
                }
                this.workflowTaskStateMachine.getData().bufferedEvents.clear();
                Map<String, ConsistentQuery> queries = data.consistentQueryRequests;
                Map queryResultsMap = request.getQueryResultsMap();
                for (Map.Entry resultEntry : queryResultsMap.entrySet()) {
                    String key = (String)resultEntry.getKey();
                    ConsistentQuery query = queries.remove(key);
                    if (query == null) continue;
                    WorkflowQueryResult result = (WorkflowQueryResult)resultEntry.getValue();
                    switch (result.getResultType()) {
                        case QUERY_RESULT_TYPE_ANSWERED: {
                            QueryWorkflowResponse response = QueryWorkflowResponse.newBuilder().setQueryResult(result.getAnswer()).build();
                            query.getResult().complete(response);
                            break;
                        }
                        case QUERY_RESULT_TYPE_FAILED: {
                            query.getResult().completeExceptionally(StatusUtils.newException((Status)Status.INTERNAL.withDescription(result.getErrorMessage()), (com.google.protobuf.Message)QueryFailedFailure.getDefaultInstance(), (Descriptors.Descriptor)QueryFailedFailure.getDescriptor()));
                            break;
                        }
                        case UNRECOGNIZED: {
                            throw Status.INVALID_ARGUMENT.withDescription("UNRECOGNIZED query result type for =" + (String)resultEntry.getKey()).asRuntimeException();
                        }
                    }
                }
                ctx.onCommit(historySize -> {
                    if (this.workflowTaskStateMachine.getState() == StateMachines.State.INITIATED) {
                        for (ConsistentQuery query : data.queryBuffer.values()) {
                            this.workflowTaskStateMachine.action(StateMachines.Action.QUERY, ctx, query, -1L);
                        }
                    } else {
                        for (ConsistentQuery consistent : data.queryBuffer.values()) {
                            QueryId queryId = new QueryId(this.executionId, consistent.getKey());
                            PollWorkflowTaskQueueResponse.Builder task = PollWorkflowTaskQueueResponse.newBuilder().setTaskToken(queryId.toBytes()).setWorkflowExecution(this.executionId.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).setQuery(consistent.getRequest().getQuery()).setWorkflowExecutionTaskQueue(this.startRequest.getTaskQueue());
                            TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(consistent.getRequest().getNamespace(), this.stickyExecutionAttributes == null ? this.startRequest.getTaskQueue().getName() : this.stickyExecutionAttributes.getWorkerTaskQueue().getName());
                            this.store.sendQueryTask(this.executionId, taskQueueId, task);
                            this.queries.put(queryId.getQueryId(), consistent.getResult());
                        }
                    }
                    data.queryBuffer.clear();
                });
            }
            finally {
                ctx.unlockTimer("completeWorkflowTask");
            }
        }, request.hasStickyAttributes() ? request.getStickyAttributes() : null);
    }

    private void failWorkflowTaskWithAReason(WorkflowTaskFailedCause failedCause, ServerFailure eventAttributesFailure, RequestContext ctx, RespondWorkflowTaskCompletedRequest request, boolean timeoutWorkflowTaskIfRecurringFailure) {
        RespondWorkflowTaskFailedRequest.Builder failedRequestBuilder = RespondWorkflowTaskFailedRequest.newBuilder().setCause(failedCause).setIdentity(request.getIdentity());
        if (eventAttributesFailure != null) {
            failedRequestBuilder.setFailure(DefaultDataConverter.STANDARD_INSTANCE.exceptionToFailure((Throwable)eventAttributesFailure));
        }
        this.processFailWorkflowTask(failedRequestBuilder.build(), ctx, timeoutWorkflowTaskIfRecurringFailure);
    }

    private boolean unhandledCommand(RespondWorkflowTaskCompletedRequest request) {
        boolean newEvents = false;
        for (RequestContext ctx2 : this.workflowTaskStateMachine.getData().bufferedEvents) {
            if (ctx2.getEvents().isEmpty()) continue;
            newEvents = true;
            break;
        }
        return newEvents && this.hasCompletionCommand(request.getCommandsList());
    }

    private boolean unhandledMessages(RespondWorkflowTaskCompletedRequest request) {
        return !this.workflowTaskStateMachine.getData().updateRequestBuffer.isEmpty() && this.hasCompletionCommand(request.getCommandsList());
    }

    private boolean hasCompletionCommand(List<Command> commands) {
        for (Command command : commands) {
            if (!WorkflowExecutionUtils.isWorkflowExecutionCompleteCommand((Command)command)) continue;
            return true;
        }
        return false;
    }

    private void processCommand(RequestContext ctx, Command d, List<Message> messages, String identity, long workflowTaskCompletedId) {
        switch (d.getCommandType()) {
            case COMMAND_TYPE_COMPLETE_WORKFLOW_EXECUTION: {
                this.processCompleteWorkflowExecution(ctx, d.getCompleteWorkflowExecutionCommandAttributes(), workflowTaskCompletedId, identity);
                break;
            }
            case COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION: {
                this.processFailWorkflowExecution(ctx, d.getFailWorkflowExecutionCommandAttributes(), workflowTaskCompletedId, identity);
                break;
            }
            case COMMAND_TYPE_CANCEL_WORKFLOW_EXECUTION: {
                this.processCancelWorkflowExecution(ctx, d.getCancelWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_CONTINUE_AS_NEW_WORKFLOW_EXECUTION: {
                this.processContinueAsNewWorkflowExecution(ctx, d.getContinueAsNewWorkflowExecutionCommandAttributes(), workflowTaskCompletedId, identity);
                break;
            }
            case COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK: {
                this.processScheduleActivityTask(ctx, d.getScheduleActivityTaskCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK: {
                this.processRequestCancelActivityTask(ctx, d.getRequestCancelActivityTaskCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_START_TIMER: {
                this.processStartTimer(ctx, d.getStartTimerCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_CANCEL_TIMER: {
                this.processCancelTimer(ctx, d.getCancelTimerCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_START_CHILD_WORKFLOW_EXECUTION: {
                this.processStartChildWorkflow(ctx, d.getStartChildWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION: {
                this.processSignalExternalWorkflowExecution(ctx, d.getSignalExternalWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_RECORD_MARKER: {
                this.processRecordMarker(ctx, d.getRecordMarkerCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION: {
                this.processRequestCancelExternalWorkflowExecution(ctx, d.getRequestCancelExternalWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES: {
                this.processUpsertWorkflowSearchAttributes(ctx, d.getUpsertWorkflowSearchAttributesCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_MODIFY_WORKFLOW_PROPERTIES: {
                this.processModifyWorkflowProperties(ctx, d.getModifyWorkflowPropertiesCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_PROTOCOL_MESSAGE: {
                this.processProtocolMessageAttributes(ctx, d.getProtocolMessageCommandAttributes(), messages, identity, workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_SCHEDULE_NEXUS_OPERATION: {
                this.processScheduleNexusOperation(ctx, d.getScheduleNexusOperationCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_NEXUS_OPERATION: {
                this.processRequestCancelNexusOperation(ctx, d.getRequestCancelNexusOperationCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            default: {
                throw Status.INVALID_ARGUMENT.withDescription("Unknown command type: " + d.getCommandType() + " for " + d).asRuntimeException();
            }
        }
    }

    private void processMessage(RequestContext ctx, Message msg, String identity, long workflowTaskCompletedId) {
        String clazzName = msg.getBody().getTypeUrl().split("/")[1];
        try {
            switch (clazzName) {
                case "temporal.api.update.v1.Acceptance": {
                    this.processAcceptanceMessage(ctx, msg, (Acceptance)msg.getBody().unpack(Acceptance.class), workflowTaskCompletedId);
                    break;
                }
                case "temporal.api.update.v1.Rejection": {
                    this.processRejectionMessage(ctx, msg, (Rejection)msg.getBody().unpack(Rejection.class), workflowTaskCompletedId);
                    break;
                }
                case "temporal.api.update.v1.Response": {
                    this.processOutcomeMessage(ctx, msg, (Response)msg.getBody().unpack(Response.class), workflowTaskCompletedId);
                    break;
                }
                default: {
                    throw Status.INVALID_ARGUMENT.withDescription("Unknown message type: " + msg.getProtocolInstanceId() + " for " + msg).asRuntimeException();
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private void processScheduleNexusOperation(RequestContext ctx, ScheduleNexusOperationCommandAttributes attr, long workflowTaskCompletedId) {
        Endpoint endpoint = this.nexusEndpointStore.getEndpointByName(attr.getEndpoint());
        StateMachine<StateMachines.NexusOperationData> operation = StateMachines.newNexusOperation(endpoint);
        long scheduleEventId = ctx.getNextEventId();
        this.nexusOperations.put(scheduleEventId, operation);
        operation.action(StateMachines.Action.INITIATE, ctx, attr, workflowTaskCompletedId);
        int attempt = operation.getData().getAttempt();
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)operation.getData().requestTimeout), () -> this.timeoutNexusRequest(scheduleEventId, "StartNexusOperation", attempt), "StartNexusOperation request timeout");
        if (attr.hasScheduleToCloseTimeout() && Durations.toMillis((Duration)attr.getScheduleToCloseTimeout()) > 0L) {
            ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)attr.getScheduleToCloseTimeout()), () -> this.timeoutNexusOperation(scheduleEventId, TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE, ((StateMachines.NexusOperationData)operation.getData()).getAttempt()), "NexusOperation ScheduleToCloseTimeout");
        }
        ctx.lockTimer("processScheduleNexusOperation");
    }

    private void processRequestCancelNexusOperation(RequestContext ctx, RequestCancelNexusOperationCommandAttributes attr, long workflowTaskCompletedId) {
        long scheduleEventId = attr.getScheduledEventId();
        StateMachine<StateMachines.NexusOperationData> operation = this.nexusOperations.get(scheduleEventId);
        if (operation == null) {
            throw Status.INVALID_ARGUMENT.withDescription("Nexus operation not found for scheduleEventId=" + scheduleEventId).asRuntimeException();
        }
        if (operation.getState() == StateMachines.State.INITIATED) {
            ctx.addEvent(HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_NEXUS_OPERATION_CANCEL_REQUESTED).setNexusOperationCancelRequestedEventAttributes(NexusOperationCancelRequestedEventAttributes.newBuilder().setScheduledEventId(attr.getScheduledEventId()).setWorkflowTaskCompletedEventId(workflowTaskCompletedId)).build());
            Failure canceled = Failure.newBuilder().setMessage("operation canceled before it was started").setCanceledFailureInfo(CanceledFailureInfo.getDefaultInstance()).build();
            operation.action(StateMachines.Action.CANCEL, ctx, canceled, workflowTaskCompletedId);
            this.nexusOperations.remove(scheduleEventId);
            ctx.setNeedWorkflowTask(true);
        } else {
            operation.action(StateMachines.Action.REQUEST_CANCELLATION, ctx, null, workflowTaskCompletedId);
            ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)operation.getData().requestTimeout), () -> this.timeoutNexusRequest(scheduleEventId, "CancelNexusOperation", ((StateMachines.NexusOperationData)operation.getData()).getAttempt()), "CancelNexusOperation request timeout");
            ctx.lockTimer("processRequestCancelNexusOperation");
        }
    }

    private void processRequestCancelExternalWorkflowExecution(RequestContext ctx, RequestCancelExternalWorkflowExecutionCommandAttributes attr, long workflowTaskCompletedId) {
        if (this.externalCancellations.containsKey(attr.getWorkflowId())) {
            throw Status.FAILED_PRECONDITION.withDescription("cancellation already requested for workflowId=" + attr.getWorkflowId()).asRuntimeException();
        }
        StateMachine<StateMachines.CancelExternalData> cancelStateMachine = StateMachines.newCancelExternalStateMachine();
        this.externalCancellations.put(attr.getWorkflowId(), cancelStateMachine);
        cancelStateMachine.action(StateMachines.Action.INITIATE, ctx, attr, workflowTaskCompletedId);
        ForkJoinPool.commonPool().execute(() -> {
            RequestCancelWorkflowExecutionRequest request = RequestCancelWorkflowExecutionRequest.newBuilder().setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId(attr.getWorkflowId())).setNamespace(ctx.getNamespace()).build();
            CancelExternalWorkflowExecutionCallerInfo info = new CancelExternalWorkflowExecutionCallerInfo(ctx.getNamespace(), ((StateMachines.CancelExternalData)cancelStateMachine.getData()).initiatedEventId, this);
            try {
                this.service.requestCancelWorkflowExecution(request, Optional.of(info));
            }
            catch (Exception e) {
                log.error("Failure to request cancel external workflow", (Throwable)e);
            }
        });
    }

    @Override
    public void reportCancelRequested(ExternalWorkflowExecutionCancelRequestedEventAttributes a) {
        this.update(ctx -> {
            if (this.isTerminalState()) {
                return;
            }
            StateMachine<StateMachines.CancelExternalData> cancellationRequest = this.externalCancellations.get(a.getWorkflowExecution().getWorkflowId());
            cancellationRequest.action(StateMachines.Action.START, ctx, a.getWorkflowExecution().getRunId(), 0L);
            this.scheduleWorkflowTask(ctx);
        });
    }

    private void processRecordMarker(RequestContext ctx, RecordMarkerCommandAttributes attr, long workflowTaskCompletedId) {
        if (attr.getMarkerName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("marker name is required").asRuntimeException();
        }
        MarkerRecordedEventAttributes.Builder marker = MarkerRecordedEventAttributes.newBuilder().setMarkerName(attr.getMarkerName()).setWorkflowTaskCompletedEventId(workflowTaskCompletedId).putAllDetails(attr.getDetailsMap());
        if (attr.hasHeader()) {
            marker.setHeader(attr.getHeader());
        }
        if (attr.hasFailure()) {
            marker.setFailure(attr.getFailure());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_MARKER_RECORDED).setMarkerRecordedEventAttributes(marker).build();
        ctx.addEvent(event);
    }

    private void processCancelTimer(RequestContext ctx, CancelTimerCommandAttributes d, long workflowTaskCompletedId) {
        String timerId = d.getTimerId();
        StateMachine<StateMachines.TimerData> timer = this.timers.get(timerId);
        if (timer == null) {
            throw Status.INVALID_ARGUMENT.withDescription("invalid history builder state for action").asRuntimeException();
        }
        timer.action(StateMachines.Action.CANCEL, ctx, d, workflowTaskCompletedId);
        this.timers.remove(timerId);
    }

    private void processRequestCancelActivityTask(RequestContext ctx, RequestCancelActivityTaskCommandAttributes a, long workflowTaskCompletedId) {
        long scheduledEventId = a.getScheduledEventId();
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.get(scheduledEventId);
        if (activity == null) {
            throw Status.FAILED_PRECONDITION.withDescription("ACTIVITY_UNKNOWN for scheduledEventId=" + scheduledEventId).asRuntimeException();
        }
        StateMachines.State beforeState = activity.getState();
        activity.action(StateMachines.Action.REQUEST_CANCELLATION, ctx, a, workflowTaskCompletedId);
        if (beforeState == StateMachines.State.INITIATED) {
            activity.action(StateMachines.Action.CANCEL, ctx, null, 0L);
            this.activities.remove(scheduledEventId);
            ctx.setNeedWorkflowTask(true);
        }
    }

    private void processScheduleActivityTask(RequestContext ctx, ScheduleActivityTaskCommandAttributes attributes, long workflowTaskCompletedId) {
        String activityId = (attributes = this.validateScheduleActivityTask(attributes)).getActivityId();
        Long activityScheduledEventId = this.activityById.get(activityId);
        if (activityScheduledEventId != null) {
            throw Status.FAILED_PRECONDITION.withDescription("Already open activity with " + activityId).asRuntimeException();
        }
        StateMachine<StateMachines.ActivityTaskData> activityStateMachine = StateMachines.newActivityStateMachine(this.store, this.startRequest);
        long activityScheduleId = ctx.getNextEventId();
        this.activities.put(activityScheduleId, activityStateMachine);
        this.activityById.put(activityId, activityScheduleId);
        activityStateMachine.action(StateMachines.Action.INITIATE, ctx, attributes, workflowTaskCompletedId);
        ActivityTaskScheduledEventAttributes scheduledEvent = activityStateMachine.getData().scheduledEvent;
        int attempt = activityStateMachine.getData().getAttempt();
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)scheduledEvent.getScheduleToCloseTimeout()), () -> this.timeoutActivity(activityScheduleId, TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE, attempt), "Activity ScheduleToCloseTimeout");
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)scheduledEvent.getScheduleToStartTimeout()), () -> this.timeoutActivity(activityScheduleId, TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_START, attempt), "Activity ScheduleToStartTimeout");
        ctx.lockTimer("processScheduleActivityTask");
    }

    private ScheduleActivityTaskCommandAttributes validateScheduleActivityTask(ScheduleActivityTaskCommandAttributes a) {
        boolean validStartToClose;
        ScheduleActivityTaskCommandAttributes.Builder result = a.toBuilder();
        if (!a.hasTaskQueue() || a.getTaskQueue().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("TaskQueue is not set on workflow task").asRuntimeException();
        }
        if (a.getActivityId().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("ActivityId is not set on workflow task").asRuntimeException();
        }
        if (!a.hasActivityType() || a.getActivityType().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("ActivityType is not set on workflow task").asRuntimeException();
        }
        if (Durations.compare((Duration)a.getScheduleToCloseTimeout(), (Duration)Durations.ZERO) < 0 || Durations.compare((Duration)a.getScheduleToStartTimeout(), (Duration)Durations.ZERO) < 0 || Durations.compare((Duration)a.getStartToCloseTimeout(), (Duration)Durations.ZERO) < 0 || Durations.compare((Duration)a.getHeartbeatTimeout(), (Duration)Durations.ZERO) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("A valid timeout may not be negative.").asRuntimeException();
        }
        Duration workflowRunTimeout = this.startRequest.getWorkflowRunTimeout();
        boolean validScheduleToClose = Durations.compare((Duration)a.getScheduleToCloseTimeout(), (Duration)Durations.ZERO) > 0;
        boolean validScheduleToStart = Durations.compare((Duration)a.getScheduleToStartTimeout(), (Duration)Durations.ZERO) > 0;
        boolean bl = validStartToClose = Durations.compare((Duration)a.getStartToCloseTimeout(), (Duration)Durations.ZERO) > 0;
        if (validScheduleToClose) {
            if (validScheduleToStart) {
                result.setScheduleToStartTimeout(Durations.fromMillis((long)Math.min(Durations.toMillis((Duration)a.getScheduleToStartTimeout()), Durations.toMillis((Duration)a.getScheduleToCloseTimeout()))));
            } else {
                result.setScheduleToStartTimeout(a.getScheduleToCloseTimeout());
            }
            if (validStartToClose) {
                result.setStartToCloseTimeout(Durations.fromMillis((long)Math.min(Durations.toMillis((Duration)a.getStartToCloseTimeout()), Durations.toMillis((Duration)a.getScheduleToCloseTimeout()))));
            } else {
                result.setStartToCloseTimeout(a.getScheduleToCloseTimeout());
            }
        } else if (validStartToClose) {
            result.setScheduleToCloseTimeout(workflowRunTimeout);
            if (!validScheduleToStart) {
                result.setScheduleToStartTimeout(workflowRunTimeout);
            }
        } else {
            throw Status.INVALID_ARGUMENT.withDescription("A valid StartToClose or ScheduleToCloseTimeout is not set on workflow task.").asRuntimeException();
        }
        if (Durations.compare((Duration)workflowRunTimeout, (Duration)Durations.ZERO) > 0) {
            if (Durations.compare((Duration)a.getScheduleToCloseTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setScheduleToCloseTimeout(workflowRunTimeout);
            }
            if (Durations.compare((Duration)a.getScheduleToStartTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setScheduleToStartTimeout(workflowRunTimeout);
            }
            if (Durations.compare((Duration)a.getStartToCloseTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setStartToCloseTimeout(workflowRunTimeout);
            }
            if (Durations.compare((Duration)a.getHeartbeatTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setHeartbeatTimeout(workflowRunTimeout);
            }
        }
        if (validScheduleToClose && Durations.compare((Duration)a.getHeartbeatTimeout(), (Duration)a.getScheduleToCloseTimeout()) > 0) {
            result.setHeartbeatTimeout(a.getScheduleToCloseTimeout());
        }
        return result.build();
    }

    private void processStartChildWorkflow(RequestContext ctx, StartChildWorkflowExecutionCommandAttributes a, long workflowTaskCompletedId) {
        a = this.validateStartChildExecutionAttributes(a);
        StateMachine<StateMachines.ChildWorkflowData> child = StateMachines.newChildWorkflowStateMachine(this.service);
        this.childWorkflows.put(ctx.getNextEventId(), child);
        child.action(StateMachines.Action.INITIATE, ctx, a, workflowTaskCompletedId);
        ctx.lockTimer("processStartChildWorkflow");
    }

    private StartChildWorkflowExecutionCommandAttributes validateStartChildExecutionAttributes(StartChildWorkflowExecutionCommandAttributes a) {
        if (a == null) {
            throw Status.INVALID_ARGUMENT.withDescription("StartChildWorkflowExecutionCommandAttributes is not set on workflow task").asRuntimeException();
        }
        if (a.getWorkflowId().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Required field WorkflowId is not set on workflow task").asRuntimeException();
        }
        if (!a.hasWorkflowType() || a.getWorkflowType().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Required field WorkflowType is not set on workflow task").asRuntimeException();
        }
        StartChildWorkflowExecutionCommandAttributes.Builder ab = a.toBuilder();
        if (a.hasRetryPolicy()) {
            ab.setRetryPolicy(TestServiceRetryState.validateAndOverrideRetryPolicy(a.getRetryPolicy()));
        }
        if (!ab.hasTaskQueue()) {
            ab.setTaskQueue(this.startRequest.getTaskQueue());
        }
        if (Durations.compare((Duration)a.getWorkflowTaskTimeout(), (Duration)Durations.ZERO) <= 0) {
            ab.setWorkflowTaskTimeout(this.startRequest.getWorkflowTaskTimeout());
        }
        return ab.build();
    }

    private void processSignalExternalWorkflowExecution(RequestContext ctx, SignalExternalWorkflowExecutionCommandAttributes a, long workflowTaskCompletedId) {
        String signalId = UUID.randomUUID().toString();
        StateMachine<StateMachines.SignalExternalData> signalStateMachine = StateMachines.newSignalExternalStateMachine();
        this.externalSignals.put(signalId, signalStateMachine);
        signalStateMachine.action(StateMachines.Action.INITIATE, ctx, a, workflowTaskCompletedId);
        ForkJoinPool.commonPool().execute(() -> {
            try {
                this.service.signalExternalWorkflowExecution(signalId, a, this);
            }
            catch (Exception e) {
                log.error("Failure signalling an external workflow execution", (Throwable)e);
            }
        });
        ctx.lockTimer("processSignalExternalWorkflowExecution");
    }

    @Override
    public void completeSignalExternalWorkflowExecution(String signalId, String runId) {
        this.update(ctx -> {
            StateMachine<StateMachines.SignalExternalData> signal = this.getSignal(signalId);
            signal.action(StateMachines.Action.COMPLETE, ctx, runId, 0L);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeSignalExternalWorkflowExecution");
        });
    }

    @Override
    public void failSignalExternalWorkflowExecution(String signalId, SignalExternalWorkflowExecutionFailedCause cause) {
        this.update(ctx -> {
            StateMachine<StateMachines.SignalExternalData> signal = this.getSignal(signalId);
            signal.action(StateMachines.Action.FAIL, ctx, cause, 0L);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("failSignalExternalWorkflowExecution");
        });
    }

    private StateMachine<StateMachines.SignalExternalData> getSignal(String signalId) {
        StateMachine<StateMachines.SignalExternalData> signal = this.externalSignals.get(signalId);
        if (signal == null) {
            throw Status.FAILED_PRECONDITION.withDescription("unknown signalId: " + signalId).asRuntimeException();
        }
        return signal;
    }

    @Override
    public void failWorkflowTask(RespondWorkflowTaskFailedRequest request) {
        this.completeWorkflowTaskUpdate(ctx -> this.processFailWorkflowTask(request, ctx, false), null);
    }

    private void processFailWorkflowTask(RespondWorkflowTaskFailedRequest request, RequestContext ctx, boolean timeoutWorkflowTaskIfRecurringFailure) {
        StateMachines.WorkflowTaskData data = this.workflowTaskStateMachine.getData();
        if (timeoutWorkflowTaskIfRecurringFailure && data.attempt >= 2) {
            return;
        }
        this.workflowTaskStateMachine.action(StateMachines.Action.FAIL, ctx, request, 0L);
        for (RequestContext deferredCtx : this.workflowTaskStateMachine.getData().bufferedEvents) {
            ctx.add(deferredCtx);
        }
        this.workflowTaskStateMachine.getData().bufferedEvents.clear();
        this.scheduleWorkflowTask(ctx);
        ctx.unlockTimer("failWorkflowTask");
    }

    private void timeoutWorkflowTask(long scheduledEventId) {
        StickyExecutionAttributes previousStickySettings = this.stickyExecutionAttributes;
        try {
            this.completeWorkflowTaskUpdate(ctx -> {
                if (this.workflowTaskStateMachine == null || this.workflowTaskStateMachine.getData().scheduledEventId != scheduledEventId || this.workflowTaskStateMachine.getState() == StateMachines.State.NONE) {
                    this.stickyExecutionAttributes = previousStickySettings;
                    return;
                }
                this.workflowTaskStateMachine.getData().queryBuffer.entrySet().removeIf(queryEntry -> ((ConsistentQuery)queryEntry.getValue()).getResult().isCancelled());
                this.workflowTaskStateMachine.action(StateMachines.Action.TIME_OUT, ctx, TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE, 0L);
                this.scheduleWorkflowTask(ctx);
                ctx.unlockTimer("timeoutWorkflowTask");
            }, null);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure trying to timeout a workflow task scheduledEventId=" + scheduledEventId, (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("Failure trying to timeout a workflow task scheduledEventId=" + scheduledEventId, (Throwable)e);
        }
    }

    @Override
    public void childWorkflowStarted(ChildWorkflowExecutionStartedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.START, ctx, a, 0L);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowStarted");
        });
    }

    @Override
    public void childWorkflowFailed(String activityId, ChildWorkflowExecutionFailedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.FAIL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowFailed");
        });
    }

    @Override
    public void childWorkflowTimedOut(String activityId, ChildWorkflowExecutionTimedOutEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.TIME_OUT, ctx, a.getRetryState(), 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowTimedOut");
        });
    }

    @Override
    public void failStartChildWorkflow(String childId, StartChildWorkflowExecutionFailedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.FAIL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("failStartChildWorkflow");
        });
    }

    @Override
    public void childWorkflowCompleted(String activityId, ChildWorkflowExecutionCompletedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.COMPLETE, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowCompleted");
        });
    }

    @Override
    public void childWorkflowCanceled(String activityId, ChildWorkflowExecutionCanceledEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.CANCEL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowCanceled");
        });
    }

    private void processStartTimer(RequestContext ctx, StartTimerCommandAttributes a, long workflowTaskCompletedId) {
        String timerId = a.getTimerId();
        StateMachine<StateMachines.TimerData> timer = this.timers.get(timerId);
        if (timer != null) {
            throw Status.FAILED_PRECONDITION.withDescription("Already open timer with " + timerId).asRuntimeException();
        }
        timer = StateMachines.newTimerStateMachine();
        this.timers.put(timerId, timer);
        timer.action(StateMachines.Action.START, ctx, a, workflowTaskCompletedId);
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)a.getStartToFireTimeout()), () -> this.fireTimer(timerId), "fire timer");
    }

    private void fireTimer(String timerId) {
        StateMachine<StateMachines.TimerData> timer;
        this.lock.lock();
        try {
            timer = this.timers.get(timerId);
            if (timer == null || this.workflow.getState() != StateMachines.State.STARTED && this.workflow.getState() != StateMachines.State.CANCELLATION_REQUESTED) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.update(ctx -> {
                timer.action(StateMachines.Action.COMPLETE, ctx, null, 0L);
                this.timers.remove(timerId);
                this.scheduleWorkflowTask(ctx);
            });
        }
        catch (Throwable e) {
            log.error("Failure firing a timer", e);
        }
    }

    private void processFailWorkflowExecution(RequestContext ctx, FailWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId, String identity) {
        Failure failure = d.getFailure();
        StateMachines.WorkflowData data = this.workflow.getData();
        if (data.retryState.isPresent()) {
            TestServiceRetryState.BackoffInterval backoffInterval;
            TestServiceRetryState rs = data.retryState.get();
            if (failure.hasApplicationFailureInfo()) {
                ApplicationFailureInfo failureInfo = failure.getApplicationFailureInfo();
                if (failureInfo.getNonRetryable()) {
                    backoffInterval = new TestServiceRetryState.BackoffInterval(RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE);
                } else {
                    Optional<String> failureType = Optional.of(failureInfo.getType());
                    backoffInterval = rs.getBackoffIntervalInSeconds(failureType, this.store.currentTime(), Optional.empty());
                }
            } else {
                backoffInterval = failure.hasTerminatedFailureInfo() || failure.hasCanceledFailureInfo() || failure.hasServerFailureInfo() && failure.getServerFailureInfo().getNonRetryable() ? new TestServiceRetryState.BackoffInterval(RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE) : rs.getBackoffIntervalInSeconds(Optional.empty(), this.store.currentTime(), Optional.empty());
            }
            if (backoffInterval.getRetryState() == RetryState.RETRY_STATE_IN_PROGRESS) {
                ContinueAsNewWorkflowExecutionCommandAttributes.Builder continueAsNewAttr = ContinueAsNewWorkflowExecutionCommandAttributes.newBuilder().setInput(this.startRequest.getInput()).setWorkflowType(this.startRequest.getWorkflowType()).setWorkflowRunTimeout(this.startRequest.getWorkflowRunTimeout()).setWorkflowTaskTimeout(this.startRequest.getWorkflowTaskTimeout()).setBackoffStartInterval(ProtobufTimeUtils.toProtoDuration((java.time.Duration)backoffInterval.getInterval()));
                if (this.startRequest.hasTaskQueue()) {
                    continueAsNewAttr.setTaskQueue(this.startRequest.getTaskQueue());
                }
                if (this.startRequest.hasRetryPolicy()) {
                    continueAsNewAttr.setRetryPolicy(this.startRequest.getRetryPolicy());
                }
                if (this.startRequest.hasHeader()) {
                    continueAsNewAttr.setHeader(this.startRequest.getHeader());
                }
                if (this.startRequest.hasMemo()) {
                    continueAsNewAttr.setMemo(this.startRequest.getMemo());
                }
                ContinueAsNewWorkflowExecutionCommandAttributes coninueAsNewCommand = continueAsNewAttr.build();
                this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, coninueAsNewCommand, workflowTaskCompletedId);
                this.workflowTaskStateMachine.getData().workflowCompleted = true;
                HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
                WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewEventAttributes = event.getWorkflowExecutionContinuedAsNewEventAttributes();
                Optional<TestServiceRetryState> continuedRetryState = Optional.of(rs.getNextAttempt(Optional.of(failure)));
                this.service.continueAsNew(this.startRequest, coninueAsNewCommand, continuedAsNewEventAttributes, continuedRetryState, identity, this.getExecutionId(), this.workflow.getData().firstExecutionRunId, this.parent, this.parentChildInitiatedEventId);
                return;
            }
        }
        if (!Strings.isNullOrEmpty((String)data.cronSchedule)) {
            this.startNewCronRun(ctx, workflowTaskCompletedId, identity, data, data.lastCompletionResult, Optional.of(failure));
            return;
        }
        this.workflow.action(StateMachines.Action.FAIL, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        this.processWorkflowCompletionCallbacks(ctx);
        if (this.parent.isPresent()) {
            ctx.lockTimer("processFailWorkflowExecution notify parent");
            ChildWorkflowExecutionFailedEventAttributes a = ChildWorkflowExecutionFailedEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setFailure(failure).setWorkflowType(this.startRequest.getWorkflowType()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowFailed(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting child failure", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure reporting child failure", e);
                }
            });
        }
    }

    private void processCompleteWorkflowExecution(RequestContext ctx, CompleteWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId, String identity) {
        StateMachines.WorkflowData data = this.workflow.getData();
        if (!Strings.isNullOrEmpty((String)data.cronSchedule)) {
            this.startNewCronRun(ctx, workflowTaskCompletedId, identity, data, d.getResult(), Optional.empty());
            return;
        }
        this.workflow.action(StateMachines.Action.COMPLETE, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        this.processWorkflowCompletionCallbacks(ctx);
        this.workflow.getData().runTimerCancellationHandle.apply();
        if (this.parent.isPresent()) {
            ctx.lockTimer("processCompleteWorkflowExecution notify parent");
            ChildWorkflowExecutionCompletedEventAttributes a = ChildWorkflowExecutionCompletedEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setResult(d.getResult()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowCompleted(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting child completion", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure reporting child completion", e);
                }
            });
        }
    }

    private void startNewCronRun(RequestContext ctx, long workflowTaskCompletedId, String identity, StateMachines.WorkflowData data, Payloads lastCompletionResult, Optional<Failure> lastFailure) {
        Objects.requireNonNull(lastFailure);
        java.time.Duration backoffInterval = CronUtils.getBackoffInterval(data.cronSchedule, this.store.currentTime());
        ContinueAsNewWorkflowExecutionCommandAttributes.Builder builder = ContinueAsNewWorkflowExecutionCommandAttributes.newBuilder().setInput(this.startRequest.getInput()).setWorkflowType(this.startRequest.getWorkflowType()).setWorkflowRunTimeout(this.startRequest.getWorkflowRunTimeout()).setWorkflowTaskTimeout(this.startRequest.getWorkflowTaskTimeout()).setTaskQueue(this.startRequest.getTaskQueue()).setBackoffStartInterval(ProtobufTimeUtils.toProtoDuration((java.time.Duration)backoffInterval)).setRetryPolicy(this.startRequest.getRetryPolicy()).setLastCompletionResult(lastCompletionResult);
        lastFailure.ifPresent(arg_0 -> ((ContinueAsNewWorkflowExecutionCommandAttributes.Builder)builder).setFailure(arg_0));
        ContinueAsNewWorkflowExecutionCommandAttributes continueAsNewCommandAttr = builder.build();
        this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, continueAsNewCommandAttr, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
        WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewEventAttributes = event.getWorkflowExecutionContinuedAsNewEventAttributes();
        this.service.continueAsNew(this.startRequest, continueAsNewCommandAttr, continuedAsNewEventAttributes, Optional.empty(), identity, this.getExecutionId(), this.workflow.getData().firstExecutionRunId, this.parent, this.parentChildInitiatedEventId);
    }

    private void processCancelWorkflowExecution(RequestContext ctx, CancelWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId) {
        this.workflow.action(StateMachines.Action.CANCEL, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        this.processWorkflowCompletionCallbacks(ctx);
        if (this.parent.isPresent()) {
            ctx.lockTimer("processCancelWorkflowExecution notify parent");
            ChildWorkflowExecutionCanceledEventAttributes a = ChildWorkflowExecutionCanceledEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setDetails(d.getDetails()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowCanceled(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting child cancellation", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure reporting child cancellation", e);
                }
            });
        }
    }

    private void processContinueAsNewWorkflowExecution(RequestContext ctx, ContinueAsNewWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId, String identity) {
        this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
        this.service.continueAsNew(this.startRequest, d, event.getWorkflowExecutionContinuedAsNewEventAttributes(), this.workflow.getData().retryState, identity, this.getExecutionId(), this.workflow.getData().firstExecutionRunId, this.parent, this.parentChildInitiatedEventId);
    }

    private void processWorkflowCompletionCallbacks(RequestContext ctx) {
        Optional<HistoryEvent> completionEvent = TestWorkflowMutableStateImpl.getCompletionEvent(ctx.getEvents());
        if (!completionEvent.isPresent()) {
            return;
        }
        this.updates.forEach((k, updateStateMachine) -> {
            if (updateStateMachine.getState() != StateMachines.State.COMPLETED && updateStateMachine.getState() != StateMachines.State.FAILED) {
                updateStateMachine.action(StateMachines.Action.COMPLETE, ctx, Message.newBuilder().setBody(Any.pack((com.google.protobuf.Message)Response.newBuilder().setOutcome(Outcome.newBuilder().setFailure(FAILED_UPDATE_ON_WF_COMPLETION).build()).build())).build(), ((HistoryEvent)completionEvent.get()).getEventId());
            }
        });
        for (Callback cb : this.startRequest.getCompletionCallbacksList()) {
            if (!cb.hasNexus()) {
                log.warn("skipping non-nexus completion callback");
                continue;
            }
            String serializedRef = cb.getNexus().getHeaderOrThrow("operation-reference");
            NexusOperationRef ref = NexusOperationRef.fromBytes(serializedRef.getBytes());
            Link startLink = LinkConverter.workflowEventToNexusLink((Link.WorkflowEvent)Link.WorkflowEvent.newBuilder().setNamespace(ctx.getNamespace()).setWorkflowId(ctx.getExecution().getWorkflowId()).setRunId(ctx.getExecution().getRunId()).setEventRef(Link.WorkflowEvent.EventReference.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED).build()).build());
            this.service.completeNexusOperation(ref, ctx.getExecution().getWorkflowId(), startLink, completionEvent.get());
        }
    }

    private WorkflowTaskFailedCause processUpsertWorkflowSearchAttributes(RequestContext ctx, UpsertWorkflowSearchAttributesCommandAttributes attr, long workflowTaskCompletedId) {
        this.visibilityStore.upsertSearchAttributesForExecution(ctx.getExecutionId(), attr.getSearchAttributes());
        UpsertWorkflowSearchAttributesEventAttributes.Builder upsertEventAttr = UpsertWorkflowSearchAttributesEventAttributes.newBuilder().setSearchAttributes(attr.getSearchAttributes()).setWorkflowTaskCompletedEventId(workflowTaskCompletedId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES).setUpsertWorkflowSearchAttributesEventAttributes(upsertEventAttr).build();
        ctx.addEvent(event);
        return null;
    }

    private void processModifyWorkflowProperties(RequestContext ctx, ModifyWorkflowPropertiesCommandAttributes attr, long workflowTaskCompletedId) {
        this.currentMemo = StateUtils.mergeMemo(this.currentMemo, attr.getUpsertedMemo().getFieldsMap());
        WorkflowPropertiesModifiedEventAttributes.Builder propModifiedEventAttr = WorkflowPropertiesModifiedEventAttributes.newBuilder().setUpsertedMemo(attr.getUpsertedMemo()).setWorkflowTaskCompletedEventId(workflowTaskCompletedId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_PROPERTIES_MODIFIED).setWorkflowPropertiesModifiedEventAttributes(propModifiedEventAttr).build();
        ctx.addEvent(event);
    }

    private WorkflowTaskFailedCause processProtocolMessageAttributes(RequestContext ctx, ProtocolMessageCommandAttributes attr, List<Message> messages, String identity, long workflowTaskCompletedId) {
        Message orderedMsg = messages.stream().filter(msg -> msg.getId().equals(attr.getMessageId())).findFirst().map(msg -> {
            messages.remove(msg);
            return msg;
        }).get();
        this.processMessage(ctx, orderedMsg, identity, workflowTaskCompletedId);
        return null;
    }

    private void processAcceptanceMessage(RequestContext ctx, Message msg, Acceptance acceptance, long workflowTaskCompletedId) {
        String protocolInstanceId = msg.getProtocolInstanceId();
        StateMachine<StateMachines.UpdateWorkflowExecutionData> update = this.updates.get(protocolInstanceId);
        if (update != null) {
            throw Status.FAILED_PRECONDITION.withDescription("Already accepted update with Id " + protocolInstanceId).asRuntimeException();
        }
        UpdateWorkflowExecution u = this.workflowTaskStateMachine.getData().updateRequest.get(protocolInstanceId);
        update = StateMachines.newUpdateWorkflowExecution(protocolInstanceId, u.getRequest().getRequest(), u.getAccepted(), u.getOutcome());
        this.updates.put(protocolInstanceId, update);
        update.action(StateMachines.Action.START, ctx, msg, workflowTaskCompletedId);
    }

    private void processRejectionMessage(RequestContext ctx, Message msg, Rejection rejection, long workflowTaskCompletedId) {
        String protocolInstanceId = msg.getProtocolInstanceId();
        StateMachine<StateMachines.UpdateWorkflowExecutionData> update = this.updates.get(protocolInstanceId);
        if (update != null) {
            throw Status.FAILED_PRECONDITION.withDescription("Already accepted update with Id " + protocolInstanceId).asRuntimeException();
        }
        UpdateWorkflowExecution u = this.workflowTaskStateMachine.getData().updateRequest.get(msg.getProtocolInstanceId());
        ctx.onCommit(historySize -> {
            u.getOutcome().complete(Outcome.newBuilder().setFailure(rejection.getFailure()).build());
            u.getAccepted().complete(false);
        });
    }

    private void processOutcomeMessage(RequestContext ctx, Message msg, Response response, long workflowTaskCompletedId) {
        String protocolInstanceId = msg.getProtocolInstanceId();
        StateMachine<StateMachines.UpdateWorkflowExecutionData> update = this.updates.get(protocolInstanceId);
        if (update == null) {
            throw Status.FAILED_PRECONDITION.withDescription("No update with Id " + protocolInstanceId).asRuntimeException();
        }
        update.action(StateMachines.Action.COMPLETE, ctx, msg, workflowTaskCompletedId);
    }

    @Override
    @Nullable
    public PollWorkflowTaskQueueResponse startWorkflow(boolean continuedAsNew, @Nullable PollWorkflowTaskQueueRequest eagerWorkflowTaskDispatchPollRequest, @Nullable Consumer<TestWorkflowMutableState> withStart) {
        AtomicReference eagerWorkflowTask = new AtomicReference();
        this.lock.lock();
        try {
            this.update(ctx -> {
                this.visibilityStore.upsertSearchAttributesForExecution(ctx.getExecutionId(), this.startRequest.getSearchAttributes());
                this.workflow.action(StateMachines.Action.START, ctx, this.startRequest, 0L);
                java.time.Duration backoffStartInterval = ProtobufTimeUtils.toJavaDuration((Duration)this.workflow.getData().backoffStartInterval);
                if (backoffStartInterval.compareTo(java.time.Duration.ZERO) > 0) {
                    ctx.addTimer(backoffStartInterval, () -> {
                        try {
                            this.update(this::scheduleWorkflowTask);
                        }
                        catch (StatusRuntimeException e) {
                            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                                log.error("Failure trying to add task for an delayed workflow retry", (Throwable)e);
                            }
                        }
                        catch (Throwable e) {
                            log.error("Failure trying to add task for an delayed workflow retry", e);
                        }
                    }, "delayedFirstWorkflowTask");
                } else {
                    this.scheduleWorkflowTask(ctx);
                    if (eagerWorkflowTaskDispatchPollRequest != null) {
                        eagerWorkflowTask.set(ctx.resetWorkflowTaskForMatching());
                    }
                }
                java.time.Duration runTimeout = ProtobufTimeUtils.toJavaDuration((Duration)this.startRequest.getWorkflowRunTimeout());
                if (backoffStartInterval.compareTo(java.time.Duration.ZERO) > 0) {
                    runTimeout = runTimeout.plus(backoffStartInterval);
                }
                this.workflow.getData().runTimerCancellationHandle = ctx.addTimer(runTimeout, this::timeoutWorkflow, "workflow execution timeout");
            });
            if (withStart != null) {
                withStart.accept(this);
            }
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
            }
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        if (!continuedAsNew && this.parent.isPresent()) {
            ChildWorkflowExecutionStartedEventAttributes a = ChildWorkflowExecutionStartedEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setWorkflowExecution(this.getExecutionId().getExecution()).setNamespace(this.getExecutionId().getNamespace()).setWorkflowType(this.startRequest.getWorkflowType()).build();
            try {
                this.parent.get().childWorkflowStarted(a);
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                    log.error("Failure reporting child completion", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("Failure trying to add task for an delayed workflow retry", (Throwable)e);
            }
        }
        if (eagerWorkflowTask.get() != null) {
            PollWorkflowTaskQueueResponse.Builder task = ((TestWorkflowStore.WorkflowTask)eagerWorkflowTask.get()).getTask();
            this.startWorkflowTask(task, eagerWorkflowTaskDispatchPollRequest);
            return task.build();
        }
        return null;
    }

    private void scheduleWorkflowTask(RequestContext ctx) {
        StateMachines.State beforeState = this.workflowTaskStateMachine.getState();
        this.workflowTaskStateMachine.action(StateMachines.Action.INITIATE, ctx, this.startRequest, 0L);
        if (beforeState == StateMachines.State.NONE && this.workflowTaskStateMachine.getState() == StateMachines.State.INITIATED) {
            ctx.lockTimer("scheduleWorkflowTask");
        }
    }

    @Override
    public void startActivityTask(PollActivityTaskQueueResponseOrBuilder task, PollActivityTaskQueueRequest pollRequest) {
        this.update(ctx -> {
            String activityId = task.getActivityId();
            StateMachine<StateMachines.ActivityTaskData> activityStateMachine = this.getPendingActivityById(activityId);
            activityStateMachine.action(StateMachines.Action.START, ctx, pollRequest, 0L);
            StateMachines.ActivityTaskData data = activityStateMachine.getData();
            data.identity = pollRequest.getIdentity();
            java.time.Duration startToCloseTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getStartToCloseTimeout());
            java.time.Duration heartbeatTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getHeartbeatTimeout());
            long scheduledEventId = activityStateMachine.getData().scheduledEventId;
            if (startToCloseTimeout.compareTo(java.time.Duration.ZERO) > 0) {
                int attempt = data.getAttempt();
                ctx.addTimer(startToCloseTimeout, () -> this.timeoutActivity(scheduledEventId, TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE, attempt), "Activity StartToCloseTimeout");
            }
            this.updateHeartbeatTimer(ctx, scheduledEventId, activityStateMachine, startToCloseTimeout, heartbeatTimeout);
        });
    }

    @Override
    public boolean isTerminalState() {
        StateMachines.State workflowState = this.workflow.getState();
        return this.isTerminalState(workflowState);
    }

    private void updateHeartbeatTimer(RequestContext ctx, long activityId, StateMachine<StateMachines.ActivityTaskData> activity, java.time.Duration startToCloseTimeout, java.time.Duration heartbeatTimeout) {
        if (heartbeatTimeout.compareTo(java.time.Duration.ZERO) > 0 && heartbeatTimeout.compareTo(startToCloseTimeout) < 0) {
            StateMachines.ActivityTaskData data = activity.getData();
            data.lastHeartbeatTime = this.clock.getAsLong();
            int attempt = data.getAttempt();
            ctx.addTimer(heartbeatTimeout, () -> this.timeoutActivity(activityId, TimeoutType.TIMEOUT_TYPE_HEARTBEAT, attempt), "Activity Heartbeat Timeout");
        }
    }

    @Override
    public void completeActivityTask(long scheduledEventId, RespondActivityTaskCompletedRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityByScheduledEventId(scheduledEventId);
            this.throwIfTaskTokenDoesntMatch(request.getTaskToken(), activity.getData());
            activity.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
            this.removeActivity(scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeActivityTask");
        });
    }

    @Override
    public void completeActivityTaskById(String activityId, RespondActivityTaskCompletedByIdRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityById(activityId);
            activity.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
            this.removeActivity(activity.getData().scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeActivityTaskById");
        });
    }

    @Override
    public void failActivityTask(long scheduledEventId, RespondActivityTaskFailedRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityByScheduledEventId(scheduledEventId);
            this.throwIfTaskTokenDoesntMatch(request.getTaskToken(), activity.getData());
            activity.action(StateMachines.Action.FAIL, ctx, request, 0L);
            if (this.isTerminalState(activity.getState())) {
                this.removeActivity(scheduledEventId);
                this.scheduleWorkflowTask(ctx);
            } else {
                this.addActivityRetryTimer(ctx, activity);
            }
            ctx.unlockTimer("failActivityTask");
        });
    }

    private void addActivityRetryTimer(RequestContext ctx, StateMachine<StateMachines.ActivityTaskData> activity) {
        StateMachines.ActivityTaskData data = activity.getData();
        int attempt = data.getAttempt();
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)data.nextBackoffInterval), () -> {
            if (activity.getState() != StateMachines.State.INITIATED && data.getAttempt() != attempt) {
                return;
            }
            LockHandle lockHandle = this.timerService.lockTimeSkipping("activityRetryTimer " + ((StateMachines.ActivityTaskData)activity.getData()).scheduledEvent.getActivityId());
            boolean unlockTimer = false;
            try {
                this.update(ctx1 -> ctx1.addActivityTask(data.activityTask));
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                    log.error("Failure trying to add task for an activity retry", (Throwable)e);
                }
                unlockTimer = true;
            }
            catch (Exception e) {
                unlockTimer = true;
                log.error("Failure trying to add task for an activity retry", (Throwable)e);
            }
            finally {
                if (unlockTimer) {
                    lockHandle.unlock("activityRetryTimer " + ((StateMachines.ActivityTaskData)activity.getData()).scheduledEvent.getActivityId());
                }
            }
        }, "Activity Retry");
    }

    @Override
    public void failActivityTaskById(String activityId, RespondActivityTaskFailedByIdRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityById(activityId);
            this.throwIfActivityNotInFlightState(activity.getState());
            activity.action(StateMachines.Action.FAIL, ctx, request, 0L);
            if (this.isTerminalState(activity.getState())) {
                this.removeActivity(activity.getData().scheduledEventId);
                this.scheduleWorkflowTask(ctx);
            } else {
                this.addActivityRetryTimer(ctx, activity);
            }
            ctx.unlockTimer("failActivityTaskById");
        });
    }

    @Override
    public void cancelActivityTask(long scheduledEventId, RespondActivityTaskCanceledRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityByScheduledEventId(scheduledEventId);
            this.throwIfTaskTokenDoesntMatch(request.getTaskToken(), activity.getData());
            this.throwIfActivityNotInFlightState(activity.getState());
            activity.action(StateMachines.Action.CANCEL, ctx, request, 0L);
            this.removeActivity(scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("cancelActivityTask");
        });
    }

    @Override
    public void cancelActivityTaskById(String activityId, RespondActivityTaskCanceledByIdRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityById(activityId);
            this.throwIfActivityNotInFlightState(activity.getState());
            activity.action(StateMachines.Action.CANCEL, ctx, request, 0L);
            this.removeActivity(activity.getData().scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("cancelActivityTaskById");
        });
    }

    @Override
    public boolean heartbeatActivityTask(long scheduledEventId, Payloads details) {
        AtomicBoolean result = new AtomicBoolean();
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityByScheduledEventId(scheduledEventId);
            this.throwIfActivityNotInFlightState(activity.getState());
            activity.action(StateMachines.Action.UPDATE, ctx, details, 0L);
            if (activity.getState() == StateMachines.State.CANCELLATION_REQUESTED) {
                result.set(true);
            }
            StateMachines.ActivityTaskData data = activity.getData();
            data.lastHeartbeatTime = this.clock.getAsLong();
            java.time.Duration startToCloseTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getStartToCloseTimeout());
            java.time.Duration heartbeatTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getHeartbeatTimeout());
            this.updateHeartbeatTimer(ctx, scheduledEventId, activity, startToCloseTimeout, heartbeatTimeout);
        });
        return result.get();
    }

    @Override
    public boolean heartbeatActivityTaskById(String id, Payloads details, String identity) {
        StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityById(id);
        return this.heartbeatActivityTask(activity.getData().scheduledEventId, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutActivity(long scheduledEventId, TimeoutType timeoutType, int timeoutAttempt) {
        boolean unlockTimer = true;
        try {
            this.update(ctx -> {
                StateMachine<StateMachines.ActivityTaskData> activity = this.getPendingActivityByScheduledEventId(scheduledEventId);
                int attempt = activity.getData().getAttempt();
                if (timeoutAttempt != attempt || activity.getState() != StateMachines.State.INITIATED && activity.getState() != StateMachines.State.STARTED) {
                    throw Status.NOT_FOUND.withDescription("Outdated timer").asRuntimeException();
                }
                if (timeoutType == TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_START && activity.getState() != StateMachines.State.INITIATED) {
                    throw Status.INTERNAL.withDescription("Not in INITIATED").asRuntimeException();
                }
                if (timeoutType == TimeoutType.TIMEOUT_TYPE_HEARTBEAT) {
                    long heartbeatTimeout = Durations.toMillis((Duration)activity.getData().scheduledEvent.getHeartbeatTimeout());
                    if (this.clock.getAsLong() - activity.getData().lastHeartbeatTime < heartbeatTimeout) {
                        throw Status.NOT_FOUND.withDescription("Timer fired earlier").asRuntimeException();
                    }
                }
                activity.action(StateMachines.Action.TIME_OUT, ctx, timeoutType, 0L);
                if (this.isTerminalState(activity.getState())) {
                    this.removeActivity(scheduledEventId);
                    this.scheduleWorkflowTask(ctx);
                } else {
                    this.addActivityRetryTimer(ctx, activity);
                }
            });
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure trying to add task for an activity retry", (Throwable)e);
            }
            unlockTimer = false;
        }
        catch (Exception e) {
            log.error("Failure trying to timeout an activity", (Throwable)e);
        }
        finally {
            if (unlockTimer) {
                this.timerService.unlockTimeSkipping("timeoutActivity: " + scheduledEventId);
            }
        }
    }

    @Override
    public void startNexusOperation(long scheduledEventId, String clientIdentity, StartOperationResponse.Async resp) {
        this.update(ctx -> {
            StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(scheduledEventId);
            operation.action(StateMachines.Action.START, ctx, resp, 0L);
            operation.getData().identity = clientIdentity;
            this.scheduleWorkflowTask(ctx);
        });
    }

    @Override
    public void cancelNexusOperation(NexusOperationRef ref, Failure failure) {
        this.update(ctx -> {
            StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(ref.getScheduledEventId());
            if (!this.operationInFlight(operation.getState())) {
                return;
            }
            operation.action(StateMachines.Action.CANCEL, ctx, failure, 0L);
            this.nexusOperations.remove(ref.getScheduledEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("cancelNexusOperation");
        });
    }

    @Override
    public void cancelNexusOperationRequestAcknowledge(NexusOperationRef ref) {
        this.update(ctx -> {
            StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(ref.getScheduledEventId());
            if (!this.operationInFlight(operation.getState())) {
                return;
            }
            ctx.unlockTimer("cancelNexusOperationRequestAcknowledge");
        });
    }

    @Override
    public void completeNexusOperation(NexusOperationRef ref, Payload result) {
        this.update(ctx -> {
            StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(ref.getScheduledEventId());
            operation.action(StateMachines.Action.COMPLETE, ctx, result, 0L);
            this.nexusOperations.remove(ref.getScheduledEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeNexusOperation");
        });
    }

    @Override
    public void completeAsyncNexusOperation(NexusOperationRef ref, Payload result, String operationID, Link startLink) {
        this.update(ctx -> {
            StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(ref.getScheduledEventId());
            if (operation.getState() == StateMachines.State.INITIATED) {
                StartOperationResponse.Async start = StartOperationResponse.Async.newBuilder().setOperationId(operationID).addLinks(startLink).build();
                operation.action(StateMachines.Action.START, ctx, start, 0L);
            }
            operation.action(StateMachines.Action.COMPLETE, ctx, result, 0L);
            this.nexusOperations.remove(ref.getScheduledEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeNexusOperation");
        });
    }

    @Override
    public void failNexusOperation(NexusOperationRef ref, Failure failure) {
        this.update(ctx -> {
            StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(ref.getScheduledEventId());
            operation.action(StateMachines.Action.FAIL, ctx, failure, 0L);
            if (this.isTerminalState(operation.getState())) {
                this.nexusOperations.remove(ref.getScheduledEventId());
                this.scheduleWorkflowTask(ctx);
            } else {
                this.retryNexusTask(ctx, operation);
            }
            ctx.unlockTimer("failNexusOperation");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutNexusOperation(long scheduledEventId, TimeoutType timeoutType, int timeoutAttempt) {
        boolean unlockTimer = true;
        try {
            this.update(ctx -> {
                StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(scheduledEventId);
                int attempt = operation.getData().getAttempt();
                if (timeoutAttempt != attempt || operation.getState() != StateMachines.State.INITIATED && operation.getState() != StateMachines.State.STARTED) {
                    throw Status.NOT_FOUND.withDescription("Timer fired earlier").asRuntimeException();
                }
                operation.action(StateMachines.Action.TIME_OUT, ctx, timeoutType, 0L);
                this.nexusOperations.remove(scheduledEventId);
                this.scheduleWorkflowTask(ctx);
            });
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure trying to timeout a Nexus operation", (Throwable)e);
            }
            unlockTimer = false;
        }
        catch (Exception e) {
            log.error("Failure trying to timeout a Nexus operation", (Throwable)e);
        }
        finally {
            if (unlockTimer) {
                this.timerService.unlockTimeSkipping("timeoutNexusOperation: " + scheduledEventId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutNexusRequest(long scheduledEventId, String requestMethod, int attempt) {
        boolean unlockTimer = true;
        try {
            this.update(ctx -> {
                StateMachine<StateMachines.NexusOperationData> operation = this.getPendingNexusOperation(scheduledEventId);
                if (attempt != operation.getData().getAttempt() || this.isTerminalState(operation.getState())) {
                    throw Status.NOT_FOUND.withDescription("Timer fired earlier").asRuntimeException();
                }
                Failure failure = Failure.newBuilder().setMessage(requestMethod + " timed out").setApplicationFailureInfo(ApplicationFailureInfo.newBuilder().setNonRetryable(false)).build();
                operation.action(StateMachines.Action.FAIL, ctx, failure, 0L);
                if (this.isTerminalState(operation.getState())) {
                    this.nexusOperations.remove(scheduledEventId);
                    this.scheduleWorkflowTask(ctx);
                } else {
                    this.retryNexusTask(ctx, operation);
                }
            });
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure trying to add task for a Nexus operation retry", (Throwable)e);
            }
            unlockTimer = false;
        }
        catch (Exception e) {
            log.error("Failure trying to timeout a Nexus operation", (Throwable)e);
        }
        finally {
            if (unlockTimer) {
                this.timerService.unlockTimeSkipping("timeoutNexusOperation: " + scheduledEventId);
            }
        }
    }

    private void retryNexusTask(RequestContext ctx, StateMachine<StateMachines.NexusOperationData> operation) {
        StateMachines.State prevState = operation.getState();
        StateMachines.NexusOperationData data = operation.getData();
        int attempt = data.getAttempt();
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)data.nextBackoffInterval), () -> {
            if (operation.getState() != prevState && data.getAttempt() != attempt) {
                return;
            }
            LockHandle lockHandle = this.timerService.lockTimeSkipping("nexusOperationRetryTimer " + ((StateMachines.NexusOperationData)operation.getData()).operationId);
            boolean unlockTimer = false;
            data.isBackingOff = false;
            try {
                data.nexusTask.setDeadline(Timestamps.add((Timestamp)ctx.currentTime(), (Duration)data.requestTimeout));
                this.update(ctx1 -> ctx1.addNexusTask(data.nexusTask));
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                    log.error("Failure trying to add task for a Nexus operation retry", (Throwable)e);
                }
                unlockTimer = true;
            }
            catch (Exception e) {
                log.error("Failure trying to add task for a Nexus operation retry", (Throwable)e);
                unlockTimer = true;
            }
            finally {
                if (unlockTimer) {
                    lockHandle.unlock("nexusOperationRetryTimer " + ((StateMachines.NexusOperationData)operation.getData()).operationId);
                }
            }
        }, "Nexus Operation Retry");
    }

    private void timeoutWorkflow() {
        this.lock.lock();
        try {
            if (this.isTerminalState(this.workflow.getState())) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.update(ctx -> {
                if (this.isTerminalState(this.workflow.getState())) {
                    return;
                }
                this.workflow.action(StateMachines.Action.TIME_OUT, ctx, RetryState.RETRY_STATE_TIMEOUT, 0L);
                this.workflowTaskStateMachine.getData().workflowCompleted = true;
                this.processWorkflowCompletionCallbacks(ctx);
                if (this.parent.isPresent()) {
                    ctx.lockTimer("timeoutWorkflow notify parent");
                }
                ForkJoinPool.commonPool().execute(() -> this.reportWorkflowTimeoutToParent(ctx));
            });
        }
        catch (Exception e) {
            log.error("Failure trying to timeout a workflow", (Throwable)e);
        }
    }

    private void reportWorkflowTimeoutToParent(RequestContext ctx) {
        if (!this.parent.isPresent()) {
            return;
        }
        try {
            ChildWorkflowExecutionTimedOutEventAttributes a = ChildWorkflowExecutionTimedOutEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setRetryState(RetryState.RETRY_STATE_TIMEOUT).setWorkflowType(this.startRequest.getWorkflowType()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).build();
            this.parent.get().childWorkflowTimedOut(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure reporting child timing out", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("Failure reporting child timing out", (Throwable)e);
        }
    }

    @Override
    public void signal(SignalWorkflowExecutionRequest signalRequest) {
        this.update(ctx -> {
            this.addExecutionSignaledEvent(ctx, signalRequest);
            this.scheduleWorkflowTask(ctx);
        });
    }

    @Override
    public void signalFromWorkflow(SignalExternalWorkflowExecutionCommandAttributes a) {
        this.update(ctx -> {
            this.addExecutionSignaledByExternalEvent(ctx, a);
            this.scheduleWorkflowTask(ctx);
        });
    }

    @Override
    public UpdateHandle updateWorkflowExecution(UpdateWorkflowExecutionRequest request, Deadline deadline) {
        if (request.getWaitPolicy().getLifecycleStage().equals((Object)UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_UNSPECIFIED) || !request.hasWaitPolicy()) {
            throw Status.INVALID_ARGUMENT.withDescription("LifeCycle stage is required").asRuntimeException();
        }
        if (request.getWaitPolicy().getLifecycleStage().equals((Object)UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_ADMITTED)) {
            throw Status.PERMISSION_DENIED.withDescription("Admitted stage is not supported").asRuntimeException();
        }
        if (this.isTerminalState()) {
            UpdateHandle updateHandle = this.getUpdate(request.getRequest().getMeta().getUpdateId());
            if (updateHandle.getOutcome().isDone()) {
                return updateHandle;
            }
            throw Status.NOT_FOUND.withDescription("workflow execution already completed").asRuntimeException();
        }
        return this.getOrCreateUpdate(request);
    }

    @Override
    public PollWorkflowExecutionUpdateResponse pollUpdateWorkflowExecution(PollWorkflowExecutionUpdateRequest request, Deadline deadline) {
        UpdateHandle updateHandle = this.getUpdate(request.getUpdateRef().getUpdateId());
        try {
            if (this.isTerminalState()) {
                if (updateHandle.getOutcome().isDone()) {
                    return PollWorkflowExecutionUpdateResponse.newBuilder().setUpdateRef(updateHandle.getRef()).setStage(updateHandle.getStage()).setOutcome(updateHandle.getOutcomeNow()).build();
                }
                throw Status.NOT_FOUND.withDescription("workflow execution already completed").asRuntimeException();
            }
            if (!request.hasWaitPolicy() || request.getWaitPolicy().getLifecycleStage().equals((Object)UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_UNSPECIFIED) || request.getWaitPolicy().getLifecycleStage().equals((Object)UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_ADMITTED)) {
                UpdateWorkflowExecutionLifecycleStage stage = updateHandle.getStage();
                PollWorkflowExecutionUpdateResponse.Builder response = PollWorkflowExecutionUpdateResponse.newBuilder().setUpdateRef(updateHandle.getRef()).setStage(stage);
                if (stage == UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED) {
                    response.setOutcome(updateHandle.getOutcomeNow());
                }
                return response.build();
            }
            UpdateWorkflowExecutionLifecycleStage reachedStage = updateHandle.waitForStage(request.getWaitPolicy().getLifecycleStage(), deadline.timeRemaining(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            PollWorkflowExecutionUpdateResponse.Builder response = PollWorkflowExecutionUpdateResponse.newBuilder().setUpdateRef(updateHandle.getRef()).setStage(reachedStage);
            if (reachedStage == UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED) {
                response.setOutcome(updateHandle.getOutcomeNow());
            }
            return response.build();
        }
        catch (TimeoutException e) {
            PollWorkflowExecutionUpdateResponse.Builder response = PollWorkflowExecutionUpdateResponse.newBuilder().setUpdateRef(request.getUpdateRef()).setStage(updateHandle.getStage());
            if (updateHandle.getStage() == UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED) {
                response.setOutcome(updateHandle.getOutcomeNow());
            }
            return response.build();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StatusRuntimeException) {
                throw (StatusRuntimeException)cause;
            }
            throw Status.INTERNAL.withCause(cause).withDescription(cause.getMessage()).asRuntimeException();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdateHandle getOrCreateUpdate(UpdateWorkflowExecutionRequest updateRequest) {
        this.lock.lock();
        String updateId = updateRequest.getRequest().getMeta().getUpdateId();
        try {
            Optional<UpdateWorkflowExecution> inflightUpdate = this.workflowTaskStateMachine.getData().getUpdateRequest(updateId);
            if (inflightUpdate.isPresent()) {
                UpdateHandle updateHandle = new UpdateHandle(inflightUpdate.get().getId(), this.getExecutionId().getExecution(), inflightUpdate.get().getAccepted(), inflightUpdate.get().getOutcome());
                return updateHandle;
            }
            StateMachine<StateMachines.UpdateWorkflowExecutionData> acceptedUpdate = this.updates.get(updateId);
            if (acceptedUpdate != null) {
                UpdateHandle updateHandle = new UpdateHandle(acceptedUpdate.getData().id, this.getExecutionId().getExecution(), acceptedUpdate.getData().accepted, acceptedUpdate.getData().outcome);
                return updateHandle;
            }
            UpdateWorkflowExecution update = new UpdateWorkflowExecution(updateRequest);
            this.update(ctx -> {
                if (this.workflowTaskStateMachine.getState() == StateMachines.State.NONE) {
                    this.scheduleWorkflowTask(ctx);
                }
                this.workflowTaskStateMachine.action(StateMachines.Action.UPDATE_WORKFLOW_EXECUTION, ctx, update, 0L);
            });
            UpdateHandle updateHandle = new UpdateHandle(update.getId(), this.getExecutionId().getExecution(), update.getAccepted(), update.getOutcome());
            return updateHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    UpdateHandle getUpdate(String updateId) {
        this.lock.lock();
        try {
            Optional<UpdateWorkflowExecution> inflightUpdate = this.workflowTaskStateMachine.getData().getUpdateRequest(updateId);
            if (inflightUpdate.isPresent()) {
                UpdateHandle updateHandle = new UpdateHandle(inflightUpdate.get().getId(), this.getExecutionId().getExecution(), inflightUpdate.get().getAccepted(), inflightUpdate.get().getOutcome());
                return updateHandle;
            }
            StateMachine<StateMachines.UpdateWorkflowExecutionData> acceptedUpdate = this.updates.get(updateId);
            if (acceptedUpdate != null) {
                UpdateHandle updateHandle = new UpdateHandle(acceptedUpdate.getData().id, this.getExecutionId().getExecution(), acceptedUpdate.getData().accepted, acceptedUpdate.getData().outcome);
                return updateHandle;
            }
            throw Status.NOT_FOUND.withDescription("update " + updateId + " not found").asRuntimeException();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, Optional<CancelExternalWorkflowExecutionCallerInfo> callerInfo) {
        this.lock.lock();
        try {
            if (this.isTerminalState()) {
                return;
            }
            this.update(ctx -> {
                this.workflow.action(StateMachines.Action.REQUEST_CANCELLATION, ctx, cancelRequest, 0L);
                this.scheduleWorkflowTask(ctx);
            });
            if (callerInfo.isPresent()) {
                CancelExternalWorkflowExecutionCallerInfo ci = callerInfo.get();
                ExternalWorkflowExecutionCancelRequestedEventAttributes a = ExternalWorkflowExecutionCancelRequestedEventAttributes.newBuilder().setInitiatedEventId(ci.getExternalInitiatedEventId()).setWorkflowExecution(this.executionId.getExecution()).setNamespace(ci.getNamespace()).build();
                ForkJoinPool.commonPool().execute(() -> {
                    try {
                        ci.getCaller().reportCancelRequested(a);
                    }
                    catch (StatusRuntimeException e) {
                        if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                            log.error("Failure reporting external cancellation requested", (Throwable)e);
                        }
                    }
                    catch (Throwable e) {
                        log.error("Failure reporting external cancellation requested", e);
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request) {
        this.update(ctx -> {
            this.workflow.action(StateMachines.Action.TERMINATE, ctx, request, 0L);
            this.workflowTaskStateMachine.getData().workflowCompleted = true;
            this.processWorkflowCompletionCallbacks(ctx);
        });
    }

    @Override
    public QueryWorkflowResponse query(QueryWorkflowRequest queryRequest, long timeoutMs) {
        boolean safeToDispatchDirectly;
        WorkflowExecutionStatus status = this.getWorkflowExecutionStatus();
        if (status != WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING) {
            boolean rejectNotCompletedCleanly;
            boolean rejectNotOpen = queryRequest.getQueryRejectCondition() == QueryRejectCondition.QUERY_REJECT_CONDITION_NOT_OPEN;
            boolean bl = rejectNotCompletedCleanly = queryRequest.getQueryRejectCondition() == QueryRejectCondition.QUERY_REJECT_CONDITION_NOT_COMPLETED_CLEANLY && status != WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_COMPLETED;
            if (rejectNotOpen || rejectNotCompletedCleanly) {
                return QueryWorkflowResponse.newBuilder().setQueryRejected(QueryRejected.newBuilder().setStatus(status)).build();
            }
        }
        this.lock.lock();
        boolean bl = safeToDispatchDirectly = this.isTerminalState() || this.workflowTaskStateMachine.getState() != StateMachines.State.INITIATED && this.workflowTaskStateMachine.getState() != StateMachines.State.STARTED;
        if (safeToDispatchDirectly) {
            return this.directQuery(queryRequest, timeoutMs);
        }
        return this.stronglyConsistentQuery(queryRequest, timeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryWorkflowResponse directQuery(QueryWorkflowRequest queryRequest, long timeoutMs) {
        CompletableFuture result = new CompletableFuture();
        try {
            QueryId queryId = new QueryId(this.executionId);
            PollWorkflowTaskQueueResponse.Builder task = PollWorkflowTaskQueueResponse.newBuilder().setTaskToken(queryId.toBytes()).setWorkflowExecution(this.executionId.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).setQuery(queryRequest.getQuery()).setWorkflowExecutionTaskQueue(this.startRequest.getTaskQueue());
            TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(queryRequest.getNamespace(), this.stickyExecutionAttributes == null ? this.startRequest.getTaskQueue().getName() : this.stickyExecutionAttributes.getWorkerTaskQueue().getName());
            this.queries.put(queryId.getQueryId(), result);
            this.store.sendQueryTask(this.executionId, taskQueueId, task);
        }
        finally {
            this.lock.unlock();
        }
        try {
            return (QueryWorkflowResponse)result.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return QueryWorkflowResponse.getDefaultInstance();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StatusRuntimeException) {
                throw (StatusRuntimeException)cause;
            }
            throw Status.INTERNAL.withCause(cause).withDescription(cause.getMessage()).asRuntimeException();
        }
        catch (TimeoutException e) {
            throw Status.DEADLINE_EXCEEDED.withCause((Throwable)e).withDescription("Query deadline of " + timeoutMs + " milliseconds exceeded").asRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryWorkflowResponse stronglyConsistentQuery(QueryWorkflowRequest queryRequest, long timeoutMs) {
        ConsistentQuery consistentQuery = new ConsistentQuery(queryRequest);
        try {
            this.update(ctx -> this.workflowTaskStateMachine.action(StateMachines.Action.QUERY, ctx, consistentQuery, 0L));
        }
        finally {
            this.lock.unlock();
        }
        CompletableFuture<QueryWorkflowResponse> result = consistentQuery.getResult();
        return this.getQueryWorkflowResponse(timeoutMs, result);
    }

    private QueryWorkflowResponse getQueryWorkflowResponse(long timeoutMs, CompletableFuture<QueryWorkflowResponse> result) {
        try {
            return result.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return QueryWorkflowResponse.getDefaultInstance();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StatusRuntimeException) {
                throw (StatusRuntimeException)cause;
            }
            throw Status.INTERNAL.withCause(cause).withDescription(cause.getMessage()).asRuntimeException();
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw Status.DEADLINE_EXCEEDED.withCause((Throwable)e).withDescription("query deadline exceeded").asRuntimeException();
        }
    }

    @Override
    public void completeQuery(QueryId queryId, RespondQueryTaskCompletedRequest completeRequest) {
        CompletableFuture<QueryWorkflowResponse> result = this.queries.remove(queryId.getQueryId());
        if (result == null) {
            throw Status.NOT_FOUND.withDescription("Unknown query id: " + queryId.getQueryId()).asRuntimeException();
        }
        if (result.isCancelled()) {
            return;
        }
        switch (completeRequest.getCompletedType()) {
            case QUERY_RESULT_TYPE_ANSWERED: {
                QueryWorkflowResponse response = QueryWorkflowResponse.newBuilder().setQueryResult(completeRequest.getQueryResult()).build();
                result.complete(response);
                break;
            }
            case QUERY_RESULT_TYPE_FAILED: {
                StatusRuntimeException error = StatusUtils.newException((Status)Status.INVALID_ARGUMENT.withDescription(completeRequest.getErrorMessage()), (com.google.protobuf.Message)QueryFailedFailure.getDefaultInstance(), (Descriptors.Descriptor)QueryFailedFailure.getDescriptor());
                result.completeExceptionally(error);
            }
        }
    }

    @Override
    public DescribeWorkflowExecutionResponse describeWorkflowExecution() {
        this.lock.lock();
        try {
            DescribeWorkflowExecutionResponse describeWorkflowExecutionResponse = this.describeWorkflowExecutionInsideLock();
            return describeWorkflowExecutionResponse;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Memo getCurrentMemo() {
        return Memo.newBuilder().putAllFields(this.currentMemo).build();
    }

    private DescribeWorkflowExecutionResponse describeWorkflowExecutionInsideLock() {
        WorkflowExecutionConfig.Builder executionConfig = WorkflowExecutionConfig.newBuilder().setTaskQueue(this.startRequest.getTaskQueue()).setWorkflowExecutionTimeout(this.startRequest.getWorkflowExecutionTimeout()).setWorkflowRunTimeout(this.startRequest.getWorkflowRunTimeout()).setDefaultWorkflowTaskTimeout(this.startRequest.getWorkflowTaskTimeout());
        GetWorkflowExecutionHistoryRequest getRequest = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(this.startRequest.getNamespace()).setExecution(this.executionId.getExecution()).build();
        List fullHistory = this.store.getWorkflowExecutionHistory(this.executionId, getRequest, null).getHistory().getEventsList();
        WorkflowExecutionInfo.Builder executionInfo = WorkflowExecutionInfo.newBuilder();
        executionInfo.setExecution(this.executionId.getExecution()).setType(this.getStartRequest().getWorkflowType()).setMemo(this.getCurrentMemo()).setSearchAttributes(this.visibilityStore.getSearchAttributesForExecution(this.executionId)).setStatus(this.getWorkflowExecutionStatus()).setHistoryLength((long)fullHistory.size()).setTaskQueue(this.getStartRequest().getTaskQueue().getName());
        TestWorkflowMutableStateImpl.populateWorkflowExecutionInfoFromHistory(executionInfo, fullHistory);
        this.parent.ifPresent(p -> executionInfo.setParentNamespaceId(p.getExecutionId().getNamespace()).setParentExecution(p.getExecutionId().getExecution()));
        List callbacks = this.startRequest.getCompletionCallbacksList().stream().map(TestWorkflowMutableStateImpl::constructCallbackInfo).collect(Collectors.toList());
        List pendingActivities = this.activities.values().stream().filter(sm -> !this.isTerminalState(sm.getState())).map(TestWorkflowMutableStateImpl::constructPendingActivityInfo).collect(Collectors.toList());
        List pendingNexusOperations = this.nexusOperations.values().stream().filter(sm -> !this.isTerminalState(sm.getState())).map(TestWorkflowMutableStateImpl::constructPendingNexusOperationInfo).collect(Collectors.toList());
        List pendingChildren = this.childWorkflows.values().stream().filter(sm -> !this.isTerminalState(sm.getState())).map(TestWorkflowMutableStateImpl::constructPendingChildExecutionInfo).collect(Collectors.toList());
        return DescribeWorkflowExecutionResponse.newBuilder().setExecutionConfig(executionConfig).setWorkflowExecutionInfo(executionInfo).addAllPendingActivities(pendingActivities).addAllPendingNexusOperations(pendingNexusOperations).addAllPendingChildren(pendingChildren).addAllCallbacks(callbacks).build();
    }

    private static PendingChildExecutionInfo constructPendingChildExecutionInfo(StateMachine<StateMachines.ChildWorkflowData> sm) {
        StateMachines.ChildWorkflowData data = sm.getData();
        return PendingChildExecutionInfo.newBuilder().setWorkflowId(data.execution.getWorkflowId()).setRunId(data.execution.getRunId()).setWorkflowTypeName(data.initiatedEvent.getWorkflowType().getName()).setInitiatedId(data.initiatedEventId).setParentClosePolicy(data.initiatedEvent.getParentClosePolicy()).build();
    }

    private static PendingActivityInfo constructPendingActivityInfo(StateMachine<StateMachines.ActivityTaskData> sm) {
        StateMachines.ActivityTaskData activityTaskData = sm.getData();
        StateMachines.State state = sm.getState();
        PendingActivityInfo.Builder builder = PendingActivityInfo.newBuilder();
        builder.setState(TestWorkflowMutableStateImpl.computeActivityState(state, activityTaskData));
        if (activityTaskData.identity != null) {
            builder.setLastWorkerIdentity(activityTaskData.identity);
        }
        if (activityTaskData.lastAttemptCompleteTime != null) {
            builder.setLastAttemptCompleteTime(activityTaskData.lastAttemptCompleteTime);
        }
        if (activityTaskData.scheduledEvent != null) {
            TestWorkflowMutableStateImpl.populatePendingActivityInfoFromScheduledEvent(builder, activityTaskData.scheduledEvent);
        }
        if (activityTaskData.activityTask != null) {
            PollActivityTaskQueueResponse.Builder pollResponse = activityTaskData.activityTask.getTask();
            TestWorkflowMutableStateImpl.populatePendingActivityInfoFromPollResponse(builder, (PollActivityTaskQueueResponseOrBuilder)pollResponse);
        }
        TestWorkflowMutableStateImpl.populatePendingActivityInfoFromHeartbeatDetails(builder, activityTaskData);
        if (activityTaskData.retryState != null) {
            TestWorkflowMutableStateImpl.populatePendingActivityInfoFromRetryData(builder, activityTaskData.retryState);
        }
        return builder.build();
    }

    private static PendingActivityState computeActivityState(StateMachines.State state, StateMachines.ActivityTaskData pendingActivity) {
        if (state == StateMachines.State.CANCELLATION_REQUESTED) {
            return PendingActivityState.PENDING_ACTIVITY_STATE_CANCEL_REQUESTED;
        }
        if (pendingActivity.startedEvent != null) {
            return PendingActivityState.PENDING_ACTIVITY_STATE_STARTED;
        }
        return PendingActivityState.PENDING_ACTIVITY_STATE_SCHEDULED;
    }

    private static void populatePendingActivityInfoFromScheduledEvent(PendingActivityInfo.Builder builder, ActivityTaskScheduledEventAttributes scheduledEvent) {
        builder.setActivityId(scheduledEvent.getActivityId()).setActivityType(scheduledEvent.getActivityType());
    }

    private static void populatePendingActivityInfoFromPollResponse(PendingActivityInfo.Builder builder, PollActivityTaskQueueResponseOrBuilder task) {
        builder.setScheduledTime(task.getScheduledTime());
        builder.setLastStartedTime(task.getStartedTime());
    }

    private static void populatePendingActivityInfoFromHeartbeatDetails(PendingActivityInfo.Builder builder, StateMachines.ActivityTaskData activityTaskData) {
        if (activityTaskData.lastHeartbeatTime > 0L) {
            builder.setLastHeartbeatTime(Timestamps.fromMillis((long)activityTaskData.lastHeartbeatTime));
            if (activityTaskData.heartbeatDetails != null) {
                builder.setHeartbeatDetails(activityTaskData.heartbeatDetails);
            }
        }
    }

    private static void populatePendingActivityInfoFromRetryData(PendingActivityInfo.Builder builder, TestServiceRetryState retryState) {
        builder.setAttempt(retryState.getAttempt());
        builder.setExpirationTime(retryState.getExpirationTime());
        retryState.getPreviousRunFailure().ifPresent(arg_0 -> ((PendingActivityInfo.Builder)builder).setLastFailure(arg_0));
        RetryPolicy retryPolicy = (RetryPolicy)Preconditions.checkNotNull((Object)retryState.getRetryPolicy(), (Object)"retryPolicy should always be present");
        builder.setMaximumAttempts(retryPolicy.getMaximumAttempts());
    }

    private static PendingNexusOperationInfo constructPendingNexusOperationInfo(StateMachine<StateMachines.NexusOperationData> sm) {
        StateMachines.NexusOperationData data = sm.getData();
        PendingNexusOperationInfo.Builder builder = PendingNexusOperationInfo.newBuilder().setEndpoint(data.scheduledEvent.getEndpoint()).setService(data.scheduledEvent.getService()).setOperation(data.scheduledEvent.getOperation()).setOperationId(data.operationId).setScheduledEventId(data.scheduledEventId).setScheduleToCloseTimeout(data.scheduledEvent.getScheduleToCloseTimeout()).setState(TestWorkflowMutableStateImpl.convertNexusOperationState(sm.getState(), data)).setAttempt(data.getAttempt());
        if (data.lastAttemptCompleteTime != null) {
            builder.setLastAttemptCompleteTime(data.lastAttemptCompleteTime);
        }
        if (data.nextAttemptScheduleTime != null) {
            builder.setNextAttemptScheduleTime(data.nextAttemptScheduleTime);
        }
        data.retryState.getPreviousRunFailure().ifPresent(arg_0 -> ((PendingNexusOperationInfo.Builder)builder).setLastAttemptFailure(arg_0));
        if (data.nexusTask.getTask().getRequest().hasCancelOperation()) {
            NexusOperationCancellationInfo.Builder cancelInfo = NexusOperationCancellationInfo.newBuilder().setRequestedTime(data.cancelRequestedTime).setState(TestWorkflowMutableStateImpl.convertNexusOperationCancellationState(sm.getState(), data)).setAttempt(data.getAttempt()).setLastAttemptCompleteTime(data.lastAttemptCompleteTime).setNextAttemptScheduleTime(data.nextAttemptScheduleTime);
            data.retryState.getPreviousRunFailure().ifPresent(arg_0 -> ((NexusOperationCancellationInfo.Builder)cancelInfo).setLastAttemptFailure(arg_0));
            builder.setCancellationInfo(cancelInfo);
        }
        return builder.build();
    }

    private static PendingNexusOperationState convertNexusOperationState(StateMachines.State state, StateMachines.NexusOperationData data) {
        if (data.isBackingOff) {
            return PendingNexusOperationState.PENDING_NEXUS_OPERATION_STATE_BACKING_OFF;
        }
        switch (state) {
            case INITIATED: {
                return PendingNexusOperationState.PENDING_NEXUS_OPERATION_STATE_SCHEDULED;
            }
            case STARTED: {
                return PendingNexusOperationState.PENDING_NEXUS_OPERATION_STATE_STARTED;
            }
        }
        return PendingNexusOperationState.PENDING_NEXUS_OPERATION_STATE_UNSPECIFIED;
    }

    private static NexusOperationCancellationState convertNexusOperationCancellationState(StateMachines.State state, StateMachines.NexusOperationData data) {
        if (data.isBackingOff) {
            return NexusOperationCancellationState.NEXUS_OPERATION_CANCELLATION_STATE_BACKING_OFF;
        }
        if (state == StateMachines.State.INITIATED) {
            return NexusOperationCancellationState.NEXUS_OPERATION_CANCELLATION_STATE_SCHEDULED;
        }
        return NexusOperationCancellationState.NEXUS_OPERATION_CANCELLATION_STATE_UNSPECIFIED;
    }

    private static CallbackInfo constructCallbackInfo(Callback completionCallback) {
        return CallbackInfo.newBuilder().setCallback(completionCallback).setTrigger(CallbackInfo.Trigger.newBuilder().setWorkflowClosed(CallbackInfo.WorkflowClosed.getDefaultInstance())).build();
    }

    private static void populateWorkflowExecutionInfoFromHistory(WorkflowExecutionInfo.Builder executionInfo, List<HistoryEvent> fullHistory) {
        TestWorkflowMutableStateImpl.getStartEvent(fullHistory).ifPresent(startEvent -> {
            Timestamp startTime = startEvent.getEventTime();
            executionInfo.setStartTime(startEvent.getEventTime());
            if (startEvent.getWorkflowExecutionStartedEventAttributes().hasFirstWorkflowTaskBackoff()) {
                executionInfo.setExecutionTime(Timestamps.add((Timestamp)startTime, (Duration)startEvent.getWorkflowExecutionStartedEventAttributes().getFirstWorkflowTaskBackoff()));
            } else {
                executionInfo.setExecutionTime(startTime);
            }
        });
        TestWorkflowMutableStateImpl.getCompletionEvent(fullHistory).ifPresent(completionEvent -> executionInfo.setCloseTime(completionEvent.getEventTime()));
    }

    private static Optional<HistoryEvent> getStartEvent(List<HistoryEvent> history) {
        if (history.size() == 0) {
            return Optional.empty();
        }
        HistoryEvent firstEvent = history.get(0);
        Preconditions.checkState((firstEvent.getEventType() == EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED ? 1 : 0) != 0, (String)"The first event in a workflow's history should be %s, but was %s", (Object)EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED.name(), (Object)firstEvent.getEventType().name());
        return Optional.of(firstEvent);
    }

    private static Optional<HistoryEvent> getCompletionEvent(List<HistoryEvent> history) {
        HistoryEvent lastEvent = history.get(history.size() - 1);
        if (WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)lastEvent)) {
            return Optional.of(lastEvent);
        }
        return Optional.empty();
    }

    private void addExecutionSignaledEvent(RequestContext ctx, SignalWorkflowExecutionRequest signalRequest) {
        WorkflowExecutionSignaledEventAttributes.Builder a = WorkflowExecutionSignaledEventAttributes.newBuilder().setIdentity(signalRequest.getIdentity()).setInput(signalRequest.getInput()).setSignalName(signalRequest.getSignalName());
        HistoryEvent.Builder event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED).setWorkflowExecutionSignaledEventAttributes(a);
        if (signalRequest.getLinksCount() > 0) {
            event.addAllLinks((Iterable)signalRequest.getLinksList());
        }
        ctx.addEvent(event.build());
    }

    private void addExecutionSignaledByExternalEvent(RequestContext ctx, SignalExternalWorkflowExecutionCommandAttributes d) {
        WorkflowExecutionSignaledEventAttributes.Builder a = WorkflowExecutionSignaledEventAttributes.newBuilder().setInput(d.getInput()).setSignalName(d.getSignalName());
        HistoryEvent executionSignaled = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED).setWorkflowExecutionSignaledEventAttributes(a).build();
        ctx.addEvent(executionSignaled);
    }

    private StateMachine<StateMachines.ActivityTaskData> getPendingActivityById(String activityId) {
        Long scheduledEventId = this.activityById.get(activityId);
        if (scheduledEventId == null) {
            throw Status.NOT_FOUND.withDescription("cannot find pending activity with ActivityID " + activityId + ", check workflow execution history for more details").asRuntimeException();
        }
        return this.getPendingActivityByScheduledEventId(scheduledEventId);
    }

    private void removeActivity(long scheduledEventId) {
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.remove(scheduledEventId);
        if (activity == null) {
            return;
        }
        this.activityById.remove(activity.getData().scheduledEvent.getActivityId());
    }

    private StateMachine<StateMachines.ActivityTaskData> getPendingActivityByScheduledEventId(long scheduledEventId) {
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.get(scheduledEventId);
        if (activity == null) {
            throw Status.NOT_FOUND.withDescription("unknown activity with scheduledEventId: " + scheduledEventId).asRuntimeException();
        }
        return activity;
    }

    private StateMachine<StateMachines.NexusOperationData> getPendingNexusOperation(long scheduledEventId) {
        StateMachine<StateMachines.NexusOperationData> operation = this.nexusOperations.get(scheduledEventId);
        if (operation == null) {
            throw Status.NOT_FOUND.withDescription("unknown Nexus operation with scheduledEventId: " + scheduledEventId).asRuntimeException();
        }
        return operation;
    }

    private StateMachine<StateMachines.ChildWorkflowData> getChildWorkflow(long initiatedEventId) {
        StateMachine<StateMachines.ChildWorkflowData> child = this.childWorkflows.get(initiatedEventId);
        if (child == null) {
            throw Status.INTERNAL.withDescription("unknown initiatedEventId: " + initiatedEventId).asRuntimeException();
        }
        return child;
    }

    private void throwIfActivityNotInFlightState(StateMachines.State activityState) {
        switch (activityState) {
            case STARTED: 
            case CANCELLATION_REQUESTED: {
                return;
            }
        }
        throw Status.NOT_FOUND.withDescription("Activity is in " + (Object)((Object)activityState) + "  state").asRuntimeException();
    }

    private void throwIfTaskTokenDoesntMatch(ByteString taskToken, StateMachines.ActivityTaskData data) {
        ActivityTaskToken activityTaskToken;
        if (!(taskToken.isEmpty() || (activityTaskToken = ActivityTaskToken.fromBytes(taskToken)).getAttempt() == (long)data.getAttempt() && activityTaskToken.getScheduledEventId() == data.scheduledEventId)) {
            throw Status.NOT_FOUND.withDescription("invalid activityID or activity already timed out or invoking workflow is completed").asRuntimeException();
        }
    }

    private boolean operationInFlight(StateMachines.State operationState) {
        switch (operationState) {
            case INITIATED: 
            case STARTED: 
            case CANCELLATION_REQUESTED: {
                return true;
            }
        }
        log.warn("skipping Nexus task for operation that is not in flight");
        return false;
    }

    @Override
    public boolean validateOperationTaskToken(NexusTaskToken tt) {
        StateMachines.NexusOperationData data = this.getPendingNexusOperation(tt.getOperationRef().getScheduledEventId()).getData();
        if (tt.getAttempt() != (long)data.getAttempt()) {
            log.warn("skipping outdated Nexus task with mismatched attempt count. provided={} expected={}", (Object)tt.getAttempt(), (Object)data.getAttempt());
            return false;
        }
        if (tt.getOperationRef().getScheduledEventId() != data.scheduledEventId) {
            log.warn("skipping outdated Nexus task with mismatched scheduledEventId. provided={} expected={}", (Object)tt.getOperationRef().getScheduledEventId(), (Object)data.getAttempt());
            return false;
        }
        if (!tt.isCancel() && data.nexusTask.getTask().getRequest().hasCancelOperation()) {
            log.warn("skipping outdated Nexus task. expected a cancel operation request");
            return false;
        }
        return true;
    }

    private boolean isTerminalState(StateMachines.State workflowState) {
        return workflowState == StateMachines.State.COMPLETED || workflowState == StateMachines.State.TIMED_OUT || workflowState == StateMachines.State.FAILED || workflowState == StateMachines.State.CANCELED || workflowState == StateMachines.State.TERMINATED || workflowState == StateMachines.State.CONTINUED_AS_NEW;
    }

    static class UpdateHandle {
        private final String id;
        private final WorkflowExecution execution;
        private final CompletableFuture<Boolean> accepted;
        private final CompletableFuture<Outcome> outcome;

        private UpdateHandle(String id, WorkflowExecution execution, CompletableFuture<Boolean> accepted, CompletableFuture<Outcome> outcome) {
            this.id = id;
            this.execution = execution;
            this.accepted = accepted;
            this.outcome = outcome;
        }

        public Future<Boolean> getAccepted() {
            return this.accepted;
        }

        public Future<Outcome> getOutcome() {
            return this.outcome;
        }

        public Outcome getOutcomeNow() {
            try {
                return this.outcome.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        public UpdateWorkflowExecutionLifecycleStage waitForStage(UpdateWorkflowExecutionLifecycleStage stage, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            switch (stage) {
                case UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_ADMITTED: {
                    break;
                }
                case UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_ACCEPTED: {
                    this.accepted.get(timeout, unit);
                    break;
                }
                case UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED: {
                    this.outcome.get(timeout, unit);
                }
            }
            return this.getStage();
        }

        public UpdateWorkflowExecutionLifecycleStage getStage() {
            if (!this.accepted.isDone()) {
                return UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_ADMITTED;
            }
            if (!this.outcome.isDone()) {
                return UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_ACCEPTED;
            }
            return UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED;
        }

        public String getId() {
            return this.id;
        }

        public UpdateRef getRef() {
            return UpdateRef.newBuilder().setUpdateId(this.id).setWorkflowExecution(this.execution).build();
        }
    }

    static class UpdateWorkflowExecution {
        private final String id;
        private final UpdateWorkflowExecutionRequest request;
        private final CompletableFuture<Boolean> accepted = new CompletableFuture();
        private final CompletableFuture<Outcome> outcome = new CompletableFuture();

        private UpdateWorkflowExecution(UpdateWorkflowExecutionRequest request) {
            this.request = request;
            String updateId = request.getRequest().getMeta().getUpdateId();
            this.id = updateId.isEmpty() ? UUID.randomUUID().toString() : updateId;
        }

        public UpdateWorkflowExecutionRequest getRequest() {
            return this.request;
        }

        public CompletableFuture<Boolean> getAccepted() {
            return this.accepted;
        }

        public CompletableFuture<Outcome> getOutcome() {
            return this.outcome;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "UpdateWorkflowExecution{id='" + this.id + '\'' + ", request=" + this.request + ", accepted=" + this.accepted + ", outcome=" + this.outcome + '}';
        }
    }

    static class ConsistentQuery {
        private final String key = UUID.randomUUID().toString();
        private final QueryWorkflowRequest request;
        private final CompletableFuture<QueryWorkflowResponse> result = new CompletableFuture();

        private ConsistentQuery(QueryWorkflowRequest request) {
            this.request = request;
        }

        public QueryWorkflowRequest getRequest() {
            return this.request;
        }

        public CompletableFuture<QueryWorkflowResponse> getResult() {
            return this.result;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return "ConsistentQuery{key='" + this.key + '\'' + ", request=" + this.request + ", result=" + this.result + '}';
        }
    }

    static class CancelExternalWorkflowExecutionCallerInfo {
        private final String namespace;
        private final long externalInitiatedEventId;
        private final TestWorkflowMutableState caller;

        CancelExternalWorkflowExecutionCallerInfo(String namespace, long externalInitiatedEventId, TestWorkflowMutableState caller) {
            this.namespace = namespace;
            this.externalInitiatedEventId = externalInitiatedEventId;
            this.caller = caller;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public long getExternalInitiatedEventId() {
            return this.externalInitiatedEventId;
        }

        public TestWorkflowMutableState getCaller() {
            return this.caller;
        }
    }

    @FunctionalInterface
    private static interface UpdateProcedure {
        public void apply(RequestContext var1);
    }
}

