/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.NamespaceState;
import io.temporal.api.enums.v1.SignalExternalWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.UpdateWorkflowExecutionLifecycleStage;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.enums.v1.WorkflowIdConflictPolicy;
import io.temporal.api.enums.v1.WorkflowIdReusePolicy;
import io.temporal.api.errordetails.v1.MultiOperationExecutionFailure;
import io.temporal.api.errordetails.v1.WorkflowExecutionAlreadyStartedFailure;
import io.temporal.api.failure.v1.ApplicationFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.failure.v1.MultiOperationExecutionAborted;
import io.temporal.api.failure.v1.NexusHandlerFailureInfo;
import io.temporal.api.failure.v1.NexusOperationFailureInfo;
import io.temporal.api.failure.v1.TerminatedFailureInfo;
import io.temporal.api.failure.v1.TimeoutFailureInfo;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes;
import io.temporal.api.namespace.v1.NamespaceInfo;
import io.temporal.api.nexus.v1.Failure;
import io.temporal.api.nexus.v1.HandlerError;
import io.temporal.api.nexus.v1.Link;
import io.temporal.api.nexus.v1.StartOperationResponse;
import io.temporal.api.nexus.v1.UnsuccessfulOperationError;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.DescribeNamespaceRequest;
import io.temporal.api.workflowservice.v1.DescribeNamespaceResponse;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.ExecuteMultiOperationRequest;
import io.temporal.api.workflowservice.v1.ExecuteMultiOperationResponse;
import io.temporal.api.workflowservice.v1.GetSystemInfoRequest;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.ListClosedWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListClosedWorkflowExecutionsResponse;
import io.temporal.api.workflowservice.v1.ListOpenWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListOpenWorkflowExecutionsResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedResponse;
import io.temporal.api.workflowservice.v1.RespondNexusTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondNexusTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondNexusTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondNexusTaskFailedResponse;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedResponse;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.UpdateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.UpdateWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtoUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.testservice.ActivityTaskToken;
import io.temporal.internal.testservice.CronUtils;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.GRPCServerHelper;
import io.temporal.internal.testservice.InProcessGRPCServer;
import io.temporal.internal.testservice.NexusOperationRef;
import io.temporal.internal.testservice.NexusTaskToken;
import io.temporal.internal.testservice.QueryId;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.internal.testservice.SelfAdvancingTimerImpl;
import io.temporal.internal.testservice.TestNexusEndpointStore;
import io.temporal.internal.testservice.TestNexusEndpointStoreImpl;
import io.temporal.internal.testservice.TestServiceRetryState;
import io.temporal.internal.testservice.TestVisibilityStore;
import io.temporal.internal.testservice.TestVisibilityStoreImpl;
import io.temporal.internal.testservice.TestWorkflowMutableState;
import io.temporal.internal.testservice.TestWorkflowMutableStateImpl;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.internal.testservice.TestWorkflowStoreImpl;
import io.temporal.internal.testservice.WorkflowId;
import io.temporal.internal.testservice.WorkflowTaskToken;
import io.temporal.serviceclient.StatusUtils;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestWorkflowService
extends WorkflowServiceGrpc.WorkflowServiceImplBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowService.class);
    private static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer();
    private static final JsonFormat.Parser JSON_PARSER = JsonFormat.parser();
    private static final String FAILURE_TYPE_STRING = io.temporal.api.failure.v1.Failure.getDescriptor().getFullName();
    private final Map<ExecutionId, TestWorkflowMutableState> executions = new HashMap<ExecutionId, TestWorkflowMutableState>();
    private final Map<WorkflowId, TestWorkflowMutableState> executionsByWorkflowId = new HashMap<WorkflowId, TestWorkflowMutableState>();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Lock lock = new ReentrantLock();
    private final TestWorkflowStore store;
    private final TestVisibilityStore visibilityStore;
    private final TestNexusEndpointStore nexusEndpointStore;
    private final SelfAdvancingTimer selfAdvancingTimer;
    private final ScheduledExecutorService backgroundScheduler = Executors.newSingleThreadScheduledExecutor();
    private final Server outOfProcessServer;
    private final InProcessGRPCServer inProcessServer;
    private final WorkflowServiceStubs workflowServiceStubs;
    private final MultiOperationExecutionFailure.OperationStatus abortedOperation = MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(Status.ABORTED.getCode().value()).setMessage("Operation was aborted.").addDetails(ProtoUtils.packAny((Message)MultiOperationExecutionAborted.newBuilder().build(), (Descriptors.Descriptor)MultiOperationExecutionAborted.getDescriptor())).build();

    TestWorkflowService(TestWorkflowStore store, TestVisibilityStore visibilityStore, TestNexusEndpointStore nexusEndpointStore, SelfAdvancingTimer selfAdvancingTimer) {
        this.store = store;
        this.visibilityStore = visibilityStore;
        this.nexusEndpointStore = nexusEndpointStore;
        this.selfAdvancingTimer = selfAdvancingTimer;
        this.outOfProcessServer = null;
        this.inProcessServer = null;
        this.workflowServiceStubs = null;
    }

    @Override
    public void close() {
        log.debug("Shutting down TestWorkflowService");
        log.debug("Shutting down background scheduler");
        this.backgroundScheduler.shutdown();
        if (this.outOfProcessServer != null) {
            log.info("Shutting down out-of-process GRPC server");
            this.outOfProcessServer.shutdown();
        }
        if (this.workflowServiceStubs != null) {
            this.workflowServiceStubs.shutdown();
        }
        if (this.inProcessServer != null) {
            log.info("Shutting down in-process GRPC server");
            this.inProcessServer.shutdown();
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            if (this.outOfProcessServer != null) {
                this.outOfProcessServer.awaitTermination(1L, TimeUnit.SECONDS);
            }
            if (this.workflowServiceStubs != null) {
                this.workflowServiceStubs.awaitTermination(1L, TimeUnit.SECONDS);
            }
            if (this.inProcessServer != null) {
                this.inProcessServer.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("shutdown interrupted", (Throwable)e);
        }
        this.store.close();
    }

    private TestWorkflowMutableState getMutableState(ExecutionId executionId) {
        return this.getMutableState(executionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestWorkflowMutableState getMutableState(ExecutionId executionId, boolean failNotExists) {
        this.lock.lock();
        try {
            if (executionId.getExecution().getRunId().isEmpty()) {
                TestWorkflowMutableState testWorkflowMutableState = this.getMutableState(executionId.getWorkflowId(), failNotExists);
                return testWorkflowMutableState;
            }
            TestWorkflowMutableState mutableState = this.executions.get(executionId);
            if (mutableState == null && failNotExists) {
                throw Status.NOT_FOUND.withDescription("Execution \"" + executionId + "\" not found in mutable state. Known executions: " + this.executions.values() + ", service=" + this).asRuntimeException();
            }
            TestWorkflowMutableState testWorkflowMutableState = mutableState;
            return testWorkflowMutableState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestWorkflowMutableState getMutableState(WorkflowId workflowId, boolean failNotExists) {
        this.lock.lock();
        try {
            TestWorkflowMutableState mutableState = this.executionsByWorkflowId.get(workflowId);
            if (mutableState == null && failNotExists) {
                throw Status.NOT_FOUND.withDescription("Execution not found in mutable state: " + workflowId).asRuntimeException();
            }
            TestWorkflowMutableState testWorkflowMutableState = mutableState;
            return testWorkflowMutableState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void startWorkflowExecution(StartWorkflowExecutionRequest request, StreamObserver<StartWorkflowExecutionResponse> responseObserver) {
        try {
            java.time.Duration backoffInterval = CronUtils.getBackoffInterval(request.getCronSchedule(), this.store.currentTime());
            StartWorkflowExecutionResponse response = this.startWorkflowExecutionImpl(request, backoffInterval, Optional.empty(), OptionalLong.empty(), null);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StartWorkflowExecutionResponse startWorkflowExecutionImpl(StartWorkflowExecutionRequest startRequest, java.time.Duration backoffStartInterval, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, @Nullable Consumer<TestWorkflowMutableState> withStart) {
        String requestWorkflowId = this.requireNotNull("WorkflowId", startRequest.getWorkflowId());
        String namespace = this.requireNotNull("Namespace", startRequest.getNamespace());
        WorkflowId workflowId = new WorkflowId(namespace, requestWorkflowId);
        WorkflowIdReusePolicy reusePolicy = startRequest.getWorkflowIdReusePolicy();
        WorkflowIdConflictPolicy conflictPolicy = startRequest.getWorkflowIdConflictPolicy();
        if (conflictPolicy != WorkflowIdConflictPolicy.WORKFLOW_ID_CONFLICT_POLICY_UNSPECIFIED && reusePolicy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_TERMINATE_IF_RUNNING) {
            throw TestWorkflowService.createInvalidArgument("Invalid WorkflowIDReusePolicy: WORKFLOW_ID_REUSE_POLICY_TERMINATE_IF_RUNNING cannot be used together with a WorkflowIDConflictPolicy.");
        }
        this.lock.lock();
        try {
            Optional<Object> retryState;
            String newRunId = UUID.randomUUID().toString();
            TestWorkflowMutableState existing = this.executionsByWorkflowId.get(workflowId);
            if (existing != null) {
                WorkflowExecutionStatus status = existing.getWorkflowExecutionStatus();
                if (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING && (reusePolicy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_TERMINATE_IF_RUNNING || conflictPolicy == WorkflowIdConflictPolicy.WORKFLOW_ID_CONFLICT_POLICY_TERMINATE_EXISTING)) {
                    existing.terminateWorkflowExecution(TerminateWorkflowExecutionRequest.newBuilder().setNamespace(startRequest.getNamespace()).setWorkflowExecution(existing.getExecutionId().getExecution()).setReason("TerminateIfRunning WorkflowIdReusePolicy Policy").setIdentity("history-service").setDetails(Payloads.newBuilder().addPayloads(Payload.newBuilder().setData(ByteString.copyFromUtf8((String)String.format("terminated by new runID: %s", newRunId))).build()).build()).build());
                } else {
                    if (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING && conflictPolicy == WorkflowIdConflictPolicy.WORKFLOW_ID_CONFLICT_POLICY_USE_EXISTING) {
                        StartWorkflowExecutionResponse startWorkflowExecutionResponse = StartWorkflowExecutionResponse.newBuilder().setStarted(false).setRunId(existing.getExecutionId().getExecution().getRunId()).build();
                        return startWorkflowExecutionResponse;
                    }
                    if (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING || reusePolicy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_REJECT_DUPLICATE) {
                        StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.throwDuplicatedWorkflow(startRequest, existing);
                        return startWorkflowExecutionResponse;
                    }
                    if (reusePolicy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE_FAILED_ONLY && (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_COMPLETED || status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_CONTINUED_AS_NEW)) {
                        StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.throwDuplicatedWorkflow(startRequest, existing);
                        return startWorkflowExecutionResponse;
                    }
                }
            }
            Optional<io.temporal.api.failure.v1.Failure> lastFailure = Optional.empty();
            if (startRequest.hasRetryPolicy()) {
                java.time.Duration expirationInterval = ProtobufTimeUtils.toJavaDuration((Duration)startRequest.getWorkflowExecutionTimeout());
                retryState = this.newRetryStateLocked(startRequest.getRetryPolicy(), expirationInterval);
                if (retryState.isPresent()) {
                    lastFailure = ((TestServiceRetryState)retryState.get()).getPreviousRunFailure();
                }
            } else {
                retryState = Optional.empty();
            }
            StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.startWorkflowExecutionNoRunningCheckLocked(startRequest, newRunId, newRunId, Optional.empty(), retryState, backoffStartInterval, null, lastFailure, parent, parentChildInitiatedEventId, withStart, workflowId);
            return startWorkflowExecutionResponse;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Optional<TestServiceRetryState> newRetryStateLocked(RetryPolicy retryPolicy, java.time.Duration expirationInterval) {
        Timestamp expirationTime = expirationInterval.isZero() ? Timestamps.fromNanos((long)0L) : Timestamps.add((Timestamp)this.store.currentTime(), (Duration)ProtobufTimeUtils.toProtoDuration((java.time.Duration)expirationInterval));
        return Optional.of(new TestServiceRetryState(retryPolicy, expirationTime));
    }

    private StartWorkflowExecutionResponse throwDuplicatedWorkflow(StartWorkflowExecutionRequest startRequest, TestWorkflowMutableState existing) {
        WorkflowExecution execution = existing.getExecutionId().getExecution();
        WorkflowExecutionAlreadyStartedFailure error = WorkflowExecutionAlreadyStartedFailure.newBuilder().setRunId(execution.getRunId()).setStartRequestId(startRequest.getRequestId()).build();
        throw StatusUtils.newException((Status)Status.ALREADY_EXISTS.withDescription(String.format("WorkflowId: %s, RunId: %s", execution.getWorkflowId(), execution.getRunId())), (Message)error, (Descriptors.Descriptor)WorkflowExecutionAlreadyStartedFailure.getDescriptor());
    }

    private StartWorkflowExecutionResponse startWorkflowExecutionNoRunningCheckLocked(StartWorkflowExecutionRequest startRequest, @Nonnull String runId, @Nonnull String firstExecutionRunId, Optional<String> continuedExecutionRunId, Optional<TestServiceRetryState> retryState, java.time.Duration backoffStartInterval, Payloads lastCompletionResult, Optional<io.temporal.api.failure.v1.Failure> lastFailure, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, @Nullable Consumer<TestWorkflowMutableState> withStart, WorkflowId workflowId) {
        String namespace = startRequest.getNamespace();
        TestWorkflowMutableStateImpl mutableState = new TestWorkflowMutableStateImpl(startRequest, firstExecutionRunId, runId, retryState, backoffStartInterval, lastCompletionResult, lastFailure, parent, parentChildInitiatedEventId, continuedExecutionRunId, this, this.store, this.visibilityStore, this.nexusEndpointStore, this.selfAdvancingTimer);
        WorkflowExecution execution = mutableState.getExecutionId().getExecution();
        ExecutionId executionId = new ExecutionId(namespace, execution);
        this.executionsByWorkflowId.put(workflowId, mutableState);
        this.executions.put(executionId, mutableState);
        PollWorkflowTaskQueueRequest eagerWorkflowTaskPollRequest = startRequest.getRequestEagerExecution() ? PollWorkflowTaskQueueRequest.newBuilder().setIdentity(startRequest.getIdentity()).setNamespace(startRequest.getNamespace()).setTaskQueue(startRequest.getTaskQueue()).build() : null;
        PollWorkflowTaskQueueResponse eagerWorkflowTask = mutableState.startWorkflow(continuedExecutionRunId.isPresent(), eagerWorkflowTaskPollRequest, withStart);
        StartWorkflowExecutionResponse.Builder response = StartWorkflowExecutionResponse.newBuilder().setRunId(execution.getRunId()).setStarted(true);
        if (eagerWorkflowTask != null) {
            response.setEagerWorkflowTask(eagerWorkflowTask);
        }
        return response.build();
    }

    public void getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, StreamObserver<GetWorkflowExecutionHistoryResponse> responseObserver) {
        ExecutionId executionId = new ExecutionId(getRequest.getNamespace(), getRequest.getExecution());
        this.executor.execute(Context.current().wrap(() -> {
            try {
                TestWorkflowMutableState mutableState = this.getMutableState(executionId);
                responseObserver.onNext((Object)this.store.getWorkflowExecutionHistory(mutableState.getExecutionId(), getRequest, Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS)));
                responseObserver.onCompleted();
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                    log.error("unexpected", (Throwable)e);
                }
                responseObserver.onError((Throwable)e);
            }
            catch (Exception e) {
                log.error("unexpected", (Throwable)e);
                responseObserver.onError((Throwable)e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T pollTaskQueue(Context ctx, Future<T> futureValue) throws ExecutionException, InterruptedException {
        Context.CancellationListener canceler = context -> futureValue.cancel(true);
        ctx.addListener(canceler, (Executor)this.backgroundScheduler);
        try {
            T t = futureValue.get();
            return t;
        }
        finally {
            ctx.removeListener(canceler);
        }
    }

    /*
     * Exception decompiling
     */
    public void pollWorkflowTaskQueue(PollWorkflowTaskQueueRequest pollRequest, StreamObserver<PollWorkflowTaskQueueResponse> responseObserver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void respondWorkflowTaskCompleted(RespondWorkflowTaskCompletedRequest request, StreamObserver<RespondWorkflowTaskCompletedResponse> responseObserver) {
        try {
            WorkflowTaskToken taskToken = WorkflowTaskToken.fromBytes(request.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(taskToken.getExecutionId());
            mutableState.completeWorkflowTask(taskToken.getHistorySize(), request);
            responseObserver.onNext((Object)RespondWorkflowTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
        catch (Throwable e) {
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(Throwables.getStackTraceAsString((Throwable)e)).withCause(e).asRuntimeException());
        }
    }

    public void respondWorkflowTaskFailed(RespondWorkflowTaskFailedRequest failedRequest, StreamObserver<RespondWorkflowTaskFailedResponse> responseObserver) {
        try {
            WorkflowTaskToken taskToken = WorkflowTaskToken.fromBytes(failedRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(taskToken.getExecutionId());
            mutableState.failWorkflowTask(failedRequest);
            responseObserver.onNext((Object)RespondWorkflowTaskFailedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void getSystemInfo(GetSystemInfoRequest request, StreamObserver<GetSystemInfoResponse> responseObserver) {
        responseObserver.onNext((Object)GetSystemInfoResponse.newBuilder().setCapabilities(GetSystemInfoResponse.Capabilities.newBuilder().setSdkMetadata(true).setSignalAndQueryHeader(true).setEncodedFailureAttributes(true).setEagerWorkflowStart(true).setUpsertMemo(true).setNexus(true).build()).build());
        responseObserver.onCompleted();
    }

    private Context.CancellableContext deadlineCtx(Deadline deadline) {
        return Context.current().withDeadline(deadline, this.backgroundScheduler);
    }

    /*
     * Exception decompiling
     */
    public void pollActivityTaskQueue(PollActivityTaskQueueRequest pollRequest, StreamObserver<PollActivityTaskQueueResponse> responseObserver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest, StreamObserver<RecordActivityTaskHeartbeatResponse> responseObserver) {
        try {
            ActivityTaskToken activityTaskToken = ActivityTaskToken.fromBytes(heartbeatRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityTaskToken.getExecutionId());
            boolean cancelRequested = mutableState.heartbeatActivityTask(activityTaskToken.getScheduledEventId(), heartbeatRequest.getDetails());
            responseObserver.onNext((Object)RecordActivityTaskHeartbeatResponse.newBuilder().setCancelRequested(cancelRequested).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void recordActivityTaskHeartbeatById(RecordActivityTaskHeartbeatByIdRequest heartbeatRequest, StreamObserver<RecordActivityTaskHeartbeatByIdResponse> responseObserver) {
        try {
            ExecutionId execution = new ExecutionId(heartbeatRequest.getNamespace(), heartbeatRequest.getWorkflowId(), heartbeatRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(execution);
            boolean cancelRequested = mutableState.heartbeatActivityTaskById(heartbeatRequest.getActivityId(), heartbeatRequest.getDetails(), heartbeatRequest.getIdentity());
            responseObserver.onNext((Object)RecordActivityTaskHeartbeatByIdResponse.newBuilder().setCancelRequested(cancelRequested).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest, StreamObserver<RespondActivityTaskCompletedResponse> responseObserver) {
        try {
            ActivityTaskToken activityTaskToken = ActivityTaskToken.fromBytes(completeRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityTaskToken.getExecutionId());
            mutableState.completeActivityTask(activityTaskToken.getScheduledEventId(), completeRequest);
            responseObserver.onNext((Object)RespondActivityTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCompletedById(RespondActivityTaskCompletedByIdRequest completeRequest, StreamObserver<RespondActivityTaskCompletedByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(completeRequest.getNamespace(), completeRequest.getWorkflowId(), completeRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.completeActivityTaskById(completeRequest.getActivityId(), completeRequest);
            responseObserver.onNext((Object)RespondActivityTaskCompletedByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest, StreamObserver<RespondActivityTaskFailedResponse> responseObserver) {
        try {
            ActivityTaskToken activityTaskToken = ActivityTaskToken.fromBytes(failRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityTaskToken.getExecutionId());
            mutableState.failActivityTask(activityTaskToken.getScheduledEventId(), failRequest);
            responseObserver.onNext((Object)RespondActivityTaskFailedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskFailedById(RespondActivityTaskFailedByIdRequest failRequest, StreamObserver<RespondActivityTaskFailedByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(failRequest.getNamespace(), failRequest.getWorkflowId(), failRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.failActivityTaskById(failRequest.getActivityId(), failRequest);
            responseObserver.onNext((Object)RespondActivityTaskFailedByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest, StreamObserver<RespondActivityTaskCanceledResponse> responseObserver) {
        try {
            ActivityTaskToken activityTaskToken = ActivityTaskToken.fromBytes(canceledRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityTaskToken.getExecutionId());
            mutableState.cancelActivityTask(activityTaskToken.getScheduledEventId(), canceledRequest);
            responseObserver.onNext((Object)RespondActivityTaskCanceledResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondActivityTaskCanceledById(RespondActivityTaskCanceledByIdRequest canceledRequest, StreamObserver<RespondActivityTaskCanceledByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(canceledRequest.getNamespace(), canceledRequest.getWorkflowId(), canceledRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.cancelActivityTaskById(canceledRequest.getActivityId(), canceledRequest);
            responseObserver.onNext((Object)RespondActivityTaskCanceledByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    /*
     * Exception decompiling
     */
    public void pollNexusTaskQueue(PollNexusTaskQueueRequest request, StreamObserver<PollNexusTaskQueueResponse> responseObserver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static io.temporal.api.failure.v1.Failure wrapNexusOperationFailure(io.temporal.api.failure.v1.Failure cause) {
        return io.temporal.api.failure.v1.Failure.newBuilder().setMessage("nexus operation completed unsuccessfully").setNexusOperationExecutionFailureInfo(NexusOperationFailureInfo.newBuilder().build()).setCause(cause).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void respondNexusTaskCompleted(RespondNexusTaskCompletedRequest request, StreamObserver<RespondNexusTaskCompletedResponse> responseObserver) {
        try {
            NexusTaskToken tt = NexusTaskToken.fromBytes(request.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(tt.getOperationRef().getExecutionId());
            if (!mutableState.validateOperationTaskToken(tt)) {
                responseObserver.onNext((Object)RespondNexusTaskCompletedResponse.getDefaultInstance());
                responseObserver.onCompleted();
                return;
            }
            if (request.getResponse().hasCancelOperation()) {
                io.temporal.api.failure.v1.Failure canceled = io.temporal.api.failure.v1.Failure.newBuilder().setMessage("operation canceled").setCanceledFailureInfo(CanceledFailureInfo.getDefaultInstance()).build();
                mutableState.cancelNexusOperationRequestAcknowledge(tt.getOperationRef());
            } else {
                if (!request.getResponse().hasStartOperation()) throw Status.INVALID_ARGUMENT.withDescription("Expected StartOperation or CancelOperation to be set on request.").asRuntimeException();
                StartOperationResponse startResp = request.getResponse().getStartOperation();
                if (startResp.hasOperationError()) {
                    UnsuccessfulOperationError opError = startResp.getOperationError();
                    Failure.Builder b = io.temporal.api.failure.v1.Failure.newBuilder().setMessage(opError.getFailure().getMessage());
                    if (startResp.getOperationError().getOperationState().equals("canceled")) {
                        b.setCanceledFailureInfo(CanceledFailureInfo.newBuilder().setDetails(TestWorkflowService.nexusFailureMetadataToPayloads(opError.getFailure())));
                        mutableState.cancelNexusOperation(tt.getOperationRef(), b.build());
                    } else {
                        mutableState.failNexusOperation(tt.getOperationRef(), TestWorkflowService.wrapNexusOperationFailure(TestWorkflowService.nexusFailureToAPIFailure(opError.getFailure(), false)));
                    }
                } else if (startResp.hasAsyncSuccess()) {
                    mutableState.startNexusOperation(tt.getOperationRef().getScheduledEventId(), request.getIdentity(), startResp.getAsyncSuccess());
                } else {
                    if (!startResp.hasSyncSuccess()) throw Status.INVALID_ARGUMENT.withDescription("Expected success or OperationError to be set on request.").asRuntimeException();
                    mutableState.completeNexusOperation(tt.getOperationRef(), startResp.getSyncSuccess().getPayload());
                }
            }
            responseObserver.onNext((Object)RespondNexusTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
            return;
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondNexusTaskFailed(RespondNexusTaskFailedRequest request, StreamObserver<RespondNexusTaskFailedResponse> responseObserver) {
        try {
            if (!request.hasError()) {
                throw Status.INVALID_ARGUMENT.withDescription("Nexus handler error not set on RespondNexusTaskFailedRequest").asRuntimeException();
            }
            NexusTaskToken tt = NexusTaskToken.fromBytes(request.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(tt.getOperationRef().getExecutionId());
            if (mutableState.validateOperationTaskToken(tt)) {
                io.temporal.api.failure.v1.Failure failure = TestWorkflowService.handlerErrorToFailure(request.getError());
                mutableState.failNexusOperation(tt.getOperationRef(), failure);
            }
            responseObserver.onNext((Object)RespondNexusTaskFailedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void completeNexusOperation(NexusOperationRef ref, String operationID, Link startLink, HistoryEvent completionEvent) {
        TestWorkflowMutableState target = this.getMutableState(ref.getExecutionId());
        switch (completionEvent.getEventType()) {
            case EVENT_TYPE_WORKFLOW_EXECUTION_COMPLETED: {
                Payloads result = completionEvent.getWorkflowExecutionCompletedEventAttributes().getResult();
                Payload p = result.getPayloadsCount() > 0 ? result.getPayloads(0) : Payload.getDefaultInstance();
                target.completeAsyncNexusOperation(ref, p, operationID, startLink);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_FAILED: {
                io.temporal.api.failure.v1.Failure wfFailure = completionEvent.getWorkflowExecutionFailedEventAttributes().getFailure();
                target.failNexusOperation(ref, TestWorkflowService.wrapNexusOperationFailure(wfFailure));
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCELED: {
                CanceledFailureInfo.Builder cancelFailure = CanceledFailureInfo.newBuilder();
                if (completionEvent.getWorkflowExecutionCanceledEventAttributes().hasDetails()) {
                    cancelFailure.setDetails(completionEvent.getWorkflowExecutionCanceledEventAttributes().getDetails());
                }
                io.temporal.api.failure.v1.Failure canceled = io.temporal.api.failure.v1.Failure.newBuilder().setMessage("operation canceled").setCanceledFailureInfo(cancelFailure.build()).build();
                target.cancelNexusOperation(ref, canceled);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_TERMINATED: {
                target.failNexusOperation(ref, TestWorkflowService.wrapNexusOperationFailure(io.temporal.api.failure.v1.Failure.newBuilder().setMessage("operation terminated").setTerminatedFailureInfo(TerminatedFailureInfo.getDefaultInstance()).build()));
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_TIMED_OUT: {
                target.failNexusOperation(ref, TestWorkflowService.wrapNexusOperationFailure(io.temporal.api.failure.v1.Failure.newBuilder().setMessage("operation exceeded internal timeout").setTimeoutFailureInfo(TimeoutFailureInfo.newBuilder().build()).build()));
                break;
            }
            default: {
                throw Status.INTERNAL.withDescription("invalid workflow execution status: " + completionEvent.getEventType()).asRuntimeException();
            }
        }
    }

    private static io.temporal.api.failure.v1.Failure handlerErrorToFailure(HandlerError err) {
        return io.temporal.api.failure.v1.Failure.newBuilder().setMessage(err.getFailure().getMessage()).setNexusHandlerFailureInfo(NexusHandlerFailureInfo.newBuilder().setType(err.getErrorType()).build()).setCause(TestWorkflowService.nexusFailureToAPIFailure(err.getFailure(), false)).build();
    }

    private static io.temporal.api.failure.v1.Failure nexusFailureToAPIFailure(Failure failure, boolean retryable) {
        Failure.Builder apiFailure = io.temporal.api.failure.v1.Failure.newBuilder();
        if (failure.getMetadataMap().containsKey("type") && ((String)failure.getMetadataMap().get("type")).equals(FAILURE_TYPE_STRING)) {
            try {
                JSON_PARSER.merge(failure.getDetails().toString(StandardCharsets.UTF_8), (Message.Builder)apiFailure);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        } else {
            Payloads payloads = TestWorkflowService.nexusFailureMetadataToPayloads(failure);
            ApplicationFailureInfo.Builder applicationFailureInfo = ApplicationFailureInfo.newBuilder();
            applicationFailureInfo.setType("NexusFailure");
            applicationFailureInfo.setDetails(payloads);
            applicationFailureInfo.setNonRetryable(!retryable);
            apiFailure.setApplicationFailureInfo(applicationFailureInfo.build());
        }
        apiFailure.setMessage(failure.getMessage());
        return apiFailure.build();
    }

    private static Payloads nexusFailureMetadataToPayloads(Failure failure) {
        Map<String, ByteString> metadata = failure.getMetadataMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ByteString.copyFromUtf8((String)((String)e.getValue()))));
        return Payloads.newBuilder().addPayloads(Payload.newBuilder().putAllMetadata(metadata).setData(failure.getDetails())).build();
    }

    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, StreamObserver<RequestCancelWorkflowExecutionResponse> responseObserver) {
        try {
            this.requestCancelWorkflowExecution(cancelRequest, Optional.empty());
            responseObserver.onNext((Object)RequestCancelWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, Optional<TestWorkflowMutableStateImpl.CancelExternalWorkflowExecutionCallerInfo> callerInfo) {
        ExecutionId executionId = new ExecutionId(cancelRequest.getNamespace(), cancelRequest.getWorkflowExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        mutableState.requestCancelWorkflowExecution(cancelRequest, callerInfo);
    }

    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request, StreamObserver<TerminateWorkflowExecutionResponse> responseObserver) {
        try {
            this.terminateWorkflowExecution(request);
            responseObserver.onNext((Object)TerminateWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request) {
        ExecutionId executionId = new ExecutionId(request.getNamespace(), request.getWorkflowExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        mutableState.terminateWorkflowExecution(request);
    }

    public void signalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest, StreamObserver<SignalWorkflowExecutionResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(signalRequest.getNamespace(), signalRequest.getWorkflowExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.signal(signalRequest);
            responseObserver.onNext((Object)SignalWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkflowExecution(UpdateWorkflowExecutionRequest request, StreamObserver<UpdateWorkflowExecutionResponse> responseObserver) {
        try (Context.CancellableContext ctx = this.deadlineCtx(this.getUpdatePollDeadline());){
            Context toRestore = ctx.attach();
            try {
                ExecutionId executionId = new ExecutionId(request.getNamespace(), request.getWorkflowExecution());
                TestWorkflowMutableState mutableState = this.getMutableState(executionId);
                Deadline deadline = Context.current().getDeadline();
                TestWorkflowMutableStateImpl.UpdateHandle updateHandle = mutableState.updateWorkflowExecution(request, deadline);
                UpdateWorkflowExecutionResponse response = this.waitForUpdateResponse(request, deadline, updateHandle);
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
            }
            catch (StatusRuntimeException e) {
                this.handleStatusRuntimeException(e, responseObserver);
            }
            finally {
                ctx.detach(toRestore);
            }
        }
    }

    UpdateWorkflowExecutionResponse waitForUpdateResponse(UpdateWorkflowExecutionRequest request, Deadline deadline, TestWorkflowMutableStateImpl.UpdateHandle updateHandle) {
        try {
            UpdateWorkflowExecutionLifecycleStage reachedStage = updateHandle.waitForStage(request.getWaitPolicy().getLifecycleStage(), deadline.timeRemaining(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            UpdateWorkflowExecutionResponse.Builder response = UpdateWorkflowExecutionResponse.newBuilder().setUpdateRef(updateHandle.getRef()).setStage(reachedStage);
            if (reachedStage == UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED) {
                response.setOutcome(updateHandle.getOutcomeNow());
            }
            return response.build();
        }
        catch (TimeoutException e) {
            UpdateWorkflowExecutionLifecycleStage stage = updateHandle.getStage();
            UpdateWorkflowExecutionResponse.Builder response = UpdateWorkflowExecutionResponse.newBuilder().setUpdateRef(updateHandle.getRef()).setStage(stage);
            if (stage == UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED) {
                response.setOutcome(updateHandle.getOutcomeNow());
            }
            return response.build();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StatusRuntimeException) {
                throw (StatusRuntimeException)cause;
            }
            throw Status.INTERNAL.withCause(cause).withDescription(cause.getMessage()).asRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollWorkflowExecutionUpdate(PollWorkflowExecutionUpdateRequest request, StreamObserver<PollWorkflowExecutionUpdateResponse> responseObserver) {
        try (Context.CancellableContext ctx = this.deadlineCtx(this.getUpdatePollDeadline());){
            Context toRestore = ctx.attach();
            try {
                ExecutionId executionId = new ExecutionId(request.getNamespace(), request.getUpdateRef().getWorkflowExecution());
                TestWorkflowMutableState mutableState = this.getMutableState(executionId);
                Deadline deadline = Context.current().getDeadline();
                PollWorkflowExecutionUpdateResponse response = mutableState.pollUpdateWorkflowExecution(request, deadline);
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
            }
            catch (StatusRuntimeException e) {
                this.handleStatusRuntimeException(e, responseObserver);
            }
            finally {
                ctx.detach(toRestore);
            }
        }
    }

    public void executeMultiOperation(ExecuteMultiOperationRequest request, StreamObserver<ExecuteMultiOperationResponse> responseObserver) {
        try {
            StartWorkflowExecutionResponse startResult;
            if (request.getOperationsCount() != 2) {
                throw Status.INVALID_ARGUMENT.withDescription("Operations have to be exactly [Start, Update].").asRuntimeException();
            }
            ExecuteMultiOperationRequest.Operation firstOperation = request.getOperations(0);
            if (firstOperation.getOperationCase() != ExecuteMultiOperationRequest.Operation.OperationCase.START_WORKFLOW) {
                throw Status.INVALID_ARGUMENT.withDescription("Operations have to be exactly [Start, Update].").asRuntimeException();
            }
            StartWorkflowExecutionRequest startRequest = firstOperation.getStartWorkflow();
            if (!startRequest.getCronSchedule().isEmpty()) {
                throw this.multiOperationExecutionFailure(MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(Status.INVALID_ARGUMENT.getCode().value()).setMessage("INVALID_ARGUMENT: CronSchedule is not allowed.").build(), this.abortedOperation);
            }
            if (startRequest.getRequestEagerExecution()) {
                throw this.multiOperationExecutionFailure(MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(Status.INVALID_ARGUMENT.getCode().value()).setMessage("INVALID_ARGUMENT: RequestEagerExecution is not supported.").build(), this.abortedOperation);
            }
            if (startRequest.hasWorkflowStartDelay()) {
                throw this.multiOperationExecutionFailure(MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(Status.INVALID_ARGUMENT.getCode().value()).setMessage("INVALID_ARGUMENT: WorkflowStartDelay is not supported.").build(), this.abortedOperation);
            }
            ExecuteMultiOperationRequest.Operation secondOperation = request.getOperations(1);
            if (secondOperation.getOperationCase() != ExecuteMultiOperationRequest.Operation.OperationCase.UPDATE_WORKFLOW) {
                throw Status.INVALID_ARGUMENT.withDescription("Operations have to be exactly [Start, Update].").asRuntimeException();
            }
            UpdateWorkflowExecutionRequest updateRequest = secondOperation.getUpdateWorkflow();
            if (!updateRequest.getWorkflowExecution().getRunId().isEmpty()) {
                throw this.multiOperationExecutionFailure(this.abortedOperation, MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(Status.INVALID_ARGUMENT.getCode().value()).setMessage("INVALID_ARGUMENT: RunId is not allowed.").build());
            }
            if (!updateRequest.getFirstExecutionRunId().isEmpty()) {
                throw this.multiOperationExecutionFailure(this.abortedOperation, MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(Status.INVALID_ARGUMENT.getCode().value()).setMessage("INVALID_ARGUMENT: FirstExecutionRunId is not allowed.").build());
            }
            if (!startRequest.getWorkflowId().equals(updateRequest.getWorkflowExecution().getWorkflowId())) {
                throw this.multiOperationExecutionFailure(this.abortedOperation, MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(Status.INVALID_ARGUMENT.getCode().value()).setMessage("INVALID_ARGUMENT: Update operation's WorkflowId is not consistent with Start operation's WorkflowId").build());
            }
            Deadline deadline = this.getUpdatePollDeadline();
            AtomicReference updateHandle = new AtomicReference();
            Consumer<TestWorkflowMutableState> applyUpdate = ms -> {
                try {
                    updateHandle.set(ms.updateWorkflowExecution(updateRequest, deadline));
                }
                catch (StatusRuntimeException e) {
                    throw this.multiOperationExecutionFailure(this.abortedOperation, MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(e.getStatus().getCode().value()).setMessage(e.getMessage()).build());
                }
            };
            try {
                startResult = this.startWorkflowExecutionImpl(startRequest, java.time.Duration.ZERO, Optional.empty(), OptionalLong.empty(), applyUpdate);
            }
            catch (StatusRuntimeException e) {
                if (StatusUtils.hasFailure((StatusRuntimeException)e, MultiOperationExecutionFailure.class)) {
                    throw e;
                }
                throw this.multiOperationExecutionFailure(MultiOperationExecutionFailure.OperationStatus.newBuilder().setCode(e.getStatus().getCode().value()).setMessage(e.getMessage()).build(), this.abortedOperation);
            }
            if (!startResult.getStarted()) {
                ExecutionId executionId = new ExecutionId(request.getNamespace(), updateRequest.getWorkflowExecution());
                TestWorkflowMutableState mutableState = this.getMutableState(executionId);
                applyUpdate.accept(mutableState);
            }
            UpdateWorkflowExecutionResponse updateResult = this.waitForUpdateResponse(updateRequest, deadline, (TestWorkflowMutableStateImpl.UpdateHandle)updateHandle.get());
            ExecuteMultiOperationResponse response = ExecuteMultiOperationResponse.newBuilder().addResponses(ExecuteMultiOperationResponse.Response.newBuilder().setStartWorkflow(startResult)).addResponses(ExecuteMultiOperationResponse.Response.newBuilder().setUpdateWorkflow(updateResult)).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private StatusRuntimeException multiOperationExecutionFailure(MultiOperationExecutionFailure.OperationStatus ... operationStatuses) {
        Status status = null;
        for (MultiOperationExecutionFailure.OperationStatus operationStatus : operationStatuses) {
            if (operationStatus == this.abortedOperation) continue;
            if (status != null) {
                throw new IllegalArgumentException("exactly one non-null operation status must be specified");
            }
            status = Status.fromCodeValue((int)operationStatus.getCode());
        }
        if (status == null) {
            throw new IllegalArgumentException("exactly one non-null operation status must be specified");
        }
        return StatusUtils.newException((Status)status.withDescription("MultiOperation could not be executed"), (Message)MultiOperationExecutionFailure.newBuilder().addAllStatuses(Arrays.asList(operationStatuses)).build(), (Descriptors.Descriptor)MultiOperationExecutionFailure.getDescriptor());
    }

    public void signalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest r, StreamObserver<SignalWithStartWorkflowExecutionResponse> responseObserver) {
        try {
            if (!r.hasTaskQueue()) {
                throw Status.INVALID_ARGUMENT.withDescription("request missing required taskQueue field").asRuntimeException();
            }
            if (!r.hasWorkflowType()) {
                throw Status.INVALID_ARGUMENT.withDescription("request missing required workflowType field").asRuntimeException();
            }
            ExecutionId executionId = new ExecutionId(r.getNamespace(), r.getWorkflowId(), null);
            TestWorkflowMutableState mutableState = this.getMutableState(executionId, false);
            SignalWorkflowExecutionRequest signalRequest = SignalWorkflowExecutionRequest.newBuilder().setInput(r.getSignalInput()).setSignalName(r.getSignalName()).setWorkflowExecution(executionId.getExecution()).setRequestId(r.getRequestId()).setControl(r.getControl()).setNamespace(r.getNamespace()).setIdentity(r.getIdentity()).addAllLinks((Iterable)r.getLinksList()).build();
            if (mutableState != null && !mutableState.isTerminalState()) {
                mutableState.signal(signalRequest);
                responseObserver.onNext((Object)SignalWithStartWorkflowExecutionResponse.newBuilder().setRunId(mutableState.getExecutionId().getExecution().getRunId()).build());
                responseObserver.onCompleted();
                return;
            }
            StartWorkflowExecutionRequest.Builder startRequest = StartWorkflowExecutionRequest.newBuilder().setRequestId(r.getRequestId()).setInput(r.getInput()).setWorkflowExecutionTimeout(r.getWorkflowExecutionTimeout()).setWorkflowRunTimeout(r.getWorkflowRunTimeout()).setWorkflowTaskTimeout(r.getWorkflowTaskTimeout()).setNamespace(r.getNamespace()).setTaskQueue(r.getTaskQueue()).setWorkflowId(r.getWorkflowId()).setWorkflowIdReusePolicy(r.getWorkflowIdReusePolicy()).setIdentity(r.getIdentity()).setWorkflowType(r.getWorkflowType()).setCronSchedule(r.getCronSchedule());
            if (r.hasRetryPolicy()) {
                startRequest.setRetryPolicy(r.getRetryPolicy());
            }
            if (r.hasHeader()) {
                startRequest.setHeader(r.getHeader());
            }
            if (r.hasMemo()) {
                startRequest.setMemo(r.getMemo());
            }
            if (r.hasSearchAttributes()) {
                startRequest.setSearchAttributes(r.getSearchAttributes());
            }
            if (r.hasWorkflowStartDelay()) {
                startRequest.setWorkflowStartDelay(r.getWorkflowStartDelay());
            }
            if (!r.getLinksList().isEmpty()) {
                startRequest.addAllLinks((Iterable)r.getLinksList());
            }
            StartWorkflowExecutionResponse startResult = this.startWorkflowExecutionImpl(startRequest.build(), java.time.Duration.ZERO, Optional.empty(), OptionalLong.empty(), ms -> ms.signal(signalRequest));
            responseObserver.onNext((Object)SignalWithStartWorkflowExecutionResponse.newBuilder().setRunId(startResult.getRunId()).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void signalExternalWorkflowExecution(String signalId, SignalExternalWorkflowExecutionCommandAttributes commandAttributes, TestWorkflowMutableState source) {
        String namespace = commandAttributes.getNamespace().isEmpty() ? source.getExecutionId().getNamespace() : commandAttributes.getNamespace();
        ExecutionId executionId = new ExecutionId(namespace, commandAttributes.getExecution());
        try {
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.signalFromWorkflow(commandAttributes);
            source.completeSignalExternalWorkflowExecution(signalId, mutableState.getExecutionId().getExecution().getRunId());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                source.failSignalExternalWorkflowExecution(signalId, SignalExternalWorkflowExecutionFailedCause.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_CAUSE_EXTERNAL_WORKFLOW_EXECUTION_NOT_FOUND);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String continueAsNew(StartWorkflowExecutionRequest previousRunStartRequest, ContinueAsNewWorkflowExecutionCommandAttributes ca, WorkflowExecutionContinuedAsNewEventAttributes ea, Optional<TestServiceRetryState> retryState, String identity, ExecutionId continuedExecutionId, String firstExecutionRunId, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId) {
        StartWorkflowExecutionRequest.Builder startRequestBuilder = StartWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setWorkflowType(ea.getWorkflowType()).setWorkflowRunTimeout(ea.getWorkflowRunTimeout()).setWorkflowTaskTimeout(ea.getWorkflowTaskTimeout()).setNamespace(continuedExecutionId.getNamespace()).setTaskQueue(ea.getTaskQueue()).setWorkflowId(continuedExecutionId.getWorkflowId().getWorkflowId()).setWorkflowIdReusePolicy(previousRunStartRequest.getWorkflowIdReusePolicy()).setIdentity(identity).setCronSchedule(previousRunStartRequest.getCronSchedule());
        if (previousRunStartRequest.getCompletionCallbacksCount() > 0) {
            startRequestBuilder.addAllCompletionCallbacks((Iterable)previousRunStartRequest.getCompletionCallbacksList());
        }
        if (ca.hasRetryPolicy()) {
            startRequestBuilder.setRetryPolicy(ca.getRetryPolicy());
        }
        if (ea.hasInput()) {
            startRequestBuilder.setInput(ea.getInput());
        }
        if (ea.hasHeader()) {
            startRequestBuilder.setHeader(ea.getHeader());
        }
        StartWorkflowExecutionRequest startRequest = startRequestBuilder.build();
        this.lock.lock();
        Optional<Object> lastFail = ea.hasFailure() ? Optional.of(ea.getFailure()) : retryState.flatMap(TestServiceRetryState::getPreviousRunFailure);
        try {
            StartWorkflowExecutionResponse response = this.startWorkflowExecutionNoRunningCheckLocked(startRequest, ea.getNewExecutionRunId(), firstExecutionRunId, Optional.of(continuedExecutionId.getExecution().getRunId()), retryState, ProtobufTimeUtils.toJavaDuration((Duration)ea.getBackoffStartInterval()), ea.getLastCompletionResult(), lastFail, parent, parentChildInitiatedEventId, null, continuedExecutionId.getWorkflowId());
            String string = response.getRunId();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest, StreamObserver<ListOpenWorkflowExecutionsResponse> responseObserver) {
        try {
            Optional<String> workflowIdFilter = listRequest.hasExecutionFilter() && !listRequest.getExecutionFilter().getWorkflowId().isEmpty() ? Optional.of(listRequest.getExecutionFilter().getWorkflowId()) : Optional.empty();
            List<WorkflowExecutionInfo> result = this.store.listWorkflows(TestWorkflowStore.WorkflowState.OPEN, workflowIdFilter);
            responseObserver.onNext((Object)ListOpenWorkflowExecutionsResponse.newBuilder().addAllExecutions(result).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest, StreamObserver<ListClosedWorkflowExecutionsResponse> responseObserver) {
        try {
            Optional<String> workflowIdFilter = listRequest.hasExecutionFilter() && !listRequest.getExecutionFilter().getWorkflowId().isEmpty() ? Optional.of(listRequest.getExecutionFilter().getWorkflowId()) : Optional.empty();
            List<WorkflowExecutionInfo> result = this.store.listWorkflows(TestWorkflowStore.WorkflowState.CLOSED, workflowIdFilter);
            responseObserver.onNext((Object)ListClosedWorkflowExecutionsResponse.newBuilder().addAllExecutions(result).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void respondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest, StreamObserver<RespondQueryTaskCompletedResponse> responseObserver) {
        try {
            QueryId queryId = QueryId.fromBytes(completeRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(queryId.getExecutionId());
            mutableState.completeQuery(queryId, completeRequest);
            responseObserver.onNext((Object)RespondQueryTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void queryWorkflow(QueryWorkflowRequest queryRequest, StreamObserver<QueryWorkflowResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(queryRequest.getNamespace(), queryRequest.getExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            Deadline deadline = Context.current().getDeadline();
            QueryWorkflowResponse result = mutableState.query(queryRequest, deadline != null ? deadline.timeRemaining(TimeUnit.MILLISECONDS) : Long.MAX_VALUE);
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void describeWorkflowExecution(DescribeWorkflowExecutionRequest request, StreamObserver<DescribeWorkflowExecutionResponse> responseObserver) {
        try {
            if (request.getNamespace().isEmpty()) {
                throw TestWorkflowService.createInvalidArgument("Namespace not set on request.");
            }
            if (!request.hasExecution()) {
                throw TestWorkflowService.createInvalidArgument("Execution not set on request.");
            }
            ExecutionId executionId = new ExecutionId(request.getNamespace(), request.getExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            DescribeWorkflowExecutionResponse result = mutableState.describeWorkflowExecution();
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void describeNamespace(DescribeNamespaceRequest request, StreamObserver<DescribeNamespaceResponse> responseObserver) {
        try {
            if (request.getNamespace().isEmpty()) {
                throw TestWorkflowService.createInvalidArgument("Namespace not set on request.");
            }
            String namespaceId = UUID.nameUUIDFromBytes(request.getNamespace().getBytes()).toString();
            DescribeNamespaceResponse result = DescribeNamespaceResponse.newBuilder().setNamespaceInfo(NamespaceInfo.newBuilder().setName(request.getNamespace()).setState(NamespaceState.NAMESPACE_STATE_REGISTERED).setId(namespaceId).setCapabilities(NamespaceInfo.Capabilities.newBuilder().setEagerWorkflowStart(true).setAsyncUpdate(true).setSyncUpdate(true)).build()).build();
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private <R> R requireNotNull(String fieldName, R value) {
        if (value == null) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing required field \"" + fieldName + "\".").asRuntimeException();
        }
        return value;
    }

    public void getDiagnostics(StringBuilder result) {
        this.store.getDiagnostics(result);
    }

    @Deprecated
    public long currentTimeMillis() {
        return this.selfAdvancingTimer.getClock().getAsLong();
    }

    public void registerDelayedCallback(java.time.Duration delay, Runnable r) {
        this.store.registerDelayedCallback(delay, r);
    }

    @Deprecated
    public void lockTimeSkipping(String caller) {
        this.selfAdvancingTimer.lockTimeSkipping(caller);
    }

    @Deprecated
    public void unlockTimeSkipping(String caller) {
        this.selfAdvancingTimer.unlockTimeSkipping(caller);
    }

    @Deprecated
    public void sleep(java.time.Duration duration) {
        CompletableFuture result = new CompletableFuture();
        this.selfAdvancingTimer.schedule(duration, () -> {
            this.selfAdvancingTimer.lockTimeSkipping("TestWorkflowService sleep");
            result.complete(null);
        }, "workflow sleep");
        this.selfAdvancingTimer.unlockTimeSkipping("TestWorkflowService sleep");
        try {
            result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Deadline getLongPollDeadline() {
        Deadline deadline = Context.current().getDeadline();
        Deadline maximumDeadline = Deadline.after((long)WorkflowServiceStubsOptions.DEFAULT_SERVER_LONG_POLL_RPC_TIMEOUT.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        return deadline != null ? deadline.minimum(maximumDeadline) : maximumDeadline;
    }

    private Deadline getUpdatePollDeadline() {
        Deadline deadline = Context.current().getDeadline();
        Deadline maximumDeadline = Deadline.after((long)java.time.Duration.ofSeconds(10L).toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        return deadline != null ? deadline.minimum(maximumDeadline) : maximumDeadline;
    }

    private void handleStatusRuntimeException(StatusRuntimeException e, StreamObserver<?> responseObserver) {
        if (e.getStatus().getCode() == Status.Code.INTERNAL) {
            log.error("unexpected", (Throwable)e);
        }
        responseObserver.onError((Throwable)e);
    }

    @Deprecated
    public TestWorkflowService() {
        this(0L, true);
    }

    @Deprecated
    public TestWorkflowService(long initialTimeMillis) {
        this(initialTimeMillis, true);
    }

    @Deprecated
    public TestWorkflowService(boolean lockTimeSkipping) {
        this(0L, true);
        if (lockTimeSkipping) {
            this.lockTimeSkipping("constructor");
        }
    }

    @Deprecated
    public static TestWorkflowService createWithNoGrpcServer() {
        return new TestWorkflowService(0L, false);
    }

    private TestWorkflowService(long initialTimeMillis, boolean startInProcessServer) {
        this.selfAdvancingTimer = new SelfAdvancingTimerImpl(initialTimeMillis, Clock.systemDefaultZone());
        this.store = new TestWorkflowStoreImpl(this.selfAdvancingTimer);
        this.visibilityStore = new TestVisibilityStoreImpl();
        this.nexusEndpointStore = new TestNexusEndpointStoreImpl();
        this.outOfProcessServer = null;
        if (startInProcessServer) {
            this.inProcessServer = new InProcessGRPCServer(Collections.singletonList(this));
            this.workflowServiceStubs = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)((WorkflowServiceStubsOptions.Builder)WorkflowServiceStubsOptions.newBuilder().setChannel(this.inProcessServer.getChannel())).build());
        } else {
            this.inProcessServer = null;
            this.workflowServiceStubs = null;
        }
    }

    @Deprecated
    public static TestWorkflowService createServerOnly(int port) {
        TestWorkflowService result = new TestWorkflowService(true, port);
        log.info("Server started, listening on " + port);
        return result;
    }

    private TestWorkflowService(boolean isOutOfProc, int port) {
        Preconditions.checkState((boolean)isOutOfProc, (Object)"Impossible.");
        this.inProcessServer = null;
        this.workflowServiceStubs = null;
        this.selfAdvancingTimer = new SelfAdvancingTimerImpl(0L, Clock.systemDefaultZone());
        this.store = new TestWorkflowStoreImpl(this.selfAdvancingTimer);
        this.visibilityStore = new TestVisibilityStoreImpl();
        this.nexusEndpointStore = new TestNexusEndpointStoreImpl();
        try {
            ServerBuilder serverBuilder = Grpc.newServerBuilderForPort((int)port, (ServerCredentials)InsecureServerCredentials.create());
            GRPCServerHelper.registerServicesAndHealthChecks(Collections.singletonList(this), (ServerBuilder)serverBuilder);
            this.outOfProcessServer = serverBuilder.build().start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public WorkflowServiceStubs newClientStub() {
        if (this.workflowServiceStubs == null) {
            throw new RuntimeException("Cannot get a client when you created your TestWorkflowService with createServerOnly.");
        }
        return this.workflowServiceStubs;
    }

    private static StatusRuntimeException createInvalidArgument(String description) {
        throw Status.INVALID_ARGUMENT.withDescription(description).asRuntimeException();
    }
}

