/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.base.Strings;
import com.google.protobuf.Duration;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.command.v1.CancelTimerCommandAttributes;
import io.temporal.api.command.v1.CancelWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.CompleteWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.FailWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.command.v1.RequestCancelActivityTaskCommandAttributes;
import io.temporal.api.command.v1.RequestCancelExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartTimerCommandAttributes;
import io.temporal.api.command.v1.UpsertWorkflowSearchAttributesCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.QueryRejectCondition;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.enums.v1.SignalExternalWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.TimeoutType;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import io.temporal.api.errordetails.v1.QueryFailedFailure;
import io.temporal.api.failure.v1.ApplicationFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.ActivityTaskScheduledEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionCanceledEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionCompletedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionStartedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionTimedOutEventAttributes;
import io.temporal.api.history.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.api.history.v1.StartChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.UpsertWorkflowSearchAttributesEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionSignaledEventAttributes;
import io.temporal.api.query.v1.QueryRejected;
import io.temporal.api.query.v1.WorkflowQueryResult;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.LockHandle;
import io.temporal.internal.testservice.QueryId;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.internal.testservice.StateMachine;
import io.temporal.internal.testservice.StateMachines;
import io.temporal.internal.testservice.TestServiceRetryState;
import io.temporal.internal.testservice.TestWorkflowMutableState;
import io.temporal.internal.testservice.TestWorkflowService;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.serviceclient.StatusUtils;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestWorkflowMutableStateImpl
implements TestWorkflowMutableState {
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowMutableStateImpl.class);
    private final Lock lock = new ReentrantLock();
    private final SelfAdvancingTimer selfAdvancingTimer;
    private final LongSupplier clock;
    private final ExecutionId executionId;
    private final Optional<TestWorkflowMutableState> parent;
    private final OptionalLong parentChildInitiatedEventId;
    private final TestWorkflowStore store;
    private final TestWorkflowService service;
    private final StartWorkflowExecutionRequest startRequest;
    private long nextEventId = 1L;
    private final Map<Long, StateMachine<StateMachines.ActivityTaskData>> activities = new HashMap<Long, StateMachine<StateMachines.ActivityTaskData>>();
    private final Map<String, Long> activityById = new HashMap<String, Long>();
    private final Map<Long, StateMachine<StateMachines.ChildWorkflowData>> childWorkflows = new HashMap<Long, StateMachine<StateMachines.ChildWorkflowData>>();
    private final Map<String, StateMachine<StateMachines.TimerData>> timers = new HashMap<String, StateMachine<StateMachines.TimerData>>();
    private final Map<String, StateMachine<StateMachines.SignalExternalData>> externalSignals = new HashMap<String, StateMachine<StateMachines.SignalExternalData>>();
    private final Map<String, StateMachine<StateMachines.CancelExternalData>> externalCancellations = new HashMap<String, StateMachine<StateMachines.CancelExternalData>>();
    private final StateMachine<StateMachines.WorkflowData> workflow;
    private final StateMachine<StateMachines.WorkflowTaskData> workflowTaskStateMachine;
    private final Map<String, CompletableFuture<QueryWorkflowResponse>> queries = new ConcurrentHashMap<String, CompletableFuture<QueryWorkflowResponse>>();
    public StickyExecutionAttributes stickyExecutionAttributes;

    TestWorkflowMutableStateImpl(StartWorkflowExecutionRequest startRequest, String runId, Optional<TestServiceRetryState> retryState, java.time.Duration backoffStartInterval, Payloads lastCompletionResult, Optional<Failure> lastFailure, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, Optional<String> continuedExecutionRunId, TestWorkflowService service, TestWorkflowStore store) {
        this.startRequest = startRequest = this.overrideStartWorkflowExecutionRequest(startRequest);
        this.parent = parent;
        this.parentChildInitiatedEventId = parentChildInitiatedEventId;
        this.service = service;
        this.executionId = new ExecutionId(startRequest.getNamespace(), startRequest.getWorkflowId(), runId);
        this.store = store;
        this.selfAdvancingTimer = store.getTimer();
        this.clock = this.selfAdvancingTimer.getClock();
        StateMachines.WorkflowData data = new StateMachines.WorkflowData(retryState, ProtobufTimeUtils.toProtoDuration((java.time.Duration)backoffStartInterval), startRequest.getCronSchedule(), lastCompletionResult, lastFailure, runId, continuedExecutionRunId);
        this.workflow = StateMachines.newWorkflowStateMachine(data);
        this.workflowTaskStateMachine = StateMachines.newWorkflowTaskStateMachine(store, startRequest);
    }

    private StartWorkflowExecutionRequest overrideStartWorkflowExecutionRequest(StartWorkflowExecutionRequest r) {
        long taskTimeoutMillis;
        long runTimeoutMillis;
        StartWorkflowExecutionRequest.Builder request = this.validateStartWorkflowExecutionRequest(r).toBuilder();
        long executionTimeoutMillis = Durations.toMillis((Duration)request.getWorkflowExecutionTimeout());
        if (executionTimeoutMillis == 0L) {
            executionTimeoutMillis = 315360000000L;
        }
        if ((executionTimeoutMillis = Math.min(executionTimeoutMillis, 315360000000L)) != Durations.toMillis((Duration)request.getWorkflowExecutionTimeout())) {
            request.setWorkflowExecutionTimeout(Durations.fromMillis((long)executionTimeoutMillis));
        }
        if ((runTimeoutMillis = Durations.toMillis((Duration)request.getWorkflowRunTimeout())) == 0L) {
            runTimeoutMillis = 315360000000L;
        }
        runTimeoutMillis = Math.min(runTimeoutMillis, 315360000000L);
        if ((runTimeoutMillis = Math.min(runTimeoutMillis, executionTimeoutMillis)) != Durations.toMillis((Duration)request.getWorkflowRunTimeout())) {
            request.setWorkflowRunTimeout(Durations.fromMillis((long)runTimeoutMillis));
        }
        if ((taskTimeoutMillis = Durations.toMillis((Duration)request.getWorkflowTaskTimeout())) == 0L) {
            taskTimeoutMillis = 10000L;
        }
        taskTimeoutMillis = Math.min(taskTimeoutMillis, 60000L);
        if ((taskTimeoutMillis = Math.min(taskTimeoutMillis, runTimeoutMillis)) != Durations.toMillis((Duration)request.getWorkflowTaskTimeout())) {
            request.setWorkflowTaskTimeout(Durations.fromMillis((long)taskTimeoutMillis));
        }
        return request.build();
    }

    private StartWorkflowExecutionRequest validateStartWorkflowExecutionRequest(StartWorkflowExecutionRequest request) {
        if (request.getRequestId().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing request ID.").asRuntimeException();
        }
        if (Durations.toMillis((Duration)request.getWorkflowExecutionTimeout()) < 0L) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid WorkflowExecutionTimeoutSeconds.").asRuntimeException();
        }
        if (Durations.toMillis((Duration)request.getWorkflowRunTimeout()) < 0L) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid WorkflowRunTimeoutSeconds.").asRuntimeException();
        }
        if (Durations.toMillis((Duration)request.getWorkflowTaskTimeout()) < 0L) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid WorkflowTaskTimeoutSeconds.").asRuntimeException();
        }
        if (!request.hasTaskQueue() || request.getTaskQueue().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing Taskqueue.").asRuntimeException();
        }
        if (!request.hasWorkflowType() || request.getWorkflowType().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing WorkflowType.").asRuntimeException();
        }
        if (request.hasRetryPolicy()) {
            TestServiceRetryState.validateAndOverrideRetryPolicy(request.getRetryPolicy());
        }
        return request;
    }

    private void update(UpdateProcedure updater) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.update(false, updater, stackTraceElements[2].getMethodName());
    }

    private void completeWorkflowTaskUpdate(UpdateProcedure updater, StickyExecutionAttributes attributes) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.stickyExecutionAttributes = attributes;
        try {
            this.update(true, updater, stackTraceElements[2].getMethodName());
        }
        catch (RuntimeException e) {
            this.stickyExecutionAttributes = null;
            throw e;
        }
    }

    private void update(boolean completeWorkflowTaskUpdate, UpdateProcedure updater, String caller) {
        String callerInfo = "Command Update from " + caller;
        this.lock.lock();
        LockHandle lockHandle = this.selfAdvancingTimer.lockTimeSkipping(callerInfo);
        try {
            if (this.isTerminalState()) {
                throw Status.NOT_FOUND.withDescription("Completed workflow").asRuntimeException();
            }
            boolean concurrentWorkflowTask = !completeWorkflowTaskUpdate && this.workflowTaskStateMachine.getState() == StateMachines.State.STARTED;
            RequestContext ctx = new RequestContext(this.clock, this, this.nextEventId);
            updater.apply(ctx);
            if (concurrentWorkflowTask && this.workflow.getState() != StateMachines.State.TIMED_OUT) {
                this.workflowTaskStateMachine.getData().bufferedEvents.add(ctx);
                ctx.fireCallbacks(0);
                this.store.applyTimersAndLocks(ctx);
            } else {
                this.nextEventId = ctx.commitChanges(this.store);
            }
        }
        catch (StatusRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
        finally {
            lockHandle.unlock();
            this.lock.unlock();
        }
    }

    @Override
    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    @Override
    public WorkflowExecutionStatus getWorkflowExecutionStatus() {
        switch (this.workflow.getState()) {
            case NONE: 
            case INITIATED: 
            case STARTED: 
            case CANCELLATION_REQUESTED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING;
            }
            case FAILED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_FAILED;
            }
            case TIMED_OUT: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_TIMED_OUT;
            }
            case CANCELED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_CANCELED;
            }
            case COMPLETED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_COMPLETED;
            }
            case CONTINUED_AS_NEW: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_CONTINUED_AS_NEW;
            }
            case TERMINATED: {
                return WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_TERMINATED;
            }
        }
        throw new IllegalStateException("unreachable");
    }

    @Override
    public StartWorkflowExecutionRequest getStartRequest() {
        return this.startRequest;
    }

    @Override
    public StickyExecutionAttributes getStickyExecutionAttributes() {
        return this.stickyExecutionAttributes;
    }

    @Override
    public Optional<TestWorkflowMutableState> getParent() {
        return this.parent;
    }

    @Override
    public void startWorkflowTask(PollWorkflowTaskQueueResponse.Builder task, PollWorkflowTaskQueueRequest pollRequest) {
        if (!task.hasQuery()) {
            this.update(ctx -> {
                StateMachines.WorkflowTaskData data = this.workflowTaskStateMachine.getData();
                long scheduledEventId = data.scheduledEventId;
                this.workflowTaskStateMachine.action(StateMachines.Action.START, ctx, pollRequest, 0L);
                task.setStartedTime(ctx.currentTime());
                ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)this.startRequest.getWorkflowTaskTimeout()), () -> this.timeoutWorkflowTask(scheduledEventId), "WorkflowTask StartToCloseTimeout");
            });
        }
    }

    @Override
    public void completeWorkflowTask(int historySizeFromToken, RespondWorkflowTaskCompletedRequest request) {
        List commands = request.getCommandsList();
        this.completeWorkflowTaskUpdate(ctx -> {
            if (ctx.getInitialEventId() != (long)(historySizeFromToken + 1)) {
                throw Status.NOT_FOUND.withDescription("Expired workflow task: expectedHistorySize=" + historySizeFromToken + ", actualHistorySize=" + ctx.getInitialEventId()).asRuntimeException();
            }
            long workflowTaskCompletedId = ctx.getNextEventId() - 1L;
            boolean newEvents = false;
            for (RequestContext requestContext : this.workflowTaskStateMachine.getData().bufferedEvents) {
                if (requestContext.getEvents().isEmpty()) continue;
                newEvents = true;
                break;
            }
            if (newEvents && this.hasCompletionCommand(request.getCommandsList())) {
                RespondWorkflowTaskFailedRequest failedRequest = RespondWorkflowTaskFailedRequest.newBuilder().setCause(WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_UNHANDLED_COMMAND).setIdentity(request.getIdentity()).build();
                this.workflowTaskStateMachine.action(StateMachines.Action.FAIL, ctx, failedRequest, workflowTaskCompletedId);
                for (RequestContext deferredCtx : this.workflowTaskStateMachine.getData().bufferedEvents) {
                    ctx.add(deferredCtx);
                }
                this.workflowTaskStateMachine.getData().bufferedEvents.clear();
                this.scheduleWorkflowTask(ctx);
                return;
            }
            try {
                boolean bl;
                this.workflowTaskStateMachine.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
                for (Command command : commands) {
                    this.processCommand(ctx, command, request.getIdentity(), workflowTaskCompletedId);
                }
                for (RequestContext requestContext : this.workflowTaskStateMachine.getData().bufferedEvents) {
                    ctx.add(requestContext);
                }
                StateMachines.WorkflowTaskData data = this.workflowTaskStateMachine.getData();
                boolean bl2 = bl = this.workflow.getState() == StateMachines.State.COMPLETED || this.workflow.getState() == StateMachines.State.FAILED || this.workflow.getState() == StateMachines.State.CANCELED;
                if (!bl && (ctx.isNeedWorkflowTask() || !this.workflowTaskStateMachine.getData().bufferedEvents.isEmpty() || request.getForceCreateNewWorkflowTask())) {
                    this.scheduleWorkflowTask(ctx);
                }
                this.workflowTaskStateMachine.getData().bufferedEvents.clear();
                Map<String, ConsistentQuery> queries = data.consistentQueryRequests;
                Map queryResultsMap = request.getQueryResultsMap();
                for (Map.Entry resultEntry : queryResultsMap.entrySet()) {
                    String key = (String)resultEntry.getKey();
                    ConsistentQuery query = queries.remove(key);
                    if (query == null) continue;
                    WorkflowQueryResult result = (WorkflowQueryResult)resultEntry.getValue();
                    switch (result.getResultType()) {
                        case QUERY_RESULT_TYPE_ANSWERED: {
                            QueryWorkflowResponse response = QueryWorkflowResponse.newBuilder().setQueryResult(result.getAnswer()).build();
                            query.getResult().complete(response);
                            break;
                        }
                        case QUERY_RESULT_TYPE_FAILED: {
                            query.getResult().completeExceptionally(StatusUtils.newException((Status)Status.INTERNAL.withDescription(result.getErrorMessage()), (GeneratedMessageV3)QueryFailedFailure.getDefaultInstance()));
                            break;
                        }
                        case UNRECOGNIZED: {
                            throw Status.INVALID_ARGUMENT.withDescription("URECOGNIZED query result type for =" + (String)resultEntry.getKey()).asRuntimeException();
                        }
                    }
                }
                ctx.onCommit(historySize -> {
                    if (this.workflowTaskStateMachine.getState() == StateMachines.State.INITIATED) {
                        for (ConsistentQuery query : data.queryBuffer.values()) {
                            this.workflowTaskStateMachine.action(StateMachines.Action.QUERY, ctx, query, -1L);
                        }
                    } else {
                        for (ConsistentQuery consistent : data.queryBuffer.values()) {
                            QueryId queryId = new QueryId(this.executionId, consistent.getKey());
                            PollWorkflowTaskQueueResponse.Builder task = PollWorkflowTaskQueueResponse.newBuilder().setTaskToken(queryId.toBytes()).setWorkflowExecution(this.executionId.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).setQuery(consistent.getRequest().getQuery()).setWorkflowExecutionTaskQueue(this.startRequest.getTaskQueue());
                            TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(consistent.getRequest().getNamespace(), this.stickyExecutionAttributes == null ? this.startRequest.getTaskQueue().getName() : this.stickyExecutionAttributes.getWorkerTaskQueue().getName());
                            this.store.sendQueryTask(this.executionId, taskQueueId, task);
                            this.queries.put(queryId.getQueryId(), consistent.getResult());
                        }
                    }
                    data.queryBuffer.clear();
                });
            }
            finally {
                ctx.unlockTimer("completeWorkflowTask");
            }
        }, request.hasStickyAttributes() ? request.getStickyAttributes() : null);
    }

    private boolean hasCompletionCommand(List<Command> commands) {
        for (Command command : commands) {
            if (!WorkflowExecutionUtils.isWorkflowExecutionCompleteCommand((Command)command)) continue;
            return true;
        }
        return false;
    }

    private void processCommand(RequestContext ctx, Command d, String identity, long workflowTaskCompletedId) {
        switch (d.getCommandType()) {
            case COMMAND_TYPE_COMPLETE_WORKFLOW_EXECUTION: {
                this.processCompleteWorkflowExecution(ctx, d.getCompleteWorkflowExecutionCommandAttributes(), workflowTaskCompletedId, identity);
                break;
            }
            case COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION: {
                this.processFailWorkflowExecution(ctx, d.getFailWorkflowExecutionCommandAttributes(), workflowTaskCompletedId, identity);
                break;
            }
            case COMMAND_TYPE_CANCEL_WORKFLOW_EXECUTION: {
                this.processCancelWorkflowExecution(ctx, d.getCancelWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_CONTINUE_AS_NEW_WORKFLOW_EXECUTION: {
                this.processContinueAsNewWorkflowExecution(ctx, d.getContinueAsNewWorkflowExecutionCommandAttributes(), workflowTaskCompletedId, identity);
                break;
            }
            case COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK: {
                this.processScheduleActivityTask(ctx, d.getScheduleActivityTaskCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK: {
                this.processRequestCancelActivityTask(ctx, d.getRequestCancelActivityTaskCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_START_TIMER: {
                this.processStartTimer(ctx, d.getStartTimerCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_CANCEL_TIMER: {
                this.processCancelTimer(ctx, d.getCancelTimerCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_START_CHILD_WORKFLOW_EXECUTION: {
                this.processStartChildWorkflow(ctx, d.getStartChildWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION: {
                this.processSignalExternalWorkflowExecution(ctx, d.getSignalExternalWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_RECORD_MARKER: {
                this.processRecordMarker(ctx, d.getRecordMarkerCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION: {
                this.processRequestCancelExternalWorkflowExecution(ctx, d.getRequestCancelExternalWorkflowExecutionCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            case COMMAND_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES: {
                this.processUpsertWorkflowSearchAttributes(ctx, d.getUpsertWorkflowSearchAttributesCommandAttributes(), workflowTaskCompletedId);
                break;
            }
            default: {
                throw Status.INVALID_ARGUMENT.withDescription("Unknown command type: " + d.getCommandType() + " for " + d).asRuntimeException();
            }
        }
    }

    private void processRequestCancelExternalWorkflowExecution(RequestContext ctx, RequestCancelExternalWorkflowExecutionCommandAttributes attr, long workflowTaskCompletedId) {
        if (this.externalCancellations.containsKey(attr.getWorkflowId())) {
            throw Status.FAILED_PRECONDITION.withDescription("cancellation aready requested for workflowId=" + attr.getWorkflowId()).asRuntimeException();
        }
        StateMachine<StateMachines.CancelExternalData> cancelStateMachine = StateMachines.newCancelExternalStateMachine();
        this.externalCancellations.put(attr.getWorkflowId(), cancelStateMachine);
        cancelStateMachine.action(StateMachines.Action.INITIATE, ctx, attr, workflowTaskCompletedId);
        ForkJoinPool.commonPool().execute(() -> {
            RequestCancelWorkflowExecutionRequest request = RequestCancelWorkflowExecutionRequest.newBuilder().setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId(attr.getWorkflowId())).setNamespace(ctx.getNamespace()).build();
            CancelExternalWorkflowExecutionCallerInfo info = new CancelExternalWorkflowExecutionCallerInfo(ctx.getNamespace(), ((StateMachines.CancelExternalData)cancelStateMachine.getData()).initiatedEventId, this.executionId.getExecution(), this);
            try {
                this.service.requestCancelWorkflowExecution(request, Optional.of(info));
            }
            catch (Exception e) {
                log.error("Failure to request cancel external workflow", (Throwable)e);
            }
        });
    }

    @Override
    public void reportCancelRequested(ExternalWorkflowExecutionCancelRequestedEventAttributes a) {
        this.update(ctx -> {
            if (this.isTerminalState()) {
                return;
            }
            StateMachine<StateMachines.CancelExternalData> cancellationRequest = this.externalCancellations.get(a.getWorkflowExecution().getWorkflowId());
            cancellationRequest.action(StateMachines.Action.START, ctx, a.getWorkflowExecution().getRunId(), 0L);
            this.scheduleWorkflowTask(ctx);
        });
    }

    private void processRecordMarker(RequestContext ctx, RecordMarkerCommandAttributes attr, long workflowTaskCompletedId) {
        if (attr.getMarkerName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("marker name is required").asRuntimeException();
        }
        MarkerRecordedEventAttributes.Builder marker = MarkerRecordedEventAttributes.newBuilder().setMarkerName(attr.getMarkerName()).setWorkflowTaskCompletedEventId(workflowTaskCompletedId).putAllDetails(attr.getDetailsMap());
        if (attr.hasHeader()) {
            marker.setHeader(attr.getHeader());
        }
        if (attr.hasFailure()) {
            marker.setFailure(attr.getFailure());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_MARKER_RECORDED).setMarkerRecordedEventAttributes(marker).build();
        ctx.addEvent(event);
    }

    private void processCancelTimer(RequestContext ctx, CancelTimerCommandAttributes d, long workflowTaskCompletedId) {
        String timerId = d.getTimerId();
        StateMachine<StateMachines.TimerData> timer = this.timers.get(timerId);
        if (timer == null) {
            throw Status.INVALID_ARGUMENT.withDescription("invalid history builder state for action").asRuntimeException();
        }
        timer.action(StateMachines.Action.CANCEL, ctx, d, workflowTaskCompletedId);
        this.timers.remove(timerId);
    }

    private void processRequestCancelActivityTask(RequestContext ctx, RequestCancelActivityTaskCommandAttributes a, long workflowTaskCompletedId) {
        long scheduledEventId = a.getScheduledEventId();
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.get(scheduledEventId);
        if (activity == null) {
            throw Status.FAILED_PRECONDITION.withDescription("ACTIVITY_UNKNOWN for scheduledEventId=" + scheduledEventId).asRuntimeException();
        }
        StateMachines.State beforeState = activity.getState();
        activity.action(StateMachines.Action.REQUEST_CANCELLATION, ctx, a, workflowTaskCompletedId);
        if (beforeState == StateMachines.State.INITIATED) {
            activity.action(StateMachines.Action.CANCEL, ctx, null, 0L);
            this.activities.remove(scheduledEventId);
            ctx.setNeedWorkflowTask(true);
        }
    }

    private void processScheduleActivityTask(RequestContext ctx, ScheduleActivityTaskCommandAttributes a, long workflowTaskCompletedId) {
        String activityId = (a = this.validateScheduleActivityTask(a)).getActivityId();
        Long activityScheduledEventId = this.activityById.get(activityId);
        if (activityScheduledEventId != null) {
            throw Status.FAILED_PRECONDITION.withDescription("Already open activity with " + activityId).asRuntimeException();
        }
        StateMachine<StateMachines.ActivityTaskData> activity = StateMachines.newActivityStateMachine(this.store, this.startRequest);
        long activityScheduleId = ctx.getNextEventId();
        this.activities.put(activityScheduleId, activity);
        this.activityById.put(activityId, activityScheduleId);
        activity.action(StateMachines.Action.INITIATE, ctx, a, workflowTaskCompletedId);
        ActivityTaskScheduledEventAttributes scheduledEvent = activity.getData().scheduledEvent;
        int attempt = activity.getData().getAttempt();
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)scheduledEvent.getScheduleToCloseTimeout()), () -> this.timeoutActivity(activityScheduleId, TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE, attempt), "Activity ScheduleToCloseTimeout");
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)scheduledEvent.getScheduleToStartTimeout()), () -> this.timeoutActivity(activityScheduleId, TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_START, attempt), "Activity ScheduleToStartTimeout");
        ctx.lockTimer("processScheduleActivityTask");
    }

    private ScheduleActivityTaskCommandAttributes validateScheduleActivityTask(ScheduleActivityTaskCommandAttributes a) {
        boolean validStartToClose;
        ScheduleActivityTaskCommandAttributes.Builder result = a.toBuilder();
        if (!a.hasTaskQueue() || a.getTaskQueue().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("TaskQueue is not set on workflow task").asRuntimeException();
        }
        if (a.getActivityId().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("ActivityId is not set on workflow task").asRuntimeException();
        }
        if (!a.hasActivityType() || a.getActivityType().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("ActivityType is not set on workflow task").asRuntimeException();
        }
        if (Durations.compare((Duration)a.getScheduleToCloseTimeout(), (Duration)Durations.ZERO) < 0 || Durations.compare((Duration)a.getScheduleToStartTimeout(), (Duration)Durations.ZERO) < 0 || Durations.compare((Duration)a.getStartToCloseTimeout(), (Duration)Durations.ZERO) < 0 || Durations.compare((Duration)a.getHeartbeatTimeout(), (Duration)Durations.ZERO) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("A valid timeout may not be negative.").asRuntimeException();
        }
        Duration workflowRunTimeout = this.startRequest.getWorkflowRunTimeout();
        boolean validScheduleToClose = Durations.compare((Duration)a.getScheduleToCloseTimeout(), (Duration)Durations.ZERO) > 0;
        boolean validScheduleToStart = Durations.compare((Duration)a.getScheduleToStartTimeout(), (Duration)Durations.ZERO) > 0;
        boolean bl = validStartToClose = Durations.compare((Duration)a.getStartToCloseTimeout(), (Duration)Durations.ZERO) > 0;
        if (validScheduleToClose) {
            if (validScheduleToStart) {
                result.setScheduleToStartTimeout(Durations.fromMillis((long)Math.min(Durations.toMillis((Duration)a.getScheduleToStartTimeout()), Durations.toMillis((Duration)a.getScheduleToCloseTimeout()))));
            } else {
                result.setScheduleToStartTimeout(a.getScheduleToCloseTimeout());
            }
            if (validStartToClose) {
                result.setStartToCloseTimeout(Durations.fromMillis((long)Math.min(Durations.toMillis((Duration)a.getStartToCloseTimeout()), Durations.toMillis((Duration)a.getScheduleToCloseTimeout()))));
            } else {
                result.setStartToCloseTimeout(a.getScheduleToCloseTimeout());
            }
        } else if (validStartToClose) {
            result.setScheduleToCloseTimeout(workflowRunTimeout);
            if (!validScheduleToStart) {
                result.setScheduleToStartTimeout(workflowRunTimeout);
            }
        } else {
            throw Status.INVALID_ARGUMENT.withDescription("A valid StartToClose or ScheduleToCloseTimeout is not set on workflow task.").asRuntimeException();
        }
        if (Durations.compare((Duration)workflowRunTimeout, (Duration)Durations.ZERO) > 0) {
            if (Durations.compare((Duration)a.getScheduleToCloseTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setScheduleToCloseTimeout(workflowRunTimeout);
            }
            if (Durations.compare((Duration)a.getScheduleToStartTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setScheduleToStartTimeout(workflowRunTimeout);
            }
            if (Durations.compare((Duration)a.getStartToCloseTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setStartToCloseTimeout(workflowRunTimeout);
            }
            if (Durations.compare((Duration)a.getHeartbeatTimeout(), (Duration)workflowRunTimeout) > 0) {
                result.setHeartbeatTimeout(workflowRunTimeout);
            }
        }
        if (Durations.compare((Duration)a.getHeartbeatTimeout(), (Duration)a.getScheduleToCloseTimeout()) > 0) {
            result.setHeartbeatTimeout(a.getScheduleToCloseTimeout());
        }
        return result.build();
    }

    private void processStartChildWorkflow(RequestContext ctx, StartChildWorkflowExecutionCommandAttributes a, long workflowTaskCompletedId) {
        a = this.validateStartChildExecutionAttributes(a);
        StateMachine<StateMachines.ChildWorkflowData> child = StateMachines.newChildWorkflowStateMachine(this.service);
        this.childWorkflows.put(ctx.getNextEventId(), child);
        child.action(StateMachines.Action.INITIATE, ctx, a, workflowTaskCompletedId);
        ctx.lockTimer("processStartChildWorkflow");
    }

    private StartChildWorkflowExecutionCommandAttributes validateStartChildExecutionAttributes(StartChildWorkflowExecutionCommandAttributes a) {
        if (a == null) {
            throw Status.INVALID_ARGUMENT.withDescription("StartChildWorkflowExecutionCommandAttributes is not set on workflow task").asRuntimeException();
        }
        if (a.getWorkflowId().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Required field WorkflowId is not set on workflow task").asRuntimeException();
        }
        if (!a.hasWorkflowType() || a.getWorkflowType().getName().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("Required field WorkflowType is not set on workflow task").asRuntimeException();
        }
        StartChildWorkflowExecutionCommandAttributes.Builder ab = a.toBuilder();
        if (a.hasRetryPolicy()) {
            ab.setRetryPolicy(TestServiceRetryState.validateAndOverrideRetryPolicy(a.getRetryPolicy()));
        }
        if (!ab.hasTaskQueue()) {
            ab.setTaskQueue(this.startRequest.getTaskQueue());
        }
        if (Durations.compare((Duration)a.getWorkflowExecutionTimeout(), (Duration)Durations.ZERO) <= 0) {
            ab.setWorkflowExecutionTimeout(this.startRequest.getWorkflowExecutionTimeout());
        }
        if (Durations.compare((Duration)a.getWorkflowRunTimeout(), (Duration)Durations.ZERO) <= 0) {
            ab.setWorkflowRunTimeout(this.startRequest.getWorkflowRunTimeout());
        }
        if (Durations.compare((Duration)a.getWorkflowTaskTimeout(), (Duration)Durations.ZERO) <= 0) {
            ab.setWorkflowTaskTimeout(this.startRequest.getWorkflowTaskTimeout());
        }
        return ab.build();
    }

    private void processSignalExternalWorkflowExecution(RequestContext ctx, SignalExternalWorkflowExecutionCommandAttributes a, long workflowTaskCompletedId) {
        String signalId = UUID.randomUUID().toString();
        StateMachine<StateMachines.SignalExternalData> signalStateMachine = StateMachines.newSignalExternalStateMachine();
        this.externalSignals.put(signalId, signalStateMachine);
        signalStateMachine.action(StateMachines.Action.INITIATE, ctx, a, workflowTaskCompletedId);
        ForkJoinPool.commonPool().execute(() -> {
            try {
                this.service.signalExternalWorkflowExecution(signalId, a, this);
            }
            catch (Exception e) {
                log.error("Failure signalling an external workflow execution", (Throwable)e);
            }
        });
        ctx.lockTimer("processSignalExternalWorkflowExecution");
    }

    @Override
    public void completeSignalExternalWorkflowExecution(String signalId, String runId) {
        this.update(ctx -> {
            StateMachine<StateMachines.SignalExternalData> signal = this.getSignal(signalId);
            signal.action(StateMachines.Action.COMPLETE, ctx, runId, 0L);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeSignalExternalWorkflowExecution");
        });
    }

    @Override
    public void failSignalExternalWorkflowExecution(String signalId, SignalExternalWorkflowExecutionFailedCause cause) {
        this.update(ctx -> {
            StateMachine<StateMachines.SignalExternalData> signal = this.getSignal(signalId);
            signal.action(StateMachines.Action.FAIL, ctx, cause, 0L);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("failSignalExternalWorkflowExecution");
        });
    }

    private StateMachine<StateMachines.SignalExternalData> getSignal(String signalId) {
        StateMachine<StateMachines.SignalExternalData> signal = this.externalSignals.get(signalId);
        if (signal == null) {
            throw Status.FAILED_PRECONDITION.withDescription("unknown signalId: " + signalId).asRuntimeException();
        }
        return signal;
    }

    @Override
    public void failWorkflowTask(RespondWorkflowTaskFailedRequest request) {
        this.completeWorkflowTaskUpdate(ctx -> {
            this.workflowTaskStateMachine.action(StateMachines.Action.FAIL, ctx, request, 0L);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("failWorkflowTask");
        }, null);
    }

    private void timeoutWorkflowTask(long scheduledEventId) {
        try {
            this.completeWorkflowTaskUpdate(ctx -> {
                if (this.workflowTaskStateMachine == null || this.workflowTaskStateMachine.getData().scheduledEventId != scheduledEventId || this.workflowTaskStateMachine.getState() == StateMachines.State.NONE) {
                    return;
                }
                Iterator<Map.Entry<String, ConsistentQuery>> queries = this.workflowTaskStateMachine.getData().queryBuffer.entrySet().iterator();
                while (queries.hasNext()) {
                    Map.Entry<String, ConsistentQuery> queryEntry = queries.next();
                    if (!queryEntry.getValue().getResult().isCancelled()) continue;
                    queries.remove();
                }
                this.workflowTaskStateMachine.action(StateMachines.Action.TIME_OUT, ctx, TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE, 0L);
                this.scheduleWorkflowTask(ctx);
                ctx.unlockTimer("timeoutWorkflowTask");
            }, null);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure trying to timeout a workflow task scheduledEventId=" + scheduledEventId, (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("Failure trying to timeout a workflow task scheduledEventId=" + scheduledEventId, (Throwable)e);
        }
    }

    @Override
    public void childWorkflowStarted(ChildWorkflowExecutionStartedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.START, ctx, a, 0L);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowStarted");
        });
    }

    @Override
    public void childWorkflowFailed(String activityId, ChildWorkflowExecutionFailedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.FAIL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowFailed");
        });
    }

    @Override
    public void childWorkflowTimedOut(String activityId, ChildWorkflowExecutionTimedOutEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.TIME_OUT, ctx, a.getRetryState(), 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowTimedOut");
        });
    }

    @Override
    public void failStartChildWorkflow(String childId, StartChildWorkflowExecutionFailedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.FAIL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("failStartChildWorkflow");
        });
    }

    @Override
    public void childWorkflowCompleted(String activityId, ChildWorkflowExecutionCompletedEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.COMPLETE, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowCompleted");
        });
    }

    @Override
    public void childWorkflowCanceled(String activityId, ChildWorkflowExecutionCanceledEventAttributes a) {
        this.update(ctx -> {
            StateMachine<StateMachines.ChildWorkflowData> child = this.getChildWorkflow(a.getInitiatedEventId());
            child.action(StateMachines.Action.CANCEL, ctx, a, 0L);
            this.childWorkflows.remove(a.getInitiatedEventId());
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("childWorkflowCanceled");
        });
    }

    private void processStartTimer(RequestContext ctx, StartTimerCommandAttributes a, long workflowTaskCompletedId) {
        String timerId = a.getTimerId();
        if (timerId == null) {
            throw Status.INVALID_ARGUMENT.withDescription("A valid TimerId is not set on StartTimerCommand").asRuntimeException();
        }
        StateMachine<StateMachines.TimerData> timer = this.timers.get(timerId);
        if (timer != null) {
            throw Status.FAILED_PRECONDITION.withDescription("Already open timer with " + timerId).asRuntimeException();
        }
        timer = StateMachines.newTimerStateMachine();
        this.timers.put(timerId, timer);
        timer.action(StateMachines.Action.START, ctx, a, workflowTaskCompletedId);
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)a.getStartToFireTimeout()), () -> this.fireTimer(timerId), "fire timer");
    }

    private void fireTimer(String timerId) {
        StateMachine<StateMachines.TimerData> timer;
        this.lock.lock();
        try {
            timer = this.timers.get(timerId);
            if (timer == null || this.workflow.getState() != StateMachines.State.STARTED && this.workflow.getState() != StateMachines.State.CANCELLATION_REQUESTED) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.update(ctx -> {
                timer.action(StateMachines.Action.COMPLETE, ctx, null, 0L);
                this.timers.remove(timerId);
                this.scheduleWorkflowTask(ctx);
            });
        }
        catch (Throwable e) {
            log.error("Failure firing a timer", e);
        }
    }

    private void processFailWorkflowExecution(RequestContext ctx, FailWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId, String identity) {
        Failure failure = d.getFailure();
        StateMachines.WorkflowData data = this.workflow.getData();
        if (data.retryState.isPresent()) {
            TestServiceRetryState.BackoffInterval backoffInterval;
            TestServiceRetryState rs = data.retryState.get();
            if (failure.hasApplicationFailureInfo()) {
                ApplicationFailureInfo failureInfo = failure.getApplicationFailureInfo();
                if (failureInfo.getNonRetryable()) {
                    backoffInterval = new TestServiceRetryState.BackoffInterval(RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE);
                } else {
                    Optional<String> failureType = Optional.of(failureInfo.getType());
                    backoffInterval = rs.getBackoffIntervalInSeconds(failureType, this.store.currentTime());
                }
            } else {
                backoffInterval = failure.hasTerminatedFailureInfo() || failure.hasCanceledFailureInfo() || failure.hasServerFailureInfo() && failure.getServerFailureInfo().getNonRetryable() ? new TestServiceRetryState.BackoffInterval(RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE) : rs.getBackoffIntervalInSeconds(Optional.empty(), this.store.currentTime());
            }
            if (backoffInterval.getRetryState() == RetryState.RETRY_STATE_IN_PROGRESS) {
                ContinueAsNewWorkflowExecutionCommandAttributes.Builder continueAsNewAttr = ContinueAsNewWorkflowExecutionCommandAttributes.newBuilder().setInput(this.startRequest.getInput()).setWorkflowType(this.startRequest.getWorkflowType()).setWorkflowRunTimeout(this.startRequest.getWorkflowRunTimeout()).setWorkflowTaskTimeout(this.startRequest.getWorkflowTaskTimeout()).setBackoffStartInterval(ProtobufTimeUtils.toProtoDuration((java.time.Duration)backoffInterval.getInterval()));
                if (this.startRequest.hasTaskQueue()) {
                    continueAsNewAttr.setTaskQueue(this.startRequest.getTaskQueue());
                }
                if (this.startRequest.hasRetryPolicy()) {
                    continueAsNewAttr.setRetryPolicy(this.startRequest.getRetryPolicy());
                }
                if (this.startRequest.hasHeader()) {
                    continueAsNewAttr.setHeader(this.startRequest.getHeader());
                }
                if (this.startRequest.hasMemo()) {
                    continueAsNewAttr.setMemo(this.startRequest.getMemo());
                }
                this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, continueAsNewAttr.build(), workflowTaskCompletedId);
                this.workflowTaskStateMachine.getData().workflowCompleted = true;
                HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
                WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewEventAttributes = event.getWorkflowExecutionContinuedAsNewEventAttributes();
                Optional<TestServiceRetryState> continuedRetryState = Optional.of(rs.getNextAttempt(Optional.of(failure)));
                String runId = this.service.continueAsNew(this.startRequest, continuedAsNewEventAttributes, continuedRetryState, identity, this.getExecutionId(), this.parent, this.parentChildInitiatedEventId);
                return;
            }
        }
        if (!Strings.isNullOrEmpty((String)data.cronSchedule)) {
            this.startNewCronRun(ctx, workflowTaskCompletedId, identity, data, data.lastCompletionResult, Optional.of(failure));
            return;
        }
        this.workflow.action(StateMachines.Action.FAIL, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        if (this.parent.isPresent()) {
            ctx.lockTimer("processFailWorkflowExecution notify parent");
            ChildWorkflowExecutionFailedEventAttributes a = ChildWorkflowExecutionFailedEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setFailure(failure).setWorkflowType(this.startRequest.getWorkflowType()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowFailed(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting child failure", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure reporting child failure", e);
                }
            });
        }
    }

    private void processCompleteWorkflowExecution(RequestContext ctx, CompleteWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId, String identity) {
        StateMachines.WorkflowData data = this.workflow.getData();
        if (!Strings.isNullOrEmpty((String)data.cronSchedule)) {
            this.startNewCronRun(ctx, workflowTaskCompletedId, identity, data, d.getResult(), Optional.empty());
            return;
        }
        this.workflow.action(StateMachines.Action.COMPLETE, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        this.workflow.getData().runTimerCancellationHandle.apply();
        if (this.parent.isPresent()) {
            ctx.lockTimer("processCompleteWorkflowExecution notify parent");
            ChildWorkflowExecutionCompletedEventAttributes a = ChildWorkflowExecutionCompletedEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setResult(d.getResult()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowCompleted(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting child completion", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure reporting child completion", e);
                }
            });
        }
    }

    private void startNewCronRun(RequestContext ctx, long workflowTaskCompletedId, String identity, StateMachines.WorkflowData data, Payloads lastCompletionResult, Optional<Failure> lastFailure) {
        Objects.requireNonNull(lastFailure);
        Cron cron = TestWorkflowMutableStateImpl.parseCron(data.cronSchedule);
        Instant i = Instant.ofEpochMilli(Timestamps.toMillis((Timestamp)this.store.currentTime()));
        ZonedDateTime now = ZonedDateTime.ofInstant(i, ZoneOffset.UTC);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        Optional backoff = executionTime.timeToNextExecution(now);
        java.time.Duration backoffInterval = java.time.Duration.ZERO;
        if (backoff.isPresent()) {
            backoffInterval = (java.time.Duration)backoff.get();
        }
        if (backoffInterval == java.time.Duration.ZERO) {
            backoff = executionTime.timeToNextExecution(now.plusSeconds(1L));
            backoffInterval = (java.time.Duration)backoff.get();
        }
        ContinueAsNewWorkflowExecutionCommandAttributes.Builder builder = ContinueAsNewWorkflowExecutionCommandAttributes.newBuilder().setInput(this.startRequest.getInput()).setWorkflowType(this.startRequest.getWorkflowType()).setWorkflowRunTimeout(this.startRequest.getWorkflowRunTimeout()).setWorkflowTaskTimeout(this.startRequest.getWorkflowTaskTimeout()).setTaskQueue(this.startRequest.getTaskQueue()).setBackoffStartInterval(ProtobufTimeUtils.toProtoDuration((java.time.Duration)backoffInterval)).setRetryPolicy(this.startRequest.getRetryPolicy()).setLastCompletionResult(lastCompletionResult);
        if (lastFailure.isPresent()) {
            builder.setFailure(lastFailure.get());
        }
        ContinueAsNewWorkflowExecutionCommandAttributes continueAsNewAttr = builder.build();
        this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, continueAsNewAttr, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
        WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewEventAttributes = event.getWorkflowExecutionContinuedAsNewEventAttributes();
        String runId = this.service.continueAsNew(this.startRequest, continuedAsNewEventAttributes, Optional.empty(), identity, this.getExecutionId(), this.parent, this.parentChildInitiatedEventId);
    }

    static Cron parseCron(String schedule) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
        CronParser parser = new CronParser(cronDefinition);
        return parser.parse(schedule);
    }

    private void processCancelWorkflowExecution(RequestContext ctx, CancelWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId) {
        this.workflow.action(StateMachines.Action.CANCEL, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        if (this.parent.isPresent()) {
            ctx.lockTimer("processCancelWorkflowExecution notify parent");
            ChildWorkflowExecutionCanceledEventAttributes a = ChildWorkflowExecutionCanceledEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setDetails(d.getDetails()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowCanceled(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting child cancellation", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure reporting child cancellation", e);
                }
            });
        }
    }

    private void processContinueAsNewWorkflowExecution(RequestContext ctx, ContinueAsNewWorkflowExecutionCommandAttributes d, long workflowTaskCompletedId, String identity) {
        this.workflow.action(StateMachines.Action.CONTINUE_AS_NEW, ctx, d, workflowTaskCompletedId);
        this.workflowTaskStateMachine.getData().workflowCompleted = true;
        HistoryEvent event = ctx.getEvents().get(ctx.getEvents().size() - 1);
        String runId = this.service.continueAsNew(this.startRequest, event.getWorkflowExecutionContinuedAsNewEventAttributes(), this.workflow.getData().retryState, identity, this.getExecutionId(), this.parent, this.parentChildInitiatedEventId);
    }

    private void processUpsertWorkflowSearchAttributes(RequestContext ctx, UpsertWorkflowSearchAttributesCommandAttributes attr, long workflowTaskCompletedId) {
        UpsertWorkflowSearchAttributesEventAttributes.Builder upsertEventAttr = UpsertWorkflowSearchAttributesEventAttributes.newBuilder().setSearchAttributes(attr.getSearchAttributes()).setWorkflowTaskCompletedEventId(workflowTaskCompletedId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES).setUpsertWorkflowSearchAttributesEventAttributes(upsertEventAttr).build();
        ctx.addEvent(event);
    }

    @Override
    public void startWorkflow(boolean continuedAsNew, Optional<SignalWorkflowExecutionRequest> signalWithStartSignal) {
        try {
            this.update(ctx -> {
                java.time.Duration backoffStartInterval;
                this.workflow.action(StateMachines.Action.START, ctx, this.startRequest, 0L);
                if (signalWithStartSignal.isPresent()) {
                    this.addExecutionSignaledEvent(ctx, (SignalWorkflowExecutionRequest)signalWithStartSignal.get());
                }
                if ((backoffStartInterval = ProtobufTimeUtils.toJavaDuration((Duration)this.workflow.getData().backoffStartInterval)).compareTo(java.time.Duration.ZERO) > 0) {
                    ctx.addTimer(backoffStartInterval, () -> {
                        try {
                            this.update(ctx1 -> this.scheduleWorkflowTask(ctx1));
                        }
                        catch (StatusRuntimeException e) {
                            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                                log.error("Failure trying to add task for an delayed workflow retry", (Throwable)e);
                            }
                        }
                        catch (Throwable e) {
                            log.error("Failure trying to add task for an delayed workflow retry", e);
                        }
                    }, "delayedFirstWorkflowTask");
                } else {
                    this.scheduleWorkflowTask(ctx);
                }
                java.time.Duration runTimeout = ProtobufTimeUtils.toJavaDuration((Duration)this.startRequest.getWorkflowRunTimeout());
                if (backoffStartInterval.compareTo(java.time.Duration.ZERO) > 0) {
                    runTimeout = runTimeout.plus(backoffStartInterval);
                }
                this.workflow.getData().runTimerCancellationHandle = ctx.addTimer(runTimeout, this::timeoutWorkflow, "workflow execution timeout");
            });
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
            }
            throw e;
        }
        if (!continuedAsNew && this.parent.isPresent()) {
            ChildWorkflowExecutionStartedEventAttributes a = ChildWorkflowExecutionStartedEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setWorkflowExecution(this.getExecutionId().getExecution()).setNamespace(this.getExecutionId().getNamespace()).setWorkflowType(this.startRequest.getWorkflowType()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    this.parent.get().childWorkflowStarted(a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting child completion", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure trying to add task for an delayed workflow retry", e);
                }
            });
        }
    }

    private void scheduleWorkflowTask(RequestContext ctx) {
        StateMachines.State beforeState = this.workflowTaskStateMachine.getState();
        this.workflowTaskStateMachine.action(StateMachines.Action.INITIATE, ctx, this.startRequest, 0L);
        if (beforeState == StateMachines.State.NONE && this.workflowTaskStateMachine.getState() == StateMachines.State.INITIATED) {
            ctx.lockTimer("scheduleWorkflowTask");
        }
    }

    @Override
    public void startActivityTask(PollActivityTaskQueueResponseOrBuilder task, PollActivityTaskQueueRequest pollRequest) {
        this.update(ctx -> {
            String activityId = task.getActivityId();
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivityById(activityId);
            activity.action(StateMachines.Action.START, ctx, pollRequest, 0L);
            StateMachines.ActivityTaskData data = activity.getData();
            java.time.Duration startToCloseTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getStartToCloseTimeout());
            java.time.Duration heartbeatTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getHeartbeatTimeout());
            long scheduledEventId = activity.getData().scheduledEventId;
            if (startToCloseTimeout.compareTo(java.time.Duration.ZERO) > 0) {
                int attempt = data.getAttempt();
                ctx.addTimer(startToCloseTimeout, () -> this.timeoutActivity(scheduledEventId, TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE, attempt), "Activity StartToCloseTimeout");
            }
            this.updateHeartbeatTimer(ctx, scheduledEventId, activity, startToCloseTimeout, heartbeatTimeout);
        });
    }

    @Override
    public boolean isTerminalState() {
        StateMachines.State workflowState = this.workflow.getState();
        return this.isTerminalState(workflowState);
    }

    private void checkCompleted() {
        StateMachines.State workflowState = this.workflow.getState();
        if (this.isTerminalState(workflowState)) {
            throw Status.NOT_FOUND.withDescription("Workflow is already completed: " + (Object)((Object)workflowState)).asRuntimeException();
        }
    }

    private boolean isTerminalState(StateMachines.State workflowState) {
        return workflowState == StateMachines.State.COMPLETED || workflowState == StateMachines.State.TIMED_OUT || workflowState == StateMachines.State.FAILED || workflowState == StateMachines.State.CANCELED || workflowState == StateMachines.State.CONTINUED_AS_NEW;
    }

    private void updateHeartbeatTimer(RequestContext ctx, long activityId, StateMachine<StateMachines.ActivityTaskData> activity, java.time.Duration startToCloseTimeout, java.time.Duration heartbeatTimeout) {
        if (heartbeatTimeout.compareTo(java.time.Duration.ZERO) > 0 && heartbeatTimeout.compareTo(startToCloseTimeout) < 0) {
            StateMachines.ActivityTaskData data = activity.getData();
            data.lastHeartbeatTime = this.clock.getAsLong();
            int attempt = data.getAttempt();
            ctx.addTimer(heartbeatTimeout, () -> this.timeoutActivity(activityId, TimeoutType.TIMEOUT_TYPE_HEARTBEAT, attempt), "Activity Heartbeat Timeout");
        }
    }

    @Override
    public void completeActivityTask(long scheduledEventId, RespondActivityTaskCompletedRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(scheduledEventId);
            activity.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
            this.removeActivity(scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeActivityTask");
        });
    }

    @Override
    public void completeActivityTaskById(String activityId, RespondActivityTaskCompletedByIdRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivityById(activityId);
            activity.action(StateMachines.Action.COMPLETE, ctx, request, 0L);
            this.removeActivity(activity.getData().scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("completeActivityTaskById");
        });
    }

    @Override
    public void failActivityTask(long scheduledEventId, RespondActivityTaskFailedRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(scheduledEventId);
            activity.action(StateMachines.Action.FAIL, ctx, request, 0L);
            if (this.isTerminalState(activity.getState())) {
                this.removeActivity(scheduledEventId);
                this.scheduleWorkflowTask(ctx);
            } else {
                this.addActivityRetryTimer(ctx, activity);
            }
            ctx.unlockTimer("failActivityTask");
        });
    }

    private void addActivityRetryTimer(RequestContext ctx, StateMachine<StateMachines.ActivityTaskData> activity) {
        StateMachines.ActivityTaskData data = activity.getData();
        int attempt = data.getAttempt();
        ctx.addTimer(ProtobufTimeUtils.toJavaDuration((Duration)data.nextBackoffInterval), () -> {
            if (activity.getState() != StateMachines.State.INITIATED && data.getAttempt() != attempt) {
                return;
            }
            this.selfAdvancingTimer.lockTimeSkipping("activityRetryTimer " + ((StateMachines.ActivityTaskData)activity.getData()).scheduledEvent.getActivityId());
            boolean unlockTimer = false;
            try {
                this.update(ctx1 -> ctx1.addActivityTask(data.activityTask));
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                    log.error("Failure trying to add task for an activity retry", (Throwable)e);
                }
                unlockTimer = true;
            }
            catch (Exception e) {
                unlockTimer = true;
                log.error("Failure trying to add task for an activity retry", (Throwable)e);
            }
            finally {
                if (unlockTimer) {
                    this.selfAdvancingTimer.unlockTimeSkipping("activityRetryTimer " + ((StateMachines.ActivityTaskData)activity.getData()).scheduledEvent.getActivityId());
                }
            }
        }, "Activity Retry");
    }

    @Override
    public void failActivityTaskById(String activityId, RespondActivityTaskFailedByIdRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivityById(activityId);
            activity.action(StateMachines.Action.FAIL, ctx, request, 0L);
            if (this.isTerminalState(activity.getState())) {
                this.removeActivity(activity.getData().scheduledEventId);
                this.scheduleWorkflowTask(ctx);
            } else {
                this.addActivityRetryTimer(ctx, activity);
            }
            ctx.unlockTimer("failActivityTaskById");
        });
    }

    @Override
    public void cancelActivityTask(long scheduledEventId, RespondActivityTaskCanceledRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(scheduledEventId);
            activity.action(StateMachines.Action.CANCEL, ctx, request, 0L);
            this.removeActivity(scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("cancelActivityTask");
        });
    }

    @Override
    public void cancelActivityTaskById(String activityId, RespondActivityTaskCanceledByIdRequest request) {
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivityById(activityId);
            activity.action(StateMachines.Action.CANCEL, ctx, request, 0L);
            this.removeActivity(activity.getData().scheduledEventId);
            this.scheduleWorkflowTask(ctx);
            ctx.unlockTimer("cancelActivityTaskById");
        });
    }

    @Override
    public boolean heartbeatActivityTask(long scheduledEventId, Payloads details) {
        AtomicBoolean result = new AtomicBoolean();
        this.update(ctx -> {
            StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(scheduledEventId);
            if (activity.getState() != StateMachines.State.STARTED && activity.getState() != StateMachines.State.CANCELLATION_REQUESTED) {
                throw Status.NOT_FOUND.withDescription("Activity is in " + (Object)((Object)activity.getState()) + "  state").asRuntimeException();
            }
            activity.action(StateMachines.Action.UPDATE, ctx, details, 0L);
            if (activity.getState() == StateMachines.State.CANCELLATION_REQUESTED) {
                result.set(true);
            }
            StateMachines.ActivityTaskData data = activity.getData();
            data.lastHeartbeatTime = this.clock.getAsLong();
            java.time.Duration startToCloseTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getStartToCloseTimeout());
            java.time.Duration heartbeatTimeout = ProtobufTimeUtils.toJavaDuration((Duration)data.scheduledEvent.getHeartbeatTimeout());
            this.updateHeartbeatTimer(ctx, scheduledEventId, activity, startToCloseTimeout, heartbeatTimeout);
        });
        return result.get();
    }

    @Override
    public boolean heartbeatActivityTaskById(String id, Payloads details) {
        StateMachine<StateMachines.ActivityTaskData> activity = this.getActivityById(id);
        return this.heartbeatActivityTask(activity.getData().scheduledEventId, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutActivity(long scheduledEventId, TimeoutType timeoutType, int timeoutAttempt) {
        boolean unlockTimer = true;
        try {
            this.update(ctx -> {
                StateMachine<StateMachines.ActivityTaskData> activity = this.getActivity(scheduledEventId);
                int attempt = activity.getData().getAttempt();
                if (timeoutAttempt != attempt || activity.getState() != StateMachines.State.INITIATED && activity.getState() != StateMachines.State.STARTED) {
                    throw Status.NOT_FOUND.withDescription("Outdated timer").asRuntimeException();
                }
                if (timeoutType == TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_START && activity.getState() != StateMachines.State.INITIATED) {
                    throw Status.INTERNAL.withDescription("Not in INITIATED").asRuntimeException();
                }
                if (timeoutType == TimeoutType.TIMEOUT_TYPE_HEARTBEAT) {
                    long heartbeatTimeout = Durations.toMillis((Duration)activity.getData().scheduledEvent.getHeartbeatTimeout());
                    if (this.clock.getAsLong() - activity.getData().lastHeartbeatTime < heartbeatTimeout) {
                        throw Status.NOT_FOUND.withDescription("Timer fired earlier").asRuntimeException();
                    }
                }
                activity.action(StateMachines.Action.TIME_OUT, ctx, timeoutType, 0L);
                if (this.isTerminalState(activity.getState())) {
                    this.removeActivity(scheduledEventId);
                    this.scheduleWorkflowTask(ctx);
                } else {
                    this.addActivityRetryTimer(ctx, activity);
                }
            });
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure trying to add task for an activity retry", (Throwable)e);
            }
            unlockTimer = false;
        }
        catch (Exception e) {
            log.error("Failure trying to timeout an activity", (Throwable)e);
        }
        finally {
            if (unlockTimer) {
                this.selfAdvancingTimer.unlockTimeSkipping("timeoutActivity: " + scheduledEventId);
            }
        }
    }

    private void timeoutWorkflow() {
        this.lock.lock();
        try {
            if (this.isTerminalState(this.workflow.getState())) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.update(ctx -> {
                if (this.isTerminalState(this.workflow.getState())) {
                    return;
                }
                this.workflow.action(StateMachines.Action.TIME_OUT, ctx, RetryState.RETRY_STATE_TIMEOUT, 0L);
                this.workflowTaskStateMachine.getData().workflowCompleted = true;
                if (this.parent != null) {
                    ctx.lockTimer("timeoutWorkflow notify parent");
                }
                ForkJoinPool.commonPool().execute(() -> this.reportWorkflowTimeoutToParent(ctx));
            });
        }
        catch (Exception e) {
            log.error("Failure trying to timeout a workflow", (Throwable)e);
        }
    }

    private void reportWorkflowTimeoutToParent(RequestContext ctx) {
        if (!this.parent.isPresent()) {
            return;
        }
        try {
            ChildWorkflowExecutionTimedOutEventAttributes a = ChildWorkflowExecutionTimedOutEventAttributes.newBuilder().setInitiatedEventId(this.parentChildInitiatedEventId.getAsLong()).setRetryState(RetryState.RETRY_STATE_TIMEOUT).setWorkflowType(this.startRequest.getWorkflowType()).setNamespace(ctx.getNamespace()).setWorkflowExecution(ctx.getExecution()).build();
            this.parent.get().childWorkflowTimedOut(ctx.getExecutionId().getWorkflowId().getWorkflowId(), a);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                log.error("Failure reporting child timing out", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("Failure reporting child timing out", (Throwable)e);
        }
    }

    @Override
    public void signal(SignalWorkflowExecutionRequest signalRequest) {
        this.update(ctx -> {
            this.addExecutionSignaledEvent(ctx, signalRequest);
            this.scheduleWorkflowTask(ctx);
        });
    }

    @Override
    public void signalFromWorkflow(SignalExternalWorkflowExecutionCommandAttributes a) {
        this.update(ctx -> {
            this.addExecutionSignaledByExternalEvent(ctx, a);
            this.scheduleWorkflowTask(ctx);
        });
    }

    @Override
    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, Optional<CancelExternalWorkflowExecutionCallerInfo> callerInfo) {
        this.update(ctx -> {
            this.workflow.action(StateMachines.Action.REQUEST_CANCELLATION, ctx, cancelRequest, 0L);
            this.scheduleWorkflowTask(ctx);
        });
        if (callerInfo.isPresent()) {
            CancelExternalWorkflowExecutionCallerInfo ci = callerInfo.get();
            ExternalWorkflowExecutionCancelRequestedEventAttributes a = ExternalWorkflowExecutionCancelRequestedEventAttributes.newBuilder().setInitiatedEventId(ci.getExternalInitiatedEventId()).setWorkflowExecution(this.executionId.getExecution()).setNamespace(ci.getNamespace()).build();
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    ci.getCaller().reportCancelRequested(a);
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() != Status.Code.NOT_FOUND) {
                        log.error("Failure reporting external cancellation requested", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error("Failure reporting external cancellation requested", e);
                }
            });
        }
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request) {
        this.update(ctx -> {
            this.workflow.action(StateMachines.Action.TERMINATE, ctx, request, 0L);
            this.workflowTaskStateMachine.getData().workflowCompleted = true;
        });
    }

    @Override
    public QueryWorkflowResponse query(QueryWorkflowRequest queryRequest, long deadline) {
        boolean safeToDispatchDirectly;
        WorkflowExecutionStatus status = this.getWorkflowExecutionStatus();
        if (status != WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING && queryRequest.getQueryRejectCondition() != null) {
            boolean rejectNotCompletedCleanly;
            boolean rejectNotOpen = queryRequest.getQueryRejectCondition() == QueryRejectCondition.QUERY_REJECT_CONDITION_NOT_OPEN;
            boolean bl = rejectNotCompletedCleanly = queryRequest.getQueryRejectCondition() == QueryRejectCondition.QUERY_REJECT_CONDITION_NOT_COMPLETED_CLEANLY && status != WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_COMPLETED;
            if (rejectNotOpen || rejectNotCompletedCleanly) {
                return QueryWorkflowResponse.newBuilder().setQueryRejected(QueryRejected.newBuilder().setStatus(status)).build();
            }
        }
        this.lock.lock();
        boolean bl = safeToDispatchDirectly = this.isTerminalState() || this.workflowTaskStateMachine.getState() != StateMachines.State.INITIATED && this.workflowTaskStateMachine.getState() != StateMachines.State.STARTED;
        if (safeToDispatchDirectly) {
            return this.directQuery(queryRequest, deadline);
        }
        return this.stronglyConsistentQuery(queryRequest, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryWorkflowResponse directQuery(QueryWorkflowRequest queryRequest, long deadline) {
        CompletableFuture result = new CompletableFuture();
        try {
            QueryId queryId = new QueryId(this.executionId);
            PollWorkflowTaskQueueResponse.Builder task = PollWorkflowTaskQueueResponse.newBuilder().setTaskToken(queryId.toBytes()).setWorkflowExecution(this.executionId.getExecution()).setWorkflowType(this.startRequest.getWorkflowType()).setQuery(queryRequest.getQuery()).setWorkflowExecutionTaskQueue(this.startRequest.getTaskQueue());
            TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(queryRequest.getNamespace(), this.stickyExecutionAttributes == null ? this.startRequest.getTaskQueue().getName() : this.stickyExecutionAttributes.getWorkerTaskQueue().getName());
            this.queries.put(queryId.getQueryId(), result);
            this.store.sendQueryTask(this.executionId, taskQueueId, task);
        }
        finally {
            this.lock.unlock();
        }
        try {
            return (QueryWorkflowResponse)result.get(deadline, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return QueryWorkflowResponse.getDefaultInstance();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StatusRuntimeException) {
                throw (StatusRuntimeException)cause;
            }
            throw Status.INTERNAL.withCause(cause).withDescription(cause.getMessage()).asRuntimeException();
        }
        catch (TimeoutException e) {
            throw Status.DEADLINE_EXCEEDED.withCause((Throwable)e).withDescription("Query deadline of " + deadline + "milliseconds exceeded").asRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryWorkflowResponse stronglyConsistentQuery(QueryWorkflowRequest queryRequest, long deadline) {
        ConsistentQuery consistentQuery = new ConsistentQuery(queryRequest);
        try {
            this.update(ctx -> this.workflowTaskStateMachine.action(StateMachines.Action.QUERY, ctx, consistentQuery, 0L));
        }
        finally {
            this.lock.unlock();
        }
        CompletableFuture<QueryWorkflowResponse> result = consistentQuery.getResult();
        return this.getQueryWorkflowResponse(deadline, result);
    }

    private QueryWorkflowResponse getQueryWorkflowResponse(long deadline, CompletableFuture<QueryWorkflowResponse> result) {
        try {
            return result.get(deadline, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return QueryWorkflowResponse.getDefaultInstance();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StatusRuntimeException) {
                throw (StatusRuntimeException)cause;
            }
            throw Status.INTERNAL.withCause(cause).withDescription(cause.getMessage()).asRuntimeException();
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw Status.DEADLINE_EXCEEDED.withCause((Throwable)e).withDescription("query deadline exceeded").asRuntimeException();
        }
    }

    @Override
    public void completeQuery(QueryId queryId, RespondQueryTaskCompletedRequest completeRequest) {
        CompletableFuture<QueryWorkflowResponse> result = this.queries.remove(queryId.getQueryId());
        if (result == null) {
            throw Status.NOT_FOUND.withDescription("Unknown query id: " + queryId.getQueryId()).asRuntimeException();
        }
        if (result.isCancelled()) {
            return;
        }
        switch (completeRequest.getCompletedType()) {
            case QUERY_RESULT_TYPE_ANSWERED: {
                QueryWorkflowResponse response = QueryWorkflowResponse.newBuilder().setQueryResult(completeRequest.getQueryResult()).build();
                result.complete(response);
                break;
            }
            case QUERY_RESULT_TYPE_FAILED: {
                StatusRuntimeException error = StatusUtils.newException((Status)Status.INVALID_ARGUMENT.withDescription(completeRequest.getErrorMessage()), (GeneratedMessageV3)QueryFailedFailure.getDefaultInstance());
                result.completeExceptionally(error);
            }
        }
    }

    private void addExecutionSignaledEvent(RequestContext ctx, SignalWorkflowExecutionRequest signalRequest) {
        WorkflowExecutionSignaledEventAttributes.Builder a = WorkflowExecutionSignaledEventAttributes.newBuilder().setInput(this.startRequest.getInput()).setIdentity(signalRequest.getIdentity()).setInput(signalRequest.getInput()).setSignalName(signalRequest.getSignalName());
        HistoryEvent executionSignaled = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED).setWorkflowExecutionSignaledEventAttributes(a).build();
        ctx.addEvent(executionSignaled);
    }

    private void addExecutionSignaledByExternalEvent(RequestContext ctx, SignalExternalWorkflowExecutionCommandAttributes d) {
        WorkflowExecutionSignaledEventAttributes.Builder a = WorkflowExecutionSignaledEventAttributes.newBuilder().setInput(this.startRequest.getInput()).setInput(d.getInput()).setSignalName(d.getSignalName());
        HistoryEvent executionSignaled = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED).setWorkflowExecutionSignaledEventAttributes(a).build();
        ctx.addEvent(executionSignaled);
    }

    private StateMachine<StateMachines.ActivityTaskData> getActivityById(String activityId) {
        Long scheduledEventId = this.activityById.get(activityId);
        if (scheduledEventId == null) {
            throw Status.NOT_FOUND.withDescription("unknown activityId: " + activityId).asRuntimeException();
        }
        return this.getActivity(scheduledEventId);
    }

    private void removeActivity(long scheduledEventId) {
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.remove(scheduledEventId);
        if (activity == null) {
            return;
        }
        this.activityById.remove(activity.getData().scheduledEvent.getActivityId());
    }

    private StateMachine<StateMachines.ActivityTaskData> getActivity(long scheduledEventId) {
        StateMachine<StateMachines.ActivityTaskData> activity = this.activities.get(scheduledEventId);
        if (activity == null) {
            throw Status.NOT_FOUND.withDescription("unknown activity with scheduledEventId: " + scheduledEventId).asRuntimeException();
        }
        return activity;
    }

    private StateMachine<StateMachines.ChildWorkflowData> getChildWorkflow(long initiatedEventId) {
        StateMachine<StateMachines.ChildWorkflowData> child = this.childWorkflows.get(initiatedEventId);
        if (child == null) {
            throw Status.INTERNAL.withDescription("unknown initiatedEventId: " + initiatedEventId).asRuntimeException();
        }
        return child;
    }

    static class ConsistentQuery {
        private final String key = UUID.randomUUID().toString();
        private final QueryWorkflowRequest request;
        private final CompletableFuture<QueryWorkflowResponse> result = new CompletableFuture();

        private ConsistentQuery(QueryWorkflowRequest request) {
            this.request = request;
        }

        public QueryWorkflowRequest getRequest() {
            return this.request;
        }

        public CompletableFuture<QueryWorkflowResponse> getResult() {
            return this.result;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return "ConsistentQuery{key='" + this.key + '\'' + ", request=" + this.request + ", result=" + this.result + '}';
        }
    }

    static class CancelExternalWorkflowExecutionCallerInfo {
        private final String namespace;
        private final long externalInitiatedEventId;
        private final TestWorkflowMutableState caller;

        CancelExternalWorkflowExecutionCallerInfo(String namespace, long externalInitiatedEventId, WorkflowExecution workflowExecution, TestWorkflowMutableState caller) {
            this.namespace = namespace;
            this.externalInitiatedEventId = externalInitiatedEventId;
            this.caller = caller;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public long getExternalInitiatedEventId() {
            return this.externalInitiatedEventId;
        }

        public TestWorkflowMutableState getCaller() {
            return this.caller;
        }
    }

    @FunctionalInterface
    private static interface UpdateProcedure {
        public void apply(RequestContext var1);
    }
}

