/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.base.Defaults;
import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.StreamObserver;
import io.temporal.activity.Activity;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.converter.Values;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.ActivityFailure;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.sync.ActivityInvocationHandler;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.DeterministicRunnerWrapper;
import io.temporal.internal.sync.LocalActivityInvocationHandler;
import io.temporal.internal.sync.POJOActivityTaskHandler;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.testing.TestActivityEnvironment;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

public final class TestActivityEnvironmentInternal
implements TestActivityEnvironment {
    private final POJOActivityTaskHandler activityTaskHandler;
    private final TestEnvironmentOptions testEnvironmentOptions;
    private final AtomicInteger idSequencer = new AtomicInteger();
    private ClassConsumerPair<Object> activityHeartbetListener;
    private static final ScheduledExecutorService heartbeatExecutor = Executors.newScheduledThreadPool(20);
    private final WorkflowServiceStubs workflowServiceStubs;
    private final Server mockServer;
    private final AtomicBoolean cancellationRequested = new AtomicBoolean();
    private final ManagedChannel channel;

    public TestActivityEnvironmentInternal(TestEnvironmentOptions options) {
        this.testEnvironmentOptions = TestEnvironmentOptions.newBuilder(options).validateAndBuildWithDefaults();
        String serverName = InProcessServerBuilder.generateName();
        try {
            this.mockServer = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)new HeartbeatInterceptingService())).build().start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build();
        this.workflowServiceStubs = WorkflowServiceStubs.newInstance((WorkflowServiceStubsOptions)WorkflowServiceStubsOptions.newBuilder().setChannel(this.channel).setMetricsScope(options.getMetricsScope()).setQueryRpcTimeout(Duration.ofSeconds(60L)).setDisableHealthCheck(true).build());
        this.activityTaskHandler = new POJOActivityTaskHandler(this.workflowServiceStubs, this.testEnvironmentOptions.getWorkflowClientOptions().getNamespace(), this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter(), heartbeatExecutor, this.testEnvironmentOptions.getWorkerFactoryOptions().getWorkerInterceptors());
    }

    @Override
    public void registerActivitiesImplementations(Object ... activityImplementations) {
        this.activityTaskHandler.registerActivityImplementations(activityImplementations);
    }

    @Override
    public <T> T newActivityStub(Class<T> activityInterface) {
        ActivityOptions options = ActivityOptions.newBuilder().setScheduleToCloseTimeout(Duration.ofDays(1L)).setHeartbeatTimeout(Duration.ofSeconds(1L)).build();
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(activityInterface, (ActivityOptions)options, null, (WorkflowOutboundCallsInterceptor)new TestActivityExecutor());
        invocationHandler = new DeterministicRunnerWrapper(invocationHandler);
        return (T)ActivityInvocationHandlerBase.newProxy(activityInterface, (InvocationHandler)invocationHandler);
    }

    @Override
    public <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options) {
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(activityInterface, (ActivityOptions)options, null, (WorkflowOutboundCallsInterceptor)new TestActivityExecutor());
        invocationHandler = new DeterministicRunnerWrapper(invocationHandler);
        return (T)ActivityInvocationHandlerBase.newProxy(activityInterface, (InvocationHandler)invocationHandler);
    }

    @Override
    public <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options, Map<String, LocalActivityOptions> activityMethodOptions) {
        InvocationHandler invocationHandler = LocalActivityInvocationHandler.newInstance(activityInterface, (LocalActivityOptions)options, activityMethodOptions, (WorkflowOutboundCallsInterceptor)new TestActivityExecutor());
        invocationHandler = new DeterministicRunnerWrapper(invocationHandler);
        return (T)ActivityInvocationHandlerBase.newProxy(activityInterface, (InvocationHandler)invocationHandler);
    }

    @Override
    public void requestCancelActivity() {
        this.cancellationRequested.set(true);
    }

    @Override
    public <T> void setActivityHeartbeatListener(Class<T> detailsClass, Functions.Proc1<T> listener) {
        this.setActivityHeartbeatListener(detailsClass, detailsClass, listener);
    }

    @Override
    public <T> void setActivityHeartbeatListener(Class<T> detailsClass, Type detailsType, Functions.Proc1<T> listener) {
        this.activityHeartbetListener = new ClassConsumerPair<T>(detailsClass, detailsType, listener);
    }

    @Override
    public void close() {
        this.channel.shutdownNow();
        try {
            this.channel.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.mockServer.shutdown();
        try {
            this.mockServer.awaitTermination();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Activity.wrap((Throwable)e);
        }
    }

    private static class ClassConsumerPair<T> {
        final Functions.Proc1<T> consumer;
        final Class<T> valueClass;
        final Type valueType;

        ClassConsumerPair(Class<T> valueClass, Type valueType, Functions.Proc1<T> consumer) {
            this.valueClass = Objects.requireNonNull(valueClass);
            this.valueType = Objects.requireNonNull(valueType);
            this.consumer = Objects.requireNonNull(consumer);
        }
    }

    private class TestActivityExecutor
    implements WorkflowOutboundCallsInterceptor {
        private TestActivityExecutor() {
        }

        public <T> WorkflowOutboundCallsInterceptor.ActivityOutput<T> executeActivity(WorkflowOutboundCallsInterceptor.ActivityInput<T> i) {
            Optional payloads = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().toPayloads(i.getArgs());
            ActivityOptions options = i.getOptions();
            PollActivityTaskQueueResponse.Builder taskBuilder = PollActivityTaskQueueResponse.newBuilder().setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getScheduleToCloseTimeout())).setHeartbeatTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getHeartbeatTimeout())).setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getStartToCloseTimeout())).setScheduledTime(ProtobufTimeUtils.getCurrentProtoTime()).setStartedTime(ProtobufTimeUtils.getCurrentProtoTime()).setTaskToken(ByteString.copyFrom((byte[])"test-task-token".getBytes(StandardCharsets.UTF_8))).setActivityId(String.valueOf(TestActivityEnvironmentInternal.this.idSequencer.incrementAndGet())).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId("test-workflow-id").setRunId(UUID.randomUUID().toString()).build()).setActivityType(ActivityType.newBuilder().setName(i.getActivityName()).build());
            if (payloads.isPresent()) {
                taskBuilder.setInput((Payloads)payloads.get());
            }
            PollActivityTaskQueueResponse task = taskBuilder.build();
            ActivityTaskHandler.Result taskResult = TestActivityEnvironmentInternal.this.activityTaskHandler.handle(new ActivityTask(task, (Functions.Proc & Serializable)() -> {}), TestActivityEnvironmentInternal.this.testEnvironmentOptions.getMetricsScope(), false);
            return new WorkflowOutboundCallsInterceptor.ActivityOutput(Workflow.newPromise(this.getReply(task, taskResult, i.getResultClass(), i.getResultType())));
        }

        public <R> WorkflowOutboundCallsInterceptor.LocalActivityOutput<R> executeLocalActivity(WorkflowOutboundCallsInterceptor.LocalActivityInput<R> i) {
            Optional payloads = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().toPayloads(i.getArgs());
            LocalActivityOptions options = i.getOptions();
            PollActivityTaskQueueResponse.Builder taskBuilder = PollActivityTaskQueueResponse.newBuilder().setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getScheduleToCloseTimeout())).setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getStartToCloseTimeout())).setScheduledTime(ProtobufTimeUtils.getCurrentProtoTime()).setStartedTime(ProtobufTimeUtils.getCurrentProtoTime()).setTaskToken(ByteString.copyFrom((byte[])"test-task-token".getBytes(StandardCharsets.UTF_8))).setActivityId(String.valueOf(TestActivityEnvironmentInternal.this.idSequencer.incrementAndGet())).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId("test-workflow-id").setRunId(UUID.randomUUID().toString()).build()).setActivityType(ActivityType.newBuilder().setName(i.getActivityName()).build());
            if (payloads.isPresent()) {
                taskBuilder.setInput((Payloads)payloads.get());
            }
            PollActivityTaskQueueResponse task = taskBuilder.build();
            ActivityTaskHandler.Result taskResult = TestActivityEnvironmentInternal.this.activityTaskHandler.handle(new ActivityTask(task, (Functions.Proc & Serializable)() -> {}), TestActivityEnvironmentInternal.this.testEnvironmentOptions.getMetricsScope(), false);
            return new WorkflowOutboundCallsInterceptor.LocalActivityOutput(Workflow.newPromise(this.getReply(task, taskResult, i.getResultClass(), i.getResultType())));
        }

        public <R> WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> executeChildWorkflow(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Random newRandom() {
            throw new UnsupportedOperationException("not implemented");
        }

        public WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalWorkflow(WorkflowOutboundCallsInterceptor.SignalExternalInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public WorkflowOutboundCallsInterceptor.CancelWorkflowOutput cancelWorkflow(WorkflowOutboundCallsInterceptor.CancelWorkflowInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void sleep(Duration duration) {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void await(String reason, Supplier<Boolean> unblockCondition) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Promise<Void> newTimer(Duration duration) {
            throw new UnsupportedOperationException("not implemented");
        }

        public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
            throw new UnsupportedOperationException("not implemented");
        }

        public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
            throw new UnsupportedOperationException("not implemented");
        }

        public int getVersion(String changeId, int minSupported, int maxSupported) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void continueAsNew(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerQuery(WorkflowOutboundCallsInterceptor.RegisterQueryInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerSignalHandlers(WorkflowOutboundCallsInterceptor.RegisterSignalHandlersInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerDynamicSignalHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicSignalHandlerInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerDynamicQueryHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicQueryHandlerInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public UUID randomUUID() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void upsertSearchAttributes(Map<String, Object> searchAttributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object newThread(Runnable runnable, boolean detached, String name) {
            throw new UnsupportedOperationException("not implemented");
        }

        public long currentTimeMillis() {
            throw new UnsupportedOperationException("not implemented");
        }

        private <T> T getReply(PollActivityTaskQueueResponse task, ActivityTaskHandler.Result response, Class<T> resultClass, Type resultType) {
            RespondActivityTaskCompletedRequest taskCompleted = response.getTaskCompleted();
            if (taskCompleted != null) {
                Optional result = taskCompleted.hasResult() ? Optional.of(taskCompleted.getResult()) : Optional.empty();
                return (T)TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().fromPayloads(0, result, resultClass, resultType);
            }
            RespondActivityTaskFailedRequest taskFailed = response.getTaskFailed().getTaskFailedRequest();
            if (taskFailed != null) {
                RuntimeException cause = FailureConverter.failureToException((Failure)taskFailed.getFailure(), (DataConverter)TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter());
                throw new ActivityFailure(0L, 0L, task.getActivityType().getName(), task.getActivityId(), RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, "TestActivityEnvironment", (Throwable)cause);
            }
            RespondActivityTaskCanceledRequest taskCanceled = response.getTaskCanceled();
            if (taskCanceled != null) {
                throw new CanceledFailure("canceled", (Values)new EncodedValues(taskCanceled.hasDetails() ? Optional.of(taskCanceled.getDetails()) : Optional.empty(), TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter()), null);
            }
            return (T)Defaults.defaultValue(resultClass);
        }
    }

    private class HeartbeatInterceptingService
    extends WorkflowServiceGrpc.WorkflowServiceImplBase {
        private HeartbeatInterceptingService() {
        }

        public void recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest request, StreamObserver<RecordActivityTaskHeartbeatResponse> responseObserver) {
            try {
                if (TestActivityEnvironmentInternal.this.activityHeartbetListener != null) {
                    Optional requestDetails = request.hasDetails() ? Optional.of(request.getDetails()) : Optional.empty();
                    Object details = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().fromPayloads(0, requestDetails, ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbetListener.valueClass, ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbetListener.valueType);
                    ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbetListener.consumer.apply(details);
                }
                responseObserver.onNext((Object)RecordActivityTaskHeartbeatResponse.newBuilder().setCancelRequested(TestActivityEnvironmentInternal.this.cancellationRequested.get()).build());
                responseObserver.onCompleted();
            }
            catch (StatusRuntimeException e) {
                responseObserver.onError((Throwable)e);
            }
        }
    }
}

