/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.collect.ObjectArrays;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptorBase;
import io.temporal.internal.sync.WorkflowClientInternal;
import io.temporal.internal.testservice.TestWorkflowService;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.testing.TestWorkflowEnvironment;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestWorkflowEnvironmentInternal
implements TestWorkflowEnvironment {
    private final TestEnvironmentOptions testEnvironmentOptions;
    private final WorkflowClientOptions workflowClientOptions;
    private final WorkerFactoryOptions workerFactoryOptions;
    private final WorkflowServiceStubs workflowServiceStubs;
    private final TestWorkflowService service;
    private final WorkerFactory workerFactory;
    private final TimeLockingInterceptor timeLockingInterceptor;

    public TestWorkflowEnvironmentInternal(TestEnvironmentOptions options) {
        this.testEnvironmentOptions = options == null ? TestEnvironmentOptions.getDefaultInstance() : options;
        this.workflowClientOptions = WorkflowClientOptions.newBuilder((WorkflowClientOptions)this.testEnvironmentOptions.getWorkflowClientOptions()).validateAndBuildWithDefaults();
        this.workerFactoryOptions = WorkerFactoryOptions.newBuilder((WorkerFactoryOptions)this.testEnvironmentOptions.getWorkerFactoryOptions()).validateAndBuildWithDefaults();
        this.service = new TestWorkflowService(this.testEnvironmentOptions.getInitialTimeMillis());
        this.timeLockingInterceptor = new TimeLockingInterceptor(this.service);
        this.service.lockTimeSkipping("TestWorkflowEnvironmentInternal constructor");
        this.workflowServiceStubs = this.testEnvironmentOptions.isUseExternalService() ? WorkflowServiceStubs.newInstance((WorkflowServiceStubsOptions)WorkflowServiceStubsOptions.newBuilder().setTarget(this.testEnvironmentOptions.getTarget()).build()) : WorkflowServiceStubs.newInstance((WorkflowServiceGrpc.WorkflowServiceImplBase)this.service, (WorkflowServiceStubsOptions)WorkflowServiceStubsOptions.newBuilder().setMetricsScope(options.getMetricsScope()).setDisableHealthCheck(true).build());
        WorkflowClient client = WorkflowClient.newInstance((WorkflowServiceStubs)this.workflowServiceStubs, (WorkflowClientOptions)this.workflowClientOptions);
        this.workerFactory = WorkerFactory.newInstance((WorkflowClient)client, (WorkerFactoryOptions)options.getWorkerFactoryOptions());
    }

    @Override
    public Worker newWorker(String taskQueue) {
        Worker result = this.workerFactory.newWorker(taskQueue, WorkerOptions.getDefaultInstance());
        return result;
    }

    @Override
    public Worker newWorker(String taskQueue, WorkerOptions options) {
        Worker result = this.workerFactory.newWorker(taskQueue, options);
        return result;
    }

    @Override
    public WorkflowClient getWorkflowClient() {
        WorkflowClientOptions options = WorkflowClientOptions.newBuilder((WorkflowClientOptions)this.workflowClientOptions).setInterceptors((WorkflowClientInterceptor[])ObjectArrays.concat((Object[])this.workflowClientOptions.getInterceptors(), (Object)((Object)this.timeLockingInterceptor))).build();
        return WorkflowClientInternal.newInstance((WorkflowServiceStubs)this.workflowServiceStubs, (WorkflowClientOptions)options);
    }

    @Override
    public long currentTimeMillis() {
        return this.service.currentTimeMillis();
    }

    @Override
    public void sleep(Duration duration) {
        this.service.sleep(duration);
    }

    @Override
    public void registerDelayedCallback(Duration delay, Runnable r) {
        this.service.registerDelayedCallback(delay, r);
    }

    @Override
    public WorkflowServiceStubs getWorkflowService() {
        return this.workflowServiceStubs;
    }

    @Override
    public String getNamespace() {
        return this.workflowClientOptions.getNamespace();
    }

    @Override
    public String getDiagnostics() {
        StringBuilder result = new StringBuilder();
        this.service.getDiagnostics(result);
        return result.toString();
    }

    @Override
    public void close() {
        this.workerFactory.shutdownNow();
        this.workerFactory.awaitTermination(10L, TimeUnit.SECONDS);
        this.service.close();
        if (Boolean.parseBoolean(System.getenv("USE_DOCKER_SERVICE"))) {
            this.workflowServiceStubs.shutdown();
        } else {
            this.workflowServiceStubs.shutdownNow();
        }
        this.workflowServiceStubs.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Override
    public void start() {
        this.workerFactory.start();
    }

    @Override
    public boolean isStarted() {
        return this.workerFactory.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.workerFactory.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.workerFactory.isTerminated();
    }

    @Override
    public void shutdown() {
        this.workerFactory.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.workerFactory.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.workerFactory.awaitTermination(timeout, unit);
    }

    @Override
    public WorkerFactory getWorkerFactory() {
        return this.workerFactory;
    }

    private static class TimeLockingInterceptor
    extends WorkflowClientInterceptorBase {
        private final IdempotentLocker locker;
        private static final Logger log = LoggerFactory.getLogger(IdempotentLocker.class);

        TimeLockingInterceptor(TestWorkflowService service) {
            this.locker = new IdempotentLocker(service);
        }

        @Deprecated
        public WorkflowStub newUntypedWorkflowStub(String workflowType, WorkflowOptions options, WorkflowStub next) {
            return new TimeLockingWorkflowStub(this.locker, next);
        }

        @Deprecated
        public WorkflowStub newUntypedWorkflowStub(WorkflowExecution execution, Optional<String> workflowType, WorkflowStub next) {
            return new TimeLockingWorkflowStub(this.locker, next);
        }

        public ActivityCompletionClient newActivityCompletionClient(ActivityCompletionClient next) {
            return next;
        }

        private static class TimeLockingWorkflowStub
        implements WorkflowStub {
            private final IdempotentLocker locker;
            private final WorkflowStub next;

            TimeLockingWorkflowStub(IdempotentLocker locker, WorkflowStub next) {
                this.locker = locker;
                this.next = next;
            }

            public void signal(String signalName, Object ... args) {
                this.next.signal(signalName, args);
            }

            public WorkflowExecution start(Object ... args) {
                return this.next.start(args);
            }

            public WorkflowExecution signalWithStart(String signalName, Object[] signalArgs, Object[] startArgs) {
                return this.next.signalWithStart(signalName, signalArgs, startArgs);
            }

            public Optional<String> getWorkflowType() {
                return this.next.getWorkflowType();
            }

            public WorkflowExecution getExecution() {
                return this.next.getExecution();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <R> R getResult(Class<R> resultClass, Type resultType) {
                this.locker.unlockTimeSkipping("TimeLockingWorkflowStub getResult");
                try {
                    Object object = this.next.getResult(resultClass, resultType);
                    return (R)object;
                }
                finally {
                    this.locker.lockTimeSkipping("TimeLockingWorkflowStub getResult");
                }
            }

            public <R> R getResult(Class<R> resultClass) {
                this.locker.unlockTimeSkipping("TimeLockingWorkflowStub getResult");
                try {
                    Object object = this.next.getResult(resultClass);
                    return (R)object;
                }
                finally {
                    this.locker.lockTimeSkipping("TimeLockingWorkflowStub getResult");
                }
            }

            public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass, Type resultType) {
                return new TimeLockingFuture(this.next.getResultAsync(resultClass, resultType));
            }

            public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass) {
                return new TimeLockingFuture(this.next.getResultAsync(resultClass));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) throws TimeoutException {
                this.locker.unlockTimeSkipping("TimeLockingWorkflowStub getResult");
                try {
                    Object object = this.next.getResult(timeout, unit, resultClass, resultType);
                    return (R)object;
                }
                finally {
                    this.locker.lockTimeSkipping("TimeLockingWorkflowStub getResult");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass) throws TimeoutException {
                this.locker.unlockTimeSkipping("TimeLockingWorkflowStub getResult");
                try {
                    Object object = this.next.getResult(timeout, unit, resultClass);
                    return (R)object;
                }
                finally {
                    this.locker.lockTimeSkipping("TimeLockingWorkflowStub getResult");
                }
            }

            public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) {
                return new TimeLockingFuture(this.next.getResultAsync(timeout, unit, resultClass, resultType));
            }

            public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass) {
                return new TimeLockingFuture(this.next.getResultAsync(timeout, unit, resultClass));
            }

            public <R> R query(String queryType, Class<R> resultClass, Object ... args) {
                return (R)this.next.query(queryType, resultClass, args);
            }

            public <R> R query(String queryType, Class<R> resultClass, Type resultType, Object ... args) {
                return (R)this.next.query(queryType, resultClass, resultType, args);
            }

            public void cancel() {
                this.next.cancel();
            }

            public void terminate(String reason, Object ... details) {
                this.next.terminate(reason, details);
            }

            public Optional<WorkflowOptions> getOptions() {
                return this.next.getOptions();
            }

            private class TimeLockingFuture<R>
            extends CompletableFuture<R> {
                public TimeLockingFuture(CompletableFuture<R> resultAsync) {
                    CompletionStage ignored = resultAsync.whenComplete((T r, U e) -> {
                        TimeLockingWorkflowStub.this.locker.lockTimeSkipping("TimeLockingWorkflowStub TimeLockingFuture constructor");
                        if (e == null) {
                            this.complete(r);
                        } else {
                            this.completeExceptionally((Throwable)e);
                        }
                    });
                }

                @Override
                public R get() throws InterruptedException, ExecutionException {
                    TimeLockingWorkflowStub.this.locker.unlockTimeSkipping("TimeLockingWorkflowStub TimeLockingFuture get");
                    try {
                        Object t = super.get();
                        return (R)t;
                    }
                    finally {
                        TimeLockingWorkflowStub.this.locker.lockTimeSkipping("TimeLockingWorkflowStub TimeLockingFuture get");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    TimeLockingWorkflowStub.this.locker.unlockTimeSkipping("TimeLockingWorkflowStub TimeLockingFuture get");
                    try {
                        Object t = super.get(timeout, unit);
                        return (R)t;
                    }
                    finally {
                        TimeLockingWorkflowStub.this.locker.lockTimeSkipping("TimeLockingWorkflowStub TimeLockingFuture get");
                    }
                }

                @Override
                public R join() {
                    TimeLockingWorkflowStub.this.locker.unlockTimeSkipping("TimeLockingWorkflowStub TimeLockingFuture join");
                    return (R)super.join();
                }
            }
        }

        private static class IdempotentLocker {
            private final TestWorkflowService store;
            private final AtomicInteger count = new AtomicInteger(1);

            private IdempotentLocker(TestWorkflowService store) {
                this.store = store;
            }

            public void lockTimeSkipping(String caller) {
                if (this.count.incrementAndGet() == 1) {
                    this.store.lockTimeSkipping(caller);
                }
            }

            public void unlockTimeSkipping(String caller) {
                if (this.count.decrementAndGet() == 0) {
                    this.store.unlockTimeSkipping(caller);
                }
            }
        }
    }
}

