/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.DummySyncWorkflowContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class DeterministicRunnerWrapper
implements InvocationHandler {
    private final InvocationHandler invocationHandler;
    private final ExecutorService executorService;

    public DeterministicRunnerWrapper(InvocationHandler invocationHandler, ExecutorService executorService) {
        this.invocationHandler = Objects.requireNonNull(invocationHandler);
        this.executorService = Objects.requireNonNull(executorService);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CompletableFuture result = new CompletableFuture();
        DeterministicRunnerImpl runner = new DeterministicRunnerImpl(this.executorService, DummySyncWorkflowContext.newDummySyncWorkflowContext(), () -> {
            try {
                result.complete(this.invocationHandler.invoke(proxy, method, args));
            }
            catch (Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        });
        runner.runUntilAllBlocked(Long.MAX_VALUE);
        try {
            return result.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

