/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.collect.ObjectArrays;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.testing.TestWorkflowEnvironment;
import io.temporal.testing.WorkflowHistoryLoader;
import io.temporal.worker.Worker;
import java.io.File;

public final class WorkflowReplayer {
    public static void replayWorkflowExecutionFromResource(String resourceName, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowHistoryLoader.readHistoryFromResource(resourceName);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecutionFromResource(String resourceName, Worker worker) throws Exception {
        WorkflowExecutionHistory history = WorkflowHistoryLoader.readHistoryFromResource(resourceName);
        WorkflowReplayer.replayWorkflowExecution(history, worker);
    }

    public static void replayWorkflowExecutionFromResource(String resourceName, TestWorkflowEnvironment testWorkflowEnvironment, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowHistoryLoader.readHistoryFromResource(resourceName);
        WorkflowReplayer.replayWorkflowExecution(history, testWorkflowEnvironment, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(File historyFile, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowHistoryLoader.readHistory(historyFile);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(String jsonSerializedHistory, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson((String)jsonSerializedHistory);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replayWorkflowExecution(WorkflowExecutionHistory history, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        try (TestWorkflowEnvironment testEnv = TestWorkflowEnvironment.newInstance();){
            WorkflowReplayer.replayWorkflowExecution(history, testEnv, workflowClass, moreWorkflowClasses);
        }
    }

    public static void replayWorkflowExecution(WorkflowExecutionHistory history, TestWorkflowEnvironment testWorkflowEnvironment, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        Worker worker = testWorkflowEnvironment.newWorker(WorkflowReplayer.getQueueName(history));
        worker.registerWorkflowImplementationTypes((Class[])ObjectArrays.concat((Object[])moreWorkflowClasses, workflowClass));
        WorkflowReplayer.replayWorkflowExecution(history, worker);
    }

    public static void replayWorkflowExecution(WorkflowExecutionHistory history, Worker worker) throws Exception {
        worker.replayWorkflowExecution(history);
    }

    private static String getQueueName(WorkflowExecutionHistory history) {
        WorkflowExecutionStartedEventAttributes attr = ((HistoryEvent)history.getEvents().get(0)).getWorkflowExecutionStartedEventAttributes();
        TaskQueue taskQueue = attr.getTaskQueue();
        return taskQueue.getName();
    }
}

