/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.util.concurrent.Uninterruptibles;
import io.temporal.internal.testservice.LockHandle;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.workflow.Functions;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SelfAdvancingTimerImpl
implements SelfAdvancingTimer {
    private static final Logger log = LoggerFactory.getLogger(SelfAdvancingTimerImpl.class);
    private final LongSupplier clock = () -> {
        long timeMillis = this.currentTimeMillis();
        return timeMillis;
    };
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), r -> new Thread(r, "Timer task"));
    private long currentTime;
    private int lockCount;
    private long timeLastLocked = -1L;
    private long systemTimeLastLocked = -1L;
    private boolean emptyQueue = true;
    private final LinkedList<LockEvent> lockEvents = new LinkedList();
    private final PriorityQueue<TimerTask> tasks = new PriorityQueue<TimerTask>(Comparator.comparing(TimerTask::getExecutionTime));
    private final Thread timerPump = new Thread((Runnable)new TimerPump(), "SelfAdvancingTimer Pump");
    private LockHandle timeLockOnEmptyQueueHandle;

    public SelfAdvancingTimerImpl(long initialTime) {
        this.currentTime = initialTime == 0L ? System.currentTimeMillis() : initialTime;
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.timeLockOnEmptyQueueHandle = this.lockTimeSkipping("SelfAdvancingTimerImpl constructor empty-queue");
        this.timerPump.start();
    }

    private void updateTimeLocked() {
        if (this.lockCount > 0) {
            if (this.timeLastLocked < 0L || this.systemTimeLastLocked < 0L) {
                throw new IllegalStateException("Invalid timeLastLocked or systemTimeLastLocked");
            }
            this.currentTime = this.timeLastLocked + (System.currentTimeMillis() - this.systemTimeLastLocked);
        } else {
            TimerTask task = this.tasks.peek();
            if (task != null && !task.isCanceled() && task.getExecutionTime() > this.currentTime) {
                this.currentTime = task.getExecutionTime();
                log.trace("Jumping to the time of the next timer task: " + this.currentTime);
            }
        }
    }

    private long currentTimeMillis() {
        this.lock.lock();
        try {
            this.updateTimeLocked();
            long l = this.currentTime;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Functions.Proc schedule(Duration delay, Runnable task) {
        return this.schedule(delay, task, "unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Functions.Proc schedule(Duration delay, Runnable task, String taskInfo) {
        this.lock.lock();
        try {
            long executionTime = delay.toMillis() + this.currentTime;
            TimerTask timerTask = new TimerTask(executionTime, task, taskInfo);
            Functions.Proc & Serializable cancellationHandle = (Functions.Proc & Serializable)() -> timerTask.cancel();
            this.tasks.add(timerTask);
            if (this.tasks.size() == 1 && this.emptyQueue) {
                if (this.timeLockOnEmptyQueueHandle == null) {
                    throw new IllegalStateException("SelfAdvancingTimerImpl should take a lock and get a handle when queue is empty, but handle is null");
                }
                this.timeLockOnEmptyQueueHandle.unlock("SelfAdvancingTimerImpl schedule non-empty-queue, task: " + taskInfo);
                this.timeLockOnEmptyQueueHandle = null;
                this.emptyQueue = false;
            }
            this.condition.signal();
            Functions.Proc & Serializable intersect = cancellationHandle;
            return intersect;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public LongSupplier getClock() {
        return this.clock;
    }

    @Override
    public LockHandle lockTimeSkipping(String caller) {
        this.lock.lock();
        try {
            LockHandle lockHandle = this.lockTimeSkippingLocked(caller);
            return lockHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    private LockHandle lockTimeSkippingLocked(String caller) {
        if (this.lockCount++ == 0) {
            this.timeLastLocked = this.currentTime;
            this.systemTimeLastLocked = System.currentTimeMillis();
        }
        LockEvent event = new LockEvent(caller, LockEventType.LOCK);
        this.lockEvents.add(event);
        return new TimerLockHandle(event);
    }

    @Override
    public void unlockTimeSkipping(String caller) {
        this.lock.lock();
        try {
            this.unlockTimeSkippingLocked(caller);
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLocks(List<RequestContext.TimerLockChange> updates) {
        this.lock.lock();
        try {
            for (RequestContext.TimerLockChange update : updates) {
                if (update.getChange() == 1) {
                    this.lockTimeSkippingLocked(update.getCaller());
                    continue;
                }
                this.unlockTimeSkippingLocked(update.getCaller());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDiagnostics(StringBuilder result) {
        result.append("Self Advancing Timer Lock Events:\n");
        this.lock.lock();
        try {
            int lockCount = 0;
            for (LockEvent event : this.lockEvents) {
                lockCount = event.lockType == LockEventType.LOCK ? ++lockCount : --lockCount;
                String indent = new String(new char[lockCount * 2]).replace("\u0000", " ");
                result.append(new Timestamp(event.timestamp)).append("\t").append((Object)event.lockType).append("\t").append(indent).append(lockCount).append("\t").append(event.caller).append("\n");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        this.timerPump.interrupt();
        Uninterruptibles.joinUninterruptibly((Thread)this.timerPump);
    }

    private void unlockTimeSkippingLocked(String caller) {
        this.unlockTimeSkippingLockedInternal();
        this.lockEvents.add(new LockEvent(caller, LockEventType.UNLOCK));
    }

    private void unlockTimeSkippingLockedInternal() {
        if (this.lockCount == 0) {
            throw new IllegalStateException("Unbalanced lock and unlock calls: \n" + this.getDiagnostics());
        }
        --this.lockCount;
        if (this.lockCount == 0) {
            this.timeLastLocked = -1L;
            this.systemTimeLastLocked = -1L;
        }
    }

    private String getDiagnostics() {
        StringBuilder result = new StringBuilder();
        this.getDiagnostics(result);
        return result.toString();
    }

    private class TimerLockHandle
    implements LockHandle {
        private final LockEvent event;

        public TimerLockHandle(LockEvent event) {
            this.event = event;
        }

        @Override
        public void unlock() {
            this.unlock(null);
        }

        @Override
        public void unlock(String caller) {
            SelfAdvancingTimerImpl.this.lock.lock();
            try {
                this.unlockFromHandleLocked();
                SelfAdvancingTimerImpl.this.condition.signal();
            }
            finally {
                SelfAdvancingTimerImpl.this.lock.unlock();
            }
        }

        private void unlockFromHandleLocked() {
            boolean removed = SelfAdvancingTimerImpl.this.lockEvents.remove(this.event);
            if (!removed) {
                throw new IllegalStateException("Unbalanced lock and unlock calls");
            }
            SelfAdvancingTimerImpl.this.unlockTimeSkippingLockedInternal();
        }
    }

    private static enum LockEventType {
        LOCK,
        UNLOCK;


        public String toString() {
            return this == LOCK ? "L" : "U";
        }
    }

    private static class LockEvent {
        String caller;
        LockEventType lockType;
        long timestamp;

        public LockEvent(String caller, LockEventType lockType) {
            this.caller = caller;
            this.lockType = lockType;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private class TimerPump
    implements Runnable {
        private TimerPump() {
        }

        @Override
        public void run() {
            SelfAdvancingTimerImpl.this.lock.lock();
            try {
                this.runLocked();
            }
            catch (RuntimeException e) {
                log.error("Timer pump failed", (Throwable)e);
            }
            finally {
                SelfAdvancingTimerImpl.this.lock.unlock();
            }
        }

        private void runLocked() {
            while (!Thread.currentThread().isInterrupted()) {
                TimerTask peekedTask;
                SelfAdvancingTimerImpl.this.updateTimeLocked();
                if (!SelfAdvancingTimerImpl.this.emptyQueue && SelfAdvancingTimerImpl.this.tasks.isEmpty()) {
                    if (SelfAdvancingTimerImpl.this.timeLockOnEmptyQueueHandle != null) {
                        throw new IllegalStateException("SelfAdvancingTimerImpl should have no taken time lock when queue is not empty, but handle is not null");
                    }
                    SelfAdvancingTimerImpl.this.timeLockOnEmptyQueueHandle = SelfAdvancingTimerImpl.this.lockTimeSkippingLocked("SelfAdvancingTimerImpl runLocked empty-queue");
                    SelfAdvancingTimerImpl.this.emptyQueue = true;
                }
                if ((peekedTask = (TimerTask)SelfAdvancingTimerImpl.this.tasks.peek()) != null) {
                    log.trace("peekedTask=" + peekedTask.getTaskInfo() + ", executionTime=" + peekedTask.getExecutionTime() + ", canceled=" + peekedTask.isCanceled());
                }
                if (peekedTask != null && peekedTask.getExecutionTime() <= SelfAdvancingTimerImpl.this.currentTime) {
                    try {
                        LockHandle lockHandle = SelfAdvancingTimerImpl.this.lockTimeSkippingLocked("runnable " + peekedTask.getTaskInfo());
                        TimerTask polledTask = (TimerTask)SelfAdvancingTimerImpl.this.tasks.poll();
                        log.trace("running task=" + peekedTask.getTaskInfo() + ", executionTime=" + peekedTask.getExecutionTime());
                        if (polledTask.isCanceled()) continue;
                        Runnable runnable = polledTask.getRunnable();
                        SelfAdvancingTimerImpl.this.executor.execute(() -> {
                            try {
                                runnable.run();
                            }
                            catch (Throwable e) {
                                log.error("Unexpected failure in timer callback", e);
                            }
                            finally {
                                lockHandle.unlock();
                            }
                        });
                    }
                    catch (RuntimeException e) {
                        log.error("Timer task failure", (Throwable)e);
                    }
                    continue;
                }
                long timeToAwait = peekedTask == null ? Long.MAX_VALUE : peekedTask.getExecutionTime() - SelfAdvancingTimerImpl.this.currentTime;
                try {
                    SelfAdvancingTimerImpl.this.condition.await(timeToAwait, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    private static class TimerTask {
        private final long executionTime;
        private final Runnable runnable;
        private final String taskInfo;
        private boolean canceled;

        TimerTask(long executionTime, Runnable runnable, String taskInfo) {
            this.executionTime = executionTime;
            this.runnable = runnable;
            this.taskInfo = taskInfo;
        }

        long getExecutionTime() {
            return this.executionTime;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        String getTaskInfo() {
            return this.taskInfo;
        }

        public String toString() {
            return "TimerTask{executionTime=" + this.executionTime + '}';
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

