/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.annotations.VisibleForTesting;
import io.temporal.client.WorkflowClient;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.testing.TestWorkflowEnvironmentInternal;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerOptions;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

@VisibleForTesting
public interface TestWorkflowEnvironment {
    public static TestWorkflowEnvironment newInstance() {
        return new TestWorkflowEnvironmentInternal(TestEnvironmentOptions.getDefaultInstance());
    }

    public static TestWorkflowEnvironment newInstance(TestEnvironmentOptions options) {
        return new TestWorkflowEnvironmentInternal(options);
    }

    public Worker newWorker(String var1);

    public Worker newWorker(String var1, WorkerOptions var2);

    public WorkflowClient getWorkflowClient();

    public long currentTimeMillis();

    public void sleep(Duration var1);

    public void registerDelayedCallback(Duration var1, Runnable var2);

    public WorkflowServiceStubs getWorkflowService();

    public String getNamespace();

    public String getDiagnostics();

    public void close();

    public WorkerFactory getWorkerFactory();

    public void start();

    public boolean isStarted();

    public boolean isShutdown();

    public boolean isTerminated();

    @Deprecated
    public void shutdownTestService();

    public void shutdown();

    public void shutdownNow();

    public void awaitTermination(long var1, TimeUnit var3);
}

