/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;

public class Signal {
    private final Object signalSync = new Object();
    private boolean signalled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        Object object = this.signalSync;
        synchronized (object) {
            this.signalled = true;
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSignal() {
        Object object = this.signalSync;
        synchronized (object) {
            this.signalled = false;
        }
    }

    public boolean waitForSignal(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.waitForSignal(timeUnit.toMillis(timeout));
    }

    public boolean waitForSignal(long timeout, TemporalUnit timeUnit) throws InterruptedException {
        return this.waitForSignal(Duration.of(timeout, timeUnit).toMillis());
    }

    public boolean waitForSignal(Duration timeout) throws InterruptedException {
        return this.waitForSignal(timeout.toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSignal(long timeoutMs) throws InterruptedException {
        if (!this.isSignalled()) {
            Signal signal = this;
            synchronized (signal) {
                this.wait(timeoutMs);
            }
        }
        return this.isSignalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSignal() throws InterruptedException {
        while (!this.isSignalled()) {
            Signal signal = this;
            synchronized (signal) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSignalled() {
        Object object = this.signalSync;
        synchronized (object) {
            return this.signalled;
        }
    }
}

