/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import io.temporal.common.Experimental;
import io.temporal.common.WorkflowExecutionHistory;
import io.temporal.internal.common.WorkflowExecutionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

@Experimental
public final class WorkflowHistoryLoader {
    private WorkflowHistoryLoader() {
    }

    public static WorkflowExecutionHistory readHistoryFromResource(String resourceFileName) throws IOException {
        ClassLoader classLoader = WorkflowExecutionUtils.class.getClassLoader();
        URL resource = classLoader.getResource(resourceFileName);
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (String)"File %s can't be found", (Object)resourceFileName);
        String historyUrl = resource.getFile();
        File historyFile = new File(historyUrl);
        return WorkflowHistoryLoader.readHistory(historyFile);
    }

    public static WorkflowExecutionHistory readHistory(File historyFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(historyFile.toPath(), StandardCharsets.UTF_8);){
            String jsonHistory = CharStreams.toString((Readable)reader);
            WorkflowExecutionHistory workflowExecutionHistory = WorkflowExecutionHistory.fromJson((String)jsonHistory);
            return workflowExecutionHistory;
        }
    }
}

