/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.api.history.v1.History;
import io.temporal.api.nexus.v1.Endpoint;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.common.SearchAttributeKey;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.internal.common.env.DebugModeUtils;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.testing.TestWorkflowEnvironment;
import io.temporal.testing.internal.TestServiceUtils;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestWorkflowRule
implements TestRule {
    private final String namespace;
    private final boolean useExternalService;
    private final boolean doNotStart;
    private final boolean doNotSetupNexusEndpoint;
    @Nullable
    private final Timeout globalTimeout;
    private final Class<?>[] workflowTypes;
    private final Object[] activityImplementations;
    private final Object[] nexusServiceImplementations;
    private final WorkflowServiceStubsOptions serviceStubsOptions;
    private final WorkflowClientOptions clientOptions;
    private final WorkerFactoryOptions workerFactoryOptions;
    private final WorkflowImplementationOptions workflowImplementationOptions;
    private final WorkerOptions workerOptions;
    private final String target;
    private final boolean useTimeskipping;
    private final Scope metricsScope;
    @Nonnull
    private final Map<String, IndexedValueType> searchAttributes;
    private String taskQueue;
    private String nexusEndpointName;
    private Endpoint nexusEndpoint;
    private final TestWorkflowEnvironment testEnvironment;
    private final TestWatcher watchman = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            System.err.println("WORKFLOW EXECUTION HISTORIES:\n" + TestWorkflowRule.this.testEnvironment.getDiagnostics());
        }
    };

    private TestWorkflowRule(Builder builder) {
        this.doNotStart = builder.doNotStart;
        this.doNotSetupNexusEndpoint = builder.doNotSetupNexusEndpoint;
        this.useExternalService = builder.useExternalService;
        this.namespace = builder.namespace == null ? "UnitTest" : builder.namespace;
        this.workflowTypes = builder.workflowTypes == null ? new Class[]{} : builder.workflowTypes;
        this.activityImplementations = builder.activityImplementations == null ? new Object[]{} : builder.activityImplementations;
        this.nexusServiceImplementations = builder.nexusServiceImplementations == null ? new Object[]{} : builder.nexusServiceImplementations;
        this.serviceStubsOptions = builder.workflowServiceStubsOptions == null ? WorkflowServiceStubsOptions.newBuilder().build() : builder.workflowServiceStubsOptions;
        this.clientOptions = builder.workflowClientOptions == null ? WorkflowClientOptions.newBuilder().setNamespace(this.namespace).build() : builder.workflowClientOptions.toBuilder().setNamespace(this.namespace).build();
        this.workerOptions = builder.workerOptions == null ? WorkerOptions.newBuilder().build() : builder.workerOptions;
        this.workerFactoryOptions = builder.workerFactoryOptions == null ? WorkerFactoryOptions.newBuilder().build() : builder.workerFactoryOptions;
        this.workflowImplementationOptions = builder.workflowImplementationOptions == null ? WorkflowImplementationOptions.newBuilder().build() : builder.workflowImplementationOptions;
        this.globalTimeout = !DebugModeUtils.isTemporalDebugModeOn() && builder.testTimeoutSeconds != 0L ? Timeout.seconds((long)builder.testTimeoutSeconds) : null;
        this.target = builder.target;
        this.useTimeskipping = builder.useTimeskipping;
        this.metricsScope = builder.metricsScope;
        this.searchAttributes = builder.searchAttributes;
        this.testEnvironment = TestWorkflowEnvironment.newInstance(this.createTestEnvOptions(builder.initialTimeMillis));
    }

    protected TestEnvironmentOptions createTestEnvOptions(long initialTimeMillis) {
        return TestEnvironmentOptions.newBuilder().setWorkflowServiceStubsOptions(this.serviceStubsOptions).setWorkflowClientOptions(this.clientOptions).setWorkerFactoryOptions(this.workerFactoryOptions).setUseExternalService(this.useExternalService).setUseTimeskipping(this.useTimeskipping).setTarget(this.target).setInitialTimeMillis(initialTimeMillis).setMetricsScope(this.metricsScope).setSearchAttributes(this.searchAttributes).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Statement apply(final Statement base, Description description) {
        boolean timeoutIsOverriddenOnTestAnnotation;
        this.taskQueue = this.init(description);
        Statement testWorkflowStatement = new Statement(){

            public void evaluate() throws Throwable {
                TestWorkflowRule.this.start();
                base.evaluate();
                TestWorkflowRule.this.shutdown();
            }
        };
        Test annotation = (Test)description.getAnnotation(Test.class);
        boolean bl = timeoutIsOverriddenOnTestAnnotation = annotation != null && annotation.timeout() > 0L;
        if (this.globalTimeout != null && !timeoutIsOverriddenOnTestAnnotation) {
            testWorkflowStatement = this.globalTimeout.apply(testWorkflowStatement, description);
        }
        return this.watchman.apply(testWorkflowStatement, description);
    }

    private String init(Description description) {
        String testMethod = description.getMethodName();
        String taskQueue = "WorkflowTest-" + testMethod + "-" + UUID.randomUUID();
        this.nexusEndpointName = String.format("WorkflowTestNexusEndpoint-%s", UUID.randomUUID());
        Worker worker = this.testEnvironment.newWorker(taskQueue, this.workerOptions);
        WorkflowImplementationOptions workflowImplementationOptions = this.workflowImplementationOptions;
        if (!this.doNotSetupNexusEndpoint) {
            workflowImplementationOptions = TestServiceUtils.applyNexusServiceOptions(workflowImplementationOptions, this.nexusServiceImplementations, this.nexusEndpointName);
        }
        worker.registerWorkflowImplementationTypes(workflowImplementationOptions, (Class[])this.workflowTypes);
        worker.registerActivitiesImplementations(this.activityImplementations);
        worker.registerNexusServiceImplementation(this.nexusServiceImplementations);
        return taskQueue;
    }

    private void start() {
        if (!this.doNotSetupNexusEndpoint && this.nexusServiceImplementations.length > 0) {
            this.nexusEndpoint = this.testEnvironment.createNexusEndpoint(this.nexusEndpointName, this.taskQueue);
        }
        if (!this.doNotStart) {
            this.testEnvironment.start();
        }
    }

    protected void shutdown() {
        if (this.nexusEndpoint != null && !this.testEnvironment.getOperatorServiceStubs().isShutdown()) {
            this.testEnvironment.deleteNexusEndpoint(this.nexusEndpoint);
        }
        this.testEnvironment.close();
    }

    public boolean isUseExternalService() {
        return this.useExternalService;
    }

    public TestWorkflowEnvironment getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public Endpoint getNexusEndpoint() {
        return this.nexusEndpoint;
    }

    public WorkflowClient getWorkflowClient() {
        return this.testEnvironment.getWorkflowClient();
    }

    public WorkflowServiceStubs getWorkflowServiceStubs() {
        return this.testEnvironment.getWorkflowServiceStubs();
    }

    public WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub() {
        return (WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.getWorkflowServiceStubs().blockingStub();
    }

    public <T extends WorkerInterceptor> T getInterceptor(Class<T> type) {
        if (this.workerFactoryOptions.getWorkerInterceptors() != null) {
            for (WorkerInterceptor interceptor : this.workerFactoryOptions.getWorkerInterceptors()) {
                if (!type.isInstance(interceptor)) continue;
                return (T)((WorkerInterceptor)type.cast(interceptor));
            }
        }
        return null;
    }

    @Deprecated
    public History getHistory(@Nonnull WorkflowExecution execution) {
        return this.testEnvironment.getWorkflowExecutionHistory(execution).getHistory();
    }

    @Deprecated
    public History getWorkflowExecutionHistory(WorkflowExecution execution) {
        return this.testEnvironment.getWorkflowExecutionHistory(execution).getHistory();
    }

    public Worker getWorker() {
        return this.testEnvironment.getWorkerFactory().getWorker(this.getTaskQueue());
    }

    public WorkerFactoryOptions getWorkerFactoryOptions() {
        return this.workerFactoryOptions;
    }

    public <T> T newWorkflowStub(Class<T> workflow) {
        return (T)this.getWorkflowClient().newWorkflowStub(workflow, TestWorkflowRule.newWorkflowOptionsForTaskQueue(this.getTaskQueue()));
    }

    public WorkflowStub newUntypedWorkflowStub(String workflow) {
        return this.getWorkflowClient().newUntypedWorkflowStub(workflow, TestWorkflowRule.newWorkflowOptionsForTaskQueue(this.getTaskQueue()));
    }

    private static WorkflowOptions newWorkflowOptionsForTaskQueue(String taskQueue) {
        return WorkflowOptions.newBuilder().setTaskQueue(taskQueue).build();
    }

    public static class Builder {
        private String namespace;
        private String target;
        private boolean useExternalService;
        private boolean doNotStart;
        private boolean doNotSetupNexusEndpoint;
        private long initialTimeMillis;
        private boolean useTimeskipping = TestEnvironmentOptions.getDefaultInstance().isUseTimeskipping();
        private Class<?>[] workflowTypes;
        private Object[] activityImplementations;
        private Object[] nexusServiceImplementations;
        private WorkflowServiceStubsOptions workflowServiceStubsOptions;
        private WorkflowClientOptions workflowClientOptions;
        private WorkerFactoryOptions workerFactoryOptions;
        private WorkflowImplementationOptions workflowImplementationOptions;
        private WorkerOptions workerOptions;
        private long testTimeoutSeconds;
        @Nonnull
        private final Map<String, IndexedValueType> searchAttributes = new HashMap<String, IndexedValueType>();
        private Scope metricsScope;

        protected Builder() {
        }

        public Builder setWorkerOptions(WorkerOptions options) {
            this.workerOptions = options;
            return this;
        }

        public void setWorkflowServiceStubsOptions(WorkflowServiceStubsOptions workflowServiceStubsOptions) {
            this.workflowServiceStubsOptions = workflowServiceStubsOptions;
        }

        public Builder setWorkflowClientOptions(WorkflowClientOptions workflowClientOptions) {
            this.workflowClientOptions = workflowClientOptions;
            return this;
        }

        public Builder setWorkerFactoryOptions(WorkerFactoryOptions options) {
            this.workerFactoryOptions = options;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setWorkflowTypes(Class<?> ... workflowTypes) {
            this.workflowTypes = workflowTypes;
            return this;
        }

        public Builder setWorkflowTypes(WorkflowImplementationOptions implementationOptions, Class<?> ... workflowTypes) {
            this.workflowImplementationOptions = implementationOptions;
            this.workflowTypes = workflowTypes;
            return this;
        }

        public Builder setNexusServiceImplementation(Object ... nexusServiceImplementations) {
            this.nexusServiceImplementations = nexusServiceImplementations;
            return this;
        }

        public Builder setActivityImplementations(Object ... activityImplementations) {
            this.activityImplementations = activityImplementations;
            return this;
        }

        public Builder setUseExternalService(boolean useExternalService) {
            this.useExternalService = useExternalService;
            return this;
        }

        public Builder setUseTimeskipping(boolean useTimeskipping) {
            this.useTimeskipping = useTimeskipping;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        @Deprecated
        public Builder setTestTimeoutSeconds(long testTimeoutSeconds) {
            this.testTimeoutSeconds = testTimeoutSeconds;
            return this;
        }

        public Builder setInitialTimeMillis(long initialTimeMillis) {
            this.initialTimeMillis = initialTimeMillis;
            return this;
        }

        public Builder setInitialTime(Instant initialTime) {
            this.initialTimeMillis = initialTime.toEpochMilli();
            return this;
        }

        public Builder setDoNotStart(boolean doNotStart) {
            this.doNotStart = doNotStart;
            return this;
        }

        public Builder setDoNotSetupNexusEndpoint(boolean doNotSetupNexusEndpoint) {
            this.doNotSetupNexusEndpoint = doNotSetupNexusEndpoint;
            return this;
        }

        public Builder registerSearchAttribute(String name, IndexedValueType type) {
            this.searchAttributes.put(name, type);
            return this;
        }

        public Builder registerSearchAttribute(SearchAttributeKey<?> key) {
            return this.registerSearchAttribute(key.getName(), key.getValueType());
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public TestWorkflowRule build() {
            return new TestWorkflowRule(this);
        }
    }
}

