/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.Priority;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.sdk.v1.UserMetadata;
import io.temporal.common.RetryOptions;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.statemachines.ExecuteActivityParameters;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.LocalActivityCallback;
import io.temporal.internal.statemachines.StartChildWorkflowExecutionParameters;
import io.temporal.internal.statemachines.StartNexusOperationParameters;
import io.temporal.internal.sync.BaseRootWorkflowInboundCallsInterceptor;
import io.temporal.internal.sync.QueryDispatcher;
import io.temporal.internal.sync.SignalDispatcher;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.UpdateDispatcher;
import io.temporal.workflow.Functions;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DummySyncWorkflowContext {
    public static SyncWorkflowContext newDummySyncWorkflowContext() {
        SyncWorkflowContext context = new SyncWorkflowContext("dummy", WorkflowExecution.newBuilder().setWorkflowId("dummy").setRunId("dummy").build(), null, new SignalDispatcher(DefaultDataConverter.STANDARD_INSTANCE), new QueryDispatcher(DefaultDataConverter.STANDARD_INSTANCE), new UpdateDispatcher(DefaultDataConverter.STANDARD_INSTANCE), null, DefaultDataConverter.STANDARD_INSTANCE, null);
        context.setReplayContext((ReplayWorkflowContext)new DummyReplayWorkflowContext());
        context.initHeadOutboundCallsInterceptor((WorkflowOutboundCallsInterceptor)context);
        context.initHeadInboundCallsInterceptor((WorkflowInboundCallsInterceptor)new BaseRootWorkflowInboundCallsInterceptor(context){

            public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
                throw new UnsupportedOperationException("#execute is not implemented or needed for low level DeterministicRunner tests");
            }
        });
        return context;
    }

    private static final class DummyReplayWorkflowContext
    implements ReplayWorkflowContext {
        private final Timer timer = new Timer();

        private DummyReplayWorkflowContext() {
        }

        public WorkflowExecution getWorkflowExecution() {
            throw new UnsupportedOperationException("not implemented");
        }

        public WorkflowExecution getParentWorkflowExecution() {
            throw new UnsupportedOperationException("not implemented");
        }

        public WorkflowExecution getRootWorkflowExecution() {
            throw new UnsupportedOperationException("not implemented");
        }

        public WorkflowType getWorkflowType() {
            return WorkflowType.newBuilder().setName("dummy-workflow").build();
        }

        public boolean isCancelRequested() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void setCancelRequested() {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean isWorkflowMethodCompleted() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void setWorkflowMethodCompleted() {
            throw new UnsupportedOperationException("not implemented");
        }

        public ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion() {
            throw new UnsupportedOperationException("not implemented");
        }

        public String getTaskQueue() {
            return "dummy-task-queue";
        }

        @Nullable
        public RetryOptions getRetryOptions() {
            return null;
        }

        public String getNamespace() {
            return "dummy-namespace";
        }

        public String getWorkflowId() {
            return "dummy-workflow-id";
        }

        @Nonnull
        public String getRunId() {
            return "dummy-run-id";
        }

        @Nonnull
        public String getFirstExecutionRunId() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Optional<String> getContinuedExecutionRunId() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Nonnull
        public String getOriginalExecutionRunId() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Duration getWorkflowRunTimeout() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Duration getWorkflowExecutionTimeout() {
            return Duration.ZERO;
        }

        public long getRunStartedTimestampMillis() {
            return 0L;
        }

        @Nonnull
        public Duration getWorkflowTaskTimeout() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Payload getMemo(String key) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Nullable
        public SearchAttributes getSearchAttributes() {
            throw new UnsupportedOperationException("not implemented");
        }

        public ReplayWorkflowContext.ScheduleActivityTaskOutput scheduleActivityTask(ExecuteActivityParameters parameters, Functions.Proc2<Optional<Payloads>, Failure> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Functions.Proc scheduleLocalActivityTask(ExecuteLocalActivityParameters parameters, LocalActivityCallback callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Functions.Proc1<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Functions.Proc2<WorkflowExecution, Exception> executionCallback, Functions.Proc2<Optional<Payloads>, Exception> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Functions.Proc1<Exception> startNexusOperation(StartNexusOperationParameters parameters, Functions.Proc2<Optional<String>, Failure> startedCallback, Functions.Proc2<Optional<Payload>, Failure> completionCallback) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Functions.Proc1<Exception> signalExternalWorkflowExecution(SignalExternalWorkflowExecutionCommandAttributes.Builder attributes, Functions.Proc2<Void, Failure> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void requestCancelExternalWorkflowExecution(WorkflowExecution execution, @Nullable String reason, Functions.Proc2<Void, RuntimeException> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes attributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Throwable getWorkflowTaskFailure() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void failWorkflowTask(Throwable failure) {
            throw new UnsupportedOperationException("not implemented");
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        public Functions.Proc1<RuntimeException> newTimer(Duration delay, UserMetadata metadata, final Functions.Proc1<RuntimeException> callback) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    callback.apply(null);
                }
            }, delay.toMillis());
            return (Functions.Proc1 & Serializable)e -> callback.apply((Object)new CanceledFailure(null));
        }

        public void sideEffect(Functions.Func<Optional<Payloads>> func, UserMetadata userMetadata, Functions.Proc1<Optional<Payloads>> callback) {
            callback.apply((Object)((Optional)func.apply()));
        }

        public void mutableSideEffect(String id, UserMetadata userMetadata, Functions.Func1<Optional<Payloads>, Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
            callback.apply((Object)((Optional)func.apply(Optional.empty())));
        }

        public boolean isReplaying() {
            return false;
        }

        public Integer getVersion(String changeId, int minSupported, int maxSupported, Functions.Proc2<Integer, RuntimeException> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Random newRandom() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Scope getMetricsScope() {
            return new NoopScope();
        }

        public boolean getEnableLoggingInReplay() {
            return false;
        }

        public UUID randomUUID() {
            return UUID.randomUUID();
        }

        public void upsertSearchAttributes(@Nonnull SearchAttributes searchAttributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void upsertMemo(Memo memo) {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean tryUseSdkFlag(SdkFlag flag) {
            return false;
        }

        public boolean checkSdkFlag(SdkFlag flag) {
            return false;
        }

        public Optional<String> getCurrentBuildId() {
            return Optional.empty();
        }

        public Priority getPriority() {
            return null;
        }

        public int getAttempt() {
            return 1;
        }

        public String getCronSchedule() {
            return "dummy-cron-schedule";
        }

        @Nullable
        public Payloads getLastCompletionResult() {
            return null;
        }

        @Nullable
        public Failure getPreviousRunFailure() {
            return null;
        }

        @Nullable
        public String getFullReplayDirectQueryName() {
            return null;
        }

        public Map<String, Payload> getHeader() {
            return null;
        }

        public long getLastWorkflowTaskStartedEventId() {
            return 0L;
        }

        public long getHistorySize() {
            return 0L;
        }

        public boolean isContinueAsNewSuggested() {
            return false;
        }
    }
}

