/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing.internal;

import com.uber.m3.tally.Scope;
import io.nexusrpc.OperationException;
import io.nexusrpc.handler.OperationContext;
import io.temporal.activity.ActivityExecutionContext;
import io.temporal.client.ActivityCompletionException;
import io.temporal.common.SearchAttributeUpdate;
import io.temporal.common.interceptors.ActivityExecutionContextBase;
import io.temporal.common.interceptors.ActivityInboundCallsInterceptor;
import io.temporal.common.interceptors.NexusOperationInboundCallsInterceptor;
import io.temporal.common.interceptors.NexusOperationOutboundCallsInterceptor;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptorBase;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.workflow.Functions;
import io.temporal.workflow.MutableSideEffectOptions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.SideEffectOptions;
import io.temporal.workflow.TimerOptions;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import io.temporal.workflow.unsafe.WorkflowUnsafe;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingWorkerInterceptor
implements WorkerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TracingWorkerInterceptor.class);
    private final FilteredTrace trace;
    private List<String> expected;

    public TracingWorkerInterceptor(FilteredTrace trace) {
        this.trace = trace;
    }

    public String getTrace() {
        return String.join((CharSequence)"\n", this.trace.getImpl());
    }

    public void setExpected(String ... expected) {
        this.expected = Arrays.asList(expected);
    }

    public void assertExpected() {
        if (this.expected != null) {
            List<String> traceElements = this.trace.getImpl();
            for (int i = 0; i < traceElements.size(); ++i) {
                String t = traceElements.get(i);
                String expectedRegExp = this.expected.size() <= i ? "" : this.expected.get(i);
                Assert.assertTrue((String)(t + " doesn't match " + expectedRegExp + ": \n expected=\n" + String.join((CharSequence)"\n", this.expected) + "\n actual=\n" + String.join((CharSequence)"\n", traceElements) + "\n"), (boolean)t.matches(expectedRegExp));
            }
        }
    }

    public WorkflowInboundCallsInterceptor interceptWorkflow(final WorkflowInboundCallsInterceptor next) {
        if (!WorkflowUnsafe.isReplaying()) {
            this.trace.add("interceptExecuteWorkflow " + Workflow.getInfo().getWorkflowId());
        }
        return new WorkflowInboundCallsInterceptorBase(next){

            public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
                next.init((WorkflowOutboundCallsInterceptor)new TracingWorkflowOutboundCallsInterceptor(TracingWorkerInterceptor.this.trace, outboundCalls));
            }

            public void handleSignal(WorkflowInboundCallsInterceptor.SignalInput input) {
                TracingWorkerInterceptor.this.trace.add("handleSignal " + input.getSignalName());
                super.handleSignal(input);
            }

            public WorkflowInboundCallsInterceptor.QueryOutput handleQuery(WorkflowInboundCallsInterceptor.QueryInput input) {
                TracingWorkerInterceptor.this.trace.add("handleQuery " + input.getQueryName());
                return super.handleQuery(input);
            }

            @Nonnull
            public Object newWorkflowMethodThread(Runnable runnable, String name) {
                if (!WorkflowUnsafe.isReplaying()) {
                    if (name.startsWith("workflow-method")) {
                        TracingWorkerInterceptor.this.trace.add("newThread workflow-method");
                    } else {
                        TracingWorkerInterceptor.this.trace.add("newThread " + name);
                    }
                }
                return next.newWorkflowMethodThread(runnable, name);
            }
        };
    }

    public ActivityInboundCallsInterceptor interceptActivity(ActivityInboundCallsInterceptor next) {
        return new TracingActivityInboundCallsInterceptor(this.trace, next);
    }

    public NexusOperationInboundCallsInterceptor interceptNexusOperation(OperationContext context, NexusOperationInboundCallsInterceptor next) {
        return new TracingNexusOperationInboundCallsInterceptor(this.trace, next);
    }

    private static class TracingNexusOperationInboundCallsInterceptor
    implements NexusOperationInboundCallsInterceptor {
        private final NexusOperationInboundCallsInterceptor next;
        private final FilteredTrace trace;

        public TracingNexusOperationInboundCallsInterceptor(FilteredTrace trace, NexusOperationInboundCallsInterceptor next) {
            this.trace = trace;
            this.next = next;
        }

        public void init(NexusOperationOutboundCallsInterceptor outboundCalls) {
            this.next.init(outboundCalls);
        }

        public NexusOperationInboundCallsInterceptor.StartOperationOutput startOperation(NexusOperationInboundCallsInterceptor.StartOperationInput input) throws OperationException {
            this.trace.add("startNexusOperation " + input.getOperationContext().getService() + " " + input.getOperationContext().getOperation());
            return this.next.startOperation(input);
        }

        public NexusOperationInboundCallsInterceptor.CancelOperationOutput cancelOperation(NexusOperationInboundCallsInterceptor.CancelOperationInput input) {
            this.trace.add("cancelNexusOperation " + input.getOperationContext().getService() + " " + input.getOperationContext().getOperation());
            return this.next.cancelOperation(input);
        }
    }

    private static class TracingActivityInboundCallsInterceptor
    implements ActivityInboundCallsInterceptor {
        private final FilteredTrace trace;
        private final ActivityInboundCallsInterceptor next;
        private String type;
        private boolean local;

        public TracingActivityInboundCallsInterceptor(FilteredTrace trace, ActivityInboundCallsInterceptor next) {
            this.trace = trace;
            this.next = next;
        }

        public void init(ActivityExecutionContext context) {
            this.type = context.getInfo().getActivityType();
            this.local = context.getInfo().isLocal();
            this.next.init((ActivityExecutionContext)new ActivityExecutionContextBase(context){

                public <V> void heartbeat(V details) throws ActivityCompletionException {
                    trace.add("heartbeat " + details);
                    super.heartbeat(details);
                }
            });
        }

        public ActivityInboundCallsInterceptor.ActivityOutput execute(ActivityInboundCallsInterceptor.ActivityInput input) {
            this.trace.add((this.local ? "local " : "") + "activity " + this.type);
            return this.next.execute(input);
        }
    }

    static class TracingWorkflowOutboundCallsInterceptor
    implements WorkflowOutboundCallsInterceptor {
        private final FilteredTrace trace;
        private final WorkflowOutboundCallsInterceptor next;

        private TracingWorkflowOutboundCallsInterceptor(FilteredTrace trace, WorkflowOutboundCallsInterceptor next) {
            WorkflowInfo workflowInfo = Workflow.getInfo();
            Assert.assertNotNull((Object)workflowInfo);
            this.trace = trace;
            this.next = Objects.requireNonNull(next);
        }

        public <R> WorkflowOutboundCallsInterceptor.ActivityOutput<R> executeActivity(WorkflowOutboundCallsInterceptor.ActivityInput<R> input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("executeActivity " + input.getActivityName());
            }
            return this.next.executeActivity(input);
        }

        public <R> WorkflowOutboundCallsInterceptor.LocalActivityOutput<R> executeLocalActivity(WorkflowOutboundCallsInterceptor.LocalActivityInput<R> input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("executeLocalActivity " + input.getActivityName());
            }
            return this.next.executeLocalActivity(input);
        }

        public <R> WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> executeChildWorkflow(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("executeChildWorkflow " + input.getWorkflowType());
            }
            return this.next.executeChildWorkflow(input);
        }

        public <R> WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput<R> executeNexusOperation(WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R> input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("executeNexusOperation " + input.getService() + " " + input.getOperation());
            }
            return this.next.executeNexusOperation(input);
        }

        public Random newRandom() {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("newRandom");
            }
            return this.next.newRandom();
        }

        public WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalWorkflow(WorkflowOutboundCallsInterceptor.SignalExternalInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("signalExternalWorkflow " + input.getExecution().getWorkflowId() + " " + input.getSignalName());
            }
            return this.next.signalExternalWorkflow(input);
        }

        public WorkflowOutboundCallsInterceptor.CancelWorkflowOutput cancelWorkflow(WorkflowOutboundCallsInterceptor.CancelWorkflowInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("cancelWorkflow " + input.getExecution().getWorkflowId());
            }
            return this.next.cancelWorkflow(input);
        }

        public void sleep(Duration duration) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("sleep " + duration);
            }
            this.next.sleep(duration);
        }

        public boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("await " + timeout + " " + reason);
            }
            return this.next.await(timeout, reason, unblockCondition);
        }

        public void await(String reason, Supplier<Boolean> unblockCondition) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("await " + reason);
            }
            this.next.await(reason, unblockCondition);
        }

        public Promise<Void> newTimer(Duration duration) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("newTimer " + duration);
            }
            return this.next.newTimer(duration);
        }

        public Promise<Void> newTimer(Duration duration, TimerOptions options) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("newTimer " + duration);
            }
            return this.next.newTimer(duration, options);
        }

        public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("sideEffect");
            }
            return (R)this.next.sideEffect(resultClass, resultType, func);
        }

        public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func, SideEffectOptions options) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("sideEffect");
            }
            return (R)this.next.sideEffect(resultClass, resultType, func, options);
        }

        public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("mutableSideEffect");
            }
            return (R)this.next.mutableSideEffect(id, resultClass, resultType, updated, func);
        }

        public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func, MutableSideEffectOptions options) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("mutableSideEffect");
            }
            return (R)this.next.mutableSideEffect(id, resultClass, resultType, updated, func, options);
        }

        public int getVersion(String changeId, int minSupported, int maxSupported) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("getVersion");
            }
            return this.next.getVersion(changeId, minSupported, maxSupported);
        }

        public void continueAsNew(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("continueAsNew");
            }
            this.next.continueAsNew(input);
        }

        public void registerQuery(WorkflowOutboundCallsInterceptor.RegisterQueryInput input) {
            String queryType = input.getQueryType();
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("registerQuery " + queryType);
            }
            this.next.registerQuery(new WorkflowOutboundCallsInterceptor.RegisterQueryInput(queryType, input.getDescription(), input.getArgTypes(), input.getGenericArgTypes(), (Functions.Func1 & Serializable)args -> {
                Object result = input.getCallback().apply(args);
                if (!WorkflowUnsafe.isReplaying()) {
                    if (queryType.equals("query")) {
                        log.trace("query", new Throwable());
                    }
                    this.trace.add("query " + queryType);
                }
                return result;
            }));
        }

        public void registerSignalHandlers(WorkflowOutboundCallsInterceptor.RegisterSignalHandlersInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                StringBuilder signals = new StringBuilder();
                for (WorkflowOutboundCallsInterceptor.SignalRegistrationRequest request : input.getRequests()) {
                    if (signals.length() > 0) {
                        signals.append(", ");
                    }
                    signals.append(request.getSignalType());
                }
                this.trace.add("registerSignalHandlers " + signals);
            }
            this.next.registerSignalHandlers(input);
        }

        public void registerUpdateHandlers(WorkflowOutboundCallsInterceptor.RegisterUpdateHandlersInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                StringBuilder updates = new StringBuilder();
                for (WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest request : input.getRequests()) {
                    if (updates.length() > 0) {
                        updates.append(", ");
                    }
                    updates.append(request.getUpdateName());
                }
                this.trace.add("registerUpdateHandlers " + updates);
            }
            this.next.registerUpdateHandlers(input);
        }

        public void registerDynamicUpdateHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicUpdateHandlerInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("registerDynamicUpdateHandler");
            }
            this.next.registerDynamicUpdateHandler(input);
        }

        public void registerDynamicSignalHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicSignalHandlerInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("registerDynamicSignalHandler");
            }
            this.next.registerDynamicSignalHandler(input);
        }

        public void registerDynamicQueryHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicQueryHandlerInput input) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("registerDynamicQueryHandler");
            }
            this.next.registerDynamicQueryHandler(input);
        }

        public UUID randomUUID() {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("randomUUID");
            }
            return this.next.randomUUID();
        }

        public void upsertSearchAttributes(Map<String, ?> searchAttributes) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("upsertSearchAttributes");
            }
            this.next.upsertSearchAttributes(searchAttributes);
        }

        public void upsertTypedSearchAttributes(SearchAttributeUpdate<?> ... searchAttributeUpdates) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("upsertTypedSearchAttributes");
            }
            this.next.upsertTypedSearchAttributes(searchAttributeUpdates);
        }

        public void upsertMemo(Map<String, Object> memo) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("upsertMemo");
            }
            this.next.upsertMemo(memo);
        }

        public Scope getMetricsScope() {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("getMetricsScope");
            }
            return this.next.getMetricsScope();
        }

        public Object newChildThread(Runnable runnable, boolean detached, String name) {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("newThread " + name);
            }
            return this.next.newChildThread(runnable, detached, name);
        }

        public long currentTimeMillis() {
            if (!WorkflowUnsafe.isReplaying()) {
                this.trace.add("currentTimeMillis");
            }
            return this.next.currentTimeMillis();
        }
    }

    public static class FilteredTrace {
        private final List<String> impl = Collections.synchronizedList(new ArrayList());

        public boolean add(String s) {
            log.trace("FilteredTrace isReplaying=" + WorkflowUnsafe.isReplaying());
            if (!WorkflowUnsafe.isReplaying()) {
                return this.impl.add(s);
            }
            return true;
        }

        List<String> getImpl() {
            return this.impl;
        }
    }
}

