/*
 * Copyright 2015 Julien Viet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.termd.core.ssh.netty;

import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.Readable;

/**
 * @author <a href="mailto:julien@julienviet.com">Julien Viet</a>
 */
public class NettyIoHandlerBridge {

  public void sessionCreated(IoHandler handler, IoSession session) throws Exception {
    handler.sessionCreated(session);
  }

  public void sessionClosed(IoHandler handler, IoSession session) throws Exception {
    handler.sessionClosed(session);
  }

  public void messageReceived(IoHandler handler, IoSession session, Readable message) throws Exception {
    handler.messageReceived(session, message);
  }
}
