/*
 * Decompiled with CFR 0.152.
 */
package io.terrakube.terraform.spring.autoconfigure;

import io.terrakube.terraform.TerraformClient;
import io.terrakube.terraform.spring.autoconfigure.TerraformProperties;
import lombok.NonNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={TerraformProperties.class})
@ConditionalOnMissingBean(value={TerraformClient.class})
public class TerraformAutoConfiguration {
    @Bean
    public TerraformClient terraformClient(@NonNull TerraformProperties tfProperties) {
        if (tfProperties == null) {
            throw new NullPointerException("tfProperties is marked non-null but is null");
        }
        return TerraformClient.builder().showColor(tfProperties.isEnableColor()).jsonOutput(tfProperties.isJsonOutput()).terraformReleasesUrl(tfProperties.getTerraformReleasesUrl()).tofuReleasesUrl(tfProperties.getTofuReleasesUrl()).build();
    }
}

