/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.internal;

import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.slf4j.Logger;

class AetherTransferListener
extends AbstractTransferListener {
    private final Logger log;
    private ThreadLocal<Long> last;

    public AetherTransferListener(Logger log) {
        this.log = log;
        this.last = new ThreadLocal();
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        this.log.info("Downloading {}{}...", (Object)event.getResource().getRepositoryUrl(), (Object)event.getResource().getResourceName());
    }

    public void transferSucceeded(TransferEvent event) {
        this.log.info("Downloaded [{} bytes] {}{}", new Object[]{event.getTransferredBytes(), event.getResource().getRepositoryUrl(), event.getResource().getResourceName()});
    }

    public void transferFailed(TransferEvent event) {
        this.log.error("Failed to download {}{}", new Object[]{event.getResource().getRepositoryUrl(), event.getResource().getResourceName(), event.getException()});
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        Long last = this.last.get();
        if (last == null || last < System.currentTimeMillis() - 5000L) {
            String progress = event.getResource().getContentLength() > 0L ? (int)((double)event.getTransferredBytes() * 100.0 / (double)event.getResource().getContentLength()) + "%" : event.getTransferredBytes() + " bytes";
            this.log.info("Downloading [{}] {}{}...", new Object[]{progress, event.getResource().getRepositoryUrl(), event.getResource().getResourceName()});
            this.last.set(new Long(System.currentTimeMillis()));
        }
    }
}

