/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.internal;

import com.google.common.collect.ImmutableList;
import io.tesla.aether.Repository;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.Workspace;
import io.tesla.aether.connector.AetherRepositoryConnectorFactory;
import io.tesla.aether.guice.DefaultModelCache;
import io.tesla.aether.guice.DefaultModelResolver;
import io.tesla.aether.guice.RepositorySystemSessionProvider;
import io.tesla.aether.guice.maven.MavenBehaviourRepositoryProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.file.FileRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultFileProcessor;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.version.Version;
import org.eclipse.sisu.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultTeslaAether
implements TeslaAether {
    private RepositorySystem system;
    private RepositorySystemSession session;
    private ModelBuilder modelBuilder;
    private ArtifactResolver artifactResolver;
    private RemoteRepositoryManager remoteRepositoryManager;
    private List<RemoteRepository> remoteRepositories;

    public DefaultTeslaAether() {
        this(new File(System.getProperty("user.home"), ".m2/repository"), "http://repo1.maven.org/maven2/");
    }

    public DefaultTeslaAether(String localRepository, List<String> remoteRepositoryUris) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (String remoteRepositoryUri : remoteRepositoryUris) {
            repositories.add(new Repository(remoteRepositoryUri));
        }
        this.init(new File(localRepository), repositories);
    }

    public DefaultTeslaAether(File localRepository, String ... remoteRepositoryUris) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (String remoteRepositoryUri : remoteRepositoryUris) {
            repositories.add(new Repository(remoteRepositoryUri));
        }
        this.init(localRepository, repositories);
    }

    public DefaultTeslaAether(List<RemoteRepository> remoteRepositories, RepositorySystemSession repositorySystemSession) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, AetherRepositoryConnectorFactory.class);
        locator.addService(FileProcessor.class, DefaultFileProcessor.class);
        this.system = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.session = repositorySystemSession;
        this.modelBuilder = new DefaultModelBuilderFactory().newInstance();
        this.artifactResolver = (ArtifactResolver)locator.getService(ArtifactResolver.class);
        this.remoteRepositoryManager = (RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class);
        this.remoteRepositories = remoteRepositories;
    }

    private void init(File localRepository, List<Repository> repositories) {
        this.remoteRepositories = new ArrayList<RemoteRepository>();
        for (Repository r : repositories) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(r.getId(), "default", r.getUrl());
            if (r.getUsername() != null && r.getPassword() != null) {
                Authentication auth = new AuthenticationBuilder().addUsername(r.getUsername()).addPassword(r.getPassword()).build();
                builder.setAuthentication(auth);
            }
            this.remoteRepositories.add(builder.build());
        }
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, AetherRepositoryConnectorFactory.class);
        locator.addService(FileProcessor.class, DefaultFileProcessor.class);
        this.system = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.session = new RepositorySystemSessionProvider(localRepository).get();
        this.modelBuilder = new DefaultModelBuilderFactory().newInstance();
        this.artifactResolver = (ArtifactResolver)locator.getService(ArtifactResolver.class);
        this.remoteRepositoryManager = (RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class);
    }

    @Inject
    public DefaultTeslaAether(RepositorySystem system, RepositorySystemSession session, ModelBuilder modelBuilder, ArtifactResolver artifactResolver, RemoteRepositoryManager remoteRepositoryManager, @Nullable RemoteRepository remoteRepository) {
        this.system = system;
        this.session = session;
        this.modelBuilder = modelBuilder;
        this.artifactResolver = artifactResolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.remoteRepositories = remoteRepository == null ? ImmutableList.of((Object)new MavenBehaviourRepositoryProvider().get()) : ImmutableList.of((Object)remoteRepository);
        if (session.getLocalRepositoryManager() == null) {
            LocalRepository localRepo = new LocalRepository(new File(System.getProperty("user.home"), ".m2/repository"));
            try {
                ((DefaultRepositorySystemSession)session).setLocalRepositoryManager(new SimpleLocalRepositoryManagerFactory().newInstance(session, localRepo));
            }
            catch (NoLocalRepositoryManagerException e) {
                // empty catch block
            }
        }
    }

    @Override
    public Model resolveModel(File pom) throws ModelBuildingException {
        RequestTrace trace = new RequestTrace((Object)pom);
        DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
        modelRequest.setValidationLevel(0);
        modelRequest.setProcessPlugins(false);
        modelRequest.setTwoPhaseBuilding(false);
        modelRequest.setSystemProperties(this.toProperties(this.session.getUserProperties(), this.session.getSystemProperties()));
        modelRequest.setModelCache((ModelCache)new DefaultModelCache());
        modelRequest.setModelResolver((ModelResolver)new DefaultModelResolver(this.session, trace.newChild((Object)modelRequest), "bithub", this.artifactResolver, this.remoteRepositoryManager, this.remoteRepositories));
        modelRequest.setPomFile(pom);
        return this.modelBuilder.build((ModelBuildingRequest)modelRequest).getEffectiveModel();
    }

    @Override
    public Model resolveModel(String coordinate) throws ModelBuildingException, ArtifactResolutionException {
        File pom = this.resolveArtifact(coordinate).getArtifact().getFile();
        return this.resolveModel(pom);
    }

    @Override
    public ArtifactResult resolveArtifact(String coordinate) throws ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(coordinate);
        return this.resolveArtifact((Artifact)artifact);
    }

    @Override
    public ArtifactResult resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        for (RemoteRepository remoteRepository : this.remoteRepositories) {
            artifactRequest.addRepository(remoteRepository);
        }
        return this.system.resolveArtifact(this.session, artifactRequest);
    }

    @Override
    public List<Artifact> resolveArtifacts(String coordinate) throws DependencyResolutionException {
        return this.resolveArtifacts((Artifact)new DefaultArtifact(coordinate));
    }

    @Override
    public List<Artifact> resolveArtifacts(Artifact artifact) throws DependencyResolutionException {
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "runtime"));
        for (RemoteRepository remoteRepository : this.remoteRepositories) {
            collectRequest.addRepository(remoteRepository);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFlter);
        return this.resolveArtifacts(dependencyRequest);
    }

    @Override
    public List<Artifact> resolveArtifacts(DependencyRequest request) throws DependencyResolutionException {
        CollectRequest collectRequest = request.getCollectRequest();
        if (collectRequest.getRepositories() == null || collectRequest.getRepositories().isEmpty()) {
            for (RemoteRepository remoteRepository : this.remoteRepositories) {
                collectRequest.addRepository(remoteRepository);
            }
        }
        DependencyResult result = this.system.resolveDependencies(this.session, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (ArtifactResult ar : result.getArtifactResults()) {
            artifacts.add(ar.getArtifact());
        }
        return artifacts;
    }

    @Override
    public List<Artifact> resolveArtifacts(File modelFile) throws ModelBuildingException, DependencyResolutionException {
        Model model = this.resolveModel(modelFile);
        DefaultArtifact artifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), model.getPackaging(), model.getVersion());
        return this.resolveArtifacts((Artifact)artifact);
    }

    private Dependency toAetherDependency(org.apache.maven.model.Dependency dependency) {
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
        ImmutableList.Builder exclusions = ImmutableList.builder();
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add((Object)new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), null, "*"));
        }
        return new Dependency((Artifact)artifact, dependency.getScope(), Boolean.valueOf(dependency.isOptional()), (Collection)exclusions.build());
    }

    @Override
    public ArtifactType getArtifactType(String typeId) {
        return this.session.getArtifactTypeRegistry().get(typeId);
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    @Override
    public List<String> findAllVersions(String gaVersionRange) throws VersionRangeResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(gaVersionRange);
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)artifact);
        for (RemoteRepository remoteRepository : this.remoteRepositories) {
            rangeRequest.addRepository(remoteRepository);
        }
        VersionRangeResult rangeResult = this.system.resolveVersionRange(this.session, rangeRequest);
        List versions = rangeResult.getVersions();
        ArrayList<String> result = new ArrayList<String>();
        for (Version v : versions) {
            result.add(v.toString());
        }
        return result;
    }

    @Override
    public List<File> resolveWorkspace(Workspace workspace) throws ModelBuildingException, DependencyResolutionException {
        ArrayList<File> classpath = new ArrayList<File>();
        for (File projectDirectory : workspace.getProjectDirectories()) {
            File pom = new File(projectDirectory, "pom.xml");
            Model model = this.resolveModel(pom);
            List<Artifact> artifacts = this.resolveArtifacts((Artifact)new DefaultArtifact(model.getGroupId(), model.getArtifactId(), model.getPackaging(), model.getVersion()));
            for (Artifact artifact : artifacts) {
                classpath.add(artifact.getFile());
            }
            File classes = new File(model.getBuild().getDirectory(), "classes");
            classpath.add(classes);
        }
        return classpath;
    }
}

