/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.annotator;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;

public class AnnotationContainer
implements Serializable {
    private static final long serialVersionUID = 2095081099028549391L;
    private Color annotationColor;
    private String baseImagePath;
    private String saveObjectPath;
    private List<Rectangle> annotations;

    public AnnotationContainer(Color annotationColor, List<Rectangle> annotations) {
        this.setAnnotationColor(annotationColor);
        this.setAnnotations(annotations);
    }

    public Color getAnnotationColor() {
        return this.annotationColor;
    }

    public String getBaseImagePath() {
        return this.baseImagePath;
    }

    public String getSaveObjectPath() {
        return this.saveObjectPath;
    }

    public List<Rectangle> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotationColor(Color annotationColor) {
        this.annotationColor = annotationColor;
    }

    public void setAnnotations(List<Rectangle> annotations) {
        this.annotations = annotations;
    }

    public void toJson(File jsonFile) throws IOException {
        Gson gson = new Gson();
        JsonObject container = new JsonObject();
        container.add("color", gson.toJsonTree((Object)this.annotationColor));
        container.add("annotations", gson.toJsonTree(this.annotations));
        String jsonString = gson.toJson((JsonElement)container);
        FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);
        fileOutputStream.write(jsonString.getBytes());
        fileOutputStream.close();
    }

    public static AnnotationContainer readFromJson(File jsonFile) throws IOException {
        String line;
        FileInputStream fis = new FileInputStream(jsonFile);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader bufferedReader = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
        }
        String json = sb.toString();
        bufferedReader.close();
        Gson gson = new Gson();
        JsonElement jsonElement = new JsonParser().parse(json);
        Color color = (Color)gson.fromJson(jsonElement.getAsJsonObject().get("color"), Color.class);
        Type listType = new TypeToken<List<Rectangle>>(){}.getType();
        List annotations = (List)gson.fromJson(jsonElement.getAsJsonObject().get("annotations"), listType);
        return new AnnotationContainer(color, annotations);
    }
}

