/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.execution.worker.finish;

import com.google.common.eventbus.Subscribe;
import eu.tsystems.mms.tic.testframework.events.MethodEndEvent;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.testing.WebDriverManagerProvider;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import org.testng.ITestResult;

public class WebDriverShutDownWorker
implements MethodEndEvent.Listener,
WebDriverManagerProvider {
    @Subscribe
    public void onMethodEnd(MethodEndEvent methodEndEvent) {
        ITestResult iTestResult = methodEndEvent.getTestResult();
        if (iTestResult != null) {
            methodEndEvent.getMethodContext().readSessionContexts().forEach(sessionContext -> {
                WebDriverRequest webDriverRequest = sessionContext.getWebDriverRequest();
                boolean shouldClose = false;
                if (iTestResult.getMethod().isTest() && webDriverRequest.getShutdownAfterTest()) {
                    shouldClose = true;
                } else if (!iTestResult.isSuccess() && webDriverRequest.getShutdownAfterTestFailed()) {
                    shouldClose = true;
                }
                if (shouldClose) {
                    WEB_DRIVER_MANAGER.getWebDriver((SessionContext)sessionContext).ifPresent(WEB_DRIVER_MANAGER::shutdownSession);
                }
            });
        }
    }
}

