/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.execution.worker.start;

import com.google.common.eventbus.Subscribe;
import eu.tsystems.mms.tic.testframework.events.MethodStartEvent;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import java.util.LinkedList;

public class WebDriverLoggingStartWorker
implements MethodStartEvent.Listener,
Loggable {
    @Subscribe
    public void onMethodStart(MethodStartEvent event) {
        if (event.getTestMethod().isTest()) {
            LinkedList statusLog = new LinkedList();
            WebDriverSessionsManager.readSessionContexts().forEach(sessionContext -> {
                StringBuilder statusLogEntry = new StringBuilder();
                sessionContext.getActualBrowserName().ifPresent(statusLogEntry::append);
                sessionContext.getActualBrowserVersion().ifPresent(s -> statusLogEntry.append(":").append((String)s));
                sessionContext.getNodeUrl().ifPresent(url -> statusLogEntry.append(" on ").append(url));
                statusLog.add(statusLogEntry.toString());
            });
            if (statusLog.size() > 0) {
                this.log().info("Already opened webdriver sessions:\n" + String.join((CharSequence)"\n", statusLog));
            }
        }
    }
}

