/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.hooks;

import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.execution.testng.AdditionalRetryAnalyzer;
import eu.tsystems.mms.tic.testframework.execution.testng.RetryAnalyzer;
import eu.tsystems.mms.tic.testframework.execution.testng.WebDriverRetryAnalyzer;
import eu.tsystems.mms.tic.testframework.execution.worker.finish.ConditionalBehaviourWorker;
import eu.tsystems.mms.tic.testframework.execution.worker.finish.TakeInSessionEvidencesWorker;
import eu.tsystems.mms.tic.testframework.execution.worker.finish.WebDriverShutDownWorker;
import eu.tsystems.mms.tic.testframework.execution.worker.start.PerformanceTestWorker;
import eu.tsystems.mms.tic.testframework.hooks.ModuleHook;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultPropertyAssertionFactory;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionFactory;
import eu.tsystems.mms.tic.testframework.interop.ScreenshotCollector;
import eu.tsystems.mms.tic.testframework.interop.TestEvidenceCollector;
import eu.tsystems.mms.tic.testframework.listeners.ShutdownSessionsListener;
import eu.tsystems.mms.tic.testframework.listeners.WatchdogStartupListener;
import eu.tsystems.mms.tic.testframework.pageobjects.DefaultUiElementFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AriaElementLocator;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.DefaultPageFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.DefaultUiElementFinderFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.PageFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.UiElementFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.UiElementFinderFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.UiElementLabelLocator;
import eu.tsystems.mms.tic.testframework.report.ScreenshotGrabber;
import eu.tsystems.mms.tic.testframework.report.UITestStepIntegration;
import eu.tsystems.mms.tic.testframework.testing.TestController;
import eu.tsystems.mms.tic.testframework.testing.UiElementOverrides;
import eu.tsystems.mms.tic.testframework.useragents.BrowserInformation;
import eu.tsystems.mms.tic.testframework.useragents.UapBrowserInformation;
import eu.tsystems.mms.tic.testframework.watchdog.WebDriverWatchDog;
import eu.tsystems.mms.tic.testframework.webdrivermanager.DefaultWebDriverManager;
import eu.tsystems.mms.tic.testframework.webdrivermanager.IWebDriverManager;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverCapabilities;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;

public class DriverUiHook
extends AbstractModule
implements ModuleHook {
    private static IWebDriverManager webDriverManager;

    protected void configure() {
        this.bind(UiElementFactory.class).to(DefaultUiElementFactory.class).in(Scopes.SINGLETON);
        this.bind(PageFactory.class).to(DefaultPageFactory.class).in(Scopes.SINGLETON);
        this.bind(TestController.Overrides.class).to(UiElementOverrides.class).in(Scopes.SINGLETON);
        this.bind(IWebDriverManager.class).to(DefaultWebDriverManager.class).in(Scopes.SINGLETON);
        this.bind(UiElementLabelLocator.class).to(AriaElementLocator.class).in(Scopes.SINGLETON);
        this.bind(UiElementFinderFactory.class).to(DefaultUiElementFinderFactory.class).in(Scopes.SINGLETON);
        this.bind(PropertyAssertionFactory.class).to(DefaultPropertyAssertionFactory.class).in(Scopes.SINGLETON);
        this.bind(BrowserInformation.class).to(UapBrowserInformation.class);
    }

    public void init() {
        webDriverManager = (IWebDriverManager)Testerra.getInjector().getInstance(IWebDriverManager.class);
        webDriverManager.registerWebDriverRequestConfigurator(new WebDriverCapabilities());
        UITestStepIntegration.init();
        EventBus eventBus = Testerra.getEventBus();
        if (Testerra.Properties.PERF_GENERATE_STATISTICS.asBool().booleanValue()) {
            eventBus.register((Object)new PerformanceTestWorker());
        }
        eventBus.register((Object)new ConditionalBehaviourWorker());
        eventBus.register((Object)new TakeInSessionEvidencesWorker());
        eventBus.register((Object)new WebDriverShutDownWorker());
        eventBus.register((Object)new ShutdownSessionsListener());
        RetryAnalyzer.registerAdditionalRetryAnalyzer((AdditionalRetryAnalyzer)new WebDriverRetryAnalyzer());
        TestEvidenceCollector.registerScreenshotCollector((ScreenshotCollector)new ScreenshotGrabber());
        boolean watchdogEnabled = PropertyManager.getBooleanProperty((String)"tt.watchdog.enable", (boolean)false);
        if (watchdogEnabled) {
            WebDriverSessionsManager.registerWebDriverAfterStartupHandler(new WatchdogStartupListener());
        }
    }

    public void terminate() {
        DriverUiHook.shutdownModule();
    }

    public static void shutdownModule() {
        webDriverManager.requestShutdownAllSessions();
        WebDriverWatchDog.stop();
    }
}

