/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal;

import eu.tsystems.mms.tic.testframework.internal.TimingInfo;
import eu.tsystems.mms.tic.testframework.report.perf.PerfTestContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.testng.ITestResult;

public final class StopWatch {
    private static final ThreadLocal<HashMap<Object, Long>> START_PAGE_LOAD_TIMESTAMP = new ThreadLocal();
    private static final ThreadLocal<List<TimingInfo>> PAGE_LOAD_INFOS = new ThreadLocal();

    private StopWatch() {
    }

    public static void startPageLoad(Object reference) {
        long currentTimeMillis = System.currentTimeMillis();
        if (START_PAGE_LOAD_TIMESTAMP.get() == null) {
            START_PAGE_LOAD_TIMESTAMP.set(new HashMap());
        }
        START_PAGE_LOAD_TIMESTAMP.get().put(reference, currentTimeMillis);
    }

    public static void initializeStopWatch() {
        PAGE_LOAD_INFOS.set(new ArrayList());
    }

    public static void stopPageLoad(WebDriver driver, Class page) {
        Object currentUrl;
        try {
            currentUrl = driver.getCurrentUrl();
        }
        catch (WebDriverException e) {
            currentUrl = "Url unknown: " + e.getMessage();
        }
        long timeStampMillis = System.currentTimeMillis();
        HashMap<Object, Long> hashMap = START_PAGE_LOAD_TIMESTAMP.get();
        if (hashMap == null) {
            return;
        }
        if (!hashMap.containsKey(driver)) {
            return;
        }
        Long startTimestamp = hashMap.get(driver);
        long durationMillis = timeStampMillis - startTimestamp;
        String context = page.getSimpleName();
        TimingInfo timingInfo = new TimingInfo(context, (String)currentUrl, durationMillis, timeStampMillis);
        if (PAGE_LOAD_INFOS.get() == null) {
            PAGE_LOAD_INFOS.set(new ArrayList());
        }
        List<TimingInfo> timingInfoList = PAGE_LOAD_INFOS.get();
        timingInfoList.add(timingInfo);
        START_PAGE_LOAD_TIMESTAMP.get().remove(driver);
    }

    public static List<TimingInfo> getPageLoadInfos() {
        return PAGE_LOAD_INFOS.get();
    }

    public static void cleanupThreadLocals() {
        START_PAGE_LOAD_TIMESTAMP.remove();
        PAGE_LOAD_INFOS.remove();
    }

    public static void storePageLoadInfosAfterTestMethod(ITestResult iTestResult) {
        if (PAGE_LOAD_INFOS.get() == null) {
            return;
        }
        ArrayList timingInfosCopy = new ArrayList(PAGE_LOAD_INFOS.get().size());
        timingInfosCopy.addAll(PAGE_LOAD_INFOS.get());
        String threadName = Thread.currentThread().getName();
        Long threadID = Thread.currentThread().getId();
        PerfTestContainer.saveThreadName((Long)threadID, (String)threadName);
        String methodName = iTestResult.getMethod().getMethodName();
        PerfTestContainer.addPageLoadInfo((Long)threadID, timingInfosCopy, (String)methodName);
        PerfTestContainer.setTestResult((Long)threadID, (ITestResult)iTestResult);
        PAGE_LOAD_INFOS.get().clear();
        PAGE_LOAD_INFOS.remove();
    }
}

