/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal.asserts;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.execution.testng.Assertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.ActualProperty;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.testing.TestController;
import eu.tsystems.mms.tic.testframework.utils.Sequence;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AbstractTestedPropertyAssertion<T>
extends AbstractPropertyAssertion<T>
implements Loggable {
    protected static final Assertion assertionImpl = (Assertion)Testerra.getInjector().getInstance(Assertion.class);
    private static final TestController.Overrides overrides = (TestController.Overrides)Testerra.getInjector().getInstance(TestController.Overrides.class);

    public AbstractTestedPropertyAssertion(AbstractPropertyAssertion parentAssertion, AssertionProvider<T> provider) {
        super(parentAssertion, provider);
    }

    protected boolean testSequence(ActualProperty<T> actualProperty, Predicate<T> testFunction, Function<T, String> failMessageSupplier) {
        int useTime = this.config.useTimeout;
        if (useTime < 0) {
            useTime = overrides.getTimeoutInSeconds();
        }
        Sequence sequence = new Sequence().setWaitMsAfterRun(UiElement.Properties.ELEMENT_WAIT_INTERVAL_MS.asLong().longValue()).setTimeoutMs((long)useTime * 1000L);
        AtomicBoolean atomicPassed = new AtomicBoolean(false);
        AtomicReference atomicThrowable = new AtomicReference();
        AtomicReference atomicActual = new AtomicReference();
        sequence.run(() -> {
            try {
                Object actual = actualProperty.getActual();
                atomicPassed.set(testFunction.test(actual));
                atomicActual.set(actual);
            }
            catch (Throwable throwable) {
                this.failedRecursive();
                atomicThrowable.set(throwable);
            }
            return atomicPassed.get();
        });
        boolean passed = atomicPassed.get();
        if (!passed) {
            this.failedFinallyRecursive();
            if (this.config.throwErrors) {
                Throwable finalThrowable;
                Assertion useAssertion = this.config.useAssertion != null ? this.config.useAssertion : assertionImpl;
                String message = null;
                try {
                    message = failMessageSupplier.apply(atomicActual.get());
                    finalThrowable = (Throwable)atomicThrowable.get();
                }
                catch (Throwable throwable) {
                    finalThrowable = throwable;
                }
                useAssertion.fail((Error)((Object)this.wrapAssertionErrorRecursive(new AssertionError(message, finalThrowable))));
            }
        } else {
            this.passedRecursive();
        }
        return passed;
    }
}

