/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal.asserts;

import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.internal.asserts.BinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultBinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultQuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultStringAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.FileAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.QuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.StringAssertion;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.io.FilenameUtils;

public class DefaultFileAssertion
extends AbstractPropertyAssertion<File>
implements FileAssertion {
    public DefaultFileAssertion(AbstractPropertyAssertion parentAssertion, AssertionProvider<File> provider) {
        super(parentAssertion, provider);
    }

    public QuantityAssertion<Long> bytes() {
        return (QuantityAssertion)propertyAssertionFactory.createWithParent(DefaultQuantityAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Long>(){

            public Long getActual() {
                return ((File)DefaultFileAssertion.this.provider.getActual()).length();
            }

            public String createSubject() {
                return "bytes";
            }
        });
    }

    public StringAssertion<String> name() {
        return (StringAssertion)propertyAssertionFactory.createWithParent(DefaultStringAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<String>(){

            public String getActual() {
                return ((File)DefaultFileAssertion.this.provider.getActual()).getName();
            }

            public String createSubject() {
                return "name";
            }
        });
    }

    public StringAssertion<String> extension() {
        return (StringAssertion)propertyAssertionFactory.createWithParent(DefaultStringAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<String>(){

            public String getActual() {
                return FilenameUtils.getExtension((String)((File)DefaultFileAssertion.this.provider.getActual()).getName());
            }

            public String createSubject() {
                return "extension";
            }
        });
    }

    public StringAssertion<String> mimetype() {
        return (StringAssertion)propertyAssertionFactory.createWithParent(DefaultStringAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<String>(){

            public String getActual() {
                try {
                    return Files.probeContentType(((File)DefaultFileAssertion.this.provider.getActual()).toPath());
                }
                catch (IOException e) {
                    return e.getMessage();
                }
            }

            public String createSubject() {
                return "mimetype";
            }
        });
    }

    public BinaryAssertion<Boolean> exists() {
        return (BinaryAssertion)propertyAssertionFactory.createWithParent(DefaultBinaryAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Boolean>(){

            public Boolean getActual() {
                return ((File)DefaultFileAssertion.this.provider.getActual()).exists();
            }

            public String createSubject() {
                return "exists";
            }
        });
    }
}

