/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal.asserts;

import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionConfig;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionFactory;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DefaultPropertyAssertionFactory
implements PropertyAssertionFactory,
Loggable {
    public <ASSERTION extends AbstractPropertyAssertion, TYPE> ASSERTION createAssertion(Class<ASSERTION> assertionClass, AbstractPropertyAssertion parentAssertion, AssertionProvider<TYPE> provider) {
        AbstractPropertyAssertion assertion;
        try {
            Constructor<ASSERTION> constructor = assertionClass.getDeclaredConstructor(AbstractPropertyAssertion.class, AssertionProvider.class);
            assertion = (AbstractPropertyAssertion)constructor.newInstance(parentAssertion, provider);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.log().error(String.format("Unable to create assertion: %s", e.getMessage()), (Throwable)e);
            assertion = null;
        }
        return (ASSERTION)assertion;
    }

    public <ASSERTION extends AbstractPropertyAssertion, TYPE> ASSERTION createWithParent(Class<ASSERTION> assertionClass, AbstractPropertyAssertion parentAssertion, AssertionProvider<TYPE> provider) {
        ASSERTION assertion = this.createAssertion(assertionClass, parentAssertion, provider);
        ((AbstractPropertyAssertion)assertion).config = parentAssertion.config;
        return assertion;
    }

    public <ASSERTION extends AbstractPropertyAssertion, TYPE> ASSERTION createWithConfig(Class<ASSERTION> assertionClass, PropertyAssertionConfig config, AssertionProvider<TYPE> provider) {
        ASSERTION assertion = this.createAssertion(assertionClass, null, provider);
        ((AbstractPropertyAssertion)assertion).config = config;
        return assertion;
    }
}

