/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal.asserts;

import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultBinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultStringAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.QuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.StringAssertion;
import java.math.BigDecimal;
import java.util.function.Function;

public class DefaultQuantityAssertion<TYPE>
extends DefaultBinaryAssertion<TYPE>
implements QuantityAssertion<TYPE> {
    public DefaultQuantityAssertion(AbstractPropertyAssertion parentAssertion, AssertionProvider<TYPE> provider) {
        super(parentAssertion, provider);
    }

    public boolean is(Object expected, String failMessage) {
        if (expected instanceof Boolean) {
            boolean expectedBoolean = (Boolean)expected;
            return this.is(expectedBoolean, failMessage);
        }
        return this.testSequence(this.provider, actual -> assertionImpl.equals(actual, expected), actual -> assertionImpl.formatExpectEquals(null, expected, (Object)this.createFailMessage(failMessage)));
    }

    public boolean isNot(Object expected, String failMessage) {
        if (expected instanceof Boolean) {
            boolean expectedBoolean = (Boolean)expected;
            return this.is(!expectedBoolean, failMessage);
        }
        return this.testSequence(this.provider, actual -> assertionImpl.notEquals(actual, expected), actual -> assertionImpl.formatExpectNotEquals(null, expected, (Object)this.createFailMessage(failMessage)));
    }

    private BigDecimal toBigDecimal(Object given) {
        if (given == null) {
            return null;
        }
        return new BigDecimal(given.toString());
    }

    public boolean isGreaterThan(BigDecimal expected, String failMessage) {
        return this.testSequence(this.provider, actual -> assertionImpl.isGreaterThan(this.toBigDecimal(actual), expected), actual -> assertionImpl.formatExpectGreaterThan(this.toBigDecimal(actual), expected, (Object)this.createFailMessage(failMessage)));
    }

    public boolean isLowerThan(BigDecimal expected, String failMessage) {
        return this.testSequence(this.provider, actual -> assertionImpl.isLowerThan(this.toBigDecimal(actual), expected), actual -> assertionImpl.formatExpectLowerThan(this.toBigDecimal(actual), expected, (Object)this.createFailMessage(failMessage)));
    }

    public boolean isGreaterEqualThan(BigDecimal expected, String failMessage) {
        return this.testSequence(this.provider, actual -> assertionImpl.isGreaterEqualThan(this.toBigDecimal(actual), expected), actual -> assertionImpl.formatExpectGreaterEqualThan(this.toBigDecimal(actual), expected, (Object)this.createFailMessage(failMessage)));
    }

    public boolean isLowerEqualThan(BigDecimal expected, String failMessage) {
        return this.testSequence(this.provider, actual -> assertionImpl.isLowerEqualThan(this.toBigDecimal(actual), expected), actual -> assertionImpl.formatExpectLowerEqualThan(this.toBigDecimal(actual), expected, (Object)this.createFailMessage(failMessage)));
    }

    public boolean isBetween(BigDecimal lower, BigDecimal higher, String failMessage) {
        return this.testSequence(this.provider, actual -> assertionImpl.isBetween(this.toBigDecimal(actual), lower, higher), actual -> assertionImpl.formatExpectIsBetween(this.toBigDecimal(actual), lower, higher, (Object)this.createFailMessage(failMessage)));
    }

    public <MAPPED_TYPE> StringAssertion<MAPPED_TYPE> map(final Function<? super TYPE, MAPPED_TYPE> mapFunction) {
        return (StringAssertion)propertyAssertionFactory.createWithParent(DefaultStringAssertion.class, (AbstractPropertyAssertion)this, new AssertionProvider<MAPPED_TYPE>(){

            public MAPPED_TYPE getActual() {
                Object actual = DefaultQuantityAssertion.this.provider.getActual();
                if (actual == null) {
                    return null;
                }
                return mapFunction.apply(DefaultQuantityAssertion.this.provider.getActual());
            }

            public String createSubject() {
                return "mapped to " + AssertionProvider.Format.shortString(this.getActual());
            }
        });
    }

    public QuantityAssertion<BigDecimal> absolute() {
        return (QuantityAssertion)propertyAssertionFactory.createWithParent(DefaultQuantityAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<BigDecimal>(){

            public BigDecimal getActual() {
                BigDecimal number = !(DefaultQuantityAssertion.this.provider.getActual() instanceof BigDecimal) ? new BigDecimal(DefaultQuantityAssertion.this.provider.getActual().toString()) : (BigDecimal)DefaultQuantityAssertion.this.provider.getActual();
                return number.abs();
            }

            public String createSubject() {
                return "absolute";
            }
        });
    }
}

