/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal.asserts;

import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.internal.asserts.BinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultBinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultPatternAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultQuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.PatternAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.QuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.StringAssertion;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultStringAssertion<T>
extends DefaultQuantityAssertion<T>
implements StringAssertion<T>,
Loggable {
    public DefaultStringAssertion(AbstractPropertyAssertion parentAssertion, AssertionProvider<T> provider) {
        super(parentAssertion, provider);
    }

    public BinaryAssertion<Boolean> contains(final String expected) {
        return (BinaryAssertion)propertyAssertionFactory.createWithParent(DefaultBinaryAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultStringAssertion.this.provider.getActual().toString().contains(expected);
            }

            public String createSubject() {
                return "contains " + AssertionProvider.Format.param((Object)expected);
            }
        });
    }

    public BinaryAssertion<Boolean> startsWith(final String expected) {
        return (BinaryAssertion)propertyAssertionFactory.createWithParent(DefaultBinaryAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultStringAssertion.this.provider.getActual().toString().startsWith(expected);
            }

            public String createSubject() {
                return "starts with " + AssertionProvider.Format.param((Object)expected);
            }
        });
    }

    public BinaryAssertion<Boolean> endsWith(final String expected) {
        return (BinaryAssertion)propertyAssertionFactory.createWithParent(DefaultBinaryAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultStringAssertion.this.provider.getActual().toString().endsWith(expected);
            }

            public String createSubject() {
                return "ends with " + AssertionProvider.Format.param((Object)expected);
            }
        });
    }

    public PatternAssertion matches(final Pattern pattern) {
        return (PatternAssertion)propertyAssertionFactory.createWithParent(DefaultPatternAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Matcher>(){

            public Matcher getActual() {
                return pattern.matcher(DefaultStringAssertion.this.provider.getActual().toString());
            }

            public String createSubject() {
                return "matches " + AssertionProvider.Format.param((Object)pattern);
            }
        });
    }

    public BinaryAssertion<Boolean> hasWords(final List<String> words) {
        Pattern nonWordAtBegin = Pattern.compile("^\\W");
        Pattern nonWordAtTheEnd = Pattern.compile("\\W$");
        String wordsList = words.stream().map((? super T word) -> (nonWordAtBegin.matcher((CharSequence)word).find() ? "\\B" : "\\b") + "\\Q" + word).map((? super T word) -> word + "\\E" + (nonWordAtTheEnd.matcher((CharSequence)word).find() ? "\\B" : "\\b")).collect(Collectors.joining("|"));
        final Pattern wordsPattern = Pattern.compile(wordsList, 10);
        final String wordsListWithoutRegex = String.join((CharSequence)"|", words);
        return (BinaryAssertion)propertyAssertionFactory.createWithParent(DefaultBinaryAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Boolean>(){

            public Boolean getActual() {
                int found = 0;
                Matcher matcher = wordsPattern.matcher(DefaultStringAssertion.this.provider.getActual().toString());
                while (matcher.find()) {
                    ++found;
                }
                return found == words.size();
            }

            public String createSubject() {
                return "has words " + AssertionProvider.Format.param((Object)wordsListWithoutRegex);
            }
        });
    }

    public QuantityAssertion<Integer> length() {
        return (QuantityAssertion)propertyAssertionFactory.createWithParent(DefaultQuantityAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Integer>(){

            public Integer getActual() {
                return DefaultStringAssertion.this.provider.getActual().toString().length();
            }

            public String createSubject() {
                return "length";
            }
        });
    }
}

