/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;

public final class DriverStorage {
    private static final Map<String, Map<String, WebDriver>> DRIVERS_PER_TEST_METHOD = Collections.synchronizedMap(new HashMap());

    private DriverStorage() {
    }

    public static void saveDriverForTestMethod(WebDriver driver, String threadName, String testMethodName) {
        if (!DRIVERS_PER_TEST_METHOD.containsKey(testMethodName)) {
            Map<String, WebDriver> map = Collections.synchronizedMap(new HashMap());
            map.put(threadName, driver);
            DRIVERS_PER_TEST_METHOD.put(testMethodName, map);
        } else {
            Map<String, WebDriver> map = DRIVERS_PER_TEST_METHOD.get(testMethodName);
            map.put(threadName, driver);
            DRIVERS_PER_TEST_METHOD.put(testMethodName, map);
        }
    }

    public static WebDriver getDriverByTestMethodName(String testMethodName, String threadName) {
        Map<String, WebDriver> driverMap;
        WebDriver webDriver = null;
        if (DRIVERS_PER_TEST_METHOD.containsKey(testMethodName) && (driverMap = DRIVERS_PER_TEST_METHOD.get(testMethodName)) != null) {
            webDriver = driverMap.get(threadName);
        }
        return webDriver;
    }

    public static Map<String, Map<String, WebDriver>> getAllDriversPerTestMethod() {
        return DRIVERS_PER_TEST_METHOD;
    }

    public static void removeSpecificDriver(String testMethodName) {
        String threadName = "" + Thread.currentThread().getId();
        if (DRIVERS_PER_TEST_METHOD.containsKey(testMethodName)) {
            DRIVERS_PER_TEST_METHOD.get(testMethodName).remove(threadName);
        }
    }

    public static void clearDriverMap() {
        DRIVERS_PER_TEST_METHOD.clear();
    }
}

