/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.internal.utils;

import eu.tsystems.mms.tic.testframework.internal.utils.CoreExceptionUtils;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AbstractPage;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextUtils;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtils
extends CoreExceptionUtils {
    private static final String INIT_STRING = "<init>";

    public static String getPageContextFromThrowable(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        String methodName = ExecutionContextUtils.getMethodNameFromCurrentTestResult();
        if (methodName == null) {
            return null;
        }
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int position = 0;
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            if (!methodName.equals(stackTraceElement.getMethodName())) continue;
            position = i;
            break;
        }
        if (position == 0) {
            return null;
        }
        if ((position = ExceptionUtils.findSubclassCallBackwards((StackTraceElement[])stackTrace, (int)position, AbstractPage.class, null)) == -1) {
            return null;
        }
        StackTraceElement stackTraceElement = stackTrace[position];
        String simpleClassName = ExceptionUtils.getSimpleNameFromClassString((String)stackTraceElement.getClassName());
        String actionName = stackTraceElement.getMethodName();
        if (StringUtils.isBlank((CharSequence)actionName) || actionName.equals(INIT_STRING)) {
            return String.format("Construct %s", simpleClassName);
        }
        return String.format("%s.%s", simpleClassName, actionName);
    }
}

