/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.layout;

import eu.tsystems.mms.tic.testframework.common.IProperties;
import eu.tsystems.mms.tic.testframework.common.PropertyManagerProvider;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.execution.testng.OptionalAssert;
import eu.tsystems.mms.tic.testframework.layout.LayoutCheckException;
import eu.tsystems.mms.tic.testframework.layout.reporting.LayoutCheckContext;
import eu.tsystems.mms.tic.testframework.report.Report;
import eu.tsystems.mms.tic.testframework.report.model.context.CustomContext;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextController;
import eu.tsystems.mms.tic.testframework.utils.AssertUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayoutCheck
implements PropertyManagerProvider {
    private static final Report report = (Report)Testerra.getInjector().getInstance(Report.class);
    private static final double NO_DISTANCE = 0.0;
    private static final double RGB_DEVIATION_PERCENT = Properties.PIXEL_RGB_DEVIATION_PERCENT.asDouble();
    private static final double RGB_MAX_DEVIATION = 255.0;
    private static final HashMap<String, Integer> runCount = new HashMap();
    @Deprecated
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutCheck.class);

    private LayoutCheck() {
    }

    public static Path getDir(String basePath) {
        File baseDir = new File(basePath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        return baseDir.toPath();
    }

    private static MatchStep prepare(File screenshot, String targetImageName) {
        MatchStep step = new MatchStep();
        Path referenceImagesDir = LayoutCheck.getDir(PROPERTY_MANAGER.getProperty((IProperties)Properties.REFERENCE_PATH, (Object)"src/test/resources/screenreferences/reference"));
        Path actualImagesDir = LayoutCheck.getDir(PROPERTY_MANAGER.getProperty((IProperties)Properties.ACTUAL_PATH, (Object)"src/test/resources/screenreferences/actual"));
        Path distanceImagesDir = LayoutCheck.getDir(PROPERTY_MANAGER.getProperty((IProperties)Properties.DISTANCE_PATH, (Object)"src/test/resources/screenreferences/distance"));
        step.referenceFileName = referenceImagesDir.resolve(String.format(PROPERTY_MANAGER.getProperty((IProperties)Properties.REFERENCE_NAMETEMPLATE, (Object)"Reference%s.png"), targetImageName));
        String runCountModifier = "";
        if (!runCount.containsKey(targetImageName)) {
            runCount.put(targetImageName, 1);
        } else {
            Integer newCount = runCount.get(targetImageName) + 1;
            runCount.put(targetImageName, newCount);
            runCountModifier = String.format("-%03d", newCount);
        }
        step.takeReferenceOnly = Properties.TAKEREFERENCE.asBool();
        if (step.takeReferenceOnly) {
            try {
                FileUtils.copyFile((File)screenshot, (File)step.referenceFileName.toFile());
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
                throw new SystemException("Error when saving reference screenshot.", (Throwable)e);
            }
            LOGGER.info(String.format("Saved reference screenshot at '%s'.", step.referenceFileName.toString()));
        } else {
            step.consecutiveTargetImageName = targetImageName + runCountModifier;
            step.actualFileName = actualImagesDir.resolve(String.format(Properties.ACTUAL_NAMETEMPLATE.asString(), step.consecutiveTargetImageName));
            try {
                FileUtils.copyFile((File)screenshot, (File)step.actualFileName.toFile());
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
                throw new SystemException("Error when saving screenshot.", (Throwable)e);
            }
            LOGGER.debug(String.format("Saved actual screenshot at '%s'.", step.actualFileName.toString()));
            step.distanceFileName = distanceImagesDir.resolve(String.format(Properties.DISTANCE_NAMETEMPLATE.asString(), step.consecutiveTargetImageName));
        }
        return step;
    }

    public static MatchStep matchPixels(TakesScreenshot takesScreenshot, String targetImageName) {
        File screenshot = (File)takesScreenshot.getScreenshotAs(OutputType.FILE);
        return LayoutCheck.matchPixels(screenshot, targetImageName);
    }

    public static MatchStep matchPixels(File screenshot, String targetImageName) {
        MatchStep step = LayoutCheck.prepare(screenshot, targetImageName);
        if (!step.takeReferenceOnly) {
            LayoutCheck.matchPixels(step);
        }
        return step;
    }

    private static void matchPixels(MatchStep matchStep) {
        try {
            File refFile = matchStep.referenceFileName.toFile();
            File actualFile = matchStep.actualFileName.toFile();
            if (!refFile.exists()) {
                throw new FileNotFoundException(matchStep.referenceFileName.toString());
            }
            if (!actualFile.exists()) {
                throw new FileNotFoundException(matchStep.actualFileName.toString());
            }
            BufferedImage referenceImage = ImageIO.read(refFile);
            BufferedImage actualImage = ImageIO.read(actualFile);
            matchStep.referenceFileDimension = new Dimension(referenceImage.getWidth(), referenceImage.getHeight());
            matchStep.actualFileDimension = new Dimension(actualImage.getWidth(), actualImage.getHeight());
            boolean useIgnoreColor = Properties.USE_IGNORE_COLOR.asBool();
            matchStep.distance = LayoutCheck.generateDistanceImage(referenceImage, actualImage, matchStep.distanceFileName, useIgnoreColor);
        }
        catch (Exception e) {
            throw new LayoutCheckException(matchStep, (Throwable)e);
        }
    }

    private static int getColorOfPixel(BufferedImage image, int x, int y) {
        return image.getRGB(x, y);
    }

    private static double generateDistanceImage(BufferedImage expectedImage, BufferedImage actualImage, Path resultFilename, boolean useIgnoreColor) {
        int pixelsInError = 0;
        int noOfIgnoredPixels = 0;
        Dimension distanceImageSize = LayoutCheck.calculateMinImageSize(expectedImage, actualImage);
        BufferedImage distanceImage = new BufferedImage(distanceImageSize.width, distanceImageSize.height, expectedImage.getType());
        Dimension expectedImageDimension = new Dimension(expectedImage.getWidth(), expectedImage.getHeight());
        Dimension actualImageDimension = new Dimension(actualImage.getWidth(), actualImage.getHeight());
        if (!actualImageDimension.equals(expectedImageDimension)) {
            OptionalAssert.fail((String)String.format("The actual image (width=%dpx, height=%dpx) has a different size than the reference image (width=%dpx, height=%dpx)", actualImageDimension.width, actualImageDimension.height, expectedImageDimension.width, expectedImageDimension.height));
        }
        int ignoreColor = LayoutCheck.getColorOfPixel(expectedImage, 0, 0);
        for (int currentY = 0; currentY < distanceImageSize.height; ++currentY) {
            for (int currentX = 0; currentX < distanceImageSize.width; ++currentX) {
                boolean pixelIsInsideExpectedImage = LayoutCheck.isPixelInImageBounds(expectedImage, currentX, currentY);
                boolean pixelIsInsideActualImage = LayoutCheck.isPixelInImageBounds(actualImage, currentX, currentY);
                if (pixelIsInsideExpectedImage) {
                    distanceImage.setRGB(currentX, currentY, expectedImage.getRGB(currentX, currentY));
                }
                if (pixelIsInsideExpectedImage && pixelIsInsideActualImage) {
                    boolean ignoredPixel;
                    int expectedRgb = expectedImage.getRGB(currentX, currentY);
                    int actualImageRGB = actualImage.getRGB(currentX, currentY);
                    boolean bl = ignoredPixel = useIgnoreColor && expectedRgb == ignoreColor;
                    if (!ignoredPixel) {
                        boolean match = LayoutCheck.doRGBsMatch(expectedRgb, actualImageRGB);
                        if (match) continue;
                        distanceImage.setRGB(currentX, currentY, Color.RED.getRGB());
                        ++pixelsInError;
                        continue;
                    }
                    ++noOfIgnoredPixels;
                    continue;
                }
                distanceImage.setRGB(currentX, currentY, Color.BLUE.getRGB());
            }
        }
        try {
            resultFilename.toFile().getParentFile().mkdirs();
            ImageIO.write((RenderedImage)distanceImage, "PNG", resultFilename.toAbsolutePath().toFile());
        }
        catch (IOException ioe) {
            LOGGER.error(String.format("An error occurred while trying to persist image to '%s'.", resultFilename), (Throwable)ioe);
        }
        int totalPixels = distanceImageSize.width * distanceImageSize.height;
        double result = (double)pixelsInError / (double)(totalPixels - noOfIgnoredPixels) * 100.0;
        LOGGER.debug("Raw results of pixel check: \nDimension actual image: {}\nDimension expected image: {}\nNumber of total pixel: {}\nNumber of ignored pixel: {}\nNumber of pixel in errors: {}\nResult of matching: {}", new Object[]{actualImageDimension, expectedImageDimension, totalPixels, noOfIgnoredPixels, pixelsInError, result});
        return result;
    }

    private static boolean doRGBsMatch(int expectedRgb, int actualImageRGB) {
        if (expectedRgb == actualImageRGB) {
            return true;
        }
        if (RGB_DEVIATION_PERCENT > 0.0) {
            Color expectedColor = new Color(expectedRgb);
            Color actualColor = new Color(actualImageRGB);
            double percentR = (double)(100 * Math.abs(expectedColor.getRed() - actualColor.getRed())) / 255.0;
            double percentG = (double)(100 * Math.abs(expectedColor.getGreen() - actualColor.getGreen())) / 255.0;
            double percentB = (double)(100 * Math.abs(expectedColor.getBlue() - actualColor.getBlue())) / 255.0;
            if (percentR <= RGB_DEVIATION_PERCENT && percentG <= RGB_DEVIATION_PERCENT && percentB <= RGB_DEVIATION_PERCENT) {
                return true;
            }
        }
        return false;
    }

    private static Dimension calculateMinImageSize(BufferedImage expectedImage, BufferedImage actualImage) {
        return new Dimension(Math.min(expectedImage.getWidth(), actualImage.getWidth()), Math.min(expectedImage.getHeight(), actualImage.getHeight()));
    }

    private static boolean isPixelInImageBounds(BufferedImage image, int x, int y) {
        return image.getWidth() > x && image.getHeight() > y;
    }

    public static void toReport(MatchStep step) {
        String name = step.consecutiveTargetImageName;
        Path referenceScreenshotPath = step.referenceFileName;
        Path actualScreenshotPath = step.actualFileName;
        Path distanceScreenshotPath = step.distanceFileName;
        LayoutCheckContext context = new LayoutCheckContext();
        context.image = name;
        if (!step.actualFileDimension.equals(step.referenceFileDimension)) {
            OptionalAssert.fail((String)String.format("The actual image (width=%dpx, height=%dpx) has a different size than the reference image (width=%dpx, height=%dpx)", step.actualFileDimension.width, step.actualFileDimension.height, step.referenceFileDimension.width, step.referenceFileDimension.height));
        }
        context.distance = new BigDecimal(step.distance).setScale(2, RoundingMode.HALF_UP).doubleValue();
        context.expectedScreenshot = report.provideScreenshot(referenceScreenshotPath.toFile(), Report.FileMode.COPY);
        context.actualScreenshot = report.provideScreenshot(actualScreenshotPath.toFile(), Report.FileMode.MOVE);
        context.distanceScreenshot = report.provideScreenshot(distanceScreenshotPath.toFile(), Report.FileMode.MOVE);
        context.distanceScreenshot.getMetaData().put("Distance", Double.toString(step.distance));
        ExecutionContextController.getMethodContextForThread().ifPresent(methodContext -> methodContext.addCustomContext((CustomContext)context));
    }

    public static void assertScreenshot(WebDriver webDriver, String targetImageName, double confidenceThreshold) {
        String assertMessage = String.format("Expected that pixel distance (%%) of WebDriver screenshot to image '%s'", targetImageName);
        try {
            MatchStep matchStep = LayoutCheck.matchPixels((TakesScreenshot)webDriver, targetImageName);
            if (!matchStep.takeReferenceOnly) {
                LayoutCheck.toReport(matchStep);
            }
            AssertUtils.assertLowerEqualThan((BigDecimal)new BigDecimal(matchStep.distance).setScale(2, RoundingMode.HALF_UP), (BigDecimal)new BigDecimal(confidenceThreshold), (String)assertMessage);
        }
        catch (LayoutCheckException e) {
            MatchStep matchStep = e.getMatchStep();
            LayoutCheck.toReport(matchStep);
            throw e;
        }
    }

    public static class MatchStep {
        Path referenceFileName;
        Path actualFileName;
        Path distanceFileName;
        Path annotationDataFileName;
        Dimension referenceFileDimension;
        Dimension actualFileDimension;
        String consecutiveTargetImageName;
        public boolean takeReferenceOnly;
        public double distance = 0.0;
    }

    public static enum Properties implements IProperties
    {
        MODE("mode", "pixel"),
        TAKEREFERENCE("takereference", false),
        REFERENCE_NAMETEMPLATE("reference.nametemplate", "Reference%s.png"),
        ANNOTATED_NAMETEMPLATE("annotated.nametemplate", "ReferenceAnnotated%s.png"),
        ANNOTATIONDATA_NAMETEMPLATE("annotationdata.nametemplate", "Reference%s_data.json"),
        ACTUAL_NAMETEMPLATE("actual.nametemplate", "Actual%s.png"),
        DISTANCE_NAMETEMPLATE("distance.nametemplate", "Distance%s.png"),
        REFERENCE_PATH("reference.path", "src/test/resources/screenreferences/reference"),
        DISTANCE_PATH("distance.path", "src/test/resources/screenreferences/distance"),
        ACTUAL_PATH("actual.path", "src/test/resources/screenreferences/actual"),
        USE_IGNORE_COLOR("use.ignore.color", false),
        PIXEL_RGB_DEVIATION_PERCENT("pixel.rgb.deviation.percent", 0.0);

        private final String property;
        private final Object defaultValue;

        private Properties(String property, Object defaultValue) {
            this.property = property;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return String.format("tt.layoutcheck.%s", this.property);
        }

        public Object getDefault() {
            return this.defaultValue;
        }
    }
}

