/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.internal.Nameable;
import eu.tsystems.mms.tic.testframework.pageobjects.Component;
import eu.tsystems.mms.tic.testframework.pageobjects.DefaultComponentList;
import eu.tsystems.mms.tic.testframework.pageobjects.GuiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.InteractiveUiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElementList;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AbstractPage;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.UiElementFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.UiElementBaseAssertion;
import java.awt.Color;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class AbstractComponent<SELF extends AbstractComponent<SELF>>
extends AbstractPage<SELF>
implements Component<SELF> {
    protected static final UiElementFactory uiElementFactory = (UiElementFactory)Testerra.getInjector().getInstance(UiElementFactory.class);
    protected final UiElement rootElement;
    private String name;

    public AbstractComponent(UiElement rootElement) {
        this.rootElement = rootElement;
    }

    @Override
    public InteractiveUiElement highlight(Color color) {
        return this.rootElement.highlight(color);
    }

    @Override
    public String createXPath() {
        return this.rootElement.createXPath();
    }

    @Override
    public Locator getLocator() {
        return this.rootElement.getLocator();
    }

    @Override
    public InteractiveUiElement scrollIntoView(Point offset) {
        return this.rootElement.scrollIntoView(offset);
    }

    @Override
    public InteractiveUiElement scrollToTop() {
        return this.rootElement.scrollToTop();
    }

    @Override
    public UiElementList<SELF> list() {
        return new DefaultComponentList<AbstractComponent>(this);
    }

    @Override
    protected UiElement find(Locator locator) {
        GuiElement subElement = (GuiElement)uiElementFactory.createFromParent(this.rootElement, locator);
        subElement.setParent(this);
        return subElement;
    }

    @Override
    protected UiElement findDeep(Locator locator) {
        return this.find(locator);
    }

    @Override
    public WebDriver getWebDriver() {
        return this.rootElement.getWebDriver();
    }

    @Override
    public UiElementBaseAssertion waitFor(int seconds) {
        return this.rootElement.waitFor(seconds);
    }

    @Override
    public UiElementBaseAssertion expect() {
        return this.rootElement.expect();
    }

    public SELF setName(String name) {
        this.name = name;
        return (SELF)this;
    }

    @Override
    public String getName(boolean detailed) {
        if (this.hasOwnName() && !detailed) {
            return this.name;
        }
        String name = this.name;
        if (StringUtils.isBlank((CharSequence)name)) {
            this.name = this.getClass().getSimpleName();
        }
        return String.format("%s(%s)", name, this.rootElement.getName(detailed));
    }

    public Nameable getParent() {
        return this.rootElement.getParent();
    }

    public boolean hasOwnName() {
        return this.name != null;
    }

    @Override
    public void findWebElement(Consumer<WebElement> consumer) {
        this.rootElement.findWebElement(consumer);
    }

    @Override
    public void screenshotToReport() {
        this.rootElement.screenshotToReport();
    }
}

