/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.execution.testng.Assertion;
import eu.tsystems.mms.tic.testframework.execution.testng.CollectedAssertion;
import eu.tsystems.mms.tic.testframework.execution.testng.InstantAssertion;
import eu.tsystems.mms.tic.testframework.execution.testng.OptionalAssertion;
import eu.tsystems.mms.tic.testframework.internal.Nameable;
import eu.tsystems.mms.tic.testframework.internal.NameableChild;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionConfig;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.DefaultUiElementList;
import eu.tsystems.mms.tic.testframework.pageobjects.EmptyUiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.InteractiveUiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.pageobjects.TestableUiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElementList;
import eu.tsystems.mms.tic.testframework.pageobjects.XPath;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.UiElementFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.DefaultUiElementAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.GuiElementAssert;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.GuiElementAssertDescriptionDecorator;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.LegacyGuiElementAssertWrapper;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.PerformanceTestGuiElementAssert;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.UiElementAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.AbstractGuiElementCore;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.GuiElementCore;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.GuiElementCoreSequenceDecorator;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.GuiElementData;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.facade.DelayActionsGuiElementFacade;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.facade.UiElementLogger;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.waiters.DefaultGuiElementWait;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.waiters.GuiElementWait;
import eu.tsystems.mms.tic.testframework.report.Report;
import eu.tsystems.mms.tic.testframework.testing.WebDriverManagerProvider;
import eu.tsystems.mms.tic.testframework.webdriver.WebDriverFactory;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class GuiElement
implements UiElement,
NameableChild<UiElement>,
Loggable,
WebDriverManagerProvider {
    private static final UiElementFactory uiElementFactory = (UiElementFactory)Testerra.getInjector().getInstance(UiElementFactory.class);
    private GuiElementAssert defaultAssert;
    private GuiElementAssert instantAssert;
    private GuiElementAssert collectableAssert;
    private GuiElementAssert nonFunctionalAssert;
    private final GuiElementCore core;
    private final GuiElementData guiElementData;
    private GuiElementCore decoratedCore;
    private GuiElementWait decoratedWait;
    private Nameable parent;

    private GuiElement(GuiElementData data) {
        this.guiElementData = data;
        this.guiElementData.setGuiElement(this);
        WebDriverFactory factory = WEB_DRIVER_MANAGER.getWebDriverFactoryForBrowser(WEB_DRIVER_MANAGER.getRequestedBrowser(this.guiElementData.getWebDriver()).orElse(null));
        this.core = factory.createCore(this.guiElementData);
    }

    protected GuiElement(GuiElementData data, GuiElementCore core) {
        this.guiElementData = data;
        this.guiElementData.setGuiElement(this);
        this.core = core;
    }

    GuiElement(GuiElement guiElement, int index) {
        this(new GuiElementData(guiElement.guiElementData, index));
        this.setParent(guiElement.getParent());
        this.createDecorators();
    }

    GuiElement(GuiElementCore core) {
        this.core = core;
        AbstractGuiElementCore realCore = (AbstractGuiElementCore)core;
        this.guiElementData = realCore.guiElementData;
        this.guiElementData.setGuiElement(this);
        this.createDecorators();
    }

    @Deprecated
    public GuiElement(WebDriver driver, Locator locator) {
        this(new GuiElementData(driver, locator));
        this.guiElementData.setGuiElement(this);
        this.createDecorators();
    }

    @Deprecated
    public GuiElement(WebDriver driver, By by) {
        this(driver, LOCATE.by(by));
    }

    public GuiElementCore getCore() {
        return this.core;
    }

    public GuiElementData getData() {
        return this.guiElementData;
    }

    @Override
    public Locator getLocator() {
        return this.guiElementData.getLocate();
    }

    private void createDecorators() {
        GuiElementCoreSequenceDecorator sequenceCore = new GuiElementCoreSequenceDecorator(this.core);
        this.decoratedCore = new UiElementLogger(sequenceCore, this);
        int delayAfterAction = UiElement.Properties.DELAY_AFTER_ACTION_MILLIS.asLong().intValue();
        int delayBeforeAction = UiElement.Properties.DELAY_BEFORE_ACTION_MILLIS.asLong().intValue();
        if (delayAfterAction > 0 || delayBeforeAction > 0) {
            this.decoratedCore = new DelayActionsGuiElementFacade(this.decoratedCore, delayBeforeAction, delayAfterAction);
        }
    }

    @Deprecated
    public GuiElement withWebElementFilter(Predicate<WebElement> filter) {
        this.guiElementData.getLocate().filter(filter);
        return this;
    }

    @Deprecated
    public GuiElement setDescription(String description) {
        this.guiElementData.setName(description);
        return this;
    }

    @Deprecated
    public GuiElement getSubElement(By by) {
        return this.getSubElement(by, null);
    }

    @Deprecated
    public GuiElement getSubElement(By by, String description) {
        GuiElement subElement = this.getSubElement(LOCATE.by(by));
        if (description != null) {
            subElement.setName(description);
        }
        return subElement;
    }

    @Deprecated
    public GuiElement getSubElement(Locator locator) {
        return (GuiElement)this.find(locator);
    }

    @Override
    public UiElement scrollIntoView(Point offset) {
        this.decoratedCore.scrollIntoView(offset);
        return this;
    }

    @Override
    public UiElement scrollToTop() {
        this.decoratedCore.scrollToTop();
        return this;
    }

    @Deprecated
    public By getBy() {
        return this.guiElementData.getLocate().getBy();
    }

    @Deprecated
    public UiElement scrollToElement() {
        this.decoratedCore.scrollToElement();
        return this;
    }

    @Deprecated
    public UiElement scrollToElement(int yOffset) {
        this.decoratedCore.scrollToElement(yOffset);
        return this;
    }

    @Override
    public UiElement select() {
        this.decoratedCore.select();
        return this;
    }

    @Override
    public UiElement deselect() {
        this.decoratedCore.deselect();
        return this;
    }

    @Override
    public UiElement type(String text) {
        this.decoratedCore.type(text);
        return this;
    }

    @Override
    public UiElement click() {
        this.decoratedCore.click();
        return this;
    }

    @Override
    public UiElement submit() {
        this.decoratedCore.submit();
        return this;
    }

    @Override
    public UiElement sendKeys(CharSequence ... charSequences) {
        this.decoratedCore.sendKeys(charSequences);
        return this;
    }

    @Override
    public UiElement clear() {
        this.decoratedCore.clear();
        return this;
    }

    @Override
    public InteractiveUiElement hover() {
        return this.mouseOver();
    }

    @Deprecated
    public String getTagName() {
        return this.decoratedCore.getTagName();
    }

    @Deprecated
    public String getAttribute(String attributeName) {
        return this.decoratedCore.getAttribute(attributeName);
    }

    @Deprecated
    public boolean isSelected() {
        return this.decoratedCore.isSelected();
    }

    @Deprecated
    public boolean isEnabled() {
        return this.decoratedCore.isEnabled();
    }

    @Deprecated
    public String getText() {
        return this.decoratedCore.getText();
    }

    @Deprecated
    public boolean isDisplayed() {
        return this.decoratedCore.isDisplayed();
    }

    @Deprecated
    public boolean isVisible(boolean complete) {
        return this.decoratedCore.isVisible(complete);
    }

    @Deprecated
    public boolean isSelectable() {
        return this.decoratedCore.isSelectable();
    }

    @Deprecated
    public Point getLocation() {
        return this.decoratedCore.getLocation();
    }

    @Deprecated
    public Dimension getSize() {
        return this.decoratedCore.getSize();
    }

    @Override
    public UiElement find(Locator locator) {
        return uiElementFactory.createFromParent(this.guiElementData.getGuiElement(), locator);
    }

    @Override
    public UiElement createEmpty(Locator locator) {
        return new EmptyUiElement((UiElement)this, locator);
    }

    @Override
    public UiElementList<UiElement> list() {
        return new DefaultUiElementList(this);
    }

    @Deprecated
    public String getCssValue(String cssIdentifier) {
        return this.decoratedCore.getCssValue(cssIdentifier);
    }

    @Deprecated
    public UiElement mouseOver() {
        this.decoratedCore.mouseOver();
        return this;
    }

    @Deprecated
    public boolean isPresent() {
        return this.decoratedCore.isPresent();
    }

    @Deprecated
    public List<String> getTextsFromChildren() {
        return this.decoratedCore.getTextsFromChildren();
    }

    @Deprecated
    public boolean anyFollowingTextNodeContains(String contains) {
        return this.anyElementContainsText(contains).waitFor().present(true);
    }

    @Deprecated
    public TestableUiElement anyElementContainsText(String text) {
        String textFinderXpath = String.format("//text()[contains(., '%s')]/..", text);
        return this.find(By.xpath((String)textFinderXpath));
    }

    @Override
    public WebDriver getWebDriver() {
        return this.guiElementData.getWebDriver();
    }

    @Deprecated
    public WebElement getWebElement() {
        return this.decoratedCore.getWebElement();
    }

    @Override
    public UiElement doubleClick() {
        this.decoratedCore.doubleClick();
        return this;
    }

    @Override
    public UiElement highlight(Color color) {
        this.decoratedCore.highlight(color);
        return this;
    }

    public UiElement swipe(int offsetX, int offSetY) {
        this.decoratedCore.swipe(offsetX, offSetY);
        return this;
    }

    @Deprecated
    public int getLengthOfValueAfterSendKeys(String textToInput) {
        return this.decoratedCore.getLengthOfValueAfterSendKeys(textToInput);
    }

    @Deprecated
    public int getNumberOfFoundElements() {
        return this.decoratedCore.getNumberOfFoundElements();
    }

    @Deprecated
    public UiElement rightClick() {
        return this.contextClick();
    }

    @Override
    public UiElement contextClick() {
        this.decoratedCore.contextClick();
        return this;
    }

    @Deprecated
    public File takeScreenshot() {
        return this.decoratedCore.takeScreenshot();
    }

    public UiElement setParent(Nameable parent) {
        this.parent = parent;
        return this;
    }

    public Nameable getParent() {
        return this.parent;
    }

    public boolean hasOwnName() {
        return this.guiElementData.hasOwnName();
    }

    public String toString() {
        return this.toString(false);
    }

    @Deprecated
    public WebDriver getDriver() {
        return this.getWebDriver();
    }

    @Deprecated
    public boolean hasSensibleData() {
        return this.guiElementData.hasSensibleData();
    }

    @Override
    public GuiElement sensibleData() {
        this.guiElementData.setHasSensibleData(true);
        return this;
    }

    public GuiElement setName(String name) {
        this.guiElementData.setName(name);
        return this;
    }

    public String getName(boolean detailed) {
        return this.guiElementData.getName(detailed);
    }

    @Deprecated
    public GuiElementAssert asserts() {
        if (this.defaultAssert == null) {
            this.defaultAssert = UiElement.Properties.DEFAULT_ASSERT_IS_COLLECTOR.asBool() != false ? this.assertCollector() : this.instantAsserts();
        }
        return this.defaultAssert;
    }

    @Deprecated
    public GuiElementAssert asserts(String errorMessage) {
        GuiElementAssertDescriptionDecorator guiElementAssertDescriptionDecorator = new GuiElementAssertDescriptionDecorator(errorMessage, this.asserts());
        return guiElementAssertDescriptionDecorator;
    }

    @Deprecated
    public GuiElementAssert nonFunctionalAsserts() {
        if (this.nonFunctionalAssert == null) {
            OptionalAssertion assertion = (OptionalAssertion)Testerra.getInjector().getInstance(OptionalAssertion.class);
            this.nonFunctionalAssert = this.createAssertDecorators((Assertion)assertion);
        }
        return this.nonFunctionalAssert;
    }

    @Deprecated
    private GuiElementAssert createAssertDecorators(Assertion assertion) {
        GuiElementAssert guiElementAssert = Testerra.Properties.PERF_TEST.asBool() != false ? new PerformanceTestGuiElementAssert() : new LegacyGuiElementAssertWrapper(this, assertion);
        return guiElementAssert;
    }

    @Deprecated
    public GuiElementAssert nonFunctionalAsserts(String errorMessage) {
        GuiElementAssertDescriptionDecorator guiElementAssertDescriptionDecorator = new GuiElementAssertDescriptionDecorator(errorMessage, this.nonFunctionalAsserts());
        return guiElementAssertDescriptionDecorator;
    }

    @Deprecated
    private GuiElementAssert instantAsserts() {
        if (this.instantAssert == null) {
            InstantAssertion assertion = (InstantAssertion)Testerra.getInjector().getInstance(InstantAssertion.class);
            this.instantAssert = this.createAssertDecorators((Assertion)assertion);
        }
        return this.instantAssert;
    }

    @Deprecated
    public GuiElementAssert optionalAsserts() {
        return this.nonFunctionalAsserts();
    }

    @Deprecated
    public GuiElementAssert optionalAsserts(String errorMessage) {
        return this.nonFunctionalAsserts(errorMessage);
    }

    @Deprecated
    public GuiElementAssert assertCollector() {
        if (this.collectableAssert == null) {
            CollectedAssertion assertion = (CollectedAssertion)Testerra.getInjector().getInstance(CollectedAssertion.class);
            this.collectableAssert = this.createAssertDecorators((Assertion)assertion);
        }
        return this.collectableAssert;
    }

    @Deprecated
    public GuiElementAssert assertCollector(String errorMessage) {
        GuiElementAssertDescriptionDecorator guiElementAssertDescriptionDecorator = new GuiElementAssertDescriptionDecorator(errorMessage, this.assertCollector());
        return guiElementAssertDescriptionDecorator;
    }

    @Deprecated
    public List<GuiElement> getList() {
        return this.list().stream().map(uiElement -> (GuiElement)uiElement).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public GuiElement shadowRoot() {
        this.guiElementData.setHasShadowRoot(true);
        return this;
    }

    @Deprecated
    public GuiElementWait waits() {
        if (this.decoratedWait == null) {
            this.decoratedWait = new DefaultGuiElementWait(this);
        }
        return this.decoratedWait;
    }

    @Override
    public UiElementAssertion waitFor(int seconds) {
        PropertyAssertionConfig config = new PropertyAssertionConfig();
        config.useTimeout = seconds;
        return new DefaultUiElementAssertion((UiElement)this, config);
    }

    @Override
    public UiElementAssertion expect() {
        PropertyAssertionConfig config = new PropertyAssertionConfig();
        config.throwErrors = true;
        return new DefaultUiElementAssertion((UiElement)this, config);
    }

    @Override
    public String createXPath() {
        GuiElementData guiElementData = this.guiElementData;
        StringBuilder sb = new StringBuilder();
        do {
            Object elementPath = XPath.byToXPath(guiElementData.getLocate().getBy());
            if (guiElementData.getIndex() >= 0) {
                elementPath = (String)elementPath + "[" + guiElementData.getIndex() + "]";
            }
            sb.insert(0, (String)elementPath);
        } while ((guiElementData = guiElementData.getParent()) != null && !guiElementData.isFrame());
        return sb.toString();
    }

    @Override
    public void findWebElement(Consumer<WebElement> consumer) {
        this.decoratedCore.findWebElement(consumer);
    }

    @Override
    public void screenshotToReport() {
        this.waitFor().screenshot(Report.Mode.ALWAYS);
    }

    @Deprecated
    public Select getSelectElement() {
        return new Select(this.getWebElement());
    }
}

