/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.exceptions.ElementNotFoundException;
import eu.tsystems.mms.tic.testframework.internal.Nameable;
import eu.tsystems.mms.tic.testframework.internal.StopWatch;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionConfig;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.pageobjects.TestablePage;
import eu.tsystems.mms.tic.testframework.pageobjects.TestableUiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElementFinder;
import eu.tsystems.mms.tic.testframework.pageobjects.XPath;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AbstractPage;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.DefaultPageAssertions;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.PageUiElementFinder;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.PageAssertions;
import eu.tsystems.mms.tic.testframework.report.Report;
import eu.tsystems.mms.tic.testframework.utils.TimerUtils;
import java.util.Random;
import org.openqa.selenium.WebDriver;

public class Page
extends AbstractPage<Page>
implements TestablePage {
    private final WebDriver driver;
    private final PageUiElementFinder finder = new PageUiElementFinder(this);

    public Page(WebDriver webDriver) {
        this.driver = webDriver;
        this.perfTestExtras();
    }

    public Nameable getParent() {
        return null;
    }

    public boolean hasOwnName() {
        return true;
    }

    public Page setName(String name) {
        return this;
    }

    @Override
    public String getName(boolean detailed) {
        return this.getClass().getSimpleName();
    }

    @Override
    public WebDriver getWebDriver() {
        return this.driver;
    }

    private void perfTestExtras() {
        StopWatch.stopPageLoad(this.getWebDriver(), this.getClass());
        if (Testerra.Properties.PERF_TEST.asBool().booleanValue()) {
            this.executeThinkTime();
        }
    }

    private void executeThinkTime() {
        int randomDelta;
        Random r;
        int randomValue;
        int thinkTime = PropertyManager.getIntProperty((String)"tt.perf.page.thinktime.ms", (int)0);
        int timeToWait = 0;
        if (thinkTime > 0 && (timeToWait = thinkTime + ((randomValue = (r = new Random()).nextInt((randomDelta = 2000) * 2)) - randomDelta)) < 0) {
            timeToWait = 0;
        }
        this.log().info("Waiting a time to think of " + timeToWait + " milliseconds");
        TimerUtils.sleep((int)timeToWait);
    }

    @Deprecated
    public boolean waitForIsNotTextPresentWithDelay(String text, int delayInSeconds) {
        TimerUtils.sleep((int)(delayInSeconds * 1000));
        return this.waitForIsNotTextPresent(text);
    }

    protected UiElementFinder getFinder() {
        return this.finder;
    }

    @Override
    protected UiElement find(Locator locator) {
        return this.getFinder().find(locator);
    }

    @Override
    protected UiElement findDeep(Locator locator) {
        return this.getFinder().findDeep(locator);
    }

    @Deprecated
    public boolean waitForIsNotTextDisplayedWithDelay(String text, int delayInSeconds) {
        TimerUtils.sleep((int)(delayInSeconds * 1000));
        return this.waitForIsNotTextDisplayed(text);
    }

    @Override
    protected void pageLoaded() {
        if (PropertyManager.getBooleanProperty((String)"tt.screenshot.on.pageload", (boolean)false)) {
            this.screenshotToReport();
        }
    }

    @Deprecated
    public boolean waitForIsNotTextPresent(String text) {
        return this.anyElementContainsText(text).waitFor().present(false);
    }

    @Deprecated
    public boolean waitForIsNotTextDisplayed(String text) {
        return this.anyElementContainsText(text).waitFor().displayed(false);
    }

    @Deprecated
    public void assertIsTextPresent(String text, String description) {
        this.assertIsTextPresent(text);
    }

    @Deprecated
    public void assertIsTextDisplayed(String text, String description) {
        this.assertIsTextDisplayed(text);
    }

    @Deprecated
    public void assertIsTextPresent(String text) {
        this.anyElementContainsText(text).expect().present().is(true);
    }

    @Deprecated
    public void assertIsTextDisplayed(String text) {
        this.anyElementContainsText(text).expect().displayed().is(true);
    }

    @Deprecated
    public void assertIsNotTextPresent(String text) {
        this.anyElementContainsText(text).expect().present().is(false);
    }

    @Deprecated
    public void assertIsNotTextDisplayed(String text) {
        block2: {
            try {
                this.anyElementContainsText(text).expect().displayed().is(false);
            }
            catch (AssertionError error) {
                if (((Throwable)((Object)error)).getCause() instanceof ElementNotFoundException) break block2;
                throw error;
            }
        }
    }

    private TestableUiElement anyElementContainsText(String text) {
        return this.getFinder().findDeep(XPath.from("*").text().contains(text));
    }

    @Override
    public PageAssertions waitFor(int seconds) {
        PropertyAssertionConfig config = new PropertyAssertionConfig();
        config.useTimeout = seconds;
        return new DefaultPageAssertions(this, config);
    }

    @Override
    public PageAssertions expect() {
        PropertyAssertionConfig config = new PropertyAssertionConfig();
        config.throwErrors = true;
        return new DefaultPageAssertions(this, config);
    }

    @Override
    public void screenshotToReport() {
        this.waitFor().screenshot(Report.Mode.ALWAYS);
    }

    public String toString() {
        return this.toString(false);
    }
}

