/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects;

import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.EmptyUiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.pageobjects.LocatorFactoryProvider;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.XPath;
import eu.tsystems.mms.tic.testframework.webdriver.WebDriverRetainer;
import org.openqa.selenium.By;

public interface UiElementFinder
extends LocatorFactoryProvider,
Loggable,
WebDriverRetainer {
    public UiElement find(Locator var1);

    default public UiElement findById(Object id) {
        return this.find(LOCATE.by(By.id((String)id.toString())));
    }

    default public UiElement findByQa(String qa) {
        return this.find(LOCATE.byQa(qa));
    }

    default public UiElement find(By by) {
        return this.find(LOCATE.by(by));
    }

    default public UiElement find(XPath xPath) {
        return this.find(LOCATE.by(xPath));
    }

    default public UiElement findDeep(XPath xPath) {
        return this.findDeep(LOCATE.by(xPath));
    }

    default public UiElement findDeep(Locator locator) {
        UiElement currentScope = this.find(locator);
        if ((Integer)currentScope.waitFor().foundElements().getActual() > 0) {
            return currentScope;
        }
        UiElement frames = this.find(By.xpath((String)"(//iframe|//frame)"));
        for (UiElement frame : frames.list()) {
            UiElement deepScope = frame.findDeep(locator);
            if ((Integer)deepScope.waitFor().foundElements().getActual() <= 0) continue;
            return deepScope;
        }
        return currentScope;
    }

    default public UiElement createEmpty() {
        return this.createEmpty(LOCATE.by(By.tagName((String)"empty")));
    }

    default public UiElement createEmpty(Locator locator) {
        return new EmptyUiElement(this.getWebDriver(), locator);
    }
}

