/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects;

import eu.tsystems.mms.tic.testframework.pageobjects.Attribute;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.utils.Condition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class XPath {
    private final String selector;
    private final ArrayList<String> attributes = new ArrayList();
    private final ArrayList<XPath> contains = new ArrayList();
    private XPath subSelect;
    private final int pos;
    private XPath parentSelect;
    private XPath root;

    protected XPath(String selector, int position) {
        this.selector = selector;
        if (position == 0) {
            position = 1;
        }
        this.pos = position;
    }

    protected XPath(String selector) {
        this.selector = selector;
        this.pos = 0;
    }

    public static XPath from(String selector) {
        XPath from = new XPath(XPath.translateSubSelection(selector));
        XPath.prepareFromSelect(from);
        return from;
    }

    public static XPath from(String selector, int position) {
        XPath from = new XPath(XPath.translateSubSelection(selector), position);
        XPath.prepareFromSelect(from);
        return from;
    }

    private static void prepareFromSelect(XPath from) {
        from.root = from;
        from.parentSelect = from;
    }

    public static Condition createAttributeCondition() {
        return new Condition("and", "or");
    }

    public static String somethingContainsWord(String something, Object string) {
        return String.format("contains(concat(' ', normalize-space(%s), ' '), ' %s ')", something, string);
    }

    public static String somethingIs(String something, Object string) {
        return String.format("%s='%s'", something, string);
    }

    public static String somethingIsNot(String something, Object string) {
        return String.format("%s!='%s'", something, string);
    }

    public static String somethingMatches(String operation, String something, Object string) {
        return String.format("%s(%s,'%s')", operation, something, string);
    }

    static String byToXPath(By by) {
        String[] split = by.toString().split("\\: ", 2);
        if (split[0].startsWith("By.xpath")) {
            return split[1];
        }
        if (split[0].startsWith("By.name")) {
            return "//*[" + XPath.somethingIs("@name", split[1]) + "]";
        }
        if (split[0].startsWith("By.className")) {
            return "//*[" + XPath.somethingContainsWord("@class", split[1]) + "]";
        }
        if (split[0].startsWith("By.id")) {
            return "//*[" + XPath.somethingIs("@id", split[1]) + "]";
        }
        if (split[0].startsWith("By.tagName")) {
            return "//" + split[1];
        }
        return "byToXPath(" + by.toString() + ") not supported";
    }

    public XPath classes(String ... classes) {
        return this.attribute(Attribute.CLASS).hasWords(classes);
    }

    public XPath classes(List<String> classes) {
        return this.attribute(Attribute.CLASS).hasWords(classes);
    }

    public Test attribute(Attribute attribute) {
        return this.attribute(attribute.toString());
    }

    public XPath attribute(Attribute attribute, Object value) {
        return this.attribute(attribute.toString(), value);
    }

    public Test text() {
        return new Test(this, ".//text()");
    }

    public XPath text(Object value) {
        return this.text().is(value);
    }

    private boolean isFunction(String property) {
        return property.trim().endsWith(")");
    }

    public Test attribute(String attribute) {
        if (!this.isFunction((String)attribute)) {
            attribute = "@" + (String)attribute;
        }
        return new Test(this, (String)attribute);
    }

    public XPath attribute(String attribute, Object value) {
        if (value == null) {
            return this.attribute(attribute).present();
        }
        return this.attribute(attribute).is(value);
    }

    protected static String translateSubSelection(String selector) {
        if (((String)(selector = ((String)selector).trim())).startsWith("(")) {
            return selector;
        }
        if (((String)selector).startsWith("./")) {
            selector = ((String)selector).replaceFirst("^\\./", "/");
        } else if (!((String)selector).startsWith("/")) {
            selector = "//" + (String)selector;
        }
        return selector;
    }

    protected static String translateInnerSelection(String selector) {
        if ((selector = selector.trim()).startsWith("//")) {
            return selector.replaceFirst("^//", "descendant::");
        }
        if (selector.startsWith("/")) {
            return selector.replaceFirst("^/", "child::");
        }
        if (selector.startsWith("./")) {
            return selector.replaceFirst("^\\./", "child::");
        }
        return "descendant::" + selector;
    }

    public XPath encloses(String selector, int position) {
        XPath contains = new XPath(XPath.translateInnerSelection(selector), position);
        this.prepareContainsSelect(contains);
        return contains;
    }

    public XPath encloses(String selector) {
        XPath contains = new XPath(XPath.translateInnerSelection(selector));
        this.prepareContainsSelect(contains);
        return contains;
    }

    public XPath encloses(XPath selector) {
        return this.encloses(selector.toString());
    }

    public XPath encloses(By by) {
        return this.encloses(XPath.byToXPath(by));
    }

    public XPath encloses(Locator locator) {
        return this.encloses(locator.getBy());
    }

    private void prepareContainsSelect(XPath contains) {
        contains.root = this.root;
        contains.parentSelect = this.parentSelect;
        this.contains.add(contains);
    }

    public XPath select(String selector) {
        XPath sub = new XPath(XPath.translateSubSelection(selector));
        this.prepareSubSelect(sub);
        return sub;
    }

    public XPath select(String selector, int position) {
        XPath sub = new XPath(XPath.translateSubSelection(selector), position);
        this.prepareSubSelect(sub);
        return sub;
    }

    public XPath select(XPath selector) {
        return this.select(selector.toString());
    }

    public XPath select(By by) {
        return this.select(XPath.byToXPath(by));
    }

    public XPath select(Locator locator) {
        return this.select(locator.getBy());
    }

    private void prepareSubSelect(XPath sub) {
        sub.root = this.root;
        this.parentSelect.subSelect = sub;
        sub.parentSelect = sub;
    }

    protected String build() {
        StringBuilder xPath = new StringBuilder();
        xPath.append(this.selector);
        ArrayList<String> attributes = new ArrayList<String>(this.attributes);
        this.contains.stream().forEach(xpath -> attributes.add(xpath.build()));
        if (attributes.size() > 0) {
            xPath.append(String.format("[%s]", String.join((CharSequence)" and ", attributes)));
        }
        if (this.pos < 0) {
            xPath.append("[last()]");
        } else if (this.pos != 0) {
            xPath.append(String.format("[%d]", this.pos));
        }
        if (this.subSelect != null) {
            xPath.append(this.subSelect.build());
        }
        return xPath.toString();
    }

    public String toString() {
        return this.root.build();
    }

    public class Test {
        static final String CONTAINS = "contains";
        static final String START = "starts-with";
        static final String END = "ends-with";
        XPath xPath;
        String function;

        Test(XPath xPath, String function) {
            this.xPath = xPath;
            this.function = function;
        }

        public XPath is(Object value) {
            this.attributeIs(this.function, value);
            return this.xPath;
        }

        public XPath present() {
            XPath.this.attributes.add(String.format("%s", this.function));
            return this.xPath;
        }

        public XPath contains(Object value) {
            this.attributeMatches(CONTAINS, this.function, value);
            return this.xPath;
        }

        public XPath hasWords(String ... words) {
            return this.hasWords(Arrays.stream(words).collect(Collectors.toList()));
        }

        public XPath hasWords(List<String> words) {
            this.attributeContainsWords(this.function, words);
            return this.xPath;
        }

        public XPath startsWith(Object value) {
            this.attributeMatches(START, this.function, value);
            return this.xPath;
        }

        public XPath endsWith(Object value) {
            this.attributeMatches(END, this.function, value);
            return this.xPath;
        }

        private void attributeIs(String something, Object string) {
            XPath.this.attributes.add(XPath.somethingIs(something, string));
        }

        private void attributeMatches(String operation, String something, Object string) {
            XPath.this.attributes.add(XPath.somethingMatches(operation, something, string));
        }

        private void attributeContainsWord(String something, Object string) {
            XPath.this.attributes.add(XPath.somethingContainsWord(something, string));
        }

        private void attributeContainsWords(String something, List<String> words) {
            for (String word : words) {
                this.attributeContainsWord(something, word);
            }
        }
    }
}

