/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.filter;

abstract class StringChecker {
    StringChecker() {
    }

    abstract boolean check(String var1, String var2);

    static class ExistsNot
    extends StringChecker {
        ExistsNot() {
        }

        @Override
        boolean check(String expectedValue, String actualValue) {
            if (actualValue == null) {
                return true;
            }
            return actualValue.equals("");
        }

        public String toString() {
            return "%s exists not%s";
        }
    }

    static class Exists
    extends StringChecker {
        Exists() {
        }

        @Override
        boolean check(String expectedValue, String actualValue) {
            if (actualValue == null) {
                return false;
            }
            return !actualValue.equals("");
        }

        public String toString() {
            return "%s exists%s";
        }
    }

    static class ContainsNot
    extends StringChecker {
        ContainsNot() {
        }

        @Override
        boolean check(String expectedValue, String actualValue) {
            if (actualValue == null) {
                return expectedValue != null;
            }
            return !actualValue.contains(expectedValue);
        }

        public String toString() {
            return "%s.containsNot(\"%s\")";
        }
    }

    static class Contains
    extends StringChecker {
        Contains() {
        }

        @Override
        boolean check(String expectedValue, String actualValue) {
            if (actualValue == null) {
                return expectedValue == null;
            }
            return actualValue.contains(expectedValue);
        }

        public String toString() {
            return "%s.contains(\"%s\")";
        }
    }

    static class IsNot
    extends StringChecker {
        IsNot() {
        }

        @Override
        boolean check(String expectedValue, String actualValue) {
            if (expectedValue == null) {
                return actualValue != null;
            }
            return !expectedValue.equals(actualValue);
        }

        public String toString() {
            return "%s != \"%s\"";
        }
    }

    static class Is
    extends StringChecker {
        Is() {
        }

        @Override
        boolean check(String expectedValue, String actualValue) {
            if (expectedValue == null) {
                return actualValue == null;
            }
            return expectedValue.equals(actualValue);
        }

        public String toString() {
            return "%s = \"%s\"";
        }
    }
}

