/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.enums.CheckRule;
import eu.tsystems.mms.tic.testframework.exceptions.PageFactoryException;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.AbstractComponent;
import eu.tsystems.mms.tic.testframework.pageobjects.Component;
import eu.tsystems.mms.tic.testframework.pageobjects.EmptyUiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.pageobjects.LocatorFactoryProvider;
import eu.tsystems.mms.tic.testframework.pageobjects.Page;
import eu.tsystems.mms.tic.testframework.pageobjects.PageObject;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.XPath;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.PageCreator;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.PageFactory;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.action.AbstractFieldAction;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.action.GuiElementCheckFieldAction;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.action.SetNameFieldAction;
import eu.tsystems.mms.tic.testframework.testing.TestControllerProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public abstract class AbstractPage<SELF>
implements Loggable,
TestControllerProvider,
PageObject<SELF>,
LocatorFactoryProvider,
PageCreator {
    protected static final PageFactory pageFactory = (PageFactory)Testerra.getInjector().getInstance(PageFactory.class);

    protected abstract UiElement find(Locator var1);

    protected abstract UiElement findDeep(Locator var1);

    protected UiElement findById(Object id) {
        return this.find(LOCATE.by(By.id((String)id.toString())));
    }

    protected UiElement findByQa(String qa) {
        return this.find(LOCATE.byQa(qa));
    }

    protected UiElement find(By by) {
        return this.find(LOCATE.by(by));
    }

    protected UiElement find(XPath xPath) {
        return this.find(LOCATE.by(xPath));
    }

    protected UiElement findDeep(XPath xPath) {
        return this.findDeep(LOCATE.by(xPath));
    }

    protected UiElement findDeep(By by) {
        return this.findDeep(LOCATE.by(by));
    }

    protected UiElement createEmpty() {
        return this.createEmpty(LOCATE.by(By.tagName((String)"empty")));
    }

    protected UiElement createEmpty(Locator locator) {
        return new EmptyUiElement(this, locator);
    }

    private void checkAdditional(CheckRule checkRule) {
        switch (checkRule) {
            case IS_NOT_PRESENT: 
            case IS_NOT_DISPLAYED: {
                this.assertPageIsNotShown();
                break;
            }
            default: {
                this.assertPageIsShown();
            }
        }
    }

    void checkUiElements() throws Throwable {
        this.checkUiElements(CheckRule.DEFAULT);
    }

    void checkUiElements(CheckRule checkRule) throws Throwable {
        this.pCheckPage(checkRule);
    }

    @Deprecated
    public final void checkPage() {
        try {
            this.pCheckPage(CheckRule.DEFAULT);
        }
        catch (Throwable throwable) {
            throw new PageFactoryException(this.getClass(), this.getWebDriver(), throwable);
        }
    }

    public abstract String getName(boolean var1);

    private void pCheckPage(CheckRule checkRule) throws Throwable {
        this.checkPagePreparation();
        try {
            this.checkAnnotatedFields(checkRule);
            this.checkAdditional(checkRule);
        }
        catch (Throwable throwable) {
            this.checkPageErrorState(throwable);
        }
        this.pageLoaded();
    }

    protected void checkPagePreparation() {
    }

    protected void pageLoaded() {
    }

    protected void checkPageErrorState(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private void checkAnnotatedFields(CheckRule checkRule) {
        List<Class<AbstractPage>> allClasses = this.collectAllSuperClasses();
        allClasses.forEach(pageClass -> {
            for (Field field : pageClass.getDeclaredFields()) {
                field.setAccessible(true);
                List<AbstractFieldAction> fieldActions = this.getFieldActions(field, checkRule, this);
                fieldActions.forEach(AbstractFieldAction::run);
                field.setAccessible(false);
            }
        });
    }

    protected Optional<List<AbstractFieldAction>> addCustomFieldActions(Field field, AbstractPage declaringPage) {
        return Optional.empty();
    }

    private List<AbstractFieldAction> getFieldActions(Field field, CheckRule checkRule, AbstractPage declaringPage) {
        ArrayList<AbstractFieldAction> fieldActions = new ArrayList<AbstractFieldAction>();
        SetNameFieldAction setNameFieldAction = new SetNameFieldAction(field, declaringPage);
        fieldActions.add(setNameFieldAction);
        this.addCustomFieldActions(field, declaringPage).ifPresent(fieldActions::addAll);
        GuiElementCheckFieldAction guiElementCheckFieldAction = new GuiElementCheckFieldAction(field, checkRule, declaringPage);
        fieldActions.add(guiElementCheckFieldAction);
        return fieldActions;
    }

    private List<Class<? extends AbstractPage>> collectAllSuperClasses() {
        LinkedList<Class<? extends AbstractPage>> allClasses = new LinkedList<Class<? extends AbstractPage>>();
        allClasses.add(this.getClass());
        boolean running = true;
        Class<?> clazz = this.getClass();
        while (running) {
            clazz = clazz.getSuperclass();
            try {
                if (clazz == null) {
                    running = false;
                    continue;
                }
                if (clazz == AbstractComponent.class || clazz == Page.class) break;
                Class<?> pageClass = clazz;
                allClasses.add(pageClass);
            }
            catch (ClassCastException e) {
                running = false;
            }
        }
        return allClasses;
    }

    @Deprecated
    public void assertPageIsShown() {
    }

    @Deprecated
    public void assertPageIsNotShown() {
    }

    @Override
    public abstract WebDriver getWebDriver();

    protected <T extends Component> T createComponent(Class<T> componentClass, UiElement rootElement) {
        return pageFactory.createComponent(componentClass, rootElement);
    }

    @Override
    public <T extends Page> T createPage(Class<T> pageClass) {
        return pageFactory.createPage(pageClass, this.getWebDriver());
    }

    @Override
    public <T extends Page> Optional<T> waitForPage(Class<T> pageClass, int seconds) {
        return pageFactory.waitForPage(pageClass, this.getWebDriver(), seconds);
    }
}

