/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal;

import eu.tsystems.mms.tic.testframework.internal.asserts.QuantityAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElementList;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.UiElementBase;
import java.util.Iterator;

public abstract class AbstractUiElementList<SELF extends UiElementBase>
implements UiElementList<SELF> {
    private final SELF uiElement;
    private int iteratorIndex = 0;
    private int iteratorSize = 0;
    private int size = 0;

    public AbstractUiElementList(SELF uiElement) {
        this.uiElement = uiElement;
    }

    @Override
    public int size() {
        QuantityAssertion<Integer> assertion = this.uiElement.waitFor().foundElements();
        if (assertion.isGreaterThan(0L)) {
            this.size = (Integer)assertion.getActual();
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<SELF> iterator() {
        this.iteratorIndex = 0;
        this.iteratorSize = this.size();
        return this;
    }

    @Override
    public abstract SELF get(int var1);

    @Override
    public boolean hasNext() {
        return this.iteratorIndex < this.iteratorSize;
    }

    @Override
    public SELF next() {
        return (SELF)this.get(this.iteratorIndex++);
    }
}

